/*
 * Decompiled with CFR 0.152.
 */
package board;

import autoroute.AutorouteControl;
import board.AngleRestriction;
import board.FixedState;
import board.Item;
import board.ItemSelectionFilter;
import board.OptViaAlgo;
import board.Pin;
import board.PolylineTrace;
import board.PullTightAlgo45;
import board.PullTightAlgo90;
import board.PullTightAlgoAnyAngle;
import board.RoutingBoard;
import board.SearchTreeObject;
import board.ShapeSearchTree;
import board.TestLevel;
import board.Trace;
import board.Via;
import datastructures.Signum;
import datastructures.Stoppable;
import datastructures.TimeLimit;
import geometry.planar.FloatPoint;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.Line;
import geometry.planar.Point;
import geometry.planar.Polyline;
import geometry.planar.Side;
import geometry.planar.TileShape;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

public abstract class PullTightAlgo {
    protected final RoutingBoard board;
    protected final int[] only_net_no_arr;
    protected int curr_layer;
    protected int curr_half_width;
    protected int[] curr_net_no_arr;
    protected int curr_cl_type;
    protected IntOctagon curr_clip_shape;
    protected Set<Pin> contact_pins;
    protected int min_translate_dist;
    protected static final double c_max_cos_angle = 0.999;
    protected static final double c_min_corner_dist_square = 0.9;
    private final Stoppable stoppable_thread;
    private final TimeLimit time_limit;
    private final Point keep_point;
    private final int keep_point_layer;

    static PullTightAlgo get_instance(RoutingBoard p_board, int[] p_only_net_no_arr, IntOctagon p_clip_shape, int p_min_translate_dist, Stoppable p_stoppable_thread, int p_time_limit, Point p_keep_point, int p_keep_point_layer) {
        AngleRestriction angle_restriction = p_board.rules.get_trace_angle_restriction();
        PullTightAlgo result = angle_restriction == AngleRestriction.NINETY_DEGREE ? new PullTightAlgo90(p_board, p_only_net_no_arr, p_stoppable_thread, p_time_limit, p_keep_point, p_keep_point_layer) : (angle_restriction == AngleRestriction.FORTYFIVE_DEGREE ? new PullTightAlgo45(p_board, p_only_net_no_arr, p_stoppable_thread, p_time_limit, p_keep_point, p_keep_point_layer) : new PullTightAlgoAnyAngle(p_board, p_only_net_no_arr, p_stoppable_thread, p_time_limit, p_keep_point, p_keep_point_layer));
        result.curr_clip_shape = p_clip_shape;
        result.min_translate_dist = Math.max(p_min_translate_dist, 100);
        return result;
    }

    PullTightAlgo(RoutingBoard p_board, int[] p_only_net_no_arr, Stoppable p_stoppable_thread, int p_time_limit, Point p_keep_point, int p_keep_point_layer) {
        this.board = p_board;
        this.only_net_no_arr = p_only_net_no_arr;
        this.stoppable_thread = p_stoppable_thread;
        this.time_limit = p_time_limit > 0 ? new TimeLimit(p_time_limit) : null;
        this.keep_point = p_keep_point;
        this.keep_point_layer = p_keep_point_layer;
    }

    void opt_changed_area(AutorouteControl.ExpansionCostFactor[] p_trace_cost_arr) {
        if (this.board.changed_area == null) {
            return;
        }
        boolean something_changed = true;
        while (something_changed) {
            something_changed = false;
            block1: for (int i = 0; i < this.board.get_layer_count(); ++i) {
                IntOctagon changed_region = this.board.changed_area.get_area(i);
                if (changed_region.is_empty()) continue;
                this.board.changed_area.set_empty(i);
                this.board.join_graphics_update_box(changed_region.bounding_box());
                double changed_area_offset = 1.5 * (double)(this.board.rules.clearance_matrix.max_value(i) + 2 * this.board.rules.get_max_trace_half_width());
                changed_region = changed_region.enlarge(changed_area_offset);
                Set<SearchTreeObject> items = this.board.overlapping_objects(changed_region, i);
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    if (this.is_stop_requested()) {
                        return;
                    }
                    SearchTreeObject curr_ob = (SearchTreeObject)it.next();
                    if (curr_ob instanceof PolylineTrace) {
                        PolylineTrace curr_trace = (PolylineTrace)curr_ob;
                        if (curr_trace.pull_tight(this)) {
                            something_changed = true;
                            if (!this.split_traces_at_keep_point()) continue;
                            continue block1;
                        }
                        if (!this.smoothen_end_corners_at_trace_1(curr_trace)) continue;
                        something_changed = true;
                        continue block1;
                    }
                    if (!(curr_ob instanceof Via) || p_trace_cost_arr == null || !OptViaAlgo.opt_via_location(this.board, (Via)curr_ob, p_trace_cost_arr, this.min_translate_dist, 10)) continue;
                    something_changed = true;
                }
            }
        }
    }

    Polyline pull_tight(Polyline p_polyline, int p_layer, int p_half_width, int[] p_net_no_arr, int p_cl_type, Set<Pin> p_contact_pins) {
        this.curr_layer = p_layer;
        ShapeSearchTree search_tree = this.board.search_tree_manager.get_default_tree();
        this.curr_half_width = p_half_width + search_tree.clearance_compensation_value(p_cl_type, p_layer);
        this.curr_net_no_arr = p_net_no_arr;
        this.curr_cl_type = p_cl_type;
        this.contact_pins = p_contact_pins;
        return this.pull_tight(p_polyline);
    }

    protected boolean is_stop_requested() {
        if (this.stoppable_thread != null && this.stoppable_thread.is_stop_requested()) {
            return true;
        }
        if (this.time_limit == null) {
            return false;
        }
        boolean time_limit_exceeded = this.time_limit.limit_exceeded();
        if (time_limit_exceeded && this.board.get_test_level().ordinal() >= TestLevel.CRITICAL_DEBUGGING_OUTPUT.ordinal()) {
            System.out.println("PullTightAlgo.is_stop_requested: time limit exceeded");
        }
        return time_limit_exceeded;
    }

    Polyline reposition_lines(Polyline p_polyline) {
        if (p_polyline.arr.length < 5) {
            return p_polyline;
        }
        for (int i = 2; i < p_polyline.arr.length - 2; ++i) {
            Line new_line = this.reposition_line(p_polyline.arr, i);
            if (new_line == null) continue;
            Line[] line_arr = new Line[p_polyline.arr.length];
            System.arraycopy(p_polyline.arr, 0, line_arr, 0, line_arr.length);
            line_arr[i] = new_line;
            Polyline result = new Polyline(line_arr);
            return this.skip_segments_of_length_0(result);
        }
        return p_polyline;
    }

    protected Line reposition_line(Line[] p_line_arr, int p_no) {
        double max_translate_dist;
        Point nearest_point;
        if (p_line_arr.length - p_no < 3) {
            return null;
        }
        if (this.curr_clip_shape != null) {
            for (int i = -1; i < 1; ++i) {
                Point curr_corner = p_line_arr[p_no + i].intersection(p_line_arr[p_no + i + 1]);
                if (!this.curr_clip_shape.is_outside(curr_corner)) continue;
                return null;
            }
        }
        Line translate_line = p_line_arr[p_no];
        Point prev_corner = p_line_arr[p_no - 2].intersection(p_line_arr[p_no - 1]);
        Point next_corner = p_line_arr[p_no + 1].intersection(p_line_arr[p_no + 2]);
        double prev_dist = translate_line.signed_distance(prev_corner.to_float());
        double next_dist = translate_line.signed_distance(next_corner.to_float());
        if (Signum.of(prev_dist) != Signum.of(next_dist)) {
            return null;
        }
        if (Math.abs(prev_dist) < Math.abs(next_dist)) {
            nearest_point = prev_corner;
            max_translate_dist = prev_dist;
        } else {
            nearest_point = next_corner;
            max_translate_dist = next_dist;
        }
        double translate_dist = max_translate_dist;
        double delta_dist = max_translate_dist;
        Side side_of_nearest_point = translate_line.side_of(nearest_point);
        int sign = Signum.as_int(max_translate_dist);
        Line new_line = null;
        Line[] check_lines = new Line[3];
        check_lines[0] = p_line_arr[p_no - 1];
        check_lines[2] = p_line_arr[p_no + 1];
        boolean first_time = true;
        while (first_time || Math.abs(delta_dist) > (double)this.min_translate_dist) {
            boolean check_ok = false;
            check_lines[1] = first_time && nearest_point instanceof IntPoint ? Line.get_instance(nearest_point, translate_line.direction()) : translate_line.translate(-translate_dist);
            if (check_lines[1].equals(translate_line)) {
                return null;
            }
            Side new_line_side_of_nearest_point = check_lines[1].side_of(nearest_point);
            if (new_line_side_of_nearest_point != side_of_nearest_point && new_line_side_of_nearest_point != Side.COLLINEAR) {
                double shorten_value = (double)sign * 0.5;
                max_translate_dist -= shorten_value;
                translate_dist -= shorten_value;
                delta_dist -= shorten_value;
                continue;
            }
            Polyline tmp = new Polyline(check_lines);
            if (tmp.arr.length == 3) {
                TileShape shape_to_check = tmp.offset_shape(this.curr_half_width, 0);
                check_ok = this.board.check_trace_shape(shape_to_check, this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins);
            }
            delta_dist /= 2.0;
            if (check_ok) {
                new_line = check_lines[1];
                if (first_time) break;
                translate_dist += delta_dist;
            } else {
                translate_dist -= delta_dist;
            }
            first_time = false;
        }
        if (new_line != null && this.board.changed_area != null) {
            this.board.changed_area.join(check_lines[0].intersection_approx(new_line), this.curr_layer);
            this.board.changed_area.join(check_lines[2].intersection_approx(new_line), this.curr_layer);
            this.board.changed_area.join(p_line_arr[p_no - 1].intersection_approx(p_line_arr[p_no]), this.curr_layer);
            this.board.changed_area.join(p_line_arr[p_no].intersection_approx(p_line_arr[p_no + 1]), this.curr_layer);
        }
        return new_line;
    }

    Polyline skip_segments_of_length_0(Polyline p_polyline) {
        boolean polyline_changed = false;
        Polyline curr_polyline = p_polyline;
        for (int i = 1; i < curr_polyline.arr.length - 1; ++i) {
            boolean check_ok;
            boolean try_skip;
            Serializable curr_corner;
            Serializable prev_corner;
            if (i == 1 || i == curr_polyline.arr.length - 2) {
                prev_corner = curr_polyline.corner(i - 1);
                curr_corner = curr_polyline.corner(i);
                try_skip = curr_corner.equals(prev_corner);
            } else {
                prev_corner = curr_polyline.corner_approx(i - 1);
                curr_corner = curr_polyline.corner_approx(i);
                boolean bl = try_skip = ((FloatPoint)curr_corner).distance_square((FloatPoint)prev_corner) < 0.9;
            }
            if (!try_skip) continue;
            Line[] curr_lines = new Line[curr_polyline.arr.length - 1];
            System.arraycopy(curr_polyline.arr, 0, curr_lines, 0, i);
            System.arraycopy(curr_polyline.arr, i + 1, curr_lines, i, curr_lines.length - i);
            Polyline tmp = new Polyline(curr_lines);
            boolean bl = check_ok = tmp.arr.length == curr_lines.length;
            if (check_ok && !curr_polyline.arr[i].is_multiple_of_45_degree()) {
                TileShape shape_to_check;
                if (i > 1) {
                    shape_to_check = tmp.offset_shape(this.curr_half_width, i - 2);
                    check_ok = this.board.check_trace_shape(shape_to_check, this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins);
                }
                if (check_ok && i < curr_polyline.arr.length - 2) {
                    shape_to_check = tmp.offset_shape(this.curr_half_width, i - 1);
                    check_ok = this.board.check_trace_shape(shape_to_check, this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins);
                }
            }
            if (!check_ok) continue;
            polyline_changed = true;
            curr_polyline = tmp;
            --i;
        }
        if (!polyline_changed) {
            return p_polyline;
        }
        return curr_polyline;
    }

    boolean smoothen_end_corners_at_trace(PolylineTrace p_trace) {
        this.curr_layer = p_trace.get_layer();
        this.curr_half_width = p_trace.get_half_width();
        this.curr_net_no_arr = p_trace.net_no_arr;
        this.curr_cl_type = p_trace.clearance_class_no();
        return this.smoothen_end_corners_at_trace_1(p_trace);
    }

    private boolean smoothen_end_corners_at_trace_1(PolylineTrace p_trace) {
        if (p_trace.is_shove_fixed()) {
            return false;
        }
        Set<Pin> saved_contact_pins = this.contact_pins;
        this.contact_pins = null;
        boolean result = false;
        boolean connection_to_trace_improved = true;
        PolylineTrace curr_trace = p_trace;
        while (connection_to_trace_improved) {
            connection_to_trace_improved = false;
            Polyline adjusted_polyline = this.smoothen_end_corners_at_trace_2(curr_trace);
            if (adjusted_polyline == null) continue;
            result = true;
            connection_to_trace_improved = true;
            int trace_layer = curr_trace.get_layer();
            int curr_cl_class = curr_trace.clearance_class_no();
            FixedState curr_fixed_state = curr_trace.get_fixed_state();
            this.board.remove_item(curr_trace);
            curr_trace = this.board.insert_trace_without_cleaning(adjusted_polyline, trace_layer, this.curr_half_width, curr_trace.net_no_arr, curr_cl_class, curr_fixed_state);
            for (int curr_net_no : curr_trace.net_no_arr) {
                this.board.split_traces(adjusted_polyline.first_corner(), trace_layer, curr_net_no);
                this.board.split_traces(adjusted_polyline.last_corner(), trace_layer, curr_net_no);
                this.board.normalize_traces(curr_net_no);
                if (!this.split_traces_at_keep_point()) continue;
                return true;
            }
        }
        this.contact_pins = saved_contact_pins;
        return result;
    }

    boolean split_traces_at_keep_point() {
        if (this.keep_point == null) {
            return false;
        }
        ItemSelectionFilter filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.TRACES);
        Set<Item> picked_items = this.board.pick_items(this.keep_point, this.keep_point_layer, filter);
        for (Item curr_item : picked_items) {
            Trace[] split_pieces = ((Trace)curr_item).split(this.keep_point);
            if (split_pieces == null) continue;
            return true;
        }
        return false;
    }

    private Polyline smoothen_end_corners_at_trace_2(PolylineTrace p_trace) {
        if (p_trace == null || !p_trace.is_on_the_board()) {
            return null;
        }
        Polyline result = this.smoothen_start_corner_at_trace(p_trace);
        if (result == null) {
            result = this.smoothen_end_corner_at_trace(p_trace);
            if (result != null && this.board.changed_area != null) {
                this.board.changed_area.join(result.corner_approx(result.corner_count() - 1), this.curr_layer);
            }
        } else if (this.board.changed_area != null) {
            this.board.changed_area.join(result.corner_approx(0), this.curr_layer);
        }
        if (result != null) {
            this.contact_pins = p_trace.touching_pins_at_end_corners();
            result = this.skip_segments_of_length_0(result);
        }
        return result;
    }

    protected Polyline avoid_acid_traps(Polyline p_polyline) {
        return p_polyline;
    }

    abstract Polyline pull_tight(Polyline var1);

    abstract Polyline smoothen_start_corner_at_trace(PolylineTrace var1);

    abstract Polyline smoothen_end_corner_at_trace(PolylineTrace var1);
}

