/*
 * Decompiled with CFR 0.152.
 */
package board;

import geometry.planar.FloatPoint;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class PrintableShape {
    protected final Locale locale;

    protected PrintableShape(Locale p_locale) {
        this.locale = p_locale;
    }

    public abstract String toString();

    static class Polygon
    extends PrintableShape {
        public final FloatPoint[] corner_arr;

        public Polygon(FloatPoint[] p_corners, Locale p_locale) {
            super(p_locale);
            this.corner_arr = p_corners;
        }

        @Override
        public String toString() {
            ResourceBundle resources = ResourceBundle.getBundle("board.resources.ObjectInfoPanel", this.locale);
            String result = resources.getString("polygon") + ": ";
            for (int i = 0; i < this.corner_arr.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + this.corner_arr[i].to_string(this.locale);
            }
            return result;
        }
    }

    static class Rectangle
    extends PrintableShape {
        public final FloatPoint lower_left;
        public final FloatPoint upper_right;

        public Rectangle(FloatPoint p_lower_left, FloatPoint p_upper_right, Locale p_locale) {
            super(p_locale);
            this.lower_left = p_lower_left;
            this.upper_right = p_upper_right;
        }

        @Override
        public String toString() {
            ResourceBundle resources = ResourceBundle.getBundle("board.resources.ObjectInfoPanel", this.locale);
            String result = resources.getString("rectangle") + ": " + resources.getString("lower_left") + " = " + this.lower_left.to_string(this.locale) + ", " + resources.getString("upper_right") + " = " + this.upper_right.to_string(this.locale);
            return result;
        }
    }

    static class Circle
    extends PrintableShape {
        public final FloatPoint center;
        public final double radius;

        public Circle(FloatPoint p_center, double p_radius, Locale p_locale) {
            super(p_locale);
            this.center = p_center;
            this.radius = p_radius;
        }

        @Override
        public String toString() {
            ResourceBundle resources = ResourceBundle.getBundle("board.resources.ObjectInfoPanel", this.locale);
            String result = resources.getString("circle") + ": ";
            if (this.center.x != 0.0 || this.center.y != 0.0) {
                String center_string = resources.getString("center") + " =" + this.center.to_string(this.locale);
                result = result + center_string;
            }
            NumberFormat nf = NumberFormat.getInstance(this.locale);
            nf.setMaximumFractionDigits(4);
            String radius_string = resources.getString("radius") + " = " + nf.format((float)this.radius);
            result = result + radius_string;
            return result;
        }
    }
}

