/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.AngleRestriction;
import board.CalcFromSide;
import board.ConductionArea;
import board.DrillItem;
import board.ForcedPadAlgo;
import board.Item;
import board.RoutingBoard;
import board.ShapeSearchTree;
import board.ShapeTraceEntries;
import board.Trace;
import board.Via;
import datastructures.TimeLimit;
import geometry.planar.ConvexShape;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.Point;
import geometry.planar.RegularTileShape;
import geometry.planar.TileShape;
import geometry.planar.Vector;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;

public class MoveDrillItemAlgo {
    public static boolean check(DrillItem p_drill_item, Vector p_vector, int p_max_recursion_depth, int p_max_via_recursion_depth, Collection<Item> p_ignore_items, RoutingBoard p_board, TimeLimit p_time_limit) {
        if (p_time_limit != null && p_time_limit.limit_exceeded()) {
            return false;
        }
        if (p_drill_item.is_shove_fixed()) {
            return false;
        }
        Set<Item> contact_list = p_drill_item.get_normal_contacts();
        for (Item curr_contact : contact_list) {
            if (curr_contact instanceof Trace || curr_contact instanceof ConductionArea) continue;
            return false;
        }
        Collection<Item> ignore_items = p_ignore_items == null ? new LinkedList<Item>() : p_ignore_items;
        ignore_items.add(p_drill_item);
        ForcedPadAlgo forced_pad_algo = new ForcedPadAlgo(p_board);
        boolean attach_allowed = false;
        if (p_drill_item instanceof Via) {
            attach_allowed = ((Via)p_drill_item).attach_allowed;
        }
        ShapeSearchTree search_tree = p_board.search_tree_manager.get_default_tree();
        for (int curr_layer = p_drill_item.first_layer(); curr_layer <= p_drill_item.last_layer(); ++curr_layer) {
            CalcFromSide from_side;
            int curr_ind = curr_layer - p_drill_item.first_layer();
            TileShape curr_shape = p_drill_item.get_tree_shape(search_tree, curr_ind);
            if (curr_shape == null) continue;
            ConvexShape new_shape = (ConvexShape)((Object)curr_shape.translate_by(p_vector));
            RegularTileShape curr_tile_shape = p_board.rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE ? new_shape.bounding_box() : new_shape.bounding_octagon();
            if (forced_pad_algo.check_forced_pad(curr_tile_shape, from_side = new CalcFromSide(p_drill_item.get_center(), curr_tile_shape), curr_layer, p_drill_item.net_no_arr, p_drill_item.clearance_class_no(), attach_allowed, ignore_items, p_max_recursion_depth, p_max_via_recursion_depth, true, p_time_limit) != ForcedPadAlgo.CheckDrillResult.NOT_DRILLABLE) continue;
            return false;
        }
        return true;
    }

    static boolean insert(DrillItem p_drill_item, Vector p_vector, int p_max_recursion_depth, int p_max_via_recursion_depth, IntOctagon p_tidy_region, RoutingBoard p_board) {
        if (p_drill_item.is_shove_fixed()) {
            return false;
        }
        boolean attach_allowed = false;
        if (p_drill_item instanceof Via) {
            attach_allowed = ((Via)p_drill_item).attach_allowed;
        }
        ForcedPadAlgo forced_pad_algo = new ForcedPadAlgo(p_board);
        LinkedList<Item> ignore_items = new LinkedList<Item>();
        ignore_items.add(p_drill_item);
        ShapeSearchTree search_tree = p_board.search_tree_manager.get_default_tree();
        for (int curr_layer = p_drill_item.first_layer(); curr_layer <= p_drill_item.last_layer(); ++curr_layer) {
            CalcFromSide from_side;
            int curr_ind = curr_layer - p_drill_item.first_layer();
            TileShape curr_shape = p_drill_item.get_tree_shape(search_tree, curr_ind);
            if (curr_shape == null) continue;
            ConvexShape new_shape = (ConvexShape)((Object)curr_shape.translate_by(p_vector));
            RegularTileShape curr_tile_shape = p_board.rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE ? new_shape.bounding_box() : new_shape.bounding_octagon();
            if (p_tidy_region != null) {
                p_tidy_region = p_tidy_region.union(curr_tile_shape.bounding_octagon());
            }
            if (!forced_pad_algo.forced_pad(curr_tile_shape, from_side = new CalcFromSide(p_drill_item.get_center(), curr_tile_shape), curr_layer, p_drill_item.net_no_arr, p_drill_item.clearance_class_no(), attach_allowed, ignore_items, p_max_recursion_depth, p_max_via_recursion_depth)) {
                return false;
            }
            IntBox curr_bounding_box = curr_shape.bounding_box();
            for (int j = 0; j < 4; ++j) {
                p_board.join_changed_area(curr_bounding_box.corner_approx(j), curr_layer);
            }
        }
        p_drill_item.move_by(p_vector);
        return true;
    }

    static boolean shove_vias(TileShape p_obstacle_shape, CalcFromSide p_from_side, int p_layer, int[] p_net_no_arr, int p_cl_type, Collection<Item> p_ignore_items, int p_max_recursion_depth, int p_max_via_recursion_depth, boolean p_copper_sharing_allowed, RoutingBoard p_board) {
        ShapeTraceEntries shape_entries = new ShapeTraceEntries(p_obstacle_shape, p_layer, p_net_no_arr, p_cl_type, p_from_side, p_board);
        ShapeSearchTree search_tree = p_board.search_tree_manager.get_default_tree();
        Set<Item> obstacles = search_tree.overlapping_items_with_clearance(p_obstacle_shape, p_layer, new int[0], p_cl_type);
        if (!shape_entries.store_items(obstacles, false, p_copper_sharing_allowed)) {
            return true;
        }
        if (p_ignore_items != null) {
            shape_entries.shove_via_list.removeAll(p_ignore_items);
        }
        if (shape_entries.shove_via_list.isEmpty()) {
            return true;
        }
        double shape_radius = 0.5 * p_obstacle_shape.bounding_box().min_width();
        for (Via curr_via : shape_entries.shove_via_list) {
            if (curr_via.shares_net_no(p_net_no_arr)) continue;
            if (p_max_via_recursion_depth <= 0) {
                return true;
            }
            IntPoint[] try_via_centers = MoveDrillItemAlgo.try_shove_via_points(p_obstacle_shape, p_layer, curr_via, p_cl_type, true, p_board);
            IntPoint new_via_center = null;
            double max_dist = 0.5 * curr_via.get_shape_on_layer(p_layer).bounding_box().max_width() + shape_radius;
            double max_dist_square = max_dist * max_dist;
            IntPoint curr_via_center = (IntPoint)curr_via.get_center();
            FloatPoint check_via_center = curr_via_center.to_float();
            Vector rel_coor = null;
            for (int i = 0; i < try_via_centers.length; ++i) {
                boolean shove_ok;
                if (i != 0 && !(check_via_center.distance_square(try_via_centers[i].to_float()) <= max_dist_square)) continue;
                LinkedList<Item> ignore_items = new LinkedList<Item>();
                if (p_ignore_items != null) {
                    ignore_items.addAll(p_ignore_items);
                }
                if (!(shove_ok = MoveDrillItemAlgo.check(curr_via, rel_coor = try_via_centers[i].difference_by((Point)curr_via_center), p_max_recursion_depth, p_max_via_recursion_depth - 1, ignore_items, p_board, null))) continue;
                new_via_center = try_via_centers[i];
                break;
            }
            if (new_via_center == null || MoveDrillItemAlgo.insert(curr_via, rel_coor, p_max_recursion_depth, p_max_via_recursion_depth - 1, null, p_board)) continue;
            return false;
        }
        return true;
    }

    static IntPoint[] try_shove_via_points(TileShape p_obstacle_shape, int p_layer, Via p_via, int p_cl_class_no, boolean p_extended_check, RoutingBoard p_board) {
        IntPoint[] try_via_centers;
        double shove_distance;
        ShapeSearchTree search_tree = p_board.search_tree_manager.get_default_tree();
        TileShape curr_via_shape = p_via.get_tree_shape_on_layer(search_tree, p_layer);
        if (curr_via_shape == null) {
            return new IntPoint[0];
        }
        boolean is_int_octagon = p_obstacle_shape.is_IntOctagon();
        double clearance_value = p_board.clearance_value(p_cl_class_no, p_via.clearance_class_no(), p_layer);
        if (p_board.rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE || is_int_octagon) {
            shove_distance = 0.5 * curr_via_shape.bounding_box().max_width();
            if (!search_tree.is_clearance_compensation_used()) {
                shove_distance += clearance_value;
            }
        } else {
            shove_distance = 0.0;
            if (!search_tree.is_clearance_compensation_used()) {
                shove_distance += 0.5 * clearance_value;
            }
        }
        shove_distance += 2.0;
        IntPoint curr_via_center = (IntPoint)p_via.get_center();
        int try_count = 1;
        if (p_board.rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE) {
            IntBox curr_offset_box = p_obstacle_shape.bounding_box().offset(shove_distance);
            if (p_extended_check) {
                try_count = 2;
            }
            try_via_centers = curr_offset_box.nearest_border_projections(curr_via_center, try_count);
        } else if (is_int_octagon) {
            IntOctagon curr_offset_octagon = p_obstacle_shape.bounding_octagon().enlarge(shove_distance);
            if (p_extended_check) {
                try_count = 4;
            }
            try_via_centers = curr_offset_octagon.nearest_border_projections(curr_via_center, try_count);
        } else {
            TileShape curr_offset_shape = (TileShape)p_obstacle_shape.enlarge(shove_distance);
            if (!search_tree.is_clearance_compensation_used()) {
                curr_via_shape = (TileShape)curr_via_shape.enlarge(0.5 * clearance_value);
            }
            if (p_extended_check) {
                try_count = 4;
            }
            FloatPoint[] shove_deltas = curr_offset_shape.nearest_relative_outside_locations(curr_via_shape, try_count);
            try_via_centers = new IntPoint[shove_deltas.length];
            for (int i = 0; i < try_via_centers.length; ++i) {
                Vector curr_delta = shove_deltas[i].round().difference_by((Point)Point.ZERO);
                try_via_centers[i] = (IntPoint)curr_via_center.translate_by(curr_delta);
            }
        }
        return try_via_centers;
    }
}

