/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Item;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

public class ItemSelectionFilter
implements Serializable {
    private final boolean[] values = new boolean[SelectableChoices.values().length];

    public ItemSelectionFilter() {
        Arrays.fill(this.values, true);
        this.values[SelectableChoices.KEEPOUT.ordinal()] = false;
        this.values[SelectableChoices.VIA_KEEPOUT.ordinal()] = false;
        this.values[SelectableChoices.COMPONENT_KEEPOUT.ordinal()] = false;
        this.values[SelectableChoices.CONDUCTION.ordinal()] = false;
        this.values[SelectableChoices.BOARD_OUTLINE.ordinal()] = false;
    }

    public ItemSelectionFilter(SelectableChoices p_item_type) {
        Arrays.fill(this.values, false);
        this.values[p_item_type.ordinal()] = true;
        this.values[SelectableChoices.FIXED.ordinal()] = true;
        this.values[SelectableChoices.UNFIXED.ordinal()] = true;
    }

    public ItemSelectionFilter(SelectableChoices[] p_item_types) {
        Arrays.fill(this.values, false);
        for (int i = 0; i < p_item_types.length; ++i) {
            this.values[p_item_types[i].ordinal()] = true;
        }
        this.values[SelectableChoices.FIXED.ordinal()] = true;
        this.values[SelectableChoices.UNFIXED.ordinal()] = true;
    }

    public ItemSelectionFilter(ItemSelectionFilter p_item_selection_filter) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = p_item_selection_filter.values[i];
        }
    }

    public void set_selected(SelectableChoices p_choice, boolean p_value) {
        this.values[p_choice.ordinal()] = p_value;
    }

    public void select_all() {
        Arrays.fill(this.values, true);
    }

    public void deselect_all() {
        Arrays.fill(this.values, false);
    }

    public Set<Item> filter(Set<Item> p_items) {
        TreeSet<Item> result = new TreeSet<Item>();
        for (Item curr_item : p_items) {
            if (!curr_item.is_selected_by_filter(this)) continue;
            result.add(curr_item);
        }
        return result;
    }

    public boolean is_selected(SelectableChoices p_choice) {
        return this.values[p_choice.ordinal()];
    }

    public static enum SelectableChoices {
        TRACES,
        VIAS,
        PINS,
        CONDUCTION,
        KEEPOUT,
        VIA_KEEPOUT,
        COMPONENT_KEEPOUT,
        BOARD_OUTLINE,
        FIXED,
        UNFIXED;

    }
}

