/*
 * Decompiled with CFR 0.152.
 */
package board;

import datastructures.ShapeTree;
import geometry.planar.TileShape;
import java.util.Collection;
import java.util.LinkedList;

class ItemSearchTreesInfo {
    private final Collection<SearchTreeInfo> tree_list = new LinkedList<SearchTreeInfo>();

    public ShapeTree.Leaf[] get_tree_entries(ShapeTree p_tree) {
        for (SearchTreeInfo curr_tree_info : this.tree_list) {
            if (curr_tree_info.tree != p_tree) continue;
            return curr_tree_info.entry_arr;
        }
        return null;
    }

    public void set_tree_entries(ShapeTree.Leaf[] p_tree_entries, ShapeTree p_tree) {
        for (SearchTreeInfo curr_tree_info : this.tree_list) {
            if (curr_tree_info.tree != p_tree) continue;
            curr_tree_info.entry_arr = p_tree_entries;
            return;
        }
        SearchTreeInfo new_tree_info = new SearchTreeInfo(p_tree);
        new_tree_info.entry_arr = p_tree_entries;
        this.tree_list.add(new_tree_info);
    }

    public TileShape[] get_precalculated_tree_shapes(ShapeTree p_tree) {
        for (SearchTreeInfo curr_tree_info : this.tree_list) {
            if (curr_tree_info.tree != p_tree) continue;
            return curr_tree_info.precalculated_tree_shapes;
        }
        return null;
    }

    public void set_precalculated_tree_shapes(TileShape[] p_tile_shapes, ShapeTree p_tree) {
        for (SearchTreeInfo curr_tree_info : this.tree_list) {
            if (curr_tree_info.tree != p_tree) continue;
            curr_tree_info.precalculated_tree_shapes = p_tile_shapes;
            return;
        }
        SearchTreeInfo new_tree_info = new SearchTreeInfo(p_tree);
        new_tree_info.precalculated_tree_shapes = p_tile_shapes;
        this.tree_list.add(new_tree_info);
    }

    public void clear_precalculated_tree_shapes() {
        for (SearchTreeInfo curr_tree_info : this.tree_list) {
            curr_tree_info.precalculated_tree_shapes = null;
        }
    }

    private static class SearchTreeInfo {
        final ShapeTree tree;
        ShapeTree.Leaf[] entry_arr;
        TileShape[] precalculated_tree_shapes;

        SearchTreeInfo(ShapeTree p_tree) {
            this.tree = p_tree;
            this.entry_arr = null;
            this.precalculated_tree_shapes = null;
        }
    }
}

