/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.AngleRestriction;
import board.BasicBoard;
import board.ConductionArea;
import board.Connectable;
import board.FixedState;
import board.Item;
import board.SearchTreeObject;
import board.ShapeSearchTree;
import board.Trace;
import boardgraphics.GraphicsContext;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntPoint;
import geometry.planar.Point;
import geometry.planar.Shape;
import geometry.planar.TileShape;
import geometry.planar.Vector;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import library.Padstack;

public abstract class DrillItem
extends Item
implements Connectable,
Serializable {
    private Point center;
    private double precalculated_min_width = -1.0;
    private int precalculated_first_layer = -1;
    private int precalculated_last_layer = -1;

    public DrillItem(Point p_center, int[] p_net_no_arr, int p_clearance_type, int p_id_no, int p_group_no, FixedState p_fixed_state, BasicBoard p_board) {
        super(p_net_no_arr, p_clearance_type, p_id_no, p_group_no, p_fixed_state, p_board);
        this.center = p_center;
    }

    @Override
    public void translate_by(Vector p_vector) {
        if (this.center != null) {
            this.center = this.center.translate_by(p_vector);
        }
        this.clear_derived_data();
    }

    @Override
    public void turn_90_degree(int p_factor, IntPoint p_pole) {
        if (this.center != null) {
            this.center = this.center.turn_90_degree(p_factor, p_pole);
        }
        this.clear_derived_data();
    }

    @Override
    public void rotate_approx(double p_angle_in_degree, FloatPoint p_pole) {
        if (this.center != null) {
            FloatPoint new_center = this.center.to_float().rotate(Math.toRadians(p_angle_in_degree), p_pole);
            this.center = new_center.round();
        }
        this.clear_derived_data();
    }

    @Override
    public void change_placement_side(IntPoint p_pole) {
        if (this.center != null) {
            this.center = this.center.mirror_vertical(p_pole);
        }
        this.clear_derived_data();
    }

    @Override
    public void move_by(Vector p_vector) {
        Point old_center = this.get_center();
        TreeSet<TraceInfo> contact_trace_info = new TreeSet<TraceInfo>();
        Set<Item> contacts = this.get_normal_contacts();
        for (Item curr_contact : contacts) {
            if (!(curr_contact instanceof Trace)) continue;
            Trace curr_trace = (Trace)curr_contact;
            TraceInfo curr_trace_info = new TraceInfo(curr_trace.get_layer(), curr_trace.get_half_width(), curr_trace.clearance_class_no());
            contact_trace_info.add(curr_trace_info);
        }
        super.move_by(p_vector);
        LinkedList<Point> connect_point_list = new LinkedList<Point>();
        connect_point_list.add(old_center);
        Point new_center = this.get_center();
        IntPoint add_corner = null;
        if (old_center instanceof IntPoint && new_center instanceof IntPoint) {
            if (this.board.rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE) {
                add_corner = ((IntPoint)old_center).ninety_degree_corner((IntPoint)new_center, true);
            } else if (this.board.rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE) {
                add_corner = ((IntPoint)old_center).fortyfive_degree_corner((IntPoint)new_center, true);
            }
        }
        if (add_corner != null) {
            connect_point_list.add(add_corner);
        }
        connect_point_list.add(new_center);
        Point[] connect_points = new Point[connect_point_list.size()];
        Iterator it3 = connect_point_list.iterator();
        for (int i = 0; i < connect_points.length; ++i) {
            connect_points[i] = (Point)it3.next();
        }
        for (TraceInfo curr_trace_info : contact_trace_info) {
            this.board.insert_trace(connect_points, curr_trace_info.layer, curr_trace_info.half_width, this.net_no_arr, curr_trace_info.clearance_type, FixedState.UNFIXED);
        }
    }

    @Override
    public int shape_layer(int p_index) {
        int index = Math.max(p_index, 0);
        int from_layer = this.first_layer();
        int to_layer = this.last_layer();
        index = Math.min(index, to_layer - from_layer);
        return from_layer + index;
    }

    @Override
    public boolean is_on_layer(int p_layer) {
        return p_layer >= this.first_layer() && p_layer <= this.last_layer();
    }

    @Override
    public int first_layer() {
        if (this.precalculated_first_layer < 0) {
            Padstack padstack = this.get_padstack();
            this.precalculated_first_layer = this.is_placed_on_front() || padstack.placed_absolute ? padstack.from_layer() : padstack.board_layer_count() - padstack.to_layer() - 1;
        }
        return this.precalculated_first_layer;
    }

    @Override
    public int last_layer() {
        if (this.precalculated_last_layer < 0) {
            Padstack padstack = this.get_padstack();
            this.precalculated_last_layer = this.is_placed_on_front() || padstack.placed_absolute ? padstack.to_layer() : padstack.board_layer_count() - padstack.from_layer() - 1;
        }
        return this.precalculated_last_layer;
    }

    public abstract Shape get_shape(int var1);

    @Override
    public IntBox bounding_box() {
        IntBox result = IntBox.EMPTY;
        for (int i = 0; i < this.tile_shape_count(); ++i) {
            Shape curr_shape = this.get_shape(i);
            if (curr_shape == null) continue;
            result = result.union(curr_shape.bounding_box());
        }
        return result;
    }

    @Override
    public int tile_shape_count() {
        Padstack padstack = this.get_padstack();
        int from_layer = padstack.from_layer();
        int to_layer = padstack.to_layer();
        return to_layer - from_layer + 1;
    }

    @Override
    protected TileShape[] calculate_tree_shapes(ShapeSearchTree p_search_tree) {
        return p_search_tree.calculate_tree_shapes(this);
    }

    public double smallest_radius() {
        double result = Double.MAX_VALUE;
        FloatPoint c = this.get_center().to_float();
        for (int i = 0; i < this.tile_shape_count(); ++i) {
            Shape curr_shape = this.get_shape(i);
            if (curr_shape == null) continue;
            result = Math.min(result, curr_shape.border_distance(c));
        }
        return result;
    }

    public Point get_center() {
        return this.center;
    }

    protected void set_center(Point p_center) {
        this.center = p_center;
    }

    public abstract Padstack get_padstack();

    public TileShape get_tree_shape_on_layer(ShapeSearchTree p_tree, int p_layer) {
        int from_layer = this.first_layer();
        int to_layer = this.last_layer();
        if (p_layer < from_layer || p_layer > to_layer) {
            System.out.println("DrillItem.get_tree_shape_on_layer: p_layer out of range");
            return null;
        }
        return this.get_tree_shape(p_tree, p_layer - from_layer);
    }

    public TileShape get_tile_shape_on_layer(int p_layer) {
        int from_layer = this.first_layer();
        int to_layer = this.last_layer();
        if (p_layer < from_layer || p_layer > to_layer) {
            System.out.println("DrillItem.get_tile_shape_on_layer: p_layer out of range");
            return null;
        }
        return this.get_tile_shape(p_layer - from_layer);
    }

    public Shape get_shape_on_layer(int p_layer) {
        int from_layer = this.first_layer();
        int to_layer = this.last_layer();
        if (p_layer < from_layer || p_layer > to_layer) {
            System.out.println("DrillItem.get_shape_on_layer: p_layer out of range");
            return null;
        }
        return this.get_shape(p_layer - from_layer);
    }

    @Override
    public Set<Item> get_normal_contacts() {
        Point drill_center = this.get_center();
        IntBox search_shape = TileShape.get_instance(drill_center);
        Set<SearchTreeObject> overlaps = this.board.overlapping_objects(search_shape, -1);
        Iterator<SearchTreeObject> it = overlaps.iterator();
        TreeSet<Item> result = new TreeSet<Item>();
        while (it.hasNext()) {
            ConductionArea curr_area;
            Item curr_item;
            SearchTreeObject curr_ob = it.next();
            if (!(curr_ob instanceof Item) || (curr_item = (Item)curr_ob) == this || !curr_item.shares_net(this) || !curr_item.shares_layer(this)) continue;
            if (curr_item instanceof Trace) {
                Trace curr_trace = (Trace)curr_item;
                if (!drill_center.equals(curr_trace.first_corner()) && !drill_center.equals(curr_trace.last_corner())) continue;
                result.add(curr_item);
                continue;
            }
            if (curr_item instanceof DrillItem) {
                DrillItem curr_drill_item = (DrillItem)curr_item;
                if (!drill_center.equals(curr_drill_item.get_center())) continue;
                result.add(curr_item);
                continue;
            }
            if (!(curr_item instanceof ConductionArea) || !(curr_area = (ConductionArea)curr_item).get_area().contains(drill_center)) continue;
            result.add(curr_item);
        }
        return result;
    }

    @Override
    public Point normal_contact_point(Item p_other) {
        return p_other.normal_contact_point(this);
    }

    @Override
    Point normal_contact_point(DrillItem p_other) {
        if (this.shares_layer(p_other) && this.get_center().equals(p_other.get_center())) {
            return this.get_center();
        }
        return null;
    }

    @Override
    Point normal_contact_point(Trace p_trace) {
        if (!this.shares_layer(p_trace)) {
            return null;
        }
        Point drill_center = this.get_center();
        if (drill_center.equals(p_trace.first_corner()) || drill_center.equals(p_trace.last_corner())) {
            return drill_center;
        }
        return null;
    }

    @Override
    public Point[] get_ratsnest_corners() {
        Point[] result = new Point[]{this.get_center()};
        return result;
    }

    @Override
    public TileShape get_trace_connection_shape(ShapeSearchTree p_search_tree, int p_index) {
        return TileShape.get_instance(this.get_center());
    }

    public boolean is_placed_on_front() {
        return true;
    }

    public double min_width() {
        if (this.precalculated_min_width < 0.0) {
            double min_width = 2.147483647E9;
            int begin_layer = this.first_layer();
            int end_layer = this.last_layer();
            for (int curr_layer = begin_layer; curr_layer <= end_layer; ++curr_layer) {
                Shape curr_shape;
                if (this.board != null && !this.board.layer_structure.arr[curr_layer].is_signal || (curr_shape = this.get_shape_on_layer(curr_layer)) == null) continue;
                IntBox curr_bounding_box = curr_shape.bounding_box();
                min_width = Math.min(min_width, (double)curr_bounding_box.width());
                min_width = Math.min(min_width, (double)curr_bounding_box.height());
            }
            this.precalculated_min_width = min_width;
        }
        return this.precalculated_min_width;
    }

    @Override
    public void clear_derived_data() {
        super.clear_derived_data();
        this.precalculated_first_layer = -1;
        this.precalculated_last_layer = -1;
    }

    @Override
    public int get_draw_priority() {
        return 3;
    }

    @Override
    public void draw(Graphics p_g, GraphicsContext p_graphics_context, Color[] p_color_arr, double p_intensity) {
        if (p_graphics_context == null || p_intensity <= 0.0) {
            return;
        }
        int from_layer = this.first_layer();
        int to_layer = this.last_layer();
        double visibility_factor = 0.0;
        for (int i = from_layer; i <= to_layer; ++i) {
            visibility_factor += p_graphics_context.get_layer_visibility(i);
        }
        if (visibility_factor < 0.001) {
            return;
        }
        double intensity = p_intensity / Math.max(visibility_factor, 1.0);
        for (int i = 0; i <= to_layer - from_layer; ++i) {
            Shape curr_shape = this.get_shape(i);
            if (curr_shape == null) continue;
            Color color = p_color_arr[from_layer + i];
            double layer_intensity = intensity * p_graphics_context.get_layer_visibility(from_layer + i);
            p_graphics_context.fill_area(curr_shape, p_g, color, layer_intensity);
        }
    }

    private static class TraceInfo
    implements Comparable<TraceInfo> {
        int layer;
        int half_width;
        int clearance_type;

        TraceInfo(int p_layer, int p_half_width, int p_clearance_type) {
            this.layer = p_layer;
            this.half_width = p_half_width;
            this.clearance_type = p_clearance_type;
        }

        @Override
        public int compareTo(TraceInfo p_other) {
            return p_other.layer - this.layer;
        }
    }
}

