/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Item;
import board.ObjectInfoPanel;
import geometry.planar.ConvexShape;
import java.util.Locale;
import java.util.ResourceBundle;

public class ClearanceViolation
implements ObjectInfoPanel.Printable {
    public final Item first_item;
    public final Item second_item;
    public final ConvexShape shape;
    public final int layer;

    public ClearanceViolation(Item p_first_item, Item p_second_item, ConvexShape p_shape, int p_layer) {
        this.first_item = p_first_item;
        this.second_item = p_second_item;
        this.shape = p_shape;
        this.layer = p_layer;
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        ResourceBundle resources = ResourceBundle.getBundle("board.resources.ObjectInfoPanel", p_locale);
        p_window.append_bold(resources.getString("clearance_violation_2"));
        p_window.append(" " + resources.getString("at") + " ");
        p_window.append(this.shape.centre_of_gravity());
        p_window.append(", " + resources.getString("width") + " ");
        p_window.append(2.0 * this.shape.smallest_radius());
        p_window.append(", " + resources.getString("layer") + " ");
        p_window.append(this.first_item.board.layer_structure.arr[this.layer].name);
        p_window.append(", " + resources.getString("between"));
        p_window.newline();
        p_window.indent();
        this.first_item.print_info(p_window, p_locale);
        p_window.indent();
        this.second_item.print_info(p_window, p_locale);
    }
}

