/*
 * Decompiled with CFR 0.152.
 */
package board;

import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntOctagon;
import geometry.planar.TileShape;

class ChangedArea {
    final int layer_count;
    MutableOctagon[] arr;

    public ChangedArea(int p_layer_count) {
        this.layer_count = p_layer_count;
        this.arr = new MutableOctagon[this.layer_count];
        for (int i = 0; i < this.layer_count; ++i) {
            this.arr[i] = new MutableOctagon();
            this.arr[i].set_empty();
        }
    }

    public void join(FloatPoint p_point, int p_layer) {
        MutableOctagon curr = this.arr[p_layer];
        curr.lx = Math.min(p_point.x, curr.lx);
        curr.ly = Math.min(p_point.y, curr.ly);
        curr.rx = Math.max(curr.rx, p_point.x);
        curr.uy = Math.max(curr.uy, p_point.y);
        double tmp = p_point.x - p_point.y;
        curr.ulx = Math.min(curr.ulx, tmp);
        curr.lrx = Math.max(curr.lrx, tmp);
        tmp = p_point.x + p_point.y;
        curr.llx = Math.min(curr.llx, tmp);
        curr.urx = Math.max(curr.urx, tmp);
    }

    public void join(TileShape p_shape, int p_layer) {
        if (p_shape == null) {
            return;
        }
        int corner_count = p_shape.border_line_count();
        for (int i = 0; i < corner_count; ++i) {
            this.join(p_shape.corner_approx(i), p_layer);
        }
    }

    public IntOctagon get_area(int p_layer) {
        return this.arr[p_layer].to_int();
    }

    public IntBox surrounding_box() {
        int llx = Integer.MAX_VALUE;
        int lly = Integer.MAX_VALUE;
        int urx = Integer.MIN_VALUE;
        int ury = Integer.MIN_VALUE;
        for (int i = 0; i < this.layer_count; ++i) {
            MutableOctagon curr = this.arr[i];
            llx = Math.min(llx, (int)Math.floor(curr.lx));
            lly = Math.min(lly, (int)Math.floor(curr.ly));
            urx = Math.max(urx, (int)Math.ceil(curr.rx));
            ury = Math.max(ury, (int)Math.ceil(curr.uy));
        }
        if (llx > urx || lly > ury) {
            return IntBox.EMPTY;
        }
        return new IntBox(llx, lly, urx, ury);
    }

    void set_empty(int p_layer) {
        this.arr[p_layer].set_empty();
    }

    private static class MutableOctagon {
        double lx;
        double ly;
        double rx;
        double uy;
        double ulx;
        double lrx;
        double llx;
        double urx;

        private MutableOctagon() {
        }

        void set_empty() {
            this.lx = 2.147483647E9;
            this.ly = 2.147483647E9;
            this.rx = -2.147483648E9;
            this.uy = -2.147483648E9;
            this.ulx = 2.147483647E9;
            this.lrx = -2.147483648E9;
            this.llx = 2.147483647E9;
            this.urx = -2.147483648E9;
        }

        IntOctagon to_int() {
            if (this.rx < this.lx || this.uy < this.ly || this.lrx < this.ulx || this.urx < this.llx) {
                return IntOctagon.EMPTY;
            }
            return new IntOctagon((int)Math.floor(this.lx), (int)Math.floor(this.ly), (int)Math.ceil(this.rx), (int)Math.ceil(this.uy), (int)Math.floor(this.ulx), (int)Math.ceil(this.lrx), (int)Math.floor(this.llx), (int)Math.ceil(this.urx));
        }
    }
}

