/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.CalcFromSide;
import board.PolylineTrace;
import board.ShapeSearchTree;
import geometry.planar.FloatPoint;
import geometry.planar.Line;
import geometry.planar.Polyline;
import geometry.planar.Side;
import geometry.planar.TileShape;

class CalcShapeAndFromSide {
    final TileShape shape;
    final CalcFromSide from_side;

    CalcShapeAndFromSide(PolylineTrace p_trace, int p_index, boolean p_orthogonal, boolean p_in_shove_check) {
        ShapeSearchTree search_tree = p_trace.board.search_tree_manager.get_default_tree();
        TileShape curr_shape = p_trace.get_tree_shape(search_tree, p_index);
        CalcFromSide curr_from_side = null;
        boolean cut_off_at_start = false;
        boolean cut_off_at_end = false;
        if (p_orthogonal) {
            curr_shape = curr_shape.bounding_box();
        } else {
            TileShape cut_plane;
            TileShape tmp_shape;
            Line start_cutline;
            TileShape cut_plane2;
            TileShape tmp_shape2;
            curr_shape = curr_shape.to_Simplex();
            Line end_cutline = CalcShapeAndFromSide.calc_cutline_at_end(p_index, p_trace);
            if (end_cutline != null && (tmp_shape2 = curr_shape.intersection(cut_plane2 = TileShape.get_instance(end_cutline))) != curr_shape && !tmp_shape2.is_empty()) {
                curr_shape = tmp_shape2.to_Simplex();
                cut_off_at_end = true;
            }
            if ((start_cutline = CalcShapeAndFromSide.calc_cutline_at_start(p_index, p_trace)) != null && (tmp_shape = curr_shape.intersection(cut_plane = TileShape.get_instance(start_cutline))) != curr_shape && !tmp_shape.is_empty()) {
                curr_shape = tmp_shape.to_Simplex();
                cut_off_at_start = true;
            }
            int from_side_no = -1;
            Line curr_cut_line = null;
            if (cut_off_at_start) {
                curr_cut_line = start_cutline;
                from_side_no = curr_shape.border_line_index(curr_cut_line);
            }
            if (from_side_no < 0 && cut_off_at_end) {
                curr_cut_line = end_cutline;
                from_side_no = curr_shape.border_line_index(curr_cut_line);
            }
            if (from_side_no >= 0) {
                FloatPoint border_intersection = curr_cut_line.intersection_approx(curr_shape.border_line(from_side_no));
                curr_from_side = new CalcFromSide(from_side_no, border_intersection);
            }
        }
        if (curr_from_side == null && !p_in_shove_check) {
            curr_from_side = new CalcFromSide(p_trace.polyline(), p_index, curr_shape);
        }
        this.shape = curr_shape;
        this.from_side = curr_from_side;
    }

    private static Line calc_cutline_at_end(int p_index, PolylineTrace p_trace) {
        Polyline trace_lines = p_trace.polyline();
        ShapeSearchTree search_tree = p_trace.board.search_tree_manager.get_default_tree();
        if (p_index == trace_lines.arr.length - 3 || trace_lines.corner_approx(trace_lines.arr.length - 2).distance(trace_lines.corner_approx(p_index + 1)) < (double)p_trace.get_compensated_half_width(search_tree)) {
            Line curr_line = trace_lines.arr[trace_lines.arr.length - 1];
            FloatPoint is = trace_lines.corner_approx(trace_lines.arr.length - 3);
            Line cut_line = curr_line.side_of(is) == Side.ON_THE_LEFT ? curr_line.opposite() : curr_line;
            return cut_line;
        }
        return null;
    }

    private static Line calc_cutline_at_start(int p_index, PolylineTrace p_trace) {
        Polyline trace_lines = p_trace.polyline();
        ShapeSearchTree search_tree = p_trace.board.search_tree_manager.get_default_tree();
        if (p_index == 0 || trace_lines.corner_approx(0).distance(trace_lines.corner_approx(p_index)) < (double)p_trace.get_compensated_half_width(search_tree)) {
            Line curr_line = trace_lines.arr[0];
            FloatPoint is = trace_lines.corner_approx(1);
            Line cut_line = curr_line.side_of(is) == Side.ON_THE_LEFT ? curr_line.opposite() : curr_line;
            return cut_line;
        }
        return null;
    }
}

