/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.CompleteExpansionRoom;
import autoroute.ExpandableObject;
import autoroute.ItemAutorouteInfo;
import autoroute.MazeSearchElement;
import board.Item;
import board.ShapeSearchTree;
import geometry.planar.Simplex;
import geometry.planar.TileShape;

public class TargetItemExpansionDoor
implements ExpandableObject {
    public final Item item;
    public final int tree_entry_no;
    public final CompleteExpansionRoom room;
    private final TileShape shape;
    private final MazeSearchElement maze_search_info;

    public TargetItemExpansionDoor(Item p_item, int p_tree_entry_no, CompleteExpansionRoom p_room, ShapeSearchTree p_search_tree) {
        this.item = p_item;
        this.tree_entry_no = p_tree_entry_no;
        this.room = p_room;
        if (this.room == null) {
            this.shape = Simplex.EMPTY;
        } else {
            TileShape item_shape = this.item.get_tree_shape(p_search_tree, this.tree_entry_no);
            this.shape = item_shape.intersection(this.room.get_shape());
        }
        this.maze_search_info = new MazeSearchElement();
    }

    @Override
    public TileShape get_shape() {
        return this.shape;
    }

    @Override
    public int get_dimension() {
        return 2;
    }

    public boolean is_destination_door() {
        ItemAutorouteInfo item_info = this.item.get_autoroute_info();
        return !item_info.is_start_info();
    }

    @Override
    public CompleteExpansionRoom other_room(CompleteExpansionRoom p_room) {
        return null;
    }

    @Override
    public MazeSearchElement get_maze_search_element(int p_no) {
        return this.maze_search_info;
    }

    @Override
    public int maze_search_element_count() {
        return 1;
    }

    @Override
    public void reset() {
        this.maze_search_info.reset();
    }
}

