/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.AutorouteEngine;
import autoroute.CompleteExpansionRoom;
import autoroute.CompleteFreeSpaceExpansionRoom;
import autoroute.ExpansionDoor;
import autoroute.ExpansionRoom;
import autoroute.IncompleteFreeSpaceExpansionRoom;
import autoroute.ItemAutorouteInfo;
import autoroute.ObstacleExpansionRoom;
import autoroute.TargetItemExpansionDoor;
import board.Connectable;
import board.Item;
import board.PolylineTrace;
import board.SearchTreeObject;
import board.ShapeSearchTree;
import board.TestLevel;
import datastructures.ShapeTree;
import datastructures.Signum;
import geometry.planar.Direction;
import geometry.planar.FloatPoint;
import geometry.planar.IntPoint;
import geometry.planar.Line;
import geometry.planar.Point;
import geometry.planar.Side;
import geometry.planar.Simplex;
import geometry.planar.TileShape;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;

public class SortedRoomNeighbours {
    private final ExpansionRoom from_room;
    private final CompleteExpansionRoom completed_room;
    private final TileShape room_shape;
    private final SortedSet<SortedRoomNeighbour> sorted_neighbours;
    private final Collection<ShapeTree.TreeEntry> own_net_objects;

    public static CompleteExpansionRoom calculate(ExpansionRoom p_room, AutorouteEngine p_autoroute_engine) {
        int net_no = p_autoroute_engine.get_net_no();
        TestLevel test_level = p_autoroute_engine.board.get_test_level();
        SortedRoomNeighbours room_neighbours = SortedRoomNeighbours.calculate_neighbours(p_room, net_no, p_autoroute_engine.autoroute_search_tree, p_autoroute_engine.generate_room_id_no(), test_level);
        boolean edge_removed = room_neighbours.try_remove_edge(net_no, p_autoroute_engine.autoroute_search_tree, test_level);
        CompleteExpansionRoom result = room_neighbours.completed_room;
        if (edge_removed) {
            p_autoroute_engine.remove_all_doors(result);
            return SortedRoomNeighbours.calculate(p_room, p_autoroute_engine);
        }
        if (room_neighbours.sorted_neighbours.isEmpty()) {
            if (result instanceof ObstacleExpansionRoom) {
                SortedRoomNeighbours.calculate_incomplete_rooms_with_empty_neighbours((ObstacleExpansionRoom)p_room, p_autoroute_engine);
            }
        } else {
            room_neighbours.calculate_new_incomplete_rooms(p_autoroute_engine);
            if (test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal() && result.get_shape().dimension() < 2) {
                System.out.println("AutorouteEngine.calculate_new_incomplete_rooms_with_mmore_than_1_neighbour: unexpected dimension for smoothened_shape");
            }
        }
        if (result instanceof CompleteFreeSpaceExpansionRoom) {
            SortedRoomNeighbours.calculate_target_doors((CompleteFreeSpaceExpansionRoom)result, room_neighbours.own_net_objects, p_autoroute_engine);
        }
        return result;
    }

    private static void calculate_incomplete_rooms_with_empty_neighbours(ObstacleExpansionRoom p_room, AutorouteEngine p_autoroute_engine) {
        TileShape room_shape = p_room.get_shape();
        for (int i = 0; i < room_shape.border_line_count(); ++i) {
            Line curr_line = room_shape.border_line(i);
            if (!SortedRoomNeighbours.insert_door_ok(p_room, curr_line)) continue;
            Line[] shape_line = new Line[]{curr_line.opposite()};
            Simplex new_room_shape = new Simplex(shape_line);
            TileShape new_contained_shape = room_shape.intersection((TileShape)new_room_shape);
            IncompleteFreeSpaceExpansionRoom new_room = p_autoroute_engine.add_incomplete_expansion_room(new_room_shape, p_room.get_layer(), new_contained_shape);
            ExpansionDoor new_door = new ExpansionDoor(p_room, new_room, 1);
            p_room.add_door(new_door);
            new_room.add_door(new_door);
        }
    }

    private static void calculate_target_doors(CompleteFreeSpaceExpansionRoom p_room, Collection<ShapeTree.TreeEntry> p_own_net_objects, AutorouteEngine p_autoroute_engine) {
        if (!p_own_net_objects.isEmpty()) {
            p_room.set_net_dependent();
        }
        for (ShapeTree.TreeEntry curr_entry : p_own_net_objects) {
            TileShape curr_connection_shape;
            Connectable curr_object;
            if (!(curr_entry.object instanceof Connectable) || !(curr_object = (Connectable)((Object)curr_entry.object)).contains_net(p_autoroute_engine.get_net_no()) || (curr_connection_shape = curr_object.get_trace_connection_shape(p_autoroute_engine.autoroute_search_tree, curr_entry.shape_index_in_object)) == null || !p_room.get_shape().intersects(curr_connection_shape)) continue;
            Item curr_item = (Item)((Object)curr_object);
            TargetItemExpansionDoor new_target_door = new TargetItemExpansionDoor(curr_item, curr_entry.shape_index_in_object, p_room, p_autoroute_engine.autoroute_search_tree);
            p_room.add_target_door(new_target_door);
        }
    }

    private static SortedRoomNeighbours calculate_neighbours(ExpansionRoom p_room, int p_net_no, ShapeSearchTree p_autoroute_search_tree, int p_room_id_no, TestLevel p_test_level) {
        CompleteExpansionRoom completed_room;
        TileShape room_shape = p_room.get_shape();
        if (p_room instanceof IncompleteFreeSpaceExpansionRoom) {
            completed_room = new CompleteFreeSpaceExpansionRoom(room_shape, p_room.get_layer(), p_room_id_no);
        } else if (p_room instanceof ObstacleExpansionRoom) {
            completed_room = (ObstacleExpansionRoom)p_room;
        } else {
            System.out.println("SortedRoomNeighbours.calculate: unexpected expansion room type");
            return null;
        }
        SortedRoomNeighbours result = new SortedRoomNeighbours(p_room, completed_room);
        LinkedList<ShapeTree.TreeEntry> overlapping_objects = new LinkedList<ShapeTree.TreeEntry>();
        p_autoroute_search_tree.overlapping_tree_entries(room_shape, p_room.get_layer(), overlapping_objects);
        for (ShapeTree.TreeEntry curr_entry : overlapping_objects) {
            int touching_side_no_of_neighbour_room;
            boolean neighbour_room_touch_is_corner;
            int touching_side_no_of_room;
            boolean room_touch_is_corner;
            SearchTreeObject curr_object = (SearchTreeObject)curr_entry.object;
            if (curr_object == p_room) continue;
            if (p_room instanceof IncompleteFreeSpaceExpansionRoom && !curr_object.is_trace_obstacle(p_net_no)) {
                result.own_net_objects.add(curr_entry);
                continue;
            }
            TileShape curr_shape = curr_object.get_tree_shape(p_autoroute_search_tree, curr_entry.shape_index_in_object);
            TileShape intersection = room_shape.intersection(curr_shape);
            int dimension = intersection.dimension();
            if (dimension > 1) {
                if (completed_room instanceof ObstacleExpansionRoom && curr_object instanceof Item) {
                    Item curr_item = (Item)curr_object;
                    if (!curr_item.is_route()) continue;
                    ItemAutorouteInfo item_info = curr_item.get_autoroute_info();
                    ObstacleExpansionRoom curr_overlap_room = item_info.get_expansion_room(curr_entry.shape_index_in_object, p_autoroute_search_tree);
                    ((ObstacleExpansionRoom)completed_room).create_overlap_door(curr_overlap_room);
                    continue;
                }
                if (p_test_level.ordinal() < TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) continue;
                System.out.println("SortedRoomNeighbours.calculate: unexpected area overlap of free space expansion room");
                continue;
            }
            if (dimension < 0) {
                if (p_test_level.ordinal() < TestLevel.CRITICAL_DEBUGGING_OUTPUT.ordinal()) continue;
                System.out.println("SortedRoomNeighbours.calculate: dimension >= 0 expected");
                continue;
            }
            if (dimension == 1) {
                Item curr_item;
                int[] touching_sides = room_shape.touching_sides(curr_shape);
                if (touching_sides.length != 2) {
                    if (p_test_level.ordinal() < TestLevel.CRITICAL_DEBUGGING_OUTPUT.ordinal()) continue;
                    System.out.println("SortedRoomNeighbours.calculate: touching_sides length 2 expected");
                    continue;
                }
                result.add_sorted_neighbour(curr_shape, intersection, touching_sides[0], touching_sides[1], false, false);
                ExpansionRoom neighbour_room = null;
                if (curr_object instanceof ExpansionRoom) {
                    neighbour_room = (ExpansionRoom)((Object)curr_object);
                } else if (curr_object instanceof Item && (curr_item = (Item)curr_object).is_route()) {
                    ItemAutorouteInfo item_info = curr_item.get_autoroute_info();
                    neighbour_room = item_info.get_expansion_room(curr_entry.shape_index_in_object, p_autoroute_search_tree);
                }
                if (neighbour_room == null || !SortedRoomNeighbours.insert_door_ok(completed_room, neighbour_room, intersection)) continue;
                ExpansionDoor new_door = new ExpansionDoor(completed_room, neighbour_room, 1);
                neighbour_room.add_door(new_door);
                completed_room.add_door(new_door);
                continue;
            }
            Point touching_point = intersection.corner(0);
            int room_corner_no = room_shape.equals_corner(touching_point);
            if (room_corner_no >= 0) {
                room_touch_is_corner = true;
                touching_side_no_of_room = room_corner_no;
            } else {
                room_touch_is_corner = false;
                touching_side_no_of_room = room_shape.contains_on_border_line_no(touching_point);
                if (touching_side_no_of_room < 0 && p_test_level.ordinal() >= TestLevel.CRITICAL_DEBUGGING_OUTPUT.ordinal()) {
                    System.out.println("SortedRoomNeighbours.calculate: touching_side_no_of_room >= 0 expected");
                }
            }
            int neighbour_room_corner_no = curr_shape.equals_corner(touching_point);
            if (neighbour_room_corner_no >= 0) {
                neighbour_room_touch_is_corner = true;
                touching_side_no_of_neighbour_room = curr_shape.prev_no(neighbour_room_corner_no);
            } else {
                neighbour_room_touch_is_corner = false;
                touching_side_no_of_neighbour_room = curr_shape.contains_on_border_line_no(touching_point);
                if (touching_side_no_of_neighbour_room < 0 && p_test_level.ordinal() >= TestLevel.CRITICAL_DEBUGGING_OUTPUT.ordinal()) {
                    System.out.println("AutorouteEngine.SortedRoomNeighbours.calculate: touching_side_no_of_neighbour_room >= 0 expected");
                }
            }
            result.add_sorted_neighbour(curr_shape, intersection, touching_side_no_of_room, touching_side_no_of_neighbour_room, room_touch_is_corner, neighbour_room_touch_is_corner);
        }
        return result;
    }

    private SortedRoomNeighbours(ExpansionRoom p_from_room, CompleteExpansionRoom p_completed_room) {
        this.from_room = p_from_room;
        this.completed_room = p_completed_room;
        this.room_shape = p_completed_room.get_shape();
        this.sorted_neighbours = new TreeSet<SortedRoomNeighbour>();
        this.own_net_objects = new LinkedList<ShapeTree.TreeEntry>();
    }

    private void add_sorted_neighbour(TileShape p_neighbour_shape, TileShape p_intersection, int p_touching_side_no_of_room, int p_touching_side_no_of_neighbour_room, boolean p_room_touch_is_corner, boolean p_neighbour_room_touch_is_corner) {
        SortedRoomNeighbour new_neighbour = new SortedRoomNeighbour(p_neighbour_shape, p_intersection, p_touching_side_no_of_room, p_touching_side_no_of_neighbour_room, p_room_touch_is_corner, p_neighbour_room_touch_is_corner);
        this.sorted_neighbours.add(new_neighbour);
    }

    private boolean try_remove_edge(int p_net_no, ShapeSearchTree p_autoroute_search_tree, TestLevel p_test_level) {
        if (!(this.from_room instanceof IncompleteFreeSpaceExpansionRoom)) {
            return false;
        }
        IncompleteFreeSpaceExpansionRoom curr_incomplete_room = (IncompleteFreeSpaceExpansionRoom)this.from_room;
        Iterator it = this.sorted_neighbours.iterator();
        int remove_edge_no = -1;
        Simplex room_simplex = curr_incomplete_room.get_shape().to_Simplex();
        double room_shape_area = room_simplex.area();
        int prev_edge_no = -1;
        int curr_edge_no = 0;
        while (it.hasNext()) {
            SortedRoomNeighbour next_neighbour = (SortedRoomNeighbour)it.next();
            if (next_neighbour.touching_side_no_of_room == prev_edge_no) continue;
            if (next_neighbour.touching_side_no_of_room == curr_edge_no) {
                prev_edge_no = curr_edge_no++;
                continue;
            }
            remove_edge_no = curr_edge_no;
            break;
        }
        if (remove_edge_no < 0 && curr_edge_no < room_simplex.border_line_count()) {
            remove_edge_no = curr_edge_no;
        }
        if (remove_edge_no >= 0) {
            IncompleteFreeSpaceExpansionRoom new_shape;
            Simplex enlarged_shape = room_simplex.remove_border_line(remove_edge_no);
            IncompleteFreeSpaceExpansionRoom enlarged_room = new IncompleteFreeSpaceExpansionRoom(enlarged_shape, curr_incomplete_room.get_layer(), curr_incomplete_room.get_contained_shape());
            Collection<IncompleteFreeSpaceExpansionRoom> new_rooms = p_autoroute_search_tree.complete_shape(enlarged_room, p_net_no, null, null);
            if (new_rooms.size() != 1) {
                if (p_test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                    System.out.println("AutorouteEngine.calculate_doors: 1 completed shape expected");
                }
                return false;
            }
            boolean remove_edge = false;
            if (new_rooms.size() == 1 && (new_shape = new_rooms.iterator().next()).get_shape().area() > room_shape_area) {
                remove_edge = true;
            }
            if (remove_edge) {
                Iterator<IncompleteFreeSpaceExpansionRoom> it2 = new_rooms.iterator();
                IncompleteFreeSpaceExpansionRoom new_room = it2.next();
                curr_incomplete_room.set_shape(new_room.get_shape());
                curr_incomplete_room.set_contained_shape(new_room.get_contained_shape());
                return true;
            }
        }
        return false;
    }

    public void calculate_new_incomplete_rooms(AutorouteEngine p_autoroute_engine) {
        SortedRoomNeighbour prev_neighbour = this.sorted_neighbours.last();
        Iterator it = this.sorted_neighbours.iterator();
        Simplex room_simplex = this.from_room.get_shape().to_Simplex();
        while (it.hasNext()) {
            boolean intersection_with_next_neighbour_starts_at_corner;
            SortedRoomNeighbour next_neighbour = (SortedRoomNeighbour)it.next();
            int first_touching_side_no = prev_neighbour.touching_side_no_of_room;
            int last_touching_side_no = next_neighbour.touching_side_no_of_room;
            int curr_next_no = room_simplex.next_no(first_touching_side_no);
            boolean intersection_with_prev_neighbour_ends_at_corner = (first_touching_side_no != last_touching_side_no || prev_neighbour == this.sorted_neighbours.last()) && prev_neighbour.last_corner().equals(room_simplex.corner(curr_next_no));
            boolean bl = intersection_with_next_neighbour_starts_at_corner = (first_touching_side_no != last_touching_side_no || prev_neighbour == this.sorted_neighbours.last()) && next_neighbour.first_corner().equals(room_simplex.corner(last_touching_side_no));
            if (intersection_with_prev_neighbour_ends_at_corner) {
                first_touching_side_no = curr_next_no;
            }
            if (intersection_with_next_neighbour_starts_at_corner) {
                last_touching_side_no = room_simplex.prev_no(last_touching_side_no);
            }
            boolean neighbours_touch = false;
            if (this.sorted_neighbours.size() > 1) {
                neighbours_touch = prev_neighbour.last_corner().equals(next_neighbour.first_corner());
            }
            if (!neighbours_touch) {
                int last_bounding_line_no = prev_neighbour.touching_side_no_of_neighbour_room;
                if (!intersection_with_prev_neighbour_ends_at_corner && !prev_neighbour.room_touch_is_corner) {
                    last_bounding_line_no = prev_neighbour.neighbour_shape.prev_no(last_bounding_line_no);
                }
                int first_bounding_line_no = next_neighbour.touching_side_no_of_neighbour_room;
                if (!intersection_with_next_neighbour_starts_at_corner && !next_neighbour.neighbour_room_touch_is_corner) {
                    first_bounding_line_no = next_neighbour.neighbour_shape.next_no(first_bounding_line_no);
                }
                Line start_edge_line = next_neighbour.neighbour_shape.border_line(first_bounding_line_no).opposite();
                Line middle_edge_line = null;
                int curr_touching_side_no = last_touching_side_no;
                boolean first_time = true;
                while (true) {
                    TileShape new_contained_shape;
                    Simplex new_room_shape;
                    Line end_edge_line;
                    boolean last_time;
                    boolean corner_cut_off = false;
                    if (this.from_room instanceof IncompleteFreeSpaceExpansionRoom) {
                        IncompleteFreeSpaceExpansionRoom incomplete_room = (IncompleteFreeSpaceExpansionRoom)this.from_room;
                        if (curr_touching_side_no == last_touching_side_no && first_touching_side_no != last_touching_side_no) {
                            IntPoint cut_line_start = prev_neighbour.last_corner().to_float().round();
                            IntPoint cut_line_end = next_neighbour.first_corner().to_float().round();
                            Line cut_line = new Line((Point)cut_line_start, cut_line_end);
                            TileShape cut_half_plane = TileShape.get_instance(cut_line);
                            ((CompleteFreeSpaceExpansionRoom)this.completed_room).set_shape(this.completed_room.get_shape().intersection(cut_half_plane));
                            corner_cut_off = true;
                            if (incomplete_room.get_contained_shape().side_of(cut_line) != Side.ON_THE_LEFT) {
                                corner_cut_off = false;
                            }
                            if (corner_cut_off) {
                                middle_edge_line = cut_line.opposite();
                            }
                        }
                    }
                    int next_touching_side_no = room_simplex.prev_no(curr_touching_side_no);
                    if (!corner_cut_off) {
                        middle_edge_line = room_simplex.border_line(curr_touching_side_no).opposite();
                    }
                    Direction middle_line_dir = middle_edge_line.direction();
                    boolean bl2 = last_time = curr_touching_side_no == first_touching_side_no && (prev_neighbour != this.sorted_neighbours.last() || !first_time) || corner_cut_off;
                    if (last_time) {
                        end_edge_line = prev_neighbour.neighbour_shape.border_line(last_bounding_line_no).opposite();
                        if (end_edge_line.direction().side_of(middle_line_dir) != Side.ON_THE_LEFT) {
                            end_edge_line = null;
                        }
                    } else {
                        end_edge_line = null;
                    }
                    if (start_edge_line != null && middle_line_dir.side_of(start_edge_line.direction()) != Side.ON_THE_LEFT) {
                        start_edge_line = null;
                    }
                    int new_edge_line_count = 1;
                    if (start_edge_line != null) {
                        ++new_edge_line_count;
                    }
                    if (end_edge_line != null) {
                        ++new_edge_line_count;
                    }
                    Line[] new_edge_lines = new Line[new_edge_line_count];
                    int curr_index = 0;
                    if (start_edge_line != null) {
                        new_edge_lines[curr_index] = start_edge_line;
                        ++curr_index;
                    }
                    new_edge_lines[curr_index] = middle_edge_line;
                    if (end_edge_line != null) {
                        new_edge_lines[++curr_index] = end_edge_line;
                    }
                    if (!(new_room_shape = Simplex.get_instance(new_edge_lines)).is_empty() && !(new_contained_shape = this.completed_room.get_shape().intersection((TileShape)new_room_shape)).is_empty()) {
                        IncompleteFreeSpaceExpansionRoom new_room = p_autoroute_engine.add_incomplete_expansion_room(new_room_shape, this.from_room.get_layer(), new_contained_shape);
                        ExpansionDoor new_door = new ExpansionDoor(this.completed_room, new_room, 1);
                        this.completed_room.add_door(new_door);
                        new_room.add_door(new_door);
                    }
                    if (last_time) break;
                    curr_touching_side_no = next_touching_side_no;
                    start_edge_line = null;
                    first_time = false;
                }
            }
            prev_neighbour = next_neighbour;
        }
    }

    static boolean insert_door_ok(ExpansionRoom p_room_1, ExpansionRoom p_room_2, TileShape p_door_shape) {
        if (p_room_1.door_exists(p_room_2)) {
            return false;
        }
        if (p_room_1 instanceof ObstacleExpansionRoom && p_room_2 instanceof ObstacleExpansionRoom) {
            Item first_item = ((ObstacleExpansionRoom)p_room_1).get_item();
            Item second_item = ((ObstacleExpansionRoom)p_room_2).get_item();
            return first_item.shares_net(second_item);
        }
        if (!(p_room_1 instanceof ObstacleExpansionRoom) && !(p_room_2 instanceof ObstacleExpansionRoom)) {
            return true;
        }
        Line door_line = null;
        Point prev_corner = p_door_shape.corner(0);
        int corner_count = p_door_shape.border_line_count();
        for (int i = 1; i < corner_count; ++i) {
            Point curr_corner = p_door_shape.corner(i);
            if (!curr_corner.equals(prev_corner)) {
                door_line = p_door_shape.border_line(i - 1);
                break;
            }
            prev_corner = curr_corner;
        }
        if (p_room_1 instanceof ObstacleExpansionRoom && !SortedRoomNeighbours.insert_door_ok((ObstacleExpansionRoom)p_room_1, door_line)) {
            return false;
        }
        return !(p_room_2 instanceof ObstacleExpansionRoom) || SortedRoomNeighbours.insert_door_ok((ObstacleExpansionRoom)p_room_2, door_line);
    }

    private static boolean insert_door_ok(ObstacleExpansionRoom p_room, Line p_door_line) {
        if (p_door_line == null) {
            System.out.println("SortedRoomNeighbours.insert_door_ok: p_door_line is null");
            return false;
        }
        Item curr_item = p_room.get_item();
        if (curr_item instanceof PolylineTrace) {
            Line curr_trace_line;
            int room_index = p_room.get_index_in_item();
            PolylineTrace curr_trace = (PolylineTrace)curr_item;
            if (!(room_index != 0 && room_index != curr_trace.tile_shape_count() - 1 || (curr_trace_line = curr_trace.polyline().arr[room_index + 1]).is_parallel(p_door_line))) {
                return false;
            }
        }
        return true;
    }

    private class SortedRoomNeighbour
    implements Comparable<SortedRoomNeighbour> {
        public final TileShape neighbour_shape;
        public final TileShape intersection;
        public final int touching_side_no_of_room;
        public final int touching_side_no_of_neighbour_room;
        public final boolean room_touch_is_corner;
        public final boolean neighbour_room_touch_is_corner;
        private Point precalculated_first_corner = null;
        private Point precalculated_last_corner = null;
        private static final double c_dist_tolerance = 1.0;

        public SortedRoomNeighbour(TileShape p_neighbour_shape, TileShape p_intersection, int p_touching_side_no_of_room, int p_touching_side_no_of_neighbour_room, boolean p_room_touch_is_corner, boolean p_neighbour_room_touch_is_corner) {
            this.neighbour_shape = p_neighbour_shape;
            this.intersection = p_intersection;
            this.touching_side_no_of_room = p_touching_side_no_of_room;
            this.touching_side_no_of_neighbour_room = p_touching_side_no_of_neighbour_room;
            this.room_touch_is_corner = p_room_touch_is_corner;
            this.neighbour_room_touch_is_corner = p_neighbour_room_touch_is_corner;
        }

        @Override
        public int compareTo(SortedRoomNeighbour p_other) {
            double other_distance2;
            double this_distance2;
            double other_distance;
            int compare_value = this.touching_side_no_of_room - p_other.touching_side_no_of_room;
            if (compare_value != 0) {
                return compare_value;
            }
            FloatPoint compare_corner = SortedRoomNeighbours.this.room_shape.corner_approx(this.touching_side_no_of_room);
            double this_distance = this.first_corner().to_float().distance(compare_corner);
            double delta_distance = this_distance - (other_distance = p_other.first_corner().to_float().distance(compare_corner));
            if (Math.abs(delta_distance) <= 1.0 && this.first_corner().equals(p_other.first_corner()) && Math.abs(delta_distance = (this_distance2 = this.last_corner().to_float().distance(compare_corner)) - (other_distance2 = p_other.last_corner().to_float().distance(compare_corner))) <= 1.0 && this.neighbour_room_touch_is_corner && p_other.neighbour_room_touch_is_corner) {
                int compare_line_no = this.touching_side_no_of_room;
                if (this.room_touch_is_corner) {
                    compare_line_no = SortedRoomNeighbours.this.room_shape.prev_no(compare_line_no);
                }
                Direction compare_dir = SortedRoomNeighbours.this.room_shape.border_line(compare_line_no).direction().opposite();
                Line this_compare_line = this.neighbour_shape.border_line(this.touching_side_no_of_neighbour_room);
                Line other_compare_line = p_other.neighbour_shape.border_line(p_other.touching_side_no_of_neighbour_room);
                delta_distance = compare_dir.compare_from(this_compare_line.direction(), other_compare_line.direction());
            }
            int result = Signum.as_int(delta_distance);
            return result;
        }

        public Point first_corner() {
            if (this.precalculated_first_corner == null) {
                if (this.room_touch_is_corner) {
                    this.precalculated_first_corner = SortedRoomNeighbours.this.room_shape.corner(this.touching_side_no_of_room);
                } else if (this.neighbour_room_touch_is_corner) {
                    this.precalculated_first_corner = this.neighbour_shape.corner(this.touching_side_no_of_neighbour_room);
                } else {
                    Point curr_first_corner = this.neighbour_shape.corner(this.neighbour_shape.next_no(this.touching_side_no_of_neighbour_room));
                    Line prev_line = SortedRoomNeighbours.this.room_shape.border_line(SortedRoomNeighbours.this.room_shape.prev_no(this.touching_side_no_of_room));
                    this.precalculated_first_corner = prev_line.side_of(curr_first_corner) == Side.ON_THE_RIGHT ? curr_first_corner : SortedRoomNeighbours.this.room_shape.corner(this.touching_side_no_of_room);
                }
            }
            return this.precalculated_first_corner;
        }

        public Point last_corner() {
            if (this.precalculated_last_corner == null) {
                if (this.room_touch_is_corner) {
                    this.precalculated_last_corner = SortedRoomNeighbours.this.room_shape.corner(this.touching_side_no_of_room);
                } else if (this.neighbour_room_touch_is_corner) {
                    this.precalculated_last_corner = this.neighbour_shape.corner(this.touching_side_no_of_neighbour_room);
                } else {
                    Point curr_last_corner = this.neighbour_shape.corner(this.touching_side_no_of_neighbour_room);
                    Line next_line = SortedRoomNeighbours.this.room_shape.border_line(SortedRoomNeighbours.this.room_shape.next_no(this.touching_side_no_of_room));
                    this.precalculated_last_corner = next_line.side_of(curr_last_corner) == Side.ON_THE_RIGHT ? curr_last_corner : SortedRoomNeighbours.this.room_shape.corner(SortedRoomNeighbours.this.room_shape.next_no(this.touching_side_no_of_room));
                }
            }
            return this.precalculated_last_corner;
        }
    }
}

