/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.AutorouteEngine;
import autoroute.CompleteExpansionRoom;
import autoroute.CompleteFreeSpaceExpansionRoom;
import autoroute.ExpansionDoor;
import autoroute.ExpansionRoom;
import autoroute.IncompleteFreeSpaceExpansionRoom;
import autoroute.ItemAutorouteInfo;
import autoroute.ObstacleExpansionRoom;
import autoroute.SortedRoomNeighbours;
import board.Item;
import board.SearchTreeObject;
import board.ShapeSearchTree;
import datastructures.ShapeTree;
import geometry.planar.FloatPoint;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.TileShape;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class Sorted45DegreeRoomNeighbours {
    public final CompleteExpansionRoom completed_room;
    public final SortedSet<SortedRoomNeighbour> sorted_neighbours;
    private final ExpansionRoom from_room;
    private final IntOctagon room_shape;
    private final boolean[] edge_interiour_touches_obstacle;

    public static CompleteExpansionRoom calculate(ExpansionRoom p_room, AutorouteEngine p_autoroute_engine) {
        int net_no = p_autoroute_engine.get_net_no();
        Sorted45DegreeRoomNeighbours room_neighbours = Sorted45DegreeRoomNeighbours.calculate_neighbours(p_room, net_no, p_autoroute_engine.autoroute_search_tree, p_autoroute_engine.generate_room_id_no());
        if (room_neighbours == null) {
            return null;
        }
        boolean edge_removed = room_neighbours.try_remove_edge_line(net_no, p_autoroute_engine.autoroute_search_tree);
        CompleteExpansionRoom result = room_neighbours.completed_room;
        if (edge_removed) {
            p_autoroute_engine.remove_all_doors(result);
            return Sorted45DegreeRoomNeighbours.calculate(p_room, p_autoroute_engine);
        }
        if (room_neighbours.sorted_neighbours.isEmpty()) {
            if (result instanceof ObstacleExpansionRoom) {
                room_neighbours.calculate_edge_incomplete_rooms_of_obstacle_expansion_room(0, 7, p_autoroute_engine);
            }
        } else {
            room_neighbours.calculate_new_incomplete_rooms(p_autoroute_engine);
        }
        return result;
    }

    private static Sorted45DegreeRoomNeighbours calculate_neighbours(ExpansionRoom p_room, int p_net_no, ShapeSearchTree p_autoroute_search_tree, int p_room_id_no) {
        CompleteExpansionRoom completed_room;
        TileShape room_shape = p_room.get_shape();
        if (p_room instanceof IncompleteFreeSpaceExpansionRoom) {
            completed_room = new CompleteFreeSpaceExpansionRoom(room_shape, p_room.get_layer(), p_room_id_no);
        } else if (p_room instanceof ObstacleExpansionRoom) {
            completed_room = (ObstacleExpansionRoom)p_room;
        } else {
            System.out.println("Sorted45DegreeRoomNeighbours.calculate_neighbours: unexpected expansion room type");
            return null;
        }
        IntOctagon room_oct = room_shape.bounding_octagon();
        Sorted45DegreeRoomNeighbours result = new Sorted45DegreeRoomNeighbours(p_room, completed_room);
        LinkedList<ShapeTree.TreeEntry> overlapping_objects = new LinkedList<ShapeTree.TreeEntry>();
        p_autoroute_search_tree.overlapping_tree_entries(room_shape, p_room.get_layer(), overlapping_objects);
        for (ShapeTree.TreeEntry curr_entry : overlapping_objects) {
            Item curr_item;
            SearchTreeObject curr_object = (SearchTreeObject)curr_entry.object;
            if (curr_object == p_room) continue;
            if (completed_room instanceof CompleteFreeSpaceExpansionRoom && !curr_object.is_trace_obstacle(p_net_no)) {
                ((CompleteFreeSpaceExpansionRoom)completed_room).calculate_target_doors(curr_entry, p_net_no, p_autoroute_search_tree);
                continue;
            }
            TileShape curr_shape = curr_object.get_tree_shape(p_autoroute_search_tree, curr_entry.shape_index_in_object);
            IntOctagon curr_oct = curr_shape.bounding_octagon();
            IntOctagon intersection = room_oct.intersection(curr_oct);
            int dimension = intersection.dimension();
            if (dimension > 1 && completed_room instanceof ObstacleExpansionRoom) {
                Item curr_item2;
                if (!(curr_object instanceof Item) || !(curr_item2 = (Item)curr_object).is_route()) continue;
                ItemAutorouteInfo item_info = curr_item2.get_autoroute_info();
                ObstacleExpansionRoom curr_overlap_room = item_info.get_expansion_room(curr_entry.shape_index_in_object, p_autoroute_search_tree);
                ((ObstacleExpansionRoom)completed_room).create_overlap_door(curr_overlap_room);
                continue;
            }
            if (dimension < 0) continue;
            result.add_sorted_neighbour(curr_oct, intersection);
            if (dimension <= 0) continue;
            ExpansionRoom neighbour_room = null;
            if (curr_object instanceof ExpansionRoom) {
                neighbour_room = (ExpansionRoom)((Object)curr_object);
            } else if (curr_object instanceof Item && (curr_item = (Item)curr_object).is_route()) {
                ItemAutorouteInfo item_info = curr_item.get_autoroute_info();
                neighbour_room = item_info.get_expansion_room(curr_entry.shape_index_in_object, p_autoroute_search_tree);
            }
            if (neighbour_room == null || !SortedRoomNeighbours.insert_door_ok(completed_room, neighbour_room, intersection)) continue;
            ExpansionDoor new_door = new ExpansionDoor(completed_room, neighbour_room);
            neighbour_room.add_door(new_door);
            completed_room.add_door(new_door);
        }
        return result;
    }

    private Sorted45DegreeRoomNeighbours(ExpansionRoom p_from_room, CompleteExpansionRoom p_completed_room) {
        this.from_room = p_from_room;
        this.completed_room = p_completed_room;
        this.room_shape = p_completed_room.get_shape().bounding_octagon();
        this.sorted_neighbours = new TreeSet<SortedRoomNeighbour>();
        this.edge_interiour_touches_obstacle = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            this.edge_interiour_touches_obstacle[i] = false;
        }
    }

    private void add_sorted_neighbour(IntOctagon p_neighbour_shape, IntOctagon p_intersection) {
        SortedRoomNeighbour new_neighbour = new SortedRoomNeighbour(p_neighbour_shape, p_intersection);
        if (new_neighbour.last_touching_side >= 0) {
            this.sorted_neighbours.add(new_neighbour);
        }
    }

    private void calculate_edge_incomplete_rooms_of_obstacle_expansion_room(int p_from_side_no, int p_to_side_no, AutorouteEngine p_autoroute_engine) {
        if (!(this.from_room instanceof ObstacleExpansionRoom)) {
            System.out.println("Sorted45DegreeRoomNeighbours.calculate_side_incomplete_rooms_of_obstacle_expansion_room: ObstacleExpansionRoom expected for this.from_room");
            return;
        }
        IntOctagon board_bounding_oct = p_autoroute_engine.board.get_bounding_box().bounding_octagon();
        IntPoint curr_corner = this.room_shape.corner(p_from_side_no);
        int curr_side_no = p_from_side_no;
        while (true) {
            int next_side_no;
            IntPoint next_corner;
            if (!curr_corner.equals(next_corner = this.room_shape.corner(next_side_no = (curr_side_no + 1) % 8))) {
                int lx = board_bounding_oct.lx;
                int ly = board_bounding_oct.ly;
                int rx = board_bounding_oct.rx;
                int uy = board_bounding_oct.uy;
                int ulx = board_bounding_oct.ulx;
                int lrx = board_bounding_oct.lrx;
                int llx = board_bounding_oct.llx;
                int urx = board_bounding_oct.urx;
                if (curr_side_no == 0) {
                    uy = this.room_shape.ly;
                } else if (curr_side_no == 1) {
                    ulx = this.room_shape.lrx;
                } else if (curr_side_no == 2) {
                    lx = this.room_shape.rx;
                } else if (curr_side_no == 3) {
                    llx = this.room_shape.urx;
                } else if (curr_side_no == 4) {
                    ly = this.room_shape.uy;
                } else if (curr_side_no == 5) {
                    lrx = this.room_shape.ulx;
                } else if (curr_side_no == 6) {
                    rx = this.room_shape.lx;
                } else if (curr_side_no == 7) {
                    urx = this.room_shape.llx;
                } else {
                    System.out.println("SortedOrthoganelRoomNeighbours.calculate_edge_incomplete_rooms_of_obstacle_expansion_room: curr_side_no illegal");
                    return;
                }
                this.insert_incomplete_room(p_autoroute_engine, lx, ly, rx, uy, ulx, lrx, llx, urx);
            }
            if (curr_side_no == p_to_side_no) break;
            curr_side_no = next_side_no;
        }
    }

    private static IntOctagon remove_not_touching_border_lines(IntOctagon p_room_oct, boolean[] p_edge_interiour_touches_obstacle) {
        int lx = p_edge_interiour_touches_obstacle[6] ? p_room_oct.lx : -33554432;
        int ly = p_edge_interiour_touches_obstacle[0] ? p_room_oct.ly : -33554432;
        int rx = p_edge_interiour_touches_obstacle[2] ? p_room_oct.rx : 0x2000000;
        int uy = p_edge_interiour_touches_obstacle[4] ? p_room_oct.uy : 0x2000000;
        int ulx = p_edge_interiour_touches_obstacle[5] ? p_room_oct.ulx : -33554432;
        int lrx = p_edge_interiour_touches_obstacle[1] ? p_room_oct.lrx : 0x2000000;
        int llx = p_edge_interiour_touches_obstacle[7] ? p_room_oct.llx : -33554432;
        int urx = p_edge_interiour_touches_obstacle[3] ? p_room_oct.urx : 0x2000000;
        IntOctagon result = new IntOctagon(lx, ly, rx, uy, ulx, lrx, llx, urx);
        return result.normalize();
    }

    private boolean try_remove_edge_line(int p_net_no, ShapeSearchTree p_autoroute_search_tree) {
        if (!(this.from_room instanceof IncompleteFreeSpaceExpansionRoom)) {
            return false;
        }
        IncompleteFreeSpaceExpansionRoom curr_incomplete_room = (IncompleteFreeSpaceExpansionRoom)this.from_room;
        if (!(curr_incomplete_room.get_shape() instanceof IntOctagon)) {
            System.out.println("Sorted45DegreeRoomNeighbours.try_remove_edge_line: IntOctagon expected for room_shape type");
            return false;
        }
        IntOctagon room_oct = (IntOctagon)curr_incomplete_room.get_shape();
        double room_area = room_oct.area();
        boolean try_remove_edge_lines = false;
        for (int i = 0; i < 8; ++i) {
            FloatPoint next_corner;
            FloatPoint prev_corner;
            if (this.edge_interiour_touches_obstacle[i] || !((prev_corner = this.room_shape.corner_approx(i)).distance_square(next_corner = this.room_shape.corner_approx(this.room_shape.next_no(i))) > 1.0)) continue;
            try_remove_edge_lines = true;
            break;
        }
        if (try_remove_edge_lines) {
            IncompleteFreeSpaceExpansionRoom new_room;
            IntOctagon enlarged_oct = Sorted45DegreeRoomNeighbours.remove_not_touching_border_lines(room_oct, this.edge_interiour_touches_obstacle);
            List<ExpansionDoor> door_list = this.completed_room.get_doors();
            TileShape ignore_shape = null;
            CompleteFreeSpaceExpansionRoom ignore_object = null;
            double max_door_area = 0.0;
            for (ExpansionDoor curr_door : door_list) {
                TileShape curr_door_shape;
                double curr_door_area;
                CompleteExpansionRoom other_room;
                if (curr_door.dimension != 2 || !((other_room = curr_door.other_room(this.completed_room)) instanceof CompleteFreeSpaceExpansionRoom) || !((curr_door_area = (curr_door_shape = curr_door.get_shape()).area()) > max_door_area)) continue;
                max_door_area = curr_door_area;
                ignore_shape = curr_door_shape;
                ignore_object = (CompleteFreeSpaceExpansionRoom)other_room;
            }
            IncompleteFreeSpaceExpansionRoom enlarged_room = new IncompleteFreeSpaceExpansionRoom(enlarged_oct, curr_incomplete_room.get_layer(), curr_incomplete_room.get_contained_shape());
            Collection<IncompleteFreeSpaceExpansionRoom> new_rooms = p_autoroute_search_tree.complete_shape(enlarged_room, p_net_no, ignore_object, ignore_shape);
            if (new_rooms.size() == 1 && (new_room = new_rooms.iterator().next()).get_shape().area() > room_area) {
                curr_incomplete_room.set_shape(new_room.get_shape());
                curr_incomplete_room.set_contained_shape(new_room.get_contained_shape());
                return true;
            }
        }
        return false;
    }

    private void insert_incomplete_room(AutorouteEngine p_autoroute_engine, int p_lx, int p_ly, int p_rx, int p_uy, int p_ulx, int p_lrx, int p_llx, int p_urx) {
        int door_dimension;
        IntOctagon new_contained_shape;
        IntOctagon new_incomplete_room_shape = new IntOctagon(p_lx, p_ly, p_rx, p_uy, p_ulx, p_lrx, p_llx, p_urx);
        if ((new_incomplete_room_shape = new_incomplete_room_shape.normalize()).dimension() == 2 && !(new_contained_shape = this.room_shape.intersection(new_incomplete_room_shape)).is_empty() && (door_dimension = new_contained_shape.dimension()) > 0) {
            IncompleteFreeSpaceExpansionRoom new_room = p_autoroute_engine.add_incomplete_expansion_room(new_incomplete_room_shape, this.from_room.get_layer(), new_contained_shape);
            ExpansionDoor new_door = new ExpansionDoor(this.completed_room, new_room, door_dimension);
            this.completed_room.add_door(new_door);
            new_room.add_door(new_door);
        }
    }

    private void calculate_new_incomplete_rooms_for_obstacle_expansion_room(SortedRoomNeighbour p_prev_neighbour, SortedRoomNeighbour p_next_neighbour, AutorouteEngine p_autoroute_engine) {
        int from_side_no = p_prev_neighbour.last_touching_side;
        int to_side_no = p_next_neighbour.first_touching_side;
        if (from_side_no == to_side_no && p_prev_neighbour != p_next_neighbour) {
            return;
        }
        IntOctagon board_bounding_oct = p_autoroute_engine.board.bounding_box.bounding_octagon();
        int lx = board_bounding_oct.lx;
        int ly = board_bounding_oct.ly;
        int rx = board_bounding_oct.rx;
        int uy = board_bounding_oct.uy;
        int ulx = board_bounding_oct.ulx;
        int lrx = board_bounding_oct.lrx;
        int llx = board_bounding_oct.llx;
        int urx = board_bounding_oct.urx;
        if (from_side_no == 0) {
            uy = this.room_shape.ly;
            ulx = p_prev_neighbour.intersection.lrx;
        } else if (from_side_no == 1) {
            ulx = this.room_shape.lrx;
            lx = p_prev_neighbour.intersection.rx;
        } else if (from_side_no == 2) {
            lx = this.room_shape.rx;
            llx = p_prev_neighbour.intersection.urx;
        } else if (from_side_no == 3) {
            llx = this.room_shape.urx;
            ly = p_prev_neighbour.intersection.uy;
        } else if (from_side_no == 4) {
            ly = this.room_shape.uy;
            lrx = p_prev_neighbour.intersection.ulx;
        } else if (from_side_no == 5) {
            lrx = this.room_shape.ulx;
            rx = p_prev_neighbour.intersection.lx;
        } else if (from_side_no == 6) {
            rx = this.room_shape.lx;
            urx = p_prev_neighbour.intersection.llx;
        } else if (from_side_no == 7) {
            urx = this.room_shape.llx;
            uy = p_prev_neighbour.intersection.ly;
        }
        this.insert_incomplete_room(p_autoroute_engine, lx, ly, rx, uy, ulx, lrx, llx, urx);
        lx = board_bounding_oct.lx;
        ly = board_bounding_oct.ly;
        rx = board_bounding_oct.rx;
        uy = board_bounding_oct.uy;
        ulx = board_bounding_oct.ulx;
        lrx = board_bounding_oct.lrx;
        llx = board_bounding_oct.llx;
        urx = board_bounding_oct.urx;
        if (to_side_no == 0) {
            uy = this.room_shape.ly;
            urx = p_next_neighbour.intersection.llx;
        } else if (to_side_no == 1) {
            ulx = this.room_shape.lrx;
            uy = p_next_neighbour.intersection.ly;
        } else if (to_side_no == 2) {
            lx = this.room_shape.rx;
            ulx = p_next_neighbour.intersection.lrx;
        } else if (to_side_no == 3) {
            llx = this.room_shape.urx;
            lx = p_next_neighbour.intersection.rx;
        } else if (to_side_no == 4) {
            ly = this.room_shape.uy;
            llx = p_next_neighbour.intersection.urx;
        } else if (to_side_no == 5) {
            lrx = this.room_shape.ulx;
            ly = p_next_neighbour.intersection.uy;
        } else if (to_side_no == 6) {
            rx = this.room_shape.lx;
            lrx = p_next_neighbour.intersection.ulx;
        } else if (to_side_no == 7) {
            urx = this.room_shape.llx;
            rx = p_next_neighbour.intersection.lx;
        }
        this.insert_incomplete_room(p_autoroute_engine, lx, ly, rx, uy, ulx, lrx, llx, urx);
        int curr_from_side_no = (from_side_no + 1) % 8;
        if (curr_from_side_no == to_side_no) {
            return;
        }
        int curr_to_side_no = (to_side_no + 7) % 8;
        this.calculate_edge_incomplete_rooms_of_obstacle_expansion_room(curr_from_side_no, curr_to_side_no, p_autoroute_engine);
    }

    private void calculate_new_incomplete_rooms(AutorouteEngine p_autoroute_engine) {
        IntOctagon board_bounding_oct = p_autoroute_engine.board.bounding_box.bounding_octagon();
        SortedRoomNeighbour prev_neighbour = this.sorted_neighbours.last();
        if (this.from_room instanceof ObstacleExpansionRoom && this.sorted_neighbours.size() == 1) {
            this.calculate_new_incomplete_rooms_for_obstacle_expansion_room(prev_neighbour, prev_neighbour, p_autoroute_engine);
            return;
        }
        for (SortedRoomNeighbour next_neighbour : this.sorted_neighbours) {
            boolean insert_incomplete_room;
            if (this.completed_room instanceof ObstacleExpansionRoom && this.sorted_neighbours.size() == 2) {
                IntOctagon intersection = next_neighbour.intersection.intersection(prev_neighbour.intersection);
                insert_incomplete_room = intersection.is_empty() ? true : (intersection.dimension() >= 1 ? false : (prev_neighbour.last_touching_side == next_neighbour.first_touching_side ? false : prev_neighbour.last_touching_side != (next_neighbour.first_touching_side + 1) % 8));
            } else {
                boolean bl = insert_incomplete_room = !next_neighbour.intersection.intersects(prev_neighbour.intersection);
            }
            if (insert_incomplete_room) {
                if (this.from_room instanceof ObstacleExpansionRoom && next_neighbour.first_touching_side != prev_neighbour.last_touching_side) {
                    this.calculate_new_incomplete_rooms_for_obstacle_expansion_room(prev_neighbour, next_neighbour, p_autoroute_engine);
                } else {
                    int lx = board_bounding_oct.lx;
                    int ly = board_bounding_oct.ly;
                    int rx = board_bounding_oct.rx;
                    int uy = board_bounding_oct.uy;
                    int ulx = board_bounding_oct.ulx;
                    int lrx = board_bounding_oct.lrx;
                    int llx = board_bounding_oct.llx;
                    int urx = board_bounding_oct.urx;
                    if (next_neighbour.first_touching_side == 0) {
                        if (prev_neighbour.intersection.llx < next_neighbour.intersection.llx) {
                            urx = next_neighbour.intersection.llx;
                            uy = prev_neighbour.intersection.ly;
                            if (prev_neighbour.last_touching_side == 0) {
                                ulx = prev_neighbour.intersection.lrx;
                            }
                        } else if (prev_neighbour.intersection.llx > next_neighbour.intersection.llx) {
                            rx = next_neighbour.intersection.lx;
                            urx = prev_neighbour.intersection.llx;
                        } else {
                            urx = next_neighbour.intersection.llx;
                        }
                    } else if (next_neighbour.first_touching_side == 1) {
                        if (prev_neighbour.intersection.ly < next_neighbour.intersection.ly) {
                            uy = next_neighbour.intersection.ly;
                            ulx = prev_neighbour.intersection.lrx;
                            if (prev_neighbour.last_touching_side == 1) {
                                lx = prev_neighbour.intersection.rx;
                            }
                        } else if (prev_neighbour.intersection.ly > next_neighbour.intersection.ly) {
                            uy = prev_neighbour.intersection.ly;
                            urx = next_neighbour.intersection.llx;
                        } else {
                            uy = next_neighbour.intersection.ly;
                        }
                    } else if (next_neighbour.first_touching_side == 2) {
                        if (prev_neighbour.intersection.lrx > next_neighbour.intersection.lrx) {
                            ulx = next_neighbour.intersection.lrx;
                            lx = prev_neighbour.intersection.rx;
                            if (prev_neighbour.last_touching_side == 2) {
                                llx = prev_neighbour.intersection.urx;
                            }
                        } else if (prev_neighbour.intersection.lrx < next_neighbour.intersection.lrx) {
                            uy = next_neighbour.intersection.ly;
                            ulx = prev_neighbour.intersection.lrx;
                        } else {
                            ulx = next_neighbour.intersection.lrx;
                        }
                    } else if (next_neighbour.first_touching_side == 3) {
                        if (prev_neighbour.intersection.rx > next_neighbour.intersection.rx) {
                            lx = next_neighbour.intersection.rx;
                            llx = prev_neighbour.intersection.urx;
                            if (prev_neighbour.last_touching_side == 3) {
                                ly = prev_neighbour.intersection.uy;
                            }
                        } else if (prev_neighbour.intersection.rx < next_neighbour.intersection.rx) {
                            lx = prev_neighbour.intersection.rx;
                            ulx = next_neighbour.intersection.lrx;
                        } else {
                            lx = next_neighbour.intersection.rx;
                        }
                    } else if (next_neighbour.first_touching_side == 4) {
                        if (prev_neighbour.intersection.urx > next_neighbour.intersection.urx) {
                            llx = next_neighbour.intersection.urx;
                            ly = prev_neighbour.intersection.uy;
                            if (prev_neighbour.last_touching_side == 4) {
                                lrx = prev_neighbour.intersection.ulx;
                            }
                        } else if (prev_neighbour.intersection.urx < next_neighbour.intersection.urx) {
                            lx = next_neighbour.intersection.rx;
                            llx = prev_neighbour.intersection.urx;
                        } else {
                            llx = next_neighbour.intersection.urx;
                        }
                    } else if (next_neighbour.first_touching_side == 5) {
                        if (prev_neighbour.intersection.uy > next_neighbour.intersection.uy) {
                            ly = next_neighbour.intersection.uy;
                            lrx = prev_neighbour.intersection.ulx;
                            if (prev_neighbour.last_touching_side == 5) {
                                rx = prev_neighbour.intersection.lx;
                            }
                        } else if (prev_neighbour.intersection.uy < next_neighbour.intersection.uy) {
                            ly = prev_neighbour.intersection.uy;
                            llx = next_neighbour.intersection.urx;
                        } else {
                            ly = next_neighbour.intersection.uy;
                        }
                    } else if (next_neighbour.first_touching_side == 6) {
                        if (prev_neighbour.intersection.ulx < next_neighbour.intersection.ulx) {
                            lrx = next_neighbour.intersection.ulx;
                            rx = prev_neighbour.intersection.lx;
                            if (prev_neighbour.last_touching_side == 6) {
                                urx = prev_neighbour.intersection.llx;
                            }
                        } else if (prev_neighbour.intersection.ulx > next_neighbour.intersection.ulx) {
                            ly = next_neighbour.intersection.uy;
                            lrx = prev_neighbour.intersection.ulx;
                        } else {
                            lrx = next_neighbour.intersection.ulx;
                        }
                    } else if (next_neighbour.first_touching_side == 7) {
                        if (prev_neighbour.intersection.lx < next_neighbour.intersection.lx) {
                            rx = next_neighbour.intersection.lx;
                            urx = prev_neighbour.intersection.llx;
                            if (prev_neighbour.last_touching_side == 7) {
                                uy = prev_neighbour.intersection.ly;
                            }
                        } else if (prev_neighbour.intersection.lx > next_neighbour.intersection.lx) {
                            rx = prev_neighbour.intersection.lx;
                            lrx = next_neighbour.intersection.ulx;
                        } else {
                            rx = next_neighbour.intersection.lx;
                        }
                    } else {
                        System.out.println("Sorted45DegreeRoomNeighbour.calculate_new_incomplete: illegal touching side");
                    }
                    this.insert_incomplete_room(p_autoroute_engine, lx, ly, rx, uy, ulx, lrx, llx, urx);
                }
            }
            prev_neighbour = next_neighbour;
        }
    }

    private class SortedRoomNeighbour
    implements Comparable<SortedRoomNeighbour> {
        public final IntOctagon shape;
        public final IntOctagon intersection;
        public final int first_touching_side;
        public final int last_touching_side;

        public SortedRoomNeighbour(IntOctagon p_neighbour_shape, IntOctagon p_intersection) {
            int curr_side_no;
            this.shape = p_neighbour_shape;
            this.intersection = p_intersection;
            if (this.intersection.ly == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.ly && this.intersection.llx > ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.llx) {
                this.first_touching_side = 0;
            } else if (this.intersection.lrx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.lrx && this.intersection.ly > ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.ly) {
                this.first_touching_side = 1;
            } else if (this.intersection.rx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.rx && this.intersection.lrx < ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.lrx) {
                this.first_touching_side = 2;
            } else if (this.intersection.urx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.urx && this.intersection.rx < ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.rx) {
                this.first_touching_side = 3;
            } else if (this.intersection.uy == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.uy && this.intersection.urx < ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.urx) {
                this.first_touching_side = 4;
            } else if (this.intersection.ulx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.ulx && this.intersection.uy < ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.uy) {
                this.first_touching_side = 5;
            } else if (this.intersection.lx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.lx && this.intersection.ulx > ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.ulx) {
                this.first_touching_side = 6;
            } else if (this.intersection.llx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.llx && this.intersection.lx > ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.lx) {
                this.first_touching_side = 7;
            } else {
                this.first_touching_side = -1;
                this.last_touching_side = -1;
                return;
            }
            if (this.intersection.llx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.llx && this.intersection.ly > ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.ly) {
                this.last_touching_side = 7;
            } else if (this.intersection.lx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.lx && this.intersection.llx > ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.llx) {
                this.last_touching_side = 6;
            } else if (this.intersection.ulx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.ulx && this.intersection.lx > ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.lx) {
                this.last_touching_side = 5;
            } else if (this.intersection.uy == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.uy && this.intersection.ulx > ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.ulx) {
                this.last_touching_side = 4;
            } else if (this.intersection.urx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.urx && this.intersection.uy < ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.uy) {
                this.last_touching_side = 3;
            } else if (this.intersection.rx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.rx && this.intersection.urx < ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.urx) {
                this.last_touching_side = 2;
            } else if (this.intersection.lrx == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.lrx && this.intersection.rx < ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.rx) {
                this.last_touching_side = 1;
            } else if (this.intersection.ly == ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.ly && this.intersection.lrx < ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).room_shape.lrx) {
                this.last_touching_side = 0;
            } else {
                this.last_touching_side = -1;
                return;
            }
            int next_side_no = this.first_touching_side;
            do {
                curr_side_no = next_side_no;
                next_side_no = (next_side_no + 1) % 8;
                if (Sorted45DegreeRoomNeighbours.this.edge_interiour_touches_obstacle[curr_side_no]) continue;
                boolean touch_only_at_corner = false;
                if (curr_side_no == this.first_touching_side && this.intersection.corner(curr_side_no).equals(Sorted45DegreeRoomNeighbours.this.room_shape.corner(next_side_no))) {
                    touch_only_at_corner = true;
                }
                if (curr_side_no == this.last_touching_side && this.intersection.corner(next_side_no).equals(Sorted45DegreeRoomNeighbours.this.room_shape.corner(curr_side_no))) {
                    touch_only_at_corner = true;
                }
                if (touch_only_at_corner) continue;
                ((Sorted45DegreeRoomNeighbours)Sorted45DegreeRoomNeighbours.this).edge_interiour_touches_obstacle[curr_side_no] = true;
            } while (curr_side_no != this.last_touching_side);
        }

        @Override
        public int compareTo(SortedRoomNeighbour p_other) {
            int cmp_value;
            if (this.first_touching_side > p_other.first_touching_side) {
                return 1;
            }
            if (this.first_touching_side < p_other.first_touching_side) {
                return -1;
            }
            IntOctagon is1 = this.intersection;
            IntOctagon is2 = p_other.intersection;
            if (this.first_touching_side == 0) {
                cmp_value = is1.corner((int)0).x - is2.corner((int)0).x;
            } else if (this.first_touching_side == 1) {
                cmp_value = is1.corner((int)1).x - is2.corner((int)1).x;
            } else if (this.first_touching_side == 2) {
                cmp_value = is1.corner((int)2).y - is2.corner((int)2).y;
            } else if (this.first_touching_side == 3) {
                cmp_value = is1.corner((int)3).y - is2.corner((int)3).y;
            } else if (this.first_touching_side == 4) {
                cmp_value = is2.corner((int)4).x - is1.corner((int)4).x;
            } else if (this.first_touching_side == 5) {
                cmp_value = is2.corner((int)5).x - is1.corner((int)5).x;
            } else if (this.first_touching_side == 6) {
                cmp_value = is2.corner((int)6).y - is1.corner((int)6).y;
            } else if (this.first_touching_side == 7) {
                cmp_value = is2.corner((int)7).y - is1.corner((int)7).y;
            } else {
                System.out.println("SortedRoomNeighbour.compareTo: first_touching_side out of range ");
                return 0;
            }
            if (cmp_value == 0) {
                int this_touching_side_diff = (this.last_touching_side - this.first_touching_side + 8) % 8;
                int other_touching_side_diff = (p_other.last_touching_side - p_other.first_touching_side + 8) % 8;
                if (this_touching_side_diff > other_touching_side_diff) {
                    return 1;
                }
                if (this_touching_side_diff < other_touching_side_diff) {
                    return -1;
                }
                if (this.last_touching_side == 0) {
                    cmp_value = is1.corner((int)1).x - is2.corner((int)1).x;
                } else if (this.last_touching_side == 1) {
                    cmp_value = is1.corner((int)2).x - is2.corner((int)2).x;
                } else if (this.last_touching_side == 2) {
                    cmp_value = is1.corner((int)3).y - is2.corner((int)3).y;
                } else if (this.last_touching_side == 3) {
                    cmp_value = is1.corner((int)4).y - is2.corner((int)4).y;
                } else if (this.last_touching_side == 4) {
                    cmp_value = is2.corner((int)5).x - is1.corner((int)5).x;
                } else if (this.last_touching_side == 5) {
                    cmp_value = is2.corner((int)6).x - is1.corner((int)6).x;
                } else if (this.last_touching_side == 6) {
                    cmp_value = is2.corner((int)7).y - is1.corner((int)7).y;
                } else if (this.last_touching_side == 7) {
                    cmp_value = is2.corner((int)0).y - is1.corner((int)0).y;
                }
            }
            return cmp_value;
        }
    }
}

