/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.CompleteExpansionRoom;
import autoroute.ExpandableObject;
import autoroute.ExpansionDoor;
import autoroute.ExpansionRoom;
import autoroute.TargetItemExpansionDoor;
import board.Item;
import board.PolylineTrace;
import board.SearchTreeObject;
import board.ShapeSearchTree;
import boardgraphics.GraphicsContext;
import geometry.planar.TileShape;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class ObstacleExpansionRoom
implements CompleteExpansionRoom {
    private final Item item;
    private final int index_in_item;
    private final TileShape shape;
    private List<ExpansionDoor> doors;
    private boolean doors_calculated = false;

    ObstacleExpansionRoom(Item p_item, int p_index_in_item, ShapeSearchTree p_shape_tree) {
        this.item = p_item;
        this.index_in_item = p_index_in_item;
        this.shape = p_item.get_tree_shape(p_shape_tree, p_index_in_item);
        this.doors = new LinkedList<ExpansionDoor>();
    }

    public int get_index_in_item() {
        return this.index_in_item;
    }

    @Override
    public int get_layer() {
        return this.item.shape_layer(this.index_in_item);
    }

    @Override
    public TileShape get_shape() {
        return this.shape;
    }

    @Override
    public boolean door_exists(ExpansionRoom p_other) {
        if (this.doors != null) {
            for (ExpansionDoor curr_door : this.doors) {
                if (curr_door.first_room != p_other && curr_door.second_room != p_other) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void add_door(ExpansionDoor p_door) {
        this.doors.add(p_door);
    }

    public boolean create_overlap_door(ObstacleExpansionRoom p_other) {
        if (this.door_exists(p_other)) {
            return false;
        }
        if (!this.item.is_route() || !p_other.item.is_route()) {
            return false;
        }
        if (!this.item.shares_net(p_other.item)) {
            return false;
        }
        if (this.item == p_other.item) {
            if (!(this.item instanceof PolylineTrace)) {
                return false;
            }
            if (this.index_in_item != p_other.index_in_item + 1 && this.index_in_item != p_other.index_in_item - 1) {
                return false;
            }
        }
        ExpansionDoor new_door = new ExpansionDoor(this, p_other, 2);
        this.add_door(new_door);
        p_other.add_door(new_door);
        return true;
    }

    @Override
    public List<ExpansionDoor> get_doors() {
        return this.doors;
    }

    @Override
    public void clear_doors() {
        this.doors = new LinkedList<ExpansionDoor>();
    }

    @Override
    public void reset_doors() {
        for (ExpandableObject expandableObject : this.doors) {
            expandableObject.reset();
        }
    }

    @Override
    public Collection<TargetItemExpansionDoor> get_target_doors() {
        return new LinkedList<TargetItemExpansionDoor>();
    }

    public Item get_item() {
        return this.item;
    }

    @Override
    public SearchTreeObject get_object() {
        return this.item;
    }

    @Override
    public boolean remove_door(ExpandableObject p_door) {
        return this.doors.remove(p_door);
    }

    boolean all_doors_calculated() {
        return this.doors_calculated;
    }

    void set_doors_calculated(boolean p_value) {
        this.doors_calculated = p_value;
    }

    @Override
    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context, double p_intensity) {
        Color draw_color = Color.WHITE;
        double layer_visibility = p_graphics_context.get_layer_visibility(this.get_layer());
        p_graphics_context.fill_area(this.get_shape(), p_graphics, draw_color, p_intensity * layer_visibility);
        p_graphics_context.draw_boundary(this.get_shape(), 0.0, draw_color, p_graphics, layer_visibility);
    }
}

