/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.AutorouteControl;
import autoroute.AutorouteEngine;
import autoroute.CompleteExpansionRoom;
import autoroute.CompleteFreeSpaceExpansionRoom;
import autoroute.Connection;
import autoroute.DestinationDistance;
import autoroute.DrillPage;
import autoroute.ExpandableObject;
import autoroute.ExpansionDoor;
import autoroute.ExpansionDrill;
import autoroute.FreeSpaceExpansionRoom;
import autoroute.IncompleteFreeSpaceExpansionRoom;
import autoroute.ItemAutorouteInfo;
import autoroute.MazeListElement;
import autoroute.MazeSearchElement;
import autoroute.MazeShoveTraceAlgo;
import autoroute.ObstacleExpansionRoom;
import autoroute.TargetItemExpansionDoor;
import board.AngleRestriction;
import board.Connectable;
import board.FixedState;
import board.ForcedPadAlgo;
import board.ForcedViaAlgo;
import board.Item;
import board.ItemSelectionFilter;
import board.Pin;
import board.PolylineTrace;
import board.SearchTreeObject;
import board.ShapeSearchTree;
import board.TestLevel;
import board.Trace;
import board.Via;
import geometry.planar.ConvexShape;
import geometry.planar.FloatLine;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.Line;
import geometry.planar.Point;
import geometry.planar.Polyline;
import geometry.planar.TileShape;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import library.Padstack;

public class MazeSearchAlgo {
    public final AutorouteEngine autoroute_engine;
    final AutorouteControl ctrl;
    private final ShapeSearchTree search_tree;
    final SortedSet<MazeListElement> maze_expansion_list;
    final DestinationDistance destination_distance;
    private ExpandableObject destination_door = null;
    private int section_no_of_destination_door = 0;
    private final Random random_generator = new Random();
    private static final int ALREADY_RIPPED_COSTS = 1;

    public static MazeSearchAlgo get_instance(Set<Item> p_start_items, Set<Item> p_destination_items, AutorouteEngine p_autoroute_database, AutorouteControl p_ctrl) {
        MazeSearchAlgo new_instance = new MazeSearchAlgo(p_autoroute_database, p_ctrl);
        MazeSearchAlgo result = new_instance.init(p_start_items, p_destination_items) ? new_instance : null;
        return result;
    }

    MazeSearchAlgo(AutorouteEngine p_autoroute_engine, AutorouteControl p_ctrl) {
        this.autoroute_engine = p_autoroute_engine;
        this.ctrl = p_ctrl;
        this.random_generator.setSeed(p_ctrl.ripup_costs);
        this.search_tree = p_autoroute_engine.autoroute_search_tree;
        this.maze_expansion_list = new TreeSet<MazeListElement>();
        this.destination_distance = new DestinationDistance(this.ctrl.trace_costs, this.ctrl.layer_active, this.ctrl.min_normal_via_cost, this.ctrl.min_cheap_via_cost);
    }

    public Result find_connection() {
        while (this.occupy_next_element()) {
        }
        if (this.destination_door == null) {
            return null;
        }
        return new Result(this.destination_door, this.section_no_of_destination_door);
    }

    public boolean occupy_next_element() {
        TargetItemExpansionDoor curr_door;
        if (this.destination_door != null) {
            return false;
        }
        MazeListElement list_element = null;
        MazeSearchElement curr_door_section = null;
        boolean next_element_found = false;
        while (!this.maze_expansion_list.isEmpty()) {
            if (this.autoroute_engine.is_stop_requested()) {
                return false;
            }
            Iterator it = this.maze_expansion_list.iterator();
            list_element = (MazeListElement)it.next();
            int curr_section_no = list_element.section_no_of_door;
            curr_door_section = list_element.door.get_maze_search_element(curr_section_no);
            it.remove();
            if (curr_door_section.is_occupied) continue;
            next_element_found = true;
            break;
        }
        if (!next_element_found) {
            return false;
        }
        curr_door_section.backtrack_door = list_element.backtrack_door;
        curr_door_section.section_no_of_backtrack_door = list_element.section_no_of_backtrack_door;
        curr_door_section.room_ripped = list_element.room_ripped;
        curr_door_section.adjustment = list_element.adjustment;
        if (list_element.door instanceof DrillPage) {
            this.expand_to_drills_of_page(list_element);
            return true;
        }
        if (list_element.door instanceof TargetItemExpansionDoor && (curr_door = (TargetItemExpansionDoor)list_element.door).is_destination_door()) {
            this.destination_door = curr_door;
            this.section_no_of_destination_door = list_element.section_no_of_door;
            return false;
        }
        if (this.ctrl.is_fanout && list_element.door instanceof ExpansionDrill && list_element.backtrack_door instanceof ExpansionDrill) {
            this.destination_door = list_element.door;
            this.section_no_of_destination_door = list_element.section_no_of_door;
            return false;
        }
        if (this.ctrl.vias_allowed && list_element.door instanceof ExpansionDrill && !(list_element.backtrack_door instanceof ExpansionDrill)) {
            this.expand_to_other_layers(list_element);
        }
        if (list_element.next_room != null && !this.expand_to_room_doors(list_element)) {
            return true;
        }
        curr_door_section.is_occupied = true;
        return true;
    }

    private boolean expand_to_room_doors(MazeListElement p_list_element) {
        double neckdown_half_width;
        Item start_item;
        int layer_no = p_list_element.next_room.get_layer();
        boolean layer_active = this.ctrl.layer_active[layer_no];
        if (!layer_active && this.autoroute_engine.board.layer_structure.arr[layer_no].is_signal) {
            return true;
        }
        double half_width = this.ctrl.compensated_trace_half_width[layer_no];
        boolean curr_door_is_small = false;
        if (p_list_element.door instanceof ExpansionDoor) {
            double neck_down_half_width;
            double half_width_add = half_width + 2.0;
            ExpansionDoor curr_door = (ExpansionDoor)p_list_element.door;
            if (this.ctrl.with_neckdown && (neck_down_half_width = this.check_neck_down_at_dest_pin(p_list_element.next_room)) > 0.0) {
                half_width = half_width_add = Math.min(half_width_add, neck_down_half_width);
            }
            curr_door_is_small = this.door_is_small(curr_door, 2.0 * half_width_add);
        }
        this.autoroute_engine.complete_neigbour_rooms(p_list_element.next_room);
        FloatPoint shape_entry_middle = p_list_element.shape_entry.a.middle_point(p_list_element.shape_entry.b);
        if (this.ctrl.with_neckdown && p_list_element.door instanceof TargetItemExpansionDoor && (start_item = ((TargetItemExpansionDoor)p_list_element.door).item) instanceof Pin && (neckdown_half_width = (double)((Pin)start_item).get_trace_neckdown_halfwidth(layer_no)) > 0.0) {
            half_width = Math.min(half_width, neckdown_half_width);
        }
        boolean next_room_is_thick = true;
        if (p_list_element.next_room instanceof ObstacleExpansionRoom) {
            next_room_is_thick = this.room_shape_is_thick((ObstacleExpansionRoom)p_list_element.next_room);
        } else {
            TileShape next_room_shape = p_list_element.next_room.get_shape();
            if (next_room_shape.min_width() < 2.0 * half_width) {
                next_room_is_thick = false;
            } else if (!p_list_element.already_checked && p_list_element.door.get_dimension() == 1 && !curr_door_is_small) {
                FloatPoint[] nearest_points = next_room_shape.nearest_border_points_approx(shape_entry_middle, 2);
                if (nearest_points.length < 2) {
                    System.out.println("MazeSearchAlgo.expand_to_room_doors: nearest_points.length == 2 expected");
                    next_room_is_thick = false;
                } else {
                    double curr_dist = nearest_points[1].distance(shape_entry_middle);
                    boolean bl = next_room_is_thick = curr_dist > half_width + 1.0;
                }
            }
        }
        if (!layer_active && p_list_element.door instanceof ExpansionDrill) {
            Point drill_location = ((ExpansionDrill)p_list_element.door).location;
            ItemSelectionFilter filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.CONDUCTION);
            Set<Item> picked_items = this.autoroute_engine.board.pick_items(drill_location, layer_no, filter);
            for (Item curr_item : picked_items) {
                if (curr_item.contains_net(this.ctrl.net_no)) continue;
                return true;
            }
        }
        boolean something_expanded = false;
        if (this.expand_to_target_doors(p_list_element, next_room_is_thick, curr_door_is_small, shape_entry_middle)) {
            something_expanded = true;
        }
        if (!layer_active) {
            return true;
        }
        int ripup_costs = 0;
        if (p_list_element.next_room instanceof FreeSpaceExpansionRoom) {
            if (!p_list_element.already_checked && curr_door_is_small) {
                boolean enter_through_small_door = false;
                if (next_room_is_thick) {
                    enter_through_small_door = this.check_leaving_ripped_item(p_list_element);
                }
                if (!enter_through_small_door) {
                    return something_expanded;
                }
            }
        } else if (p_list_element.next_room instanceof ObstacleExpansionRoom) {
            ObstacleExpansionRoom obstacle_room = (ObstacleExpansionRoom)p_list_element.next_room;
            if (!p_list_element.already_checked) {
                boolean bl;
                boolean bl2 = false;
                if (this.ctrl.ripup_allowed) {
                    ripup_costs = this.check_ripup(p_list_element, obstacle_room.get_item(), curr_door_is_small);
                    boolean bl3 = bl = ripup_costs >= 0;
                }
                if (ripup_costs != 1 && next_room_is_thick) {
                    Item obstacle_item = obstacle_room.get_item();
                    if (!curr_door_is_small && this.ctrl.max_shove_trace_recursion_depth > 0 && obstacle_item instanceof PolylineTrace && !this.shove_trace_room(p_list_element, obstacle_room)) {
                        if (ripup_costs > 0) {
                            MazeListElement new_element = new MazeListElement(p_list_element.door, p_list_element.section_no_of_door, p_list_element.backtrack_door, p_list_element.section_no_of_backtrack_door, p_list_element.expansion_value + (double)ripup_costs, p_list_element.sorting_value + (double)ripup_costs, p_list_element.next_room, p_list_element.shape_entry, true, p_list_element.adjustment, true);
                            this.maze_expansion_list.add(new_element);
                        }
                        return something_expanded;
                    }
                }
                if (!bl) {
                    return true;
                }
            }
        }
        for (ExpansionDoor expansionDoor : p_list_element.next_room.get_doors()) {
            if (expansionDoor == p_list_element.door || !this.expand_to_door(expansionDoor, p_list_element, ripup_costs, next_room_is_thick, MazeSearchElement.Adjustment.NONE)) continue;
            something_expanded = true;
        }
        if (this.ctrl.vias_allowed && !(p_list_element.door instanceof ExpansionDrill)) {
            Item curr_obstacle_item;
            if ((something_expanded || next_room_is_thick) && p_list_element.next_room instanceof CompleteFreeSpaceExpansionRoom) {
                Collection<DrillPage> overlapping_drill_pages = this.autoroute_engine.drill_page_array.overlapping_pages(p_list_element.next_room.get_shape());
                for (DrillPage to_drill_page : overlapping_drill_pages) {
                    this.expand_to_drill_page(to_drill_page, p_list_element);
                    something_expanded = true;
                }
            } else if (p_list_element.next_room instanceof ObstacleExpansionRoom && (curr_obstacle_item = ((ObstacleExpansionRoom)p_list_element.next_room).get_item()) instanceof Via) {
                Via via = (Via)curr_obstacle_item;
                ExpansionDrill via_drill_info = via.get_autoroute_drill_info(this.autoroute_engine.autoroute_search_tree);
                this.expand_to_drill(via_drill_info, p_list_element, ripup_costs);
            }
        }
        return something_expanded;
    }

    private boolean expand_to_target_doors(MazeListElement p_list_element, boolean p_next_room_is_thick, boolean p_curr_door_is_small, FloatPoint p_shape_entry_middle) {
        if (p_curr_door_is_small) {
            CompleteExpansionRoom from_room;
            boolean enter_through_small_door = false;
            if (p_list_element.door instanceof ExpansionDoor && (from_room = ((ExpansionDoor)p_list_element.door).other_room(p_list_element.next_room)) instanceof ObstacleExpansionRoom) {
                enter_through_small_door = true;
            }
            if (!enter_through_small_door) {
                return false;
            }
        }
        boolean result = false;
        for (TargetItemExpansionDoor to_door : p_list_element.next_room.get_target_doors()) {
            FloatLine new_shape_entry;
            if (to_door == p_list_element.door) continue;
            TileShape target_shape = ((Connectable)((Object)to_door.item)).get_trace_connection_shape(this.autoroute_engine.autoroute_search_tree, to_door.tree_entry_no);
            FloatPoint connection_point = target_shape.nearest_point_approx(p_shape_entry_middle);
            if (!p_next_room_is_thick) {
                Polyline check_polyline;
                boolean check_ok;
                int[] curr_net_no_arr = new int[]{this.ctrl.net_no};
                int curr_layer = p_list_element.next_room.get_layer();
                Point[] check_points = new IntPoint[]{p_shape_entry_middle.round(), connection_point.round()};
                if (!check_points[0].equals(check_points[1]) && !(check_ok = this.autoroute_engine.board.check_forced_trace_polyline(check_polyline = new Polyline(check_points), this.ctrl.trace_half_width[curr_layer], curr_layer, curr_net_no_arr, this.ctrl.trace_clearance_class_no, this.ctrl.max_shove_trace_recursion_depth, this.ctrl.max_shove_via_recursion_depth, this.ctrl.max_spring_over_recursion_depth))) continue;
            }
            if (!this.expand_to_door_section(to_door, 0, new_shape_entry = new FloatLine(connection_point, connection_point), p_list_element, 0, MazeSearchElement.Adjustment.NONE)) continue;
            result = true;
        }
        return result;
    }

    private boolean expand_to_door(ExpansionDoor p_to_door, MazeListElement p_list_element, int p_add_costs, boolean p_next_room_is_thick, MazeSearchElement.Adjustment p_adjustment) {
        double half_width = this.ctrl.compensated_trace_half_width[p_list_element.next_room.get_layer()];
        boolean something_expanded = false;
        FloatLine[] line_sections = p_to_door.get_section_segments(half_width);
        for (int i = 0; i < line_sections.length; ++i) {
            FloatLine new_shape_entry;
            if (p_to_door.section_arr[i].is_occupied) continue;
            if (p_next_room_is_thick) {
                new_shape_entry = line_sections[i];
                if (p_to_door.dimension == 1 && line_sections.length == 1 && p_to_door.first_room instanceof CompleteFreeSpaceExpansionRoom && p_to_door.second_room instanceof CompleteFreeSpaceExpansionRoom) {
                    FloatPoint shape_entry_middle = new_shape_entry.a.middle_point(new_shape_entry.b);
                    TileShape room_shape = p_list_element.next_room.get_shape();
                    if (room_shape.min_width() < 2.0 * half_width) {
                        return false;
                    }
                    FloatPoint[] nearest_points = room_shape.nearest_border_points_approx(shape_entry_middle, 2);
                    if (nearest_points.length < 2 || nearest_points[1].distance(shape_entry_middle) <= half_width + 1.0) {
                        return false;
                    }
                }
            } else if (p_to_door.dimension == 1 && i == 0 && line_sections[0].b.distance_square(line_sections[0].a) < 1.0 || (new_shape_entry = MazeSearchAlgo.segment_projection(p_list_element.shape_entry, line_sections[i])) == null) continue;
            if (!this.expand_to_door_section(p_to_door, i, new_shape_entry, p_list_element, p_add_costs, p_adjustment)) continue;
            something_expanded = true;
        }
        return something_expanded;
    }

    private boolean door_is_small(ExpansionDoor p_door, double p_trace_width) {
        if (p_door.dimension == 1 || p_door.first_room instanceof CompleteFreeSpaceExpansionRoom && p_door.second_room instanceof CompleteFreeSpaceExpansionRoom) {
            double door_length;
            TileShape door_shape = p_door.get_shape();
            if (door_shape.is_empty()) {
                if (this.autoroute_engine.board.get_test_level().ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                    System.out.println("MazeSearchAlgo:check_door_width door_shape is empty");
                }
                return true;
            }
            AngleRestriction angle_restriction = this.autoroute_engine.board.rules.get_trace_angle_restriction();
            if (angle_restriction == AngleRestriction.NINETY_DEGREE) {
                IntBox door_box = door_shape.bounding_box();
                door_length = door_box.max_width();
            } else if (angle_restriction == AngleRestriction.FORTYFIVE_DEGREE) {
                IntOctagon door_oct = door_shape.bounding_octagon();
                door_length = door_oct.max_width();
            } else {
                FloatLine door_line_segment = door_shape.diagonal_corner_segment();
                door_length = door_line_segment.b.distance(door_line_segment.a);
            }
            if (door_length < p_trace_width) {
                return true;
            }
        }
        return false;
    }

    private boolean expand_to_door_section(ExpandableObject p_door, int p_section_no, FloatLine p_shape_entry, MazeListElement p_from_element, int p_add_costs, MazeSearchElement.Adjustment p_adjustment) {
        if (p_door.get_maze_search_element((int)p_section_no).is_occupied || p_shape_entry == null) {
            return false;
        }
        CompleteExpansionRoom next_room = p_door.other_room(p_from_element.next_room);
        int layer = p_from_element.next_room.get_layer();
        FloatPoint shape_entry_middle = p_shape_entry.a.middle_point(p_shape_entry.b);
        double expansion_value = p_from_element.expansion_value + (double)p_add_costs + shape_entry_middle.weighted_distance(p_from_element.shape_entry.a.middle_point(p_from_element.shape_entry.b), this.ctrl.trace_costs[layer].horizontal, this.ctrl.trace_costs[layer].vertical);
        double sorting_value = expansion_value + this.destination_distance.calculate(shape_entry_middle, layer);
        boolean room_ripped = p_add_costs > 0 && p_adjustment == MazeSearchElement.Adjustment.NONE || p_from_element.already_checked && p_from_element.room_ripped;
        MazeListElement new_element = new MazeListElement(p_door, p_section_no, p_from_element.door, p_from_element.section_no_of_door, expansion_value, sorting_value, next_room, p_shape_entry, room_ripped, p_adjustment, false);
        this.maze_expansion_list.add(new_element);
        return true;
    }

    private void expand_to_drill(ExpansionDrill p_drill, MazeListElement p_from_element, int p_add_costs) {
        int new_section_no_of_backtrack_door;
        ExpandableObject new_backtrack_door;
        FloatPoint nearest_exit_corner;
        Item from_item;
        boolean room_shape_is_thin;
        int layer = p_from_element.next_room.get_layer();
        int trace_half_width = this.ctrl.compensated_trace_half_width[layer];
        boolean bl = room_shape_is_thin = p_from_element.next_room.get_shape().min_width() < (double)(2 * trace_half_width);
        if (room_shape_is_thin && (p_from_element.backtrack_door == null || !p_drill.get_shape().intersects(p_from_element.backtrack_door.get_shape()))) {
            return;
        }
        double via_radius = this.ctrl.via_radius_arr[layer];
        ConvexShape shrinked_drill_shape = p_drill.get_shape().shrink(via_radius);
        FloatPoint compare_corner = p_from_element.shape_entry.a.middle_point(p_from_element.shape_entry.b);
        if (p_from_element.door instanceof DrillPage && p_from_element.backtrack_door instanceof TargetItemExpansionDoor && (from_item = ((TargetItemExpansionDoor)p_from_element.backtrack_door).item) instanceof Pin && (nearest_exit_corner = ((Pin)from_item).nearest_trace_exit_corner(p_drill.location.to_float(), trace_half_width, layer)) != null) {
            compare_corner = nearest_exit_corner;
        }
        FloatPoint nearest_point = shrinked_drill_shape.nearest_point_approx(compare_corner);
        FloatLine shape_entry = new FloatLine(nearest_point, nearest_point);
        int section_no = layer - p_drill.first_layer;
        double expansion_value = p_from_element.expansion_value + (double)p_add_costs + nearest_point.weighted_distance(compare_corner, this.ctrl.trace_costs[layer].horizontal, this.ctrl.trace_costs[layer].vertical);
        if (p_from_element.door instanceof DrillPage) {
            new_backtrack_door = p_from_element.backtrack_door;
            new_section_no_of_backtrack_door = p_from_element.section_no_of_backtrack_door;
        } else {
            new_backtrack_door = p_from_element.door;
            new_section_no_of_backtrack_door = p_from_element.section_no_of_door;
            expansion_value += this.ctrl.min_normal_via_cost;
        }
        double sorting_value = expansion_value + this.destination_distance.calculate(nearest_point, layer);
        MazeListElement new_element = new MazeListElement(p_drill, section_no, new_backtrack_door, new_section_no_of_backtrack_door, expansion_value, sorting_value, null, shape_entry, p_from_element.room_ripped, MazeSearchElement.Adjustment.NONE, false);
        this.maze_expansion_list.add(new_element);
    }

    private void expand_to_drill_page(DrillPage p_drill_page, MazeListElement p_from_element) {
        int layer = p_from_element.next_room.get_layer();
        FloatPoint from_element_shape_entry_middle = p_from_element.shape_entry.a.middle_point(p_from_element.shape_entry.b);
        FloatPoint nearest_point = p_drill_page.shape.nearest_point(from_element_shape_entry_middle);
        double expansion_value = p_from_element.expansion_value + this.ctrl.min_normal_via_cost;
        double sorting_value = expansion_value + nearest_point.weighted_distance(from_element_shape_entry_middle, this.ctrl.trace_costs[layer].horizontal, this.ctrl.trace_costs[layer].vertical) + this.destination_distance.calculate(nearest_point, layer);
        MazeListElement new_element = new MazeListElement(p_drill_page, layer, p_from_element.door, p_from_element.section_no_of_door, expansion_value, sorting_value, p_from_element.next_room, p_from_element.shape_entry, p_from_element.room_ripped, MazeSearchElement.Adjustment.NONE, false);
        this.maze_expansion_list.add(new_element);
    }

    private void expand_to_drills_of_page(MazeListElement p_from_element) {
        int from_room_layer = p_from_element.section_no_of_door;
        DrillPage drill_page = (DrillPage)p_from_element.door;
        Collection<ExpansionDrill> drill_list = drill_page.get_drills(this.autoroute_engine, this.ctrl.attach_smd_allowed);
        for (ExpansionDrill curr_drill : drill_list) {
            int section_no = from_room_layer - curr_drill.first_layer;
            if (section_no < 0 || section_no >= curr_drill.room_arr.length || curr_drill.room_arr[section_no] != p_from_element.next_room || curr_drill.get_maze_search_element((int)section_no).is_occupied) continue;
            this.expand_to_drill(curr_drill, p_from_element, 0);
        }
    }

    private void expand_to_other_layers(MazeListElement p_list_element) {
        boolean room_ripped;
        int via_lower_bound = 0;
        int via_upper_bound = -1;
        ExpansionDrill curr_drill = (ExpansionDrill)p_list_element.door;
        int from_layer = curr_drill.first_layer + p_list_element.section_no_of_door;
        boolean smd_attached_on_component_side = false;
        boolean smd_attached_on_solder_side = false;
        if (curr_drill.room_arr[p_list_element.section_no_of_door] instanceof ObstacleExpansionRoom) {
            if (!this.ctrl.ripup_allowed) {
                return;
            }
            Item curr_obstacle_item = ((ObstacleExpansionRoom)curr_drill.room_arr[p_list_element.section_no_of_door]).get_item();
            if (!(curr_obstacle_item instanceof Via)) {
                return;
            }
            Padstack curr_obstacle_padstack = ((Via)curr_obstacle_item).get_padstack();
            if (!this.ctrl.via_rule.contains_padstack(curr_obstacle_padstack) || curr_obstacle_item.clearance_class_no() != this.ctrl.via_clearance_class) {
                return;
            }
            via_lower_bound = curr_obstacle_padstack.from_layer();
            via_upper_bound = curr_obstacle_padstack.to_layer();
            room_ripped = true;
        } else {
            TileShape curr_room_shape;
            ForcedPadAlgo.CheckDrillResult drill_result;
            int[] net_no_arr = new int[]{this.ctrl.net_no};
            room_ripped = false;
            int via_lower_limit = Math.max(curr_drill.first_layer, this.ctrl.via_lower_bound);
            int via_upper_limit = Math.min(curr_drill.last_layer, this.ctrl.via_upper_bound);
            int curr_layer = from_layer;
            while (true) {
                if ((drill_result = ForcedViaAlgo.check_layer(this.ctrl.via_radius_arr[curr_layer], this.ctrl.via_clearance_class, this.ctrl.attach_smd_allowed, curr_room_shape = curr_drill.room_arr[curr_layer - curr_drill.first_layer].get_shape(), curr_drill.location, curr_layer, net_no_arr, this.ctrl.max_shove_trace_recursion_depth, 0, this.autoroute_engine.board)) == ForcedPadAlgo.CheckDrillResult.NOT_DRILLABLE) {
                    via_lower_bound = curr_layer + 1;
                    break;
                }
                if (drill_result == ForcedPadAlgo.CheckDrillResult.DRILLABLE_WITH_ATTACH_SMD) {
                    if (curr_layer == 0) {
                        smd_attached_on_component_side = true;
                    } else if (curr_layer == this.ctrl.layer_count - 1) {
                        smd_attached_on_solder_side = true;
                    }
                }
                if (curr_layer <= via_lower_limit) {
                    via_lower_bound = via_lower_limit;
                    break;
                }
                --curr_layer;
            }
            if (via_lower_bound > curr_drill.first_layer) {
                return;
            }
            curr_layer = from_layer + 1;
            while (true) {
                if (curr_layer > via_upper_limit) {
                    via_upper_bound = via_upper_limit;
                    break;
                }
                curr_room_shape = curr_drill.room_arr[curr_layer - curr_drill.first_layer].get_shape();
                drill_result = ForcedViaAlgo.check_layer(this.ctrl.via_radius_arr[curr_layer], this.ctrl.via_clearance_class, this.ctrl.attach_smd_allowed, curr_room_shape, curr_drill.location, curr_layer, net_no_arr, this.ctrl.max_shove_trace_recursion_depth, 0, this.autoroute_engine.board);
                if (drill_result == ForcedPadAlgo.CheckDrillResult.NOT_DRILLABLE) {
                    via_upper_bound = curr_layer - 1;
                    break;
                }
                if (drill_result == ForcedPadAlgo.CheckDrillResult.DRILLABLE_WITH_ATTACH_SMD && curr_layer == this.ctrl.layer_count - 1) {
                    smd_attached_on_solder_side = true;
                }
                ++curr_layer;
            }
            if (via_upper_bound < curr_drill.last_layer) {
                return;
            }
        }
        for (int to_layer = via_lower_bound; to_layer <= via_upper_bound; ++to_layer) {
            int curr_last_layer;
            int curr_first_layer;
            if (to_layer == from_layer) continue;
            if (to_layer < from_layer) {
                curr_first_layer = to_layer;
                curr_last_layer = from_layer;
            } else {
                curr_first_layer = from_layer;
                curr_last_layer = to_layer;
            }
            boolean mask_found = false;
            for (int i = 0; i < this.ctrl.via_info_arr.length; ++i) {
                AutorouteControl.ViaMask curr_via_info = this.ctrl.via_info_arr[i];
                if (curr_first_layer < curr_via_info.from_layer || curr_last_layer > curr_via_info.to_layer || curr_via_info.from_layer < via_lower_bound || curr_via_info.to_layer > via_upper_bound) continue;
                boolean mask_ok = true;
                if (curr_via_info.from_layer == 0 && smd_attached_on_component_side || curr_via_info.to_layer == this.ctrl.layer_count - 1 && smd_attached_on_solder_side) {
                    mask_ok = curr_via_info.attach_smd_allowed;
                }
                if (!mask_ok) continue;
                mask_found = true;
                break;
            }
            if (!mask_found) continue;
            MazeSearchElement curr_drill_layer_info = curr_drill.get_maze_search_element(to_layer - curr_drill.first_layer);
            if (curr_drill_layer_info.is_occupied) continue;
            double expansion_value = p_list_element.expansion_value + (double)this.ctrl.add_via_costs[from_layer].to_layer[to_layer];
            FloatPoint shape_entry_middle = p_list_element.shape_entry.a.middle_point(p_list_element.shape_entry.b);
            double sorting_value = expansion_value + this.destination_distance.calculate(shape_entry_middle, to_layer);
            int curr_room_index = to_layer - curr_drill.first_layer;
            MazeListElement new_element = new MazeListElement(curr_drill, curr_room_index, curr_drill, p_list_element.section_no_of_door, expansion_value, sorting_value, curr_drill.room_arr[curr_room_index], p_list_element.shape_entry, room_ripped, MazeSearchElement.Adjustment.NONE, false);
            this.maze_expansion_list.add(new_element);
        }
    }

    private boolean init(Set<Item> p_start_items, Set<Item> p_destination_items) {
        MazeSearchAlgo.reduce_trace_shapes_at_tie_pins(p_start_items, this.ctrl.net_no, this.search_tree);
        MazeSearchAlgo.reduce_trace_shapes_at_tie_pins(p_destination_items, this.ctrl.net_no, this.search_tree);
        boolean destination_ok = false;
        Iterator<Item> it = p_destination_items.iterator();
        while (it.hasNext()) {
            if (this.autoroute_engine.is_stop_requested()) {
                return false;
            }
            Item curr_item = it.next();
            ItemAutorouteInfo curr_info = curr_item.get_autoroute_info();
            curr_info.set_start_info(false);
            for (int i = 0; i < curr_item.tree_shape_count(this.search_tree); ++i) {
                TileShape curr_tree_shape = curr_item.get_tree_shape(this.search_tree, i);
                if (curr_tree_shape == null) continue;
                this.destination_distance.join(curr_tree_shape.bounding_box(), curr_item.shape_layer(i));
            }
            destination_ok = true;
        }
        if (!destination_ok && this.ctrl.is_fanout) {
            IntBox board_bounding_box = this.autoroute_engine.board.bounding_box;
            this.destination_distance.join(board_bounding_box, 0);
            this.destination_distance.join(board_bounding_box, this.ctrl.layer_count - 1);
            destination_ok = true;
        }
        if (!destination_ok) {
            return false;
        }
        LinkedList<IncompleteFreeSpaceExpansionRoom> start_rooms = new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        it = p_start_items.iterator();
        while (it.hasNext()) {
            if (this.autoroute_engine.is_stop_requested()) {
                return false;
            }
            Item curr_item = it.next();
            ItemAutorouteInfo curr_info = curr_item.get_autoroute_info();
            curr_info.set_start_info(true);
            if (!(curr_item instanceof Connectable)) continue;
            for (int i = 0; i < curr_item.tree_shape_count(this.search_tree); ++i) {
                TileShape contained_shape = ((Connectable)((Object)curr_item)).get_trace_connection_shape(this.search_tree, i);
                IncompleteFreeSpaceExpansionRoom new_start_room = this.autoroute_engine.add_incomplete_expansion_room(null, curr_item.shape_layer(i), contained_shape);
                start_rooms.add(new_start_room);
            }
        }
        LinkedList<CompleteFreeSpaceExpansionRoom> completed_start_rooms = new LinkedList<CompleteFreeSpaceExpansionRoom>();
        if (this.autoroute_engine.maintain_database) {
            completed_start_rooms.addAll(this.autoroute_engine.get_rooms_with_target_items(p_start_items));
        }
        for (IncompleteFreeSpaceExpansionRoom curr_room : start_rooms) {
            if (this.autoroute_engine.is_stop_requested()) {
                return false;
            }
            Collection<CompleteFreeSpaceExpansionRoom> curr_completed_rooms = this.autoroute_engine.complete_expansion_room(curr_room);
            completed_start_rooms.addAll(curr_completed_rooms);
        }
        boolean start_ok = false;
        for (CompleteFreeSpaceExpansionRoom curr_room : completed_start_rooms) {
            Iterator<TargetItemExpansionDoor> it2 = curr_room.get_target_doors().iterator();
            while (it2.hasNext()) {
                if (this.autoroute_engine.is_stop_requested()) {
                    return false;
                }
                TargetItemExpansionDoor curr_door = it2.next();
                if (curr_door.is_destination_door()) continue;
                TileShape connection_shape = ((Connectable)((Object)curr_door.item)).get_trace_connection_shape(this.search_tree, curr_door.tree_entry_no);
                connection_shape = connection_shape.intersection(curr_door.room.get_shape());
                FloatPoint curr_center = connection_shape.centre_of_gravity();
                FloatLine shape_entry = new FloatLine(curr_center, curr_center);
                double sorting_value = this.destination_distance.calculate(curr_center, curr_room.get_layer());
                MazeListElement new_list_element = new MazeListElement(curr_door, 0, null, 0, 0.0, sorting_value, curr_room, shape_entry, false, MazeSearchElement.Adjustment.NONE, false);
                this.maze_expansion_list.add(new_list_element);
                start_ok = true;
            }
        }
        return start_ok;
    }

    private static void reduce_trace_shapes_at_tie_pins(Collection<Item> p_item_list, int p_own_net_no, ShapeSearchTree p_autoroute_tree) {
        for (Item curr_item : p_item_list) {
            if (!(curr_item instanceof Pin) || curr_item.net_count() <= 1) continue;
            Set<Item> pin_contacts = curr_item.get_normal_contacts();
            Pin curr_tie_pin = (Pin)curr_item;
            for (Item curr_contact : pin_contacts) {
                if (!(curr_contact instanceof PolylineTrace) || curr_contact.contains_net(p_own_net_no)) continue;
                p_autoroute_tree.reduce_trace_shape_at_tie_pin(curr_tie_pin, (PolylineTrace)curr_contact);
            }
        }
    }

    private boolean room_shape_is_thick(ObstacleExpansionRoom p_obstacle_room) {
        double obstacle_half_width;
        Item obstacle_item = p_obstacle_room.get_item();
        int layer = p_obstacle_room.get_layer();
        if (obstacle_item instanceof Trace) {
            obstacle_half_width = ((Trace)obstacle_item).get_half_width() + this.search_tree.clearance_compensation_value(obstacle_item.clearance_class_no(), layer);
        } else if (obstacle_item instanceof Via) {
            TileShape via_shape = ((Via)obstacle_item).get_tree_shape_on_layer(this.search_tree, layer);
            obstacle_half_width = 0.5 * via_shape.max_width();
        } else {
            System.out.println("MazeSearchAlgo. room_shape_is_thick: unexpected obstacle item");
            obstacle_half_width = 0.0;
        }
        return obstacle_half_width >= (double)this.ctrl.compensated_trace_half_width[layer];
    }

    private int check_ripup(MazeListElement p_list_element, Item p_obstacle_item, boolean p_door_is_small) {
        boolean randomize;
        Connection obstacle_connection;
        if (!p_obstacle_item.is_route()) {
            return -1;
        }
        if (p_door_is_small && !this.enter_through_small_door(p_list_element, p_obstacle_item)) {
            return -1;
        }
        CompleteExpansionRoom previous_room = p_list_element.door.other_room(p_list_element.next_room);
        boolean room_was_shoved = p_list_element.adjustment != MazeSearchElement.Adjustment.NONE;
        Item previous_item = null;
        if (previous_room != null && previous_room instanceof ObstacleExpansionRoom) {
            previous_item = ((ObstacleExpansionRoom)previous_room).get_item();
        }
        if (room_was_shoved) {
            if (previous_item != null && previous_item != p_obstacle_item && previous_item.shares_net(p_obstacle_item)) {
                return -1;
            }
        } else if (previous_item == p_obstacle_item) {
            return 1;
        }
        double fanout_via_cost_factor = 1.0;
        double cost_factor = 1.0;
        if (p_obstacle_item instanceof Trace) {
            Trace obstacle_trace = (Trace)p_obstacle_item;
            cost_factor = obstacle_trace.get_half_width();
            if (!this.ctrl.remove_unconnected_vias) {
                fanout_via_cost_factor = MazeSearchAlgo.calc_fanout_via_ripup_cost_factor(obstacle_trace);
            }
        } else if (p_obstacle_item instanceof Via) {
            boolean look_if_fanout_via = !this.ctrl.remove_unconnected_vias;
            Set<Item> contact_list = p_obstacle_item.get_normal_contacts();
            int contact_count = 0;
            for (Item curr_contact : contact_list) {
                double curr_fanout_via_cost_factor;
                if (!(curr_contact instanceof Trace) || curr_contact.is_user_fixed()) {
                    return -1;
                }
                ++contact_count;
                Trace obstacle_trace = (Trace)curr_contact;
                cost_factor = Math.max(cost_factor, (double)obstacle_trace.get_half_width());
                if (!look_if_fanout_via || !((curr_fanout_via_cost_factor = MazeSearchAlgo.calc_fanout_via_ripup_cost_factor(obstacle_trace)) > 1.0)) continue;
                fanout_via_cost_factor = curr_fanout_via_cost_factor;
                look_if_fanout_via = false;
            }
            if (fanout_via_cost_factor <= 1.0) {
                cost_factor *= 0.5 * (double)Math.max(contact_count - 1, 0);
            }
        }
        double ripup_cost = (double)this.ctrl.ripup_costs * cost_factor;
        double detour = 1.0;
        if (fanout_via_cost_factor <= 1.0 && (obstacle_connection = Connection.get(p_obstacle_item)) != null) {
            detour = obstacle_connection.get_detour();
        }
        boolean bl = randomize = this.ctrl.ripup_pass_no >= 4 && this.ctrl.ripup_pass_no % 3 != 0;
        if (randomize) {
            double random_number = this.random_generator.nextDouble();
            double random_factor = 0.5 + random_number * random_number;
            detour *= random_factor;
        }
        ripup_cost /= detour;
        int result = Math.max((int)(ripup_cost *= fanout_via_cost_factor), 1);
        int MAX_RIPUP_COSTS = 21474836;
        return Math.min(result, 21474836);
    }

    private static double calc_fanout_via_ripup_cost_factor(Trace p_trace) {
        double FANOUT_COST_CONST = 20000.0;
        for (int i = 0; i < 2; ++i) {
            PolylineTrace contact_trace;
            Set<Item> curr_end_contacts = i == 0 ? p_trace.get_start_contacts() : p_trace.get_end_contacts();
            if (curr_end_contacts.size() != 1) continue;
            Item curr_trace_contact = (Item)curr_end_contacts.iterator().next();
            boolean protect_fanout_via = false;
            if (curr_trace_contact instanceof Pin && curr_trace_contact.first_layer() == curr_trace_contact.last_layer()) {
                protect_fanout_via = true;
            } else if (curr_trace_contact instanceof PolylineTrace && curr_trace_contact.get_fixed_state() == FixedState.SHOVE_FIXED && (contact_trace = (PolylineTrace)curr_trace_contact).corner_count() == 2) {
                protect_fanout_via = true;
            }
            if (!protect_fanout_via) continue;
            double fanout_via_cost_factor = (double)p_trace.get_half_width() / p_trace.get_length();
            fanout_via_cost_factor *= fanout_via_cost_factor;
            fanout_via_cost_factor *= 20000.0;
            fanout_via_cost_factor = Math.max(fanout_via_cost_factor, 1.0);
            return fanout_via_cost_factor;
        }
        return 1.0;
    }

    private boolean shove_trace_room(MazeListElement p_list_element, ObstacleExpansionRoom p_obstacle_room) {
        MazeSearchElement.Adjustment curr_adjustment;
        if (p_list_element.section_no_of_door != 0 && p_list_element.section_no_of_door != p_list_element.door.maze_search_element_count() - 1) {
            return true;
        }
        boolean result = false;
        if (p_list_element.adjustment != MazeSearchElement.Adjustment.RIGHT) {
            LinkedList<MazeShoveTraceAlgo.DoorSection> left_to_door_section_list = new LinkedList<MazeShoveTraceAlgo.DoorSection>();
            if (MazeShoveTraceAlgo.check_shove_trace_line(p_list_element, p_obstacle_room, this.autoroute_engine.board, this.ctrl, false, left_to_door_section_list)) {
                result = true;
            }
            for (MazeShoveTraceAlgo.DoorSection curr_left_door_section : left_to_door_section_list) {
                curr_adjustment = curr_left_door_section.door.dimension == 2 ? MazeSearchElement.Adjustment.LEFT : MazeSearchElement.Adjustment.NONE;
                this.expand_to_door_section(curr_left_door_section.door, curr_left_door_section.section_no, curr_left_door_section.section_line, p_list_element, 0, curr_adjustment);
            }
        }
        if (p_list_element.adjustment != MazeSearchElement.Adjustment.LEFT) {
            LinkedList<MazeShoveTraceAlgo.DoorSection> right_to_door_section_list = new LinkedList<MazeShoveTraceAlgo.DoorSection>();
            if (MazeShoveTraceAlgo.check_shove_trace_line(p_list_element, p_obstacle_room, this.autoroute_engine.board, this.ctrl, true, right_to_door_section_list)) {
                result = true;
            }
            for (MazeShoveTraceAlgo.DoorSection curr_right_door_section : right_to_door_section_list) {
                curr_adjustment = curr_right_door_section.door.dimension == 2 ? MazeSearchElement.Adjustment.RIGHT : MazeSearchElement.Adjustment.NONE;
                this.expand_to_door_section(curr_right_door_section.door, curr_right_door_section.section_no, curr_right_door_section.section_line, p_list_element, 0, curr_adjustment);
            }
        }
        return result;
    }

    private double check_neck_down_at_dest_pin(CompleteExpansionRoom p_room) {
        Collection<TargetItemExpansionDoor> target_doors = p_room.get_target_doors();
        for (TargetItemExpansionDoor curr_target_door : target_doors) {
            if (!(curr_target_door.item instanceof Pin)) continue;
            return ((Pin)curr_target_door.item).get_trace_neckdown_halfwidth(p_room.get_layer());
        }
        return 0.0;
    }

    private static FloatLine segment_projection(FloatLine p_from_segment, FloatLine p_to_segment) {
        FloatLine result;
        FloatLine check_segment = p_from_segment.adjust_direction(p_to_segment);
        FloatLine first_projection = p_to_segment.segment_projection(check_segment);
        FloatLine second_projection = p_to_segment.segment_projection_2(check_segment);
        if (first_projection != null && second_projection != null) {
            FloatPoint result_a = first_projection.a == p_to_segment.a || second_projection.a == p_to_segment.a ? p_to_segment.a : (first_projection.a.distance_square(p_to_segment.a) <= second_projection.a.distance_square(p_to_segment.a) ? first_projection.a : second_projection.a);
            FloatPoint result_b = first_projection.b == p_to_segment.b || second_projection.b == p_to_segment.b ? p_to_segment.b : (first_projection.b.distance_square(p_to_segment.b) <= second_projection.b.distance_square(p_to_segment.b) ? first_projection.b : second_projection.b);
            result = new FloatLine(result_a, result_b);
        } else {
            result = first_projection != null ? first_projection : second_projection;
        }
        return result;
    }

    private boolean enter_through_small_door(MazeListElement p_list_element, Item p_ignore_item) {
        if (p_list_element.door.get_dimension() != 1) {
            return false;
        }
        TileShape door_shape = p_list_element.door.get_shape();
        Line door_line = null;
        FloatPoint prev_corner = door_shape.corner_approx(0);
        int corner_count = door_shape.border_line_count();
        for (int i = 1; i < corner_count; ++i) {
            FloatPoint next_corner = door_shape.corner_approx(i);
            if (next_corner.distance_square(prev_corner) > 1.0) {
                door_line = door_shape.border_line(i - 1);
                break;
            }
            prev_corner = next_corner;
        }
        if (door_line == null) {
            return false;
        }
        IntPoint door_center = door_shape.centre_of_gravity().round();
        int curr_layer = p_list_element.next_room.get_layer();
        int check_radius = this.ctrl.compensated_trace_half_width[curr_layer] + 2;
        Line[] line_arr = new Line[]{door_line.translate(check_radius), new Line((Point)door_center, door_line.direction().turn_45_degree(2)), door_line.translate(-check_radius)};
        Polyline check_polyline = new Polyline(line_arr);
        TileShape check_shape = check_polyline.offset_shape(check_radius, 0);
        int[] ignore_net_nos = new int[]{this.ctrl.net_no};
        TreeSet<SearchTreeObject> overlapping_objects = new TreeSet<SearchTreeObject>();
        this.autoroute_engine.autoroute_search_tree.overlapping_objects(check_shape, curr_layer, ignore_net_nos, overlapping_objects);
        for (SearchTreeObject curr_object : overlapping_objects) {
            if (!(curr_object instanceof Item) || curr_object == p_ignore_item) continue;
            Item curr_item = (Item)curr_object;
            if (!curr_item.shares_net(p_ignore_item)) {
                return false;
            }
            Set<Item> curr_contacts = curr_item.get_normal_contacts();
            if (curr_contacts.contains(p_ignore_item)) continue;
            return false;
        }
        return true;
    }

    private boolean check_leaving_ripped_item(MazeListElement p_list_element) {
        if (!(p_list_element.door instanceof ExpansionDoor)) {
            return false;
        }
        ExpansionDoor curr_door = (ExpansionDoor)p_list_element.door;
        CompleteExpansionRoom from_room = curr_door.other_room(p_list_element.next_room);
        if (!(from_room instanceof ObstacleExpansionRoom)) {
            return false;
        }
        Item curr_item = ((ObstacleExpansionRoom)from_room).get_item();
        if (!curr_item.is_route()) {
            return false;
        }
        return this.enter_through_small_door(p_list_element, curr_item);
    }

    static class ShoveResult {
        final ExpansionDoor opposite_door;
        final Collection<ExpansionDoor> side_doors;
        final FloatPoint from_door_passing_point;
        final FloatPoint opposite_door_passing_point;

        ShoveResult(ExpansionDoor p_opposite_door, Collection<ExpansionDoor> p_side_doors, FloatPoint p_from_door_passing_point, FloatPoint p_opposite_door_passing_point) {
            this.opposite_door = p_opposite_door;
            this.side_doors = p_side_doors;
            this.from_door_passing_point = p_from_door_passing_point;
            this.opposite_door_passing_point = p_opposite_door_passing_point;
        }
    }

    public static class Result {
        public final ExpandableObject destination_door;
        public final int section_no_of_door;

        Result(ExpandableObject p_destination_door, int p_section_no_of_door) {
            this.destination_door = p_destination_door;
            this.section_no_of_door = p_section_no_of_door;
        }
    }
}

