/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.AutorouteControl;
import autoroute.CompleteExpansionRoom;
import autoroute.ExpandableObject;
import autoroute.ExpansionDrill;
import autoroute.LocateFoundConnectionAlgo45Degree;
import autoroute.LocateFoundConnectionAlgoAnyAngle;
import autoroute.MazeSearchAlgo;
import autoroute.MazeSearchElement;
import autoroute.ObstacleExpansionRoom;
import autoroute.TargetItemExpansionDoor;
import board.AngleRestriction;
import board.Connectable;
import board.Item;
import board.ShapeSearchTree;
import board.TestLevel;
import boardgraphics.GraphicsContext;
import geometry.planar.FloatPoint;
import geometry.planar.IntPoint;
import geometry.planar.TileShape;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;

public abstract class LocateFoundConnectionAlgo {
    public final Collection<ResultItem> connection_items;
    public final Item start_item;
    public final int start_layer;
    public final Item target_item;
    public final int target_layer;
    protected final BacktrackElement[] backtrack_array;
    protected final AutorouteControl ctrl;
    protected final AngleRestriction angle_restriction;
    protected final TestLevel test_level;
    protected final TargetItemExpansionDoor start_door;
    protected FloatPoint current_from_point;
    protected FloatPoint previous_from_point;
    protected int current_trace_layer;
    protected int current_from_door_index;
    protected int current_to_door_index;
    protected int current_target_door_index;
    protected TileShape current_target_shape;

    public static LocateFoundConnectionAlgo get_instance(MazeSearchAlgo.Result p_maze_search_result, AutorouteControl p_ctrl, ShapeSearchTree p_search_tree, AngleRestriction p_angle_restriction, SortedSet<Item> p_ripped_item_list, TestLevel p_test_level) {
        if (p_maze_search_result == null) {
            return null;
        }
        LocateFoundConnectionAlgo result = p_angle_restriction == AngleRestriction.NINETY_DEGREE || p_angle_restriction == AngleRestriction.FORTYFIVE_DEGREE ? new LocateFoundConnectionAlgo45Degree(p_maze_search_result, p_ctrl, p_search_tree, p_angle_restriction, p_ripped_item_list, p_test_level) : new LocateFoundConnectionAlgoAnyAngle(p_maze_search_result, p_ctrl, p_search_tree, p_angle_restriction, p_ripped_item_list, p_test_level);
        return result;
    }

    protected LocateFoundConnectionAlgo(MazeSearchAlgo.Result p_maze_search_result, AutorouteControl p_ctrl, ShapeSearchTree p_search_tree, AngleRestriction p_angle_restriction, SortedSet<Item> p_ripped_item_list, TestLevel p_test_level) {
        this.ctrl = p_ctrl;
        this.angle_restriction = p_angle_restriction;
        this.test_level = p_test_level;
        Collection<BacktrackElement> backtrack_list = LocateFoundConnectionAlgo.backtrack(p_maze_search_result, p_ripped_item_list);
        this.backtrack_array = new BacktrackElement[backtrack_list.size()];
        Iterator<BacktrackElement> it = backtrack_list.iterator();
        for (int i = 0; i < this.backtrack_array.length; ++i) {
            this.backtrack_array[i] = it.next();
        }
        this.connection_items = new LinkedList<ResultItem>();
        BacktrackElement start_info = this.backtrack_array[this.backtrack_array.length - 1];
        if (!(start_info.door instanceof TargetItemExpansionDoor)) {
            System.out.println("LocateFoundConnectionAlgo: ItemExpansionDoor expected for start_info.door");
            this.start_item = null;
            this.start_layer = 0;
            this.target_item = null;
            this.target_layer = 0;
            this.start_door = null;
            return;
        }
        this.start_door = (TargetItemExpansionDoor)start_info.door;
        this.start_item = this.start_door.item;
        this.start_layer = this.start_door.room.get_layer();
        this.current_from_door_index = 0;
        boolean at_fanout_end = false;
        if (p_maze_search_result.destination_door instanceof TargetItemExpansionDoor) {
            TargetItemExpansionDoor curr_destination_door = (TargetItemExpansionDoor)p_maze_search_result.destination_door;
            this.target_item = curr_destination_door.item;
            this.target_layer = curr_destination_door.room.get_layer();
            this.current_from_point = LocateFoundConnectionAlgo.calculate_starting_point(curr_destination_door, p_search_tree);
        } else if (p_maze_search_result.destination_door instanceof ExpansionDrill) {
            this.target_item = null;
            ExpansionDrill curr_drill = (ExpansionDrill)p_maze_search_result.destination_door;
            this.current_from_point = curr_drill.location.to_float();
            this.target_layer = curr_drill.first_layer + p_maze_search_result.section_no_of_door;
            at_fanout_end = true;
        } else {
            System.out.println("LocateFoundConnectionAlgo: unexpected type of destination_door");
            this.target_item = null;
            this.target_layer = 0;
            return;
        }
        this.current_trace_layer = this.target_layer;
        this.previous_from_point = this.current_from_point;
        boolean connection_done = false;
        while (!connection_done) {
            boolean layer_changed = false;
            if (at_fanout_end) {
                layer_changed = true;
            } else {
                this.current_target_door_index = this.current_from_door_index + 1;
                while (this.current_target_door_index < this.backtrack_array.length && !layer_changed) {
                    if (this.backtrack_array[this.current_target_door_index].door instanceof ExpansionDrill) {
                        layer_changed = true;
                        continue;
                    }
                    ++this.current_target_door_index;
                }
            }
            if (layer_changed) {
                ExpansionDrill current_target_drill = (ExpansionDrill)this.backtrack_array[this.current_target_door_index].door;
                this.current_target_shape = TileShape.get_instance(current_target_drill.location);
            } else {
                double trace_half_width;
                TileShape shrinked_shape;
                connection_done = true;
                this.current_target_door_index = this.backtrack_array.length - 1;
                TileShape target_shape = ((Connectable)((Object)this.start_item)).get_trace_connection_shape(p_search_tree, this.start_door.tree_entry_no);
                this.current_target_shape = target_shape.intersection(this.start_door.room.get_shape());
                if (this.current_target_shape.dimension() >= 2 && !(shrinked_shape = (TileShape)this.current_target_shape.offset(-(trace_half_width = (double)this.ctrl.compensated_trace_half_width[this.start_door.room.get_layer()]))).is_empty()) {
                    this.current_target_shape = shrinked_shape;
                }
            }
            this.current_to_door_index = this.current_from_door_index + 1;
            ResultItem next_trace = this.calculate_next_trace(layer_changed, at_fanout_end);
            at_fanout_end = false;
            this.connection_items.add(next_trace);
        }
    }

    private ResultItem calculate_next_trace(boolean p_layer_changed, boolean p_at_fanout_end) {
        Collection<FloatPoint> next_corners;
        FloatPoint adjusted_start_corner;
        LinkedList<FloatPoint> corner_list = new LinkedList<FloatPoint>();
        corner_list.add(this.current_from_point);
        if (!p_at_fanout_end && (adjusted_start_corner = this.adjust_start_corner()) != this.current_from_point) {
            FloatPoint add_corner = LocateFoundConnectionAlgo.calculate_additional_corner(this.current_from_point, adjusted_start_corner, true, this.angle_restriction);
            corner_list.add(add_corner);
            corner_list.add(adjusted_start_corner);
            this.previous_from_point = this.current_from_point;
            this.current_from_point = adjusted_start_corner;
        }
        FloatPoint prev_corner = this.current_from_point;
        while (!(next_corners = this.calculate_next_trace_corners()).isEmpty()) {
            for (FloatPoint curr_next_corner : next_corners) {
                if (curr_next_corner == prev_corner) continue;
                corner_list.add(curr_next_corner);
                this.previous_from_point = this.current_from_point;
                this.current_from_point = curr_next_corner;
                prev_corner = curr_next_corner;
            }
        }
        int next_layer = this.current_trace_layer;
        if (p_layer_changed) {
            this.current_from_door_index = this.current_target_door_index + 1;
            CompleteExpansionRoom next_room = this.backtrack_array[this.current_from_door_index].next_room;
            if (next_room != null) {
                next_layer = next_room.get_layer();
            }
        }
        LinkedList<IntPoint> rounded_corner_list = new LinkedList<IntPoint>();
        Iterator it = corner_list.iterator();
        IntPoint prev_point = null;
        while (it.hasNext()) {
            IntPoint curr_point = ((FloatPoint)it.next()).round();
            if (curr_point.equals(prev_point)) continue;
            rounded_corner_list.add(curr_point);
            prev_point = curr_point;
        }
        IntPoint[] corner_arr = new IntPoint[rounded_corner_list.size()];
        Iterator it2 = rounded_corner_list.iterator();
        for (int i = 0; i < corner_arr.length; ++i) {
            corner_arr[i] = (IntPoint)it2.next();
        }
        ResultItem result = new ResultItem(corner_arr, this.current_trace_layer);
        this.current_trace_layer = next_layer;
        return result;
    }

    protected abstract Collection<FloatPoint> calculate_next_trace_corners();

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context) {
        for (int i = 0; i < this.backtrack_array.length; ++i) {
            ExpandableObject next_door;
            CompleteExpansionRoom next_room = this.backtrack_array[i].next_room;
            if (next_room != null) {
                next_room.draw(p_graphics, p_graphics_context, 0.2);
            }
            if (!((next_door = this.backtrack_array[i].door) instanceof ExpansionDrill)) continue;
            ((ExpansionDrill)next_door).draw(p_graphics, p_graphics_context, 0.2);
        }
    }

    private static FloatPoint calculate_starting_point(TargetItemExpansionDoor p_from_door, ShapeSearchTree p_search_tree) {
        TileShape connection_shape = ((Connectable)((Object)p_from_door.item)).get_trace_connection_shape(p_search_tree, p_from_door.tree_entry_no);
        connection_shape = connection_shape.intersection(p_from_door.room.get_shape());
        return connection_shape.centre_of_gravity().round().to_float();
    }

    private static Collection<BacktrackElement> backtrack(MazeSearchAlgo.Result p_maze_search_result, SortedSet<Item> p_ripped_item_list) {
        if (p_maze_search_result == null) {
            return null;
        }
        LinkedList<BacktrackElement> result = new LinkedList<BacktrackElement>();
        CompleteExpansionRoom curr_next_room = null;
        ExpandableObject curr_backtrack_door = p_maze_search_result.destination_door;
        MazeSearchElement curr_maze_search_element = curr_backtrack_door.get_maze_search_element(p_maze_search_result.section_no_of_door);
        if (curr_backtrack_door instanceof TargetItemExpansionDoor) {
            curr_next_room = ((TargetItemExpansionDoor)curr_backtrack_door).room;
        } else if (curr_backtrack_door instanceof ExpansionDrill) {
            ExpansionDrill curr_drill = (ExpansionDrill)curr_backtrack_door;
            curr_next_room = curr_drill.room_arr[curr_drill.first_layer + p_maze_search_result.section_no_of_door];
            if (curr_maze_search_element.room_ripped) {
                for (CompleteExpansionRoom tmp_room : curr_drill.room_arr) {
                    if (!(tmp_room instanceof ObstacleExpansionRoom)) continue;
                    p_ripped_item_list.add(((ObstacleExpansionRoom)tmp_room).get_item());
                }
            }
        }
        BacktrackElement curr_backtrack_element = new BacktrackElement(curr_backtrack_door, p_maze_search_result.section_no_of_door, curr_next_room);
        while (true) {
            result.add(curr_backtrack_element);
            curr_backtrack_door = curr_maze_search_element.backtrack_door;
            if (curr_backtrack_door == null) break;
            int curr_section_no = curr_maze_search_element.section_no_of_backtrack_door;
            if (curr_section_no >= curr_backtrack_door.maze_search_element_count()) {
                System.out.println("LocateFoundConnectionAlgo: curr_section_no to big");
                curr_section_no = curr_backtrack_door.maze_search_element_count() - 1;
            }
            if (curr_backtrack_door instanceof ExpansionDrill) {
                ExpansionDrill curr_drill = (ExpansionDrill)curr_backtrack_door;
                curr_next_room = curr_drill.room_arr[curr_section_no];
            } else {
                curr_next_room = curr_backtrack_door.other_room(curr_next_room);
            }
            curr_maze_search_element = curr_backtrack_door.get_maze_search_element(curr_section_no);
            curr_backtrack_element = new BacktrackElement(curr_backtrack_door, curr_section_no, curr_next_room);
            if (!curr_maze_search_element.room_ripped || !(curr_next_room instanceof ObstacleExpansionRoom)) continue;
            p_ripped_item_list.add(((ObstacleExpansionRoom)curr_next_room).get_item());
        }
        return result;
    }

    private FloatPoint adjust_start_corner() {
        if (this.current_from_door_index < 0) {
            return this.current_from_point;
        }
        BacktrackElement curr_from_info = this.backtrack_array[this.current_from_door_index];
        if (curr_from_info.next_room == null) {
            return this.current_from_point;
        }
        double trace_half_width = this.ctrl.compensated_trace_half_width[this.current_trace_layer];
        TileShape shrinked_room_shape = (TileShape)curr_from_info.next_room.get_shape().offset(-trace_half_width);
        if (shrinked_room_shape.is_empty() || shrinked_room_shape.contains(this.current_from_point)) {
            return this.current_from_point;
        }
        return shrinked_room_shape.nearest_point_approx(this.current_from_point).round().to_float();
    }

    private static FloatPoint ninety_degree_corner(FloatPoint p_from_point, FloatPoint p_to_point, boolean p_horizontal_first) {
        double y;
        double x;
        if (p_horizontal_first) {
            x = p_to_point.x;
            y = p_from_point.y;
        } else {
            x = p_from_point.x;
            y = p_to_point.y;
        }
        return new FloatPoint(x, y);
    }

    private static FloatPoint fortyfive_degree_corner(FloatPoint p_from_point, FloatPoint p_to_point, boolean p_horizontal_first) {
        double y;
        double x;
        double abs_dy;
        double abs_dx = Math.abs(p_to_point.x - p_from_point.x);
        if (abs_dx <= (abs_dy = Math.abs(p_to_point.y - p_from_point.y))) {
            if (p_horizontal_first) {
                x = p_to_point.x;
                y = p_to_point.y >= p_from_point.y ? p_from_point.y + abs_dx : p_from_point.y - abs_dx;
            } else {
                x = p_from_point.x;
                y = p_to_point.y > p_from_point.y ? p_to_point.y - abs_dx : p_to_point.y + abs_dx;
            }
        } else if (p_horizontal_first) {
            y = p_from_point.y;
            x = p_to_point.x > p_from_point.x ? p_to_point.x - abs_dy : p_to_point.x + abs_dy;
        } else {
            y = p_to_point.y;
            x = p_to_point.x > p_from_point.x ? p_from_point.x + abs_dy : p_from_point.x - abs_dy;
        }
        return new FloatPoint(x, y);
    }

    static FloatPoint calculate_additional_corner(FloatPoint p_from_point, FloatPoint p_to_point, boolean p_horizontal_first, AngleRestriction p_angle_restriction) {
        FloatPoint result = p_angle_restriction == AngleRestriction.NINETY_DEGREE ? LocateFoundConnectionAlgo.ninety_degree_corner(p_from_point, p_to_point, p_horizontal_first) : (p_angle_restriction == AngleRestriction.FORTYFIVE_DEGREE ? LocateFoundConnectionAlgo.fortyfive_degree_corner(p_from_point, p_to_point, p_horizontal_first) : p_to_point);
        return result;
    }

    protected static class BacktrackElement {
        public final ExpandableObject door;
        public final int section_no_of_door;
        public final CompleteExpansionRoom next_room;

        private BacktrackElement(ExpandableObject p_door, int p_section_no_of_door, CompleteExpansionRoom p_room) {
            this.door = p_door;
            this.section_no_of_door = p_section_no_of_door;
            this.next_room = p_room;
        }
    }

    protected static class ResultItem {
        public final IntPoint[] corners;
        public final int layer;

        public ResultItem(IntPoint[] p_corners, int p_layer) {
            this.corners = p_corners;
            this.layer = p_layer;
        }
    }
}

