/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.Connection;
import autoroute.ObstacleExpansionRoom;
import board.Item;
import board.ShapeSearchTree;
import boardgraphics.GraphicsContext;
import java.awt.Graphics;

public class ItemAutorouteInfo {
    private boolean start_info;
    private final Item item;
    private Connection precalculated_connnection = null;
    private ObstacleExpansionRoom[] expansion_room_arr;

    public ItemAutorouteInfo(Item p_item) {
        this.item = p_item;
    }

    public boolean is_start_info() {
        return this.start_info;
    }

    public void set_start_info(boolean p_value) {
        this.start_info = p_value;
    }

    public Connection get_precalculated_connection() {
        return this.precalculated_connnection;
    }

    public void set_precalculated_connection(Connection p_connection) {
        this.precalculated_connnection = p_connection;
    }

    public ObstacleExpansionRoom get_expansion_room(int p_index, ShapeSearchTree p_autoroute_tree) {
        if (this.expansion_room_arr == null) {
            this.expansion_room_arr = new ObstacleExpansionRoom[this.item.tree_shape_count(p_autoroute_tree)];
        }
        if (p_index < 0 || p_index >= this.expansion_room_arr.length) {
            System.out.println("ItemAutorouteInfo.get_expansion_room: p_index out of range");
            return null;
        }
        if (this.expansion_room_arr[p_index] == null) {
            this.expansion_room_arr[p_index] = new ObstacleExpansionRoom(this.item, p_index, p_autoroute_tree);
        }
        return this.expansion_room_arr[p_index];
    }

    public void reset_doors() {
        if (this.expansion_room_arr != null) {
            for (ObstacleExpansionRoom curr_room : this.expansion_room_arr) {
                if (curr_room == null) continue;
                curr_room.reset_doors();
            }
        }
    }

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context, double p_intensity) {
        if (this.expansion_room_arr == null) {
            return;
        }
        for (ObstacleExpansionRoom curr_room : this.expansion_room_arr) {
            if (curr_room == null) continue;
            curr_room.draw(p_graphics, p_graphics_context, p_intensity);
        }
    }
}

