/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.ExpandableObject;
import autoroute.ExpansionDoor;
import autoroute.ExpansionRoom;
import geometry.planar.TileShape;
import java.util.LinkedList;
import java.util.List;

public abstract class FreeSpaceExpansionRoom
implements ExpansionRoom {
    private final int layer;
    private TileShape shape;
    private List<ExpansionDoor> doors;

    public FreeSpaceExpansionRoom(TileShape p_shape, int p_layer) {
        this.shape = p_shape;
        this.layer = p_layer;
        this.doors = new LinkedList<ExpansionDoor>();
    }

    @Override
    public void add_door(ExpansionDoor p_door) {
        this.doors.add(p_door);
    }

    @Override
    public List<ExpansionDoor> get_doors() {
        return this.doors;
    }

    @Override
    public void clear_doors() {
        this.doors = new LinkedList<ExpansionDoor>();
    }

    @Override
    public void reset_doors() {
        for (ExpandableObject expandableObject : this.doors) {
            expandableObject.reset();
        }
    }

    @Override
    public boolean remove_door(ExpandableObject p_door) {
        return this.doors.remove(p_door);
    }

    @Override
    public TileShape get_shape() {
        return this.shape;
    }

    public void set_shape(TileShape p_shape) {
        this.shape = p_shape;
    }

    @Override
    public int get_layer() {
        return this.layer;
    }

    @Override
    public boolean door_exists(ExpansionRoom p_other) {
        if (this.doors == null) {
            return false;
        }
        for (ExpansionDoor curr_door : this.doors) {
            if (curr_door.first_room != p_other && curr_door.second_room != p_other) continue;
            return true;
        }
        return false;
    }
}

