/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.CompleteExpansionRoom;
import autoroute.CompleteFreeSpaceExpansionRoom;
import autoroute.ExpandableObject;
import autoroute.ExpansionRoom;
import autoroute.MazeSearchElement;
import geometry.planar.FloatLine;
import geometry.planar.FloatPoint;
import geometry.planar.Point;
import geometry.planar.TileShape;

public class ExpansionDoor
implements ExpandableObject {
    MazeSearchElement[] section_arr = null;
    public final ExpansionRoom first_room;
    public final ExpansionRoom second_room;
    public final int dimension;

    public ExpansionDoor(ExpansionRoom p_first_room, ExpansionRoom p_second_room, int p_dimension) {
        this.first_room = p_first_room;
        this.second_room = p_second_room;
        this.dimension = p_dimension;
    }

    public ExpansionDoor(ExpansionRoom p_first_room, ExpansionRoom p_second_room) {
        this.first_room = p_first_room;
        this.second_room = p_second_room;
        this.dimension = this.first_room.get_shape().intersection(this.second_room.get_shape()).dimension();
    }

    @Override
    public TileShape get_shape() {
        TileShape first_shape = this.first_room.get_shape();
        TileShape second_shape = this.second_room.get_shape();
        return first_shape.intersection(second_shape);
    }

    @Override
    public int get_dimension() {
        return this.dimension;
    }

    public ExpansionRoom other_room(ExpansionRoom p_room) {
        ExpansionRoom result = p_room == this.first_room ? this.second_room : (p_room == this.second_room ? this.first_room : null);
        return result;
    }

    @Override
    public CompleteExpansionRoom other_room(CompleteExpansionRoom p_room) {
        ExpansionRoom result = p_room == this.first_room ? this.second_room : (p_room == this.second_room ? this.first_room : null);
        if (!(result instanceof CompleteExpansionRoom)) {
            result = null;
        }
        return (CompleteExpansionRoom)result;
    }

    @Override
    public int maze_search_element_count() {
        return this.section_arr.length;
    }

    @Override
    public MazeSearchElement get_maze_search_element(int p_no) {
        return this.section_arr[p_no];
    }

    public FloatLine[] get_section_segments(double p_offset) {
        FloatLine shrinked_line_segment;
        FloatLine door_line_segment;
        double offset = p_offset + 2.0;
        TileShape door_shape = this.get_shape();
        if (door_shape.is_empty()) {
            return new FloatLine[0];
        }
        if (this.dimension == 1) {
            door_line_segment = door_shape.diagonal_corner_segment();
            shrinked_line_segment = door_line_segment.shrink_segment(offset);
        } else if (this.dimension == 2 && this.first_room instanceof CompleteFreeSpaceExpansionRoom && this.second_room instanceof CompleteFreeSpaceExpansionRoom) {
            door_line_segment = this.calc_door_line_segment(door_shape);
            if (door_line_segment == null) {
                return new FloatLine[0];
            }
            if (door_line_segment.b.distance_square(door_line_segment.a) < 4.0 * offset * offset) {
                return new FloatLine[0];
            }
            shrinked_line_segment = door_line_segment.shrink_segment(offset);
        } else {
            FloatPoint gravity_point = door_shape.centre_of_gravity();
            shrinked_line_segment = door_line_segment = new FloatLine(gravity_point, gravity_point);
        }
        double c_max_door_section_width = 10.0 * offset;
        int section_count = (int)(door_line_segment.b.distance(door_line_segment.a) / c_max_door_section_width) + 1;
        this.allocate_sections(section_count);
        FloatLine[] result = shrinked_line_segment.divide_segment_into_sections(section_count);
        return result;
    }

    private FloatLine calc_door_line_segment(TileShape p_door_shape) {
        TileShape first_room_shape = this.first_room.get_shape();
        TileShape second_room_shape = this.second_room.get_shape();
        Point first_corner = null;
        Point second_corner = null;
        int corner_count = p_door_shape.border_line_count();
        for (int i = 0; i < corner_count; ++i) {
            Point curr_corner = p_door_shape.corner(i);
            if (first_room_shape.contains_inside(curr_corner) || second_room_shape.contains_inside(curr_corner)) continue;
            if (first_corner == null) {
                first_corner = curr_corner;
                continue;
            }
            if (second_corner != null || first_corner.equals(curr_corner)) continue;
            second_corner = curr_corner;
            break;
        }
        if (first_corner == null || second_corner == null) {
            return null;
        }
        return new FloatLine(first_corner.to_float(), second_corner.to_float());
    }

    @Override
    public void reset() {
        if (this.section_arr != null) {
            for (MazeSearchElement curr_section : this.section_arr) {
                curr_section.reset();
            }
        }
    }

    void allocate_sections(int p_section_count) {
        if (this.section_arr != null && this.section_arr.length == p_section_count) {
            return;
        }
        this.section_arr = new MazeSearchElement[p_section_count];
        for (int i = 0; i < this.section_arr.length; ++i) {
            this.section_arr[i] = new MazeSearchElement();
        }
    }
}

