/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.DrillPage;
import board.RoutingBoard;
import boardgraphics.GraphicsContext;
import geometry.planar.IntBox;
import geometry.planar.TileShape;
import java.awt.Graphics;
import java.util.Collection;
import java.util.LinkedList;

public class DrillPageArray {
    private final IntBox bounds;
    private final int COLUMN_COUNT;
    private final int ROW_COUNT;
    private final int PAGE_WIDTH;
    private final int PAGE_HEIGHT;
    private final DrillPage[][] page_arr;

    public DrillPageArray(RoutingBoard p_board, int p_max_page_width) {
        this.bounds = p_board.bounding_box;
        double length = this.bounds.ur.x - this.bounds.ll.x;
        double height = this.bounds.ur.y - this.bounds.ll.y;
        this.COLUMN_COUNT = (int)Math.ceil(length / (double)p_max_page_width);
        this.ROW_COUNT = (int)Math.ceil(height / (double)p_max_page_width);
        this.PAGE_WIDTH = (int)Math.ceil(length / (double)this.COLUMN_COUNT);
        this.PAGE_HEIGHT = (int)Math.ceil(height / (double)this.ROW_COUNT);
        this.page_arr = new DrillPage[this.ROW_COUNT][this.COLUMN_COUNT];
        for (int j = 0; j < this.ROW_COUNT; ++j) {
            for (int i = 0; i < this.COLUMN_COUNT; ++i) {
                int ll_x = this.bounds.ll.x + i * this.PAGE_WIDTH;
                int ur_x = i == this.COLUMN_COUNT - 1 ? this.bounds.ur.x : ll_x + this.PAGE_WIDTH;
                int ll_y = this.bounds.ll.y + j * this.PAGE_HEIGHT;
                int ur_y = j == this.ROW_COUNT - 1 ? this.bounds.ur.y : ll_y + this.PAGE_HEIGHT;
                this.page_arr[j][i] = new DrillPage(new IntBox(ll_x, ll_y, ur_x, ur_y), p_board);
            }
        }
    }

    public void invalidate(TileShape p_shape) {
        Collection<DrillPage> overlaps = this.overlapping_pages(p_shape);
        for (DrillPage curr_page : overlaps) {
            curr_page.invalidate();
        }
    }

    public Collection<DrillPage> overlapping_pages(TileShape p_shape) {
        LinkedList<DrillPage> result = new LinkedList<DrillPage>();
        IntBox shape_box = p_shape.bounding_box().intersection(this.bounds);
        int min_j = (int)Math.floor((double)(shape_box.ll.y - this.bounds.ll.y) / (double)this.PAGE_HEIGHT);
        double max_j = (double)(shape_box.ur.y - this.bounds.ll.y) / (double)this.PAGE_HEIGHT;
        int min_i = (int)Math.floor((double)(shape_box.ll.x - this.bounds.ll.x) / (double)this.PAGE_WIDTH);
        double max_i = (double)(shape_box.ur.x - this.bounds.ll.x) / (double)this.PAGE_WIDTH;
        int j = min_j;
        while ((double)j < max_j) {
            int i = min_i;
            while ((double)i < max_i) {
                DrillPage curr_page = this.page_arr[j][i];
                TileShape intersection = p_shape.intersection((TileShape)curr_page.shape);
                if (intersection.dimension() > 1) {
                    result.add(this.page_arr[j][i]);
                }
                ++i;
            }
            ++j;
        }
        return result;
    }

    public void reset() {
        for (int j = 0; j < this.page_arr.length; ++j) {
            DrillPage[] curr_row = this.page_arr[j];
            for (int i = 0; i < curr_row.length; ++i) {
                curr_row[i].reset();
            }
        }
    }

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context, double p_intensity) {
        for (int j = 0; j < this.page_arr.length; ++j) {
            DrillPage[] curr_row = this.page_arr[j];
            for (int i = 0; i < curr_row.length; ++i) {
                curr_row[i].draw(p_graphics, p_graphics_context, p_intensity);
            }
        }
    }
}

