/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.BatchAutorouter;
import board.FixedState;
import board.Item;
import board.RoutingBoard;
import board.TestLevel;
import board.Trace;
import board.Via;
import datastructures.UndoableObjects;
import geometry.planar.FloatPoint;
import interactive.InteractiveActionThread;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import rules.BoardRules;

public class BatchOptRoute {
    private final InteractiveActionThread thread;
    private final RoutingBoard routing_board;
    private ReadSortedRouteItems sorted_route_items;
    private boolean use_increased_ripup_costs;
    private double min_cumulative_trace_length_before = 0.0;
    private static int MAX_AUTOROUTE_PASSES = 6;
    private static int ADDITIONAL_RIPUP_COST_FACTOR_AT_START = 10;

    public BatchOptRoute(InteractiveActionThread p_thread) {
        this.thread = p_thread;
        this.routing_board = p_thread.hdlg.get_routing_board();
        this.sorted_route_items = null;
    }

    public void optimize_board() {
        if (this.routing_board.get_test_level() != TestLevel.RELEASE_VERSION) {
            System.out.println("Before optimize: Via count: " + this.routing_board.get_vias().size() + ", trace length: " + Math.round(this.routing_board.cumulative_trace_length()));
        }
        boolean route_improved = true;
        int curr_pass_no = 0;
        this.use_increased_ripup_costs = true;
        while (route_improved) {
            boolean with_prefered_directions = ++curr_pass_no % 2 != 0;
            route_improved = this.opt_route_pass(curr_pass_no, with_prefered_directions);
        }
    }

    private boolean opt_route_pass(int p_pass_no, boolean p_with_prefered_directions) {
        boolean route_improved = false;
        int via_count_before = this.routing_board.get_vias().size();
        double trace_length_before = this.thread.hdlg.coordinate_transform.board_to_user(this.routing_board.cumulative_trace_length());
        this.sorted_route_items = new ReadSortedRouteItems();
        this.min_cumulative_trace_length_before = BatchOptRoute.calc_weighted_trace_length(this.routing_board);
        while (true) {
            if (this.thread.is_stop_requested()) {
                return route_improved;
            }
            Item curr_item = this.sorted_route_items.next();
            if (curr_item == null) break;
            if (!this.opt_route_item(curr_item, p_pass_no, p_with_prefered_directions)) continue;
            route_improved = true;
        }
        this.sorted_route_items = null;
        if (this.use_increased_ripup_costs && !route_improved) {
            this.use_increased_ripup_costs = false;
            route_improved = true;
        }
        return route_improved;
    }

    private boolean opt_route_item(Item p_item, int p_pass_no, boolean p_with_prefered_directions) {
        boolean route_improved;
        ResourceBundle resources = ResourceBundle.getBundle("interactive.resources.InteractiveState", this.thread.hdlg.get_locale());
        String start_message = resources.getString("batch_optimizer") + " " + resources.getString("stop_message") + "        " + resources.getString("pass") + " " + new Integer(p_pass_no).toString() + ": ";
        this.thread.hdlg.remove_ratsnest();
        int incomplete_count_before = this.thread.hdlg.get_ratsnest().incomplete_count();
        int via_count_before = this.routing_board.get_vias().size();
        TreeSet<Item> ripped_items = new TreeSet<Item>();
        ripped_items.add(p_item);
        if (p_item instanceof Trace) {
            Trace curr_trace = (Trace)p_item;
            Object curr_contact_list = curr_trace.get_start_contacts();
            for (int i = 0; i < 2; ++i) {
                if (BatchOptRoute.contains_only_unfixed_traces((Collection<Item>)curr_contact_list)) {
                    ripped_items.addAll((Collection<Item>)curr_contact_list);
                }
                curr_contact_list = curr_trace.get_end_contacts();
            }
        }
        TreeSet<Item> ripped_connections = new TreeSet<Item>();
        for (Item curr_item : ripped_items) {
            ripped_connections.addAll(curr_item.get_connection_items(Item.StopConnectionOption.NONE));
        }
        for (Item curr_item : ripped_connections) {
            if (!curr_item.is_user_fixed()) continue;
            return false;
        }
        this.routing_board.generate_snapshot();
        this.routing_board.remove_items(ripped_connections, false);
        for (int i = 0; i < p_item.net_count(); ++i) {
            this.routing_board.combine_traces(p_item.get_net_no(i));
        }
        int ripup_costs = this.thread.hdlg.settings.autoroute_settings.get_start_ripup_costs();
        if (this.use_increased_ripup_costs) {
            ripup_costs *= ADDITIONAL_RIPUP_COST_FACTOR_AT_START;
        }
        if (p_item instanceof Trace) {
            ripup_costs = (int)Math.round(0.6 * (double)ripup_costs);
        }
        BatchAutorouter.autoroute_passes_for_optimizing_item(this.thread, MAX_AUTOROUTE_PASSES, ripup_costs, p_with_prefered_directions);
        this.thread.hdlg.remove_ratsnest();
        int incomplete_count_after = this.thread.hdlg.get_ratsnest().incomplete_count();
        int via_count_after = this.routing_board.get_vias().size();
        double trace_length_after = BatchOptRoute.calc_weighted_trace_length(this.routing_board);
        boolean bl = route_improved = !this.thread.is_stop_requested() && (incomplete_count_after < incomplete_count_before || incomplete_count_after == incomplete_count_before && (via_count_after < via_count_before || via_count_after == via_count_before && this.min_cumulative_trace_length_before > trace_length_after));
        if (route_improved) {
            this.min_cumulative_trace_length_before = incomplete_count_after < incomplete_count_before || incomplete_count_after == incomplete_count_before && via_count_after < via_count_before ? trace_length_after : Math.min(this.min_cumulative_trace_length_before, trace_length_after);
            this.routing_board.pop_snapshot();
            double d = this.thread.hdlg.coordinate_transform.board_to_user(this.routing_board.cumulative_trace_length());
        } else {
            this.routing_board.undo(null);
        }
        return route_improved;
    }

    static boolean contains_only_unfixed_traces(Collection<Item> p_item_list) {
        for (Item curr_item : p_item_list) {
            if (!curr_item.is_user_fixed() && curr_item instanceof Trace) continue;
            return false;
        }
        return true;
    }

    private static double calc_weighted_trace_length(RoutingBoard p_board) {
        UndoableObjects.Storable curr_item;
        double result = 0.0;
        int default_clearance_class = BoardRules.default_clearance_class();
        Iterator<UndoableObjects.UndoableObjectNode> it = p_board.item_list.start_read_object();
        while ((curr_item = p_board.item_list.read_object(it)) != null) {
            Trace curr_trace;
            FixedState fixed_state;
            if (!(curr_item instanceof Trace) || (fixed_state = (curr_trace = (Trace)curr_item).get_fixed_state()) != FixedState.UNFIXED && fixed_state != FixedState.SHOVE_FIXED) continue;
            double weighted_trace_length = curr_trace.get_length() * (double)(curr_trace.get_half_width() + p_board.clearance_value(curr_trace.clearance_class_no(), default_clearance_class, curr_trace.get_layer()));
            if (fixed_state == FixedState.SHOVE_FIXED) {
                weighted_trace_length /= 2.0;
            }
            result += weighted_trace_length;
        }
        return result;
    }

    public FloatPoint get_current_position() {
        if (this.sorted_route_items == null) {
            return null;
        }
        return this.sorted_route_items.get_current_position();
    }

    private class ReadSortedRouteItems {
        private FloatPoint min_item_coor = new FloatPoint(-2.147483648E9, -2.147483648E9);
        private int min_item_layer = -1;

        ReadSortedRouteItems() {
        }

        Item next() {
            UndoableObjects.Storable curr_item;
            Item result = null;
            FloatPoint curr_min_coor = new FloatPoint(2.147483647E9, 2.147483647E9);
            int curr_min_layer = Integer.MAX_VALUE;
            Iterator<UndoableObjects.UndoableObjectNode> it = ((BatchOptRoute)BatchOptRoute.this).routing_board.item_list.start_read_object();
            while ((curr_item = ((BatchOptRoute)BatchOptRoute.this).routing_board.item_list.read_object(it)) != null) {
                Via curr_via;
                if (!(curr_item instanceof Via) || (curr_via = (Via)curr_item).is_user_fixed()) continue;
                FloatPoint curr_via_center = curr_via.get_center().to_float();
                int curr_via_min_layer = curr_via.first_layer();
                if (!(curr_via_center.x > this.min_item_coor.x) && (curr_via_center.x != this.min_item_coor.x || !(curr_via_center.y > this.min_item_coor.y) && (curr_via_center.y != this.min_item_coor.y || curr_via_min_layer <= this.min_item_layer)) || !(curr_via_center.x < curr_min_coor.x) && (curr_via_center.x != curr_min_coor.x || !(curr_via_center.y < curr_min_coor.y) && (curr_via_center.y != curr_min_coor.y || curr_via_min_layer >= curr_min_layer))) continue;
                curr_min_coor = curr_via_center;
                curr_min_layer = curr_via_min_layer;
                result = curr_via;
            }
            it = ((BatchOptRoute)BatchOptRoute.this).routing_board.item_list.start_read_object();
            while ((curr_item = ((BatchOptRoute)BatchOptRoute.this).routing_board.item_list.read_object(it)) != null) {
                Trace curr_trace;
                if (!(curr_item instanceof Trace) || (curr_trace = (Trace)curr_item).is_shove_fixed()) continue;
                FloatPoint first_corner = curr_trace.first_corner().to_float();
                FloatPoint last_corner = curr_trace.last_corner().to_float();
                FloatPoint compare_corner = first_corner.x < last_corner.x || first_corner.x == last_corner.x && first_corner.y < last_corner.y ? last_corner : first_corner;
                int curr_trace_layer = curr_trace.get_layer();
                if (!(compare_corner.x > this.min_item_coor.x) && (compare_corner.x != this.min_item_coor.x || !(compare_corner.y > this.min_item_coor.y) && (compare_corner.y != this.min_item_coor.y || curr_trace_layer <= this.min_item_layer)) || !(compare_corner.x < curr_min_coor.x) && (compare_corner.x != curr_min_coor.x || !(compare_corner.y < curr_min_coor.y) && (compare_corner.y != curr_min_coor.y || curr_trace_layer >= curr_min_layer))) continue;
                boolean is_connected_to_via = false;
                Set<Item> trace_contacts = curr_trace.get_normal_contacts();
                for (Item curr_contact : trace_contacts) {
                    if (!(curr_contact instanceof Via) || curr_contact.is_user_fixed()) continue;
                    is_connected_to_via = true;
                    break;
                }
                if (is_connected_to_via) continue;
                curr_min_coor = compare_corner;
                curr_min_layer = curr_trace_layer;
                result = curr_trace;
            }
            this.min_item_coor = curr_min_coor;
            this.min_item_layer = curr_min_layer;
            return result;
        }

        FloatPoint get_current_position() {
            return this.min_item_coor;
        }
    }
}

