/*
 * Decompiled with CFR 0.152.
 */
package autoroute;

import autoroute.AutorouteControl;
import autoroute.AutorouteEngine;
import board.ConductionArea;
import board.Connectable;
import board.DrillItem;
import board.Item;
import board.RoutingBoard;
import board.TestLevel;
import datastructures.TimeLimit;
import datastructures.UndoableObjects;
import geometry.planar.FloatLine;
import geometry.planar.FloatPoint;
import interactive.BoardHandling;
import interactive.InteractiveActionThread;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import rules.Net;

public class BatchAutorouter {
    private final InteractiveActionThread thread;
    private final BoardHandling hdlg;
    private final RoutingBoard routing_board;
    private boolean is_interrupted = false;
    private final boolean remove_unconnected_vias;
    private final AutorouteControl.ExpansionCostFactor[] trace_cost_arr;
    private final boolean retain_autoroute_database;
    private final int start_ripup_costs;
    private FloatLine air_line = null;
    private static final int TIME_LIMIT_TO_PREVENT_ENDLESS_LOOP = 1000;

    public static int autoroute_passes_for_optimizing_item(InteractiveActionThread p_thread, int p_max_pass_count, int p_ripup_costs, boolean p_with_prefered_directions) {
        int curr_pass_no;
        BatchAutorouter router_instance = new BatchAutorouter(p_thread, true, p_with_prefered_directions, p_ripup_costs);
        boolean still_unrouted_items = true;
        for (curr_pass_no = 1; still_unrouted_items && !router_instance.is_interrupted && curr_pass_no <= p_max_pass_count; ++curr_pass_no) {
            if (p_thread.is_stop_requested()) {
                router_instance.is_interrupted = true;
            }
            if ((still_unrouted_items = router_instance.autoroute_pass(curr_pass_no, false)) && !router_instance.is_interrupted) {
                p_thread.hdlg.settings.autoroute_settings.increment_pass_no();
                continue;
            }
            if (p_thread.hdlg.reduceOptTimes() != 0) continue;
            p_thread.request_stop();
        }
        router_instance.remove_tails(Item.StopConnectionOption.NONE);
        if (!still_unrouted_items) {
            --curr_pass_no;
        }
        return curr_pass_no;
    }

    public BatchAutorouter(InteractiveActionThread p_thread, boolean p_remove_unconnected_vias, boolean p_with_preferred_directions, int p_start_ripup_costs) {
        this.thread = p_thread;
        this.hdlg = p_thread.hdlg;
        this.routing_board = this.hdlg.get_routing_board();
        this.remove_unconnected_vias = p_remove_unconnected_vias;
        if (p_with_preferred_directions) {
            this.trace_cost_arr = this.hdlg.settings.autoroute_settings.get_trace_cost_arr();
        } else {
            this.trace_cost_arr = new AutorouteControl.ExpansionCostFactor[this.routing_board.get_layer_count()];
            for (int i = 0; i < this.trace_cost_arr.length; ++i) {
                double curr_min_cost = this.hdlg.settings.autoroute_settings.get_preferred_direction_trace_costs(i);
                this.trace_cost_arr[i] = new AutorouteControl.ExpansionCostFactor(curr_min_cost, curr_min_cost);
            }
        }
        this.start_ripup_costs = p_start_ripup_costs;
        this.retain_autoroute_database = false;
    }

    public boolean autoroute_passes() {
        ResourceBundle resources = ResourceBundle.getBundle("interactive.resources.InteractiveState", this.hdlg.get_locale());
        boolean still_unrouted_items = true;
        while (still_unrouted_items && !this.is_interrupted) {
            if (this.thread.is_stop_requested()) {
                this.is_interrupted = true;
                continue;
            }
            int curr_pass_no = this.hdlg.settings.autoroute_settings.get_pass_no();
            still_unrouted_items = this.autoroute_pass(curr_pass_no, true);
            if (!still_unrouted_items || this.is_interrupted) continue;
            this.hdlg.settings.autoroute_settings.increment_pass_no();
        }
        if (!(this.remove_unconnected_vias || still_unrouted_items || this.is_interrupted)) {
            this.remove_tails(Item.StopConnectionOption.NONE);
        }
        return !this.is_interrupted;
    }

    private boolean autoroute_pass(int p_pass_no, boolean p_with_screen_message) {
        try {
            UndoableObjects.Storable curr_ob;
            LinkedList<Item> autoroute_item_list = new LinkedList<Item>();
            TreeSet<Item> handeled_items = new TreeSet<Item>();
            Iterator<UndoableObjects.UndoableObjectNode> it = this.routing_board.item_list.start_read_object();
            while ((curr_ob = this.routing_board.item_list.read_object(it)) != null) {
                Item curr_item;
                if (!(curr_ob instanceof Connectable) || !(curr_ob instanceof Item) || (curr_item = (Item)curr_ob).is_route() || handeled_items.contains(curr_item)) continue;
                for (int i = 0; i < curr_item.net_count(); ++i) {
                    int curr_net_no = curr_item.get_net_no(i);
                    Set<Item> connected_set = curr_item.get_connected_set(curr_net_no);
                    Iterator iterator = connected_set.iterator();
                    while (iterator.hasNext()) {
                        Item curr_connected_item = (Item)iterator.next();
                        if (curr_connected_item.net_count() > 1) continue;
                        handeled_items.add(curr_connected_item);
                    }
                    int net_item_count = this.routing_board.connectable_item_count(curr_net_no);
                    if (connected_set.size() >= net_item_count) continue;
                    autoroute_item_list.add(curr_item);
                }
            }
            if (autoroute_item_list.isEmpty()) {
                this.air_line = null;
                return false;
            }
            int items_to_go_count = autoroute_item_list.size();
            int ripped_item_count = 0;
            int not_found = 0;
            int routed = 0;
            if (p_with_screen_message) {
                // empty if block
            }
            block5: for (Item curr_item : autoroute_item_list) {
                if (this.is_interrupted) break;
                for (int i = 0; i < curr_item.net_count(); ++i) {
                    if (this.thread.is_stop_requested()) {
                        this.is_interrupted = true;
                        continue block5;
                    }
                    this.routing_board.start_marking_changed_area();
                    TreeSet<Item> ripped_item_list = new TreeSet<Item>();
                    if (this.autoroute_item(curr_item, curr_item.get_net_no(i), ripped_item_list, p_pass_no)) {
                        ++routed;
                        this.hdlg.updateCacheIfNeeded();
                    } else {
                        ++not_found;
                    }
                    --items_to_go_count;
                    ripped_item_count += ripped_item_list.size();
                    if (!p_with_screen_message) continue;
                }
            }
            if (this.routing_board.get_test_level() != TestLevel.ALL_DEBUGGING_OUTPUT) {
                Item.StopConnectionOption stop_connection_option = this.remove_unconnected_vias ? Item.StopConnectionOption.NONE : Item.StopConnectionOption.FANOUT_VIA;
                this.remove_tails(stop_connection_option);
            }
            this.air_line = null;
            return true;
        }
        catch (Exception e) {
            this.air_line = null;
            return false;
        }
    }

    private void remove_tails(Item.StopConnectionOption p_stop_connection_option) {
        this.routing_board.start_marking_changed_area();
        this.routing_board.remove_trace_tails(-1, p_stop_connection_option);
        this.routing_board.opt_changed_area(new int[0], null, this.hdlg.settings.get_trace_pull_tight_accuracy(), this.trace_cost_arr, this.thread, 1000);
    }

    private boolean autoroute_item(Item p_item, int p_route_net_no, SortedSet<Item> p_ripped_item_list, int p_ripup_pass_no) {
        try {
            Set<Item> route_dest_set;
            Set<Item> route_start_set;
            boolean contains_plane = false;
            Net route_net = this.routing_board.rules.nets.get(p_route_net_no);
            if (route_net != null) {
                contains_plane = route_net.contains_plane();
            }
            int curr_via_costs = contains_plane ? this.hdlg.settings.autoroute_settings.get_plane_via_costs() : this.hdlg.settings.autoroute_settings.get_via_costs();
            AutorouteControl autoroute_control = new AutorouteControl(this.routing_board, p_route_net_no, this.hdlg.settings, curr_via_costs, this.trace_cost_arr);
            autoroute_control.ripup_allowed = true;
            autoroute_control.ripup_costs = this.start_ripup_costs * p_ripup_pass_no;
            autoroute_control.remove_unconnected_vias = this.remove_unconnected_vias;
            Set<Item> unconnected_set = p_item.get_unconnected_set(p_route_net_no);
            if (unconnected_set.size() == 0) {
                return true;
            }
            Set<Item> connected_set = p_item.get_connected_set(p_route_net_no);
            if (contains_plane) {
                for (Item curr_item : connected_set) {
                    if (!(curr_item instanceof ConductionArea)) continue;
                    return true;
                }
            }
            if (contains_plane) {
                route_start_set = connected_set;
                route_dest_set = unconnected_set;
            } else {
                route_start_set = unconnected_set;
                route_dest_set = connected_set;
            }
            this.calc_airline(route_start_set, route_dest_set);
            double max_milliseconds = 100000.0 * Math.pow(2.0, p_ripup_pass_no - 1);
            max_milliseconds = Math.min(max_milliseconds, 2.147483647E9);
            TimeLimit time_limit = new TimeLimit((int)max_milliseconds);
            AutorouteEngine autoroute_engine = this.routing_board.init_autoroute(p_route_net_no, autoroute_control.trace_clearance_class_no, this.thread, time_limit, this.retain_autoroute_database);
            AutorouteEngine.AutorouteResult autoroute_result = autoroute_engine.autoroute_connection(route_start_set, route_dest_set, autoroute_control, p_ripped_item_list);
            if (autoroute_result == AutorouteEngine.AutorouteResult.ROUTED) {
                this.routing_board.opt_changed_area(new int[0], null, this.hdlg.settings.get_trace_pull_tight_accuracy(), autoroute_control.trace_costs, this.thread, 1000);
            }
            boolean result = autoroute_result == AutorouteEngine.AutorouteResult.ROUTED || autoroute_result == AutorouteEngine.AutorouteResult.ALREADY_CONNECTED;
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public FloatLine get_air_line() {
        if (this.air_line == null) {
            return null;
        }
        if (this.air_line.a == null || this.air_line.b == null) {
            return null;
        }
        return this.air_line;
    }

    private void calc_airline(Collection<Item> p_from_items, Collection<Item> p_to_items) {
        FloatPoint from_corner = null;
        FloatPoint to_corner = null;
        double min_distance = Double.MAX_VALUE;
        for (Item curr_from_item : p_from_items) {
            if (!(curr_from_item instanceof DrillItem)) continue;
            FloatPoint curr_from_corner = ((DrillItem)curr_from_item).get_center().to_float();
            for (Item curr_to_item : p_to_items) {
                FloatPoint curr_to_corner;
                double curr_distance;
                if (!(curr_to_item instanceof DrillItem) || !((curr_distance = curr_from_corner.distance_square(curr_to_corner = ((DrillItem)curr_to_item).get_center().to_float())) < min_distance)) continue;
                min_distance = curr_distance;
                from_corner = curr_from_corner;
                to_corner = curr_to_corner;
            }
        }
        this.air_line = new FloatLine(from_corner, to_corner);
    }
}

