uniform sampler2D tex;
uniform sampler2D lightFromLeft;
uniform sampler2D lightFromTop;
uniform sampler2D lightFromRight;
uniform sampler2D lightFromBottom;
uniform sampler2D bump;
uniform float strength;
uniform vec2 lightSize;
uniform float screenHeight;
uniform vec4 ambient;
uniform float ambientSaturation;

varying float vflipped;
varying float vangle;
varying vec3 vSrcA;
varying vec3 vTrgA;
varying vec3 vSrcB;
varying vec3 vTrgB;

void main(void) {
    vec4 bumpLookup = texture2D(bump, floor(gl_TexCoord[0].st) / 1024.0);
    
    float topM = max(bumpLookup.x - 0.3, 0.0) * 2.0 * bumpLookup.z * strength;
    float bottomM = max(0.7 - bumpLookup.x, 0.0) * 2.0 * bumpLookup.z * strength;
    float leftM = max(bumpLookup.y - 0.3, 0.0) * 2.0 * bumpLookup.z * strength;
    float rightM = max(0.7 - bumpLookup.y, 0.0) * 2.0 * bumpLookup.z * strength;
    
    float m0 = max(0.0, 1.0 - abs(mod(vangle / 1.570796327 + 9.0, 4.0) - 1.0));
    float m1 = max(0.0, 1.0 - abs(mod(vangle / 1.570796327 + 8.0, 4.0) - 1.0));
    float m2 = max(0.0, 1.0 - abs(mod(vangle / 1.570796327 + 7.0, 4.0) - 1.0));
    float m3 = max(0.0, 1.0 - abs(mod(vangle / 1.570796327 + 6.0, 4.0) - 1.0));
	
	vec4 lightTop = texture2D(lightFromTop, vec2(gl_FragCoord.x, screenHeight - gl_FragCoord.y) / lightSize / 4.0);
	vec4 lightBottom = texture2D(lightFromBottom, vec2(gl_FragCoord.x, screenHeight - gl_FragCoord.y) / lightSize / 4.0);
    vec4 lightLeft = texture2D(lightFromLeft, vec2(gl_FragCoord.x, screenHeight - gl_FragCoord.y) / lightSize / 4.0);
	vec4 lightRight = texture2D(lightFromRight, vec2(gl_FragCoord.x, screenHeight - gl_FragCoord.y) / lightSize / 4.0);
	
	mat4 satur = mat4(
	    (1.0 - ambientSaturation) / 3.0 + ambientSaturation,
	    (1.0 - ambientSaturation) / 3.0,
	    (1.0 - ambientSaturation) / 3.0,
	    0.0,
	    
	    (1.0 - ambientSaturation) / 3.0,
	    (1.0 - ambientSaturation) / 3.0 + ambientSaturation,
	    (1.0 - ambientSaturation) / 3.0,
	    0.0,
	    
	    (1.0 - ambientSaturation) / 3.0,
	    (1.0 - ambientSaturation) / 3.0,
	    (1.0 - ambientSaturation) / 3.0 + ambientSaturation,
	    0.0,
	    
	    0.0,
	    0.0,
	    0.0,
	    1.0
	);
	
    vec4 base = texture2D(tex, floor(gl_TexCoord[0].st) / 1024.0);
    if ((base.x - vSrcA.x) * (base.x - vSrcA.x) + (base.y - vSrcA.y) * (base.y - vSrcA.y) + (base.z - vSrcA.z) * (base.z - vSrcA.z) < 0.000256) {
        base.xyz = vTrgA;
    } else if ((base.x - vSrcB.x) * (base.x - vSrcB.x) + (base.y - vSrcB.y) * (base.y - vSrcB.y) + (base.z - vSrcB.z) * (base.z - vSrcB.z) < 0.000256) {
        base.xyz = vTrgB;
    }
	
	if (vflipped > 0.9) {
        vec4 totalLight =
            topM * (lightTop * m0 + lightRight * m1 + lightBottom * m2 + lightLeft * m3) + // top
            leftM * (lightTop * m3 + lightRight * m0 + lightBottom * m1 + lightLeft * m2) + // left
            bottomM * (lightTop * m2 + lightRight * m3 + lightBottom * m0 + lightLeft * m1) + // bottom
            rightM * (lightTop * m1 + lightRight * m2 + lightBottom * m3 + lightLeft * m0); // right
	
	    gl_FragColor = base * ambient * satur + vec4(totalLight.x, totalLight.y, totalLight.z, 0);
	} else {
	    vec4 totalLight =
            topM * (lightTop * m0 + lightRight * m1 + lightBottom * m2 + lightLeft * m3) + // top
            rightM * (lightTop * m3 + lightRight * m0 + lightBottom * m1 + lightLeft * m2) + // left
            bottomM * (lightTop * m2 + lightRight * m3 + lightBottom * m0 + lightLeft * m1) + // bottom
            leftM * (lightTop * m1 + lightRight * m2 + lightBottom * m3 + lightLeft * m0); // right
	
	    gl_FragColor = base * ambient * satur + vec4(totalLight.x, totalLight.y, totalLight.z, 0);
	}
}
