uniform vec4 ambient;

varying float vflagSize;
varying float wind;
varying float t;
varying float yShift;
varying vec2 coord;

void main(void) {
    vec2 texCoord = coord / vflagSize;
    texCoord = texCoord + vec2(0, cos(texCoord.x * 9.0 + t) * 0.07 * texCoord.x + 1.0 / (wind * 0.4 + 0.01) * texCoord.x + yShift * texCoord.x);
    texCoord = texCoord / vec2(min(0.95 + cos(t * wind) * 0.01, max(-0.95 + cos(t * wind) * 0.01, wind * 0.2)), 1.0);
    if (texCoord.x < 0.0 || texCoord.y - texCoord.x * 0.5 < -1.0 || texCoord.x > 1.0 || texCoord.y + texCoord.x * 0.5 > 0.0) {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
    } else {
	    gl_FragColor = gl_Color * ambient;
    }
}
