uniform sampler2D tex;
uniform sampler2D mask;

varying vec3 vmaskOffsetAndEnabled;
varying vec2 vglobalTexCoord;
varying vec4 vpaint;

void main(void) {    
    vec4 maskValue = texture2D(mask, floor(vglobalTexCoord + vmaskOffsetAndEnabled.xy) / 1024.0);
    if (vmaskOffsetAndEnabled.z > 0.0 && maskValue.a < 0.1) {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
        return;
    }
    
	gl_FragColor = (texture2D(tex, floor(gl_TexCoord[0].st) / 1024.0) * vec4(1.0 - vpaint.w, 1.0 - vpaint.w, 1.0 - vpaint.w, 1.0) + vec4(vpaint.x, vpaint.y, vpaint.z, 0.0)) * gl_Color;
}
