uniform sampler2D tex;

varying float vflagSize;
varying vec2 vtexOffset;
varying float wind;
varying float t;
varying float yShift;

void main(void) {
    vec2 texCoord = gl_TexCoord[0].st / vflagSize;
    texCoord = texCoord + vec2(0, cos((texCoord.x + t) * wind) * 0.07 * texCoord.x + 1.0 / (wind * 0.4 + 0.18) * texCoord.x + yShift * texCoord.x);
    texCoord = texCoord / vec2(min(1.0, max(-1.0, wind * 0.2 + 0.15)), 1.0);
    if (texCoord.x < 0.0 || texCoord.y < -1.0 || texCoord.x > 1.0 || texCoord.y > 0.0) {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
    } else {
        gl_FragColor = texture2D(tex, texCoord / 2.0 + vtexOffset);
    }
}
