/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.FinalArrayList;
import com.sun.xml.internal.org.jvnet.mimepull.Header;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEParser;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEParsingException;
import com.sun.xml.internal.org.jvnet.mimepull.hdr;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;

final class InternetHeaders {
    private final FinalArrayList<hdr> headers = new FinalArrayList();

    InternetHeaders(MIMEParser.LineInputStream lis) {
        String prevline = null;
        StringBuffer lineBuffer = new StringBuffer();
        try {
            String line;
            do {
                if ((line = lis.readLine()) != null && (line.startsWith(" ") || line.startsWith("\t"))) {
                    if (prevline != null) {
                        lineBuffer.append(prevline);
                        prevline = null;
                    }
                    lineBuffer.append("\r\n");
                    lineBuffer.append(line);
                    continue;
                }
                if (prevline != null) {
                    this.addHeaderLine(prevline);
                } else if (lineBuffer.length() > 0) {
                    this.addHeaderLine(lineBuffer.toString());
                    lineBuffer.setLength(0);
                }
                prevline = line;
            } while (line != null && line.length() > 0);
        }
        catch (IOException ioex) {
            throw new MIMEParsingException("Error in input stream", ioex);
        }
    }

    List<String> getHeader(String name) {
        FinalArrayList<String> v = new FinalArrayList<String>();
        int len = this.headers.size();
        for (int i = 0; i < len; ++i) {
            hdr h = (hdr)this.headers.get(i);
            if (!name.equalsIgnoreCase(h.name)) continue;
            v.add(h.getValue());
        }
        return v.size() == 0 ? null : v;
    }

    FinalArrayList<? extends Header> getAllHeaders() {
        return this.headers;
    }

    void addHeaderLine(String line) {
        try {
            char c = line.charAt(0);
            if (c == ' ' || c == '\t') {
                hdr h = (hdr)this.headers.get(this.headers.size() - 1);
                h.line = h.line + "\r\n" + line;
            } else {
                this.headers.add(new hdr(line));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

