/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityRuntimeException;
import com.sun.org.apache.xml.internal.security.signature.NodeFilter;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathAPIHolder;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathFuncHereAPI;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import com.sun.org.apache.xpath.internal.objects.XObject;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformXPath
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xpath-19991116";

    @Override
    protected String engineGetURI() {
        return implementedTransformURI;
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, Transform transform) throws TransformationException {
        try {
            CachedXPathAPIHolder.setDoc(transform.getElement().getOwnerDocument());
            Element element = XMLUtils.selectDsNode(transform.getElement().getFirstChild(), "XPath", 0);
            if (element == null) {
                Object[] objectArray = new Object[]{"ds:XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            Node node = element.getChildNodes().item(0);
            String string = CachedXPathFuncHereAPI.getStrFromNode(node);
            xMLSignatureInput.setNeedsToBeExpanded(this.needsCircunvent(string));
            if (node == null) {
                throw new DOMException(3, "Text must be in ds:Xpath");
            }
            xMLSignatureInput.addNodeFilter(new XPathNodeFilter(element, node, string));
            xMLSignatureInput.setNodeSet(true);
            return xMLSignatureInput;
        }
        catch (DOMException dOMException) {
            throw new TransformationException("empty", dOMException);
        }
    }

    private boolean needsCircunvent(String string) {
        return string.indexOf("namespace") != -1 || string.indexOf("name()") != -1;
    }

    static class XPathNodeFilter
    implements NodeFilter {
        PrefixResolverDefault prefixResolver;
        CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
        Node xpathnode;
        String str;

        XPathNodeFilter(Element element, Node node, String string) {
            this.xpathnode = node;
            this.str = string;
            this.prefixResolver = new PrefixResolverDefault(element);
        }

        @Override
        public int isNodeInclude(Node node) {
            try {
                XObject xObject = this.xPathFuncHereAPI.eval(node, this.xpathnode, this.str, this.prefixResolver);
                if (xObject.bool()) {
                    return 1;
                }
                return 0;
            }
            catch (TransformerException transformerException) {
                Object[] objectArray = new Object[]{node};
                throw new XMLSecurityRuntimeException("signature.Transform.node", objectArray, transformerException);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{node, new Short(node.getNodeType())};
                throw new XMLSecurityRuntimeException("signature.Transform.nodeAndType", objectArray, exception);
            }
        }

        @Override
        public int isNodeIncludeDO(Node node, int n) {
            return this.isNodeInclude(node);
        }
    }
}

