/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsBorders;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import sun.swing.DefaultLookup;
import sun.swing.StringUIClientPropertyKey;

public class WindowsComboBoxUI
extends BasicComboBoxUI {
    private static final MouseListener rolloverListener = new MouseAdapter(){

        private void handleRollover(MouseEvent mouseEvent, boolean bl) {
            JComboBox jComboBox = this.getComboBox(mouseEvent);
            WindowsComboBoxUI windowsComboBoxUI = this.getWindowsComboBoxUI(mouseEvent);
            if (jComboBox == null || windowsComboBoxUI == null) {
                return;
            }
            if (!jComboBox.isEditable()) {
                ButtonModel buttonModel = null;
                if (windowsComboBoxUI.arrowButton != null) {
                    buttonModel = windowsComboBoxUI.arrowButton.getModel();
                }
                if (buttonModel != null) {
                    buttonModel.setRollover(bl);
                }
            }
            windowsComboBoxUI.isRollover = bl;
            jComboBox.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.handleRollover(mouseEvent, true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.handleRollover(mouseEvent, false);
        }

        private JComboBox getComboBox(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            JComboBox jComboBox = null;
            if (object instanceof JComboBox) {
                jComboBox = (JComboBox)object;
            } else if (object instanceof XPComboBoxButton) {
                jComboBox = ((XPComboBoxButton)object).getWindowsComboBoxUI().comboBox;
            }
            return jComboBox;
        }

        private WindowsComboBoxUI getWindowsComboBoxUI(MouseEvent mouseEvent) {
            JComboBox jComboBox = this.getComboBox(mouseEvent);
            WindowsComboBoxUI windowsComboBoxUI = null;
            if (jComboBox != null && jComboBox.getUI() instanceof WindowsComboBoxUI) {
                windowsComboBoxUI = (WindowsComboBoxUI)jComboBox.getUI();
            }
            return windowsComboBoxUI;
        }
    };
    private boolean isRollover = false;
    private static final PropertyChangeListener componentOrientationListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JComboBox jComboBox;
            WindowsComboBoxUI windowsComboBoxUI;
            String string = propertyChangeEvent.getPropertyName();
            Object object = null;
            if ("componentOrientation" == string && (object = propertyChangeEvent.getSource()) instanceof JComboBox && ((JComboBox)object).getUI() instanceof WindowsComboBoxUI && (windowsComboBoxUI = (WindowsComboBoxUI)(jComboBox = (JComboBox)object).getUI()).arrowButton instanceof XPComboBoxButton) {
                ((XPComboBoxButton)windowsComboBoxUI.arrowButton).setPart(jComboBox.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? TMSchema.Part.CP_DROPDOWNBUTTONLEFT : TMSchema.Part.CP_DROPDOWNBUTTONRIGHT);
            }
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsComboBoxUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.isRollover = false;
        this.comboBox.setRequestFocusEnabled(true);
        if (XPStyle.getXP() != null && this.arrowButton != null) {
            this.comboBox.addMouseListener(rolloverListener);
            this.arrowButton.addMouseListener(rolloverListener);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.comboBox.removeMouseListener(rolloverListener);
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(rolloverListener);
        }
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null && xPStyle.isSkinDefined(this.comboBox, TMSchema.Part.CP_DROPDOWNBUTTONRIGHT)) {
            this.comboBox.addPropertyChangeListener("componentOrientation", componentOrientationListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener("componentOrientation", componentOrientationListener);
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (XPStyle.getXP() != null) {
            this.editor.addMouseListener(rolloverListener);
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        this.editor.removeMouseListener(rolloverListener);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (XPStyle.getXP() != null) {
            this.paintXPComboBoxBackground(graphics, jComponent);
        }
        super.paint(graphics, jComponent);
    }

    TMSchema.State getXPComboBoxState(JComponent jComponent) {
        TMSchema.State state = TMSchema.State.NORMAL;
        if (!jComponent.isEnabled()) {
            state = TMSchema.State.DISABLED;
        } else if (this.isPopupVisible(this.comboBox)) {
            state = TMSchema.State.PRESSED;
        } else if (this.isRollover) {
            state = TMSchema.State.HOT;
        }
        return state;
    }

    private void paintXPComboBoxBackground(Graphics graphics, JComponent jComponent) {
        XPStyle xPStyle = XPStyle.getXP();
        TMSchema.State state = this.getXPComboBoxState(jComponent);
        XPStyle.Skin skin = null;
        if (!this.comboBox.isEditable() && xPStyle.isSkinDefined(jComponent, TMSchema.Part.CP_READONLY)) {
            skin = xPStyle.getSkin(jComponent, TMSchema.Part.CP_READONLY);
        }
        if (skin == null) {
            skin = xPStyle.getSkin(jComponent, TMSchema.Part.CP_COMBOBOX);
        }
        skin.paintSkin(graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), state);
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            rectangle.x += 2;
            rectangle.y += 2;
            rectangle.width -= 4;
            rectangle.height -= 4;
        } else {
            ++rectangle.x;
            ++rectangle.y;
            rectangle.width -= 2;
            rectangle.height -= 2;
        }
        if (!this.comboBox.isEditable() && xPStyle != null && xPStyle.isSkinDefined(this.comboBox, TMSchema.Part.CP_READONLY)) {
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            Component component = bl && !this.isPopupVisible(this.comboBox) ? listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false) : listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setFont(this.comboBox.getFont());
            if (this.comboBox.isEnabled()) {
                component.setForeground(this.comboBox.getForeground());
                component.setBackground(this.comboBox.getBackground());
            } else {
                component.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
                component.setBackground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
            }
            boolean bl2 = false;
            if (component instanceof JPanel) {
                bl2 = true;
            }
            this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
        } else {
            super.paintCurrentValue(graphics, rectangle, bl);
        }
    }

    @Override
    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        if (XPStyle.getXP() == null) {
            super.paintCurrentValueBackground(graphics, rectangle, bl);
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        dimension.width = XPStyle.getXP() != null ? (dimension.width += 5) : (dimension.width += 4);
        dimension.height += 2;
        return dimension;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                if (XPStyle.getXP() != null && WindowsComboBoxUI.this.arrowButton != null) {
                    Dimension dimension = container.getSize();
                    Insets insets = WindowsComboBoxUI.this.getInsets();
                    int n = ((WindowsComboBoxUI)WindowsComboBoxUI.this).arrowButton.getPreferredSize().width;
                    WindowsComboBoxUI.this.arrowButton.setBounds(WindowsGraphicsUtils.isLeftToRight((JComboBox)container) ? dimension.width - insets.right - n : insets.left, insets.top, n, dimension.height - insets.top - insets.bottom);
                }
            }
        };
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    @Override
    protected ComboPopup createPopup() {
        return super.createPopup();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor();
    }

    @Override
    protected ListCellRenderer createRenderer() {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null && xPStyle.isSkinDefined(this.comboBox, TMSchema.Part.CP_READONLY)) {
            return new WindowsComboBoxRenderer();
        }
        return super.createRenderer();
    }

    @Override
    protected JButton createArrowButton() {
        if (XPStyle.getXP() != null) {
            return new XPComboBoxButton();
        }
        return super.createArrowButton();
    }

    private static class WindowsComboBoxRenderer
    extends BasicComboBoxRenderer.UIResource {
        private static final Object BORDER_KEY = new StringUIClientPropertyKey("BORDER_KEY");
        private static final Border NULL_BORDER = new EmptyBorder(0, 0, 0, 0);

        private WindowsComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                if (n == -1 && bl) {
                    Border border = jComponent.getBorder();
                    WindowsBorders.DashedBorder dashedBorder = new WindowsBorders.DashedBorder(jList.getForeground());
                    jComponent.setBorder(dashedBorder);
                    if (jComponent.getClientProperty(BORDER_KEY) == null) {
                        jComponent.putClientProperty(BORDER_KEY, border == null ? NULL_BORDER : border);
                    }
                } else if (jComponent.getBorder() instanceof WindowsBorders.DashedBorder) {
                    Object object2 = jComponent.getClientProperty(BORDER_KEY);
                    if (object2 instanceof Border) {
                        jComponent.setBorder(object2 == NULL_BORDER ? null : (Border)object2);
                    }
                    jComponent.putClientProperty(BORDER_KEY, null);
                }
                if (n == -1) {
                    jComponent.setOpaque(false);
                    jComponent.setForeground(jList.getForeground());
                } else {
                    jComponent.setOpaque(true);
                }
            }
            return component;
        }
    }

    public static class WindowsComboBoxEditor
    extends BasicComboBoxEditor.UIResource {
        @Override
        protected JTextField createEditorComponent() {
            JTextField jTextField = super.createEditorComponent();
            Border border = (Border)UIManager.get("ComboBox.editorBorder");
            if (border != null) {
                jTextField.setBorder(border);
            }
            jTextField.setOpaque(false);
            return jTextField;
        }

        @Override
        public void setItem(Object object) {
            super.setItem(object);
            if (this.editor.hasFocus()) {
                this.editor.selectAll();
            }
        }
    }

    @Deprecated
    protected class WindowsComboPopup
    extends BasicComboPopup {
        public WindowsComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        protected KeyListener createKeyListener() {
            return new InvocationKeyHandler();
        }

        protected class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            protected InvocationKeyHandler() {
                super(WindowsComboPopup.this);
            }
        }
    }

    private class XPComboBoxButton
    extends XPStyle.GlyphButton {
        public XPComboBoxButton() {
            super(null, !XPStyle.getXP().isSkinDefined(WindowsComboBoxUI.this.comboBox, TMSchema.Part.CP_DROPDOWNBUTTONRIGHT) ? TMSchema.Part.CP_DROPDOWNBUTTON : (WindowsComboBoxUI.this.comboBox.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? TMSchema.Part.CP_DROPDOWNBUTTONLEFT : TMSchema.Part.CP_DROPDOWNBUTTONRIGHT));
            this.setRequestFocusEnabled(false);
        }

        @Override
        protected TMSchema.State getState() {
            TMSchema.State state = super.getState();
            if (state != TMSchema.State.DISABLED && WindowsComboBoxUI.this.comboBox != null && !WindowsComboBoxUI.this.comboBox.isEditable() && XPStyle.getXP().isSkinDefined(WindowsComboBoxUI.this.comboBox, TMSchema.Part.CP_DROPDOWNBUTTONRIGHT)) {
                state = TMSchema.State.NORMAL;
            }
            return state;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(17, 21);
        }

        void setPart(TMSchema.Part part) {
            this.setPart(WindowsComboBoxUI.this.comboBox, part);
        }

        WindowsComboBoxUI getWindowsComboBoxUI() {
            return WindowsComboBoxUI.this;
        }
    }
}

