/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamSharedLibraryLoader;

public class SteamGameServerAPI {
    private static boolean isRunning = false;

    public static boolean init(int ip, short steamPort, short gamePort, short queryPort, ServerMode serverMode, String versionString) {
        return SteamGameServerAPI.init(null, ip, steamPort, gamePort, queryPort, serverMode, versionString);
    }

    public static boolean init(String pathToNativeLibraries, int ip, short steamPort, short gamePort, short queryPort, ServerMode serverMode, String versionString) {
        boolean fromJar = pathToNativeLibraries == null || pathToNativeLibraries.endsWith(".jar");
        isRunning = SteamSharedLibraryLoader.extractAndLoadLibraries(fromJar, pathToNativeLibraries);
        isRunning = isRunning && SteamGameServerAPI.nativeInit(ip, steamPort, gamePort, queryPort, serverMode.ordinal(), versionString);
        return isRunning;
    }

    public static void shutdown() {
        isRunning = false;
        SteamGameServerAPI.nativeShutdown();
    }

    public static SteamID getSteamID() {
        return new SteamID(SteamGameServerAPI.nativeGetSteamID());
    }

    private static native boolean nativeInit(int var0, short var1, short var2, short var3, int var4, String var5);

    private static native void nativeShutdown();

    public static native void runCallbacks();

    public static native boolean isSecure();

    private static native long nativeGetSteamID();

    static native long getSteamGameServerPointer();

    static native long getSteamGameServerNetworkingPointer();

    static native long getSteamGameServerStatsPointer();

    static native long getSteamGameServerHTTPPointer();

    public static enum ServerMode {
        Invalid,
        NoAuthentication,
        Authentication,
        AuthenticationAndSecure;

    }
}

