/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamAPICall;
import com.codedisaster.steamworks.SteamAuth;
import com.codedisaster.steamworks.SteamAuthTicket;
import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamGameServerAPI;
import com.codedisaster.steamworks.SteamGameServerCallback;
import com.codedisaster.steamworks.SteamGameServerCallbackAdapter;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamInterface;
import java.nio.Buffer;

public class SteamGameServer
extends SteamInterface {
    public SteamGameServer(SteamGameServerCallback callback) {
        super(SteamGameServerAPI.getSteamGameServerPointer(), SteamGameServer.createCallback(new SteamGameServerCallbackAdapter(callback)));
    }

    public void setProduct(String product) {
        SteamGameServer.setProduct(this.pointer, product);
    }

    public void setGameDescription(String gameDescription) {
        SteamGameServer.setGameDescription(this.pointer, gameDescription);
    }

    public void setModDir(String modDir) {
        SteamGameServer.setModDir(this.pointer, modDir);
    }

    public void setDedicatedServer(boolean dedicated) {
        SteamGameServer.setDedicatedServer(this.pointer, dedicated);
    }

    public void logOn(String token) {
        SteamGameServer.logOn(this.pointer, token);
    }

    public void logOnAnonymous() {
        SteamGameServer.logOnAnonymous(this.pointer);
    }

    public void logOff() {
        SteamGameServer.logOff(this.pointer);
    }

    public boolean isLoggedOn() {
        return SteamGameServer.isLoggedOn(this.pointer);
    }

    public boolean isSecure() {
        return SteamGameServer.isSecure(this.pointer);
    }

    public SteamID getSteamID() {
        return new SteamID(SteamGameServer.getSteamID(this.pointer));
    }

    public boolean wasRestartRequested() {
        return SteamGameServer.wasRestartRequested(this.pointer);
    }

    public void setMaxPlayerCount(int playersMax) {
        SteamGameServer.setMaxPlayerCount(this.pointer, playersMax);
    }

    public void setBotPlayerCount(int botplayers) {
        SteamGameServer.setBotPlayerCount(this.pointer, botplayers);
    }

    public void setServerName(String serverName) {
        SteamGameServer.setServerName(this.pointer, serverName);
    }

    public void setMapName(String mapName) {
        SteamGameServer.setMapName(this.pointer, mapName);
    }

    public void setPasswordProtected(boolean passwordProtected) {
        SteamGameServer.setPasswordProtected(this.pointer, passwordProtected);
    }

    public void setSpectatorPort(short spectatorPort) {
        SteamGameServer.setSpectatorPort(this.pointer, spectatorPort);
    }

    public void setSpectatorServerName(String spectatorServerName) {
        SteamGameServer.setSpectatorServerName(this.pointer, spectatorServerName);
    }

    public void clearAllKeyValues() {
        SteamGameServer.clearAllKeyValues(this.pointer);
    }

    public void setKeyValue(String key, String value) {
        SteamGameServer.setKeyValue(this.pointer, key, value);
    }

    public void setGameTags(String gameTags) {
        SteamGameServer.setGameTags(this.pointer, gameTags);
    }

    public void setGameData(String gameData) {
        SteamGameServer.setGameData(this.pointer, gameData);
    }

    public void setRegion(String region) {
        SteamGameServer.setRegion(this.pointer, region);
    }

    public SteamID sendUserConnectAndAuthenticate(int clientIP, Buffer authBlob, int authBlobSize, SteamID steamIDUser) {
        long[] ids = new long[1];
        if (SteamGameServer.sendUserConnectAndAuthenticate(this.pointer, clientIP, authBlob, authBlobSize, ids)) {
            return new SteamID(ids[0]);
        }
        return null;
    }

    public SteamID createUnauthenticatedUserConnection() {
        return new SteamID(SteamGameServer.createUnauthenticatedUserConnection(this.pointer));
    }

    public void sendUserDisconnect(SteamID steamIDUser) {
        SteamGameServer.sendUserDisconnect(this.pointer, steamIDUser.handle);
    }

    public boolean updateUserData(SteamID steamIDUser, String playerName, int score) {
        return SteamGameServer.updateUserData(this.pointer, steamIDUser.handle, playerName, score);
    }

    public SteamAuthTicket getAuthSessionTicket(Buffer authTicket, int[] sizeInBytes) throws SteamException {
        if (!authTicket.isDirect()) {
            throw new SteamException("Direct buffer required!");
        }
        int ticket = SteamGameServer.getAuthSessionTicket(this.pointer, authTicket, authTicket.capacity(), sizeInBytes);
        if ((long)ticket != 0L) {
            authTicket.limit(sizeInBytes[0]);
        }
        return new SteamAuthTicket(ticket);
    }

    public SteamAuth.BeginAuthSessionResult beginAuthSession(Buffer authTicket, SteamID steamID) throws SteamException {
        if (!authTicket.isDirect()) {
            throw new SteamException("Direct buffer required!");
        }
        int result = SteamGameServer.beginAuthSession(this.pointer, authTicket, authTicket.limit(), steamID.handle);
        return SteamAuth.BeginAuthSessionResult.byOrdinal(result);
    }

    public void endAuthSession(SteamID steamID) {
        SteamGameServer.endAuthSession(this.pointer, steamID.handle);
    }

    public void cancelAuthTicket(SteamAuthTicket authTicket) {
        SteamGameServer.cancelAuthTicket(this.pointer, (int)authTicket.handle);
    }

    public SteamAuth.UserHasLicenseForAppResult userHasLicenseForApp(SteamID steamID, long appID) {
        return SteamAuth.UserHasLicenseForAppResult.byOrdinal(SteamGameServer.userHasLicenseForApp(this.pointer, steamID.handle, appID));
    }

    public boolean requestUserGroupStatus(SteamID steamIDUser, SteamID steamIDGroup) {
        return SteamGameServer.requestUserGroupStatus(this.pointer, steamIDUser.handle, steamIDGroup.handle);
    }

    public int getPublicIP() {
        return SteamGameServer.getPublicIP(this.pointer);
    }

    public boolean handleIncomingPacket(Buffer data, int srcIP, short srcPort) {
        return SteamGameServer.handleIncomingPacket(this.pointer, data, data.limit(), srcIP, srcPort);
    }

    public int getNextOutgoingPacket(Buffer out, int[] netAdr, short[] port) {
        return SteamGameServer.getNextOutgoingPacket(this.pointer, out, out.capacity(), netAdr, port);
    }

    public void enableHeartbeats(boolean active) {
        SteamGameServer.enableHeartbeats(this.pointer, active);
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        SteamGameServer.setHeartbeatInterval(this.pointer, heartbeatInterval);
    }

    public void forceHeartbeat() {
        SteamGameServer.forceHeartbeat(this.pointer);
    }

    public SteamAPICall associateWithClan(SteamID steamIDClan) {
        return new SteamAPICall(SteamGameServer.associateWithClan(this.pointer, steamIDClan.handle));
    }

    public SteamAPICall computeNewPlayerCompatibility(SteamID steamIDNewPlayer) {
        return new SteamAPICall(SteamGameServer.computeNewPlayerCompatibility(this.pointer, steamIDNewPlayer.handle));
    }

    private static native long createCallback(SteamGameServerCallbackAdapter var0);

    private static native void setProduct(long var0, String var2);

    private static native void setGameDescription(long var0, String var2);

    private static native void setModDir(long var0, String var2);

    private static native void setDedicatedServer(long var0, boolean var2);

    private static native void logOn(long var0, String var2);

    private static native void logOnAnonymous(long var0);

    private static native void logOff(long var0);

    private static native boolean isLoggedOn(long var0);

    private static native boolean isSecure(long var0);

    private static native long getSteamID(long var0);

    private static native boolean wasRestartRequested(long var0);

    private static native void setMaxPlayerCount(long var0, int var2);

    private static native void setBotPlayerCount(long var0, int var2);

    private static native void setServerName(long var0, String var2);

    private static native void setMapName(long var0, String var2);

    private static native void setPasswordProtected(long var0, boolean var2);

    private static native void setSpectatorPort(long var0, short var2);

    private static native void setSpectatorServerName(long var0, String var2);

    private static native void clearAllKeyValues(long var0);

    private static native void setKeyValue(long var0, String var2, String var3);

    private static native void setGameTags(long var0, String var2);

    private static native void setGameData(long var0, String var2);

    private static native void setRegion(long var0, String var2);

    private static native boolean sendUserConnectAndAuthenticate(long var0, int var2, Buffer var3, int var4, long[] var5);

    private static native long createUnauthenticatedUserConnection(long var0);

    private static native void sendUserDisconnect(long var0, long var2);

    private static native boolean updateUserData(long var0, long var2, String var4, int var5);

    private static native int getAuthSessionTicket(long var0, Buffer var2, int var3, int[] var4);

    private static native int beginAuthSession(long var0, Buffer var2, int var3, long var4);

    private static native void endAuthSession(long var0, long var2);

    private static native void cancelAuthTicket(long var0, int var2);

    private static native int userHasLicenseForApp(long var0, long var2, long var4);

    private static native boolean requestUserGroupStatus(long var0, long var2, long var4);

    private static native int getPublicIP(long var0);

    private static native boolean handleIncomingPacket(long var0, Buffer var2, int var3, int var4, short var5);

    private static native int getNextOutgoingPacket(long var0, Buffer var2, int var3, int[] var4, short[] var5);

    private static native void enableHeartbeats(long var0, boolean var2);

    private static native void setHeartbeatInterval(long var0, int var2);

    private static native void forceHeartbeat(long var0);

    private static native long associateWithClan(long var0, long var2);

    private static native long computeNewPlayerCompatibility(long var0, long var2);

    public static enum DenyReason {
        Invalid,
        InvalidVersion,
        Generic,
        NotLoggedOn,
        NoLicense,
        Cheater,
        LoggedInElseWhere,
        UnknownText,
        IncompatibleAnticheat,
        MemoryCorruption,
        IncompatibleSoftware,
        SteamConnectionLost,
        SteamConnectionError,
        SteamResponseTimedOut,
        SteamValidationStalled,
        SteamOwnerLeftGuestUser;

        private static final DenyReason[] values;

        static DenyReason byOrdinal(int denyReason) {
            return values[denyReason];
        }

        static {
            values = DenyReason.values();
        }
    }
}

