/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamSharedLibraryLoader;

public class SteamAPI {
    private static boolean isRunning = false;

    public static boolean init() {
        return SteamAPI.init(null);
    }

    public static boolean init(String pathToNativeLibraries) {
        boolean fromJar = pathToNativeLibraries == null || pathToNativeLibraries.endsWith(".jar");
        isRunning = SteamSharedLibraryLoader.extractAndLoadLibraries(fromJar, pathToNativeLibraries);
        isRunning = isRunning && SteamAPI.nativeInit();
        return isRunning;
    }

    public static void shutdown() {
        isRunning = false;
        SteamAPI.nativeShutdown();
    }

    public static boolean isSteamRunning() {
        return isRunning && SteamAPI.isSteamRunningNative();
    }

    public static native boolean restartAppIfNecessary(long var0);

    private static native boolean nativeInit();

    private static native void nativeShutdown();

    public static native void runCallbacks();

    private static native boolean isSteamRunningNative();

    static native long getSteamAppsPointer();

    static native long getSteamFriendsPointer();

    static native long getSteamMatchmakingPointer();

    static native long getSteamNetworkingPointer();

    static native long getSteamRemoteStoragePointer();

    static native long getSteamHTTPPointer();

    static native long getSteamUGCPointer();

    static native long getSteamUserPointer();

    static native long getSteamUserStatsPointer();

    static native long getSteamUtilsPointer();
}

