/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CityName;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.CombatInfo;
import com.zarkonnen.airships.CombatSpeed;
import com.zarkonnen.airships.Compression;
import com.zarkonnen.airships.ConstructionStrategy;
import com.zarkonnen.airships.DifficultyLevel;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.FleetOwner;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MapSize;
import com.zarkonnen.airships.MonsterNest;
import com.zarkonnen.airships.MonsterNestType;
import com.zarkonnen.airships.MonsterSetting;
import com.zarkonnen.airships.Perlin;
import com.zarkonnen.airships.Recording;
import com.zarkonnen.airships.ResearchSpeed;
import com.zarkonnen.airships.Road;
import com.zarkonnen.airships.SeaLevelSetting;
import com.zarkonnen.airships.SecretPoliceLevel;
import com.zarkonnen.airships.ShapeUtils;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.SpyActionResult;
import com.zarkonnen.airships.StrategicAI;
import com.zarkonnen.airships.StrategicPlayerInfo;
import com.zarkonnen.airships.StrategicSetupInfo;
import com.zarkonnen.airships.TakeoverMethod;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.TechSpeedSetting;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;
import org.newdawn.slick.Color;

public strictfp class WorldMap
implements JSONAble {
    public static final int SCALE_FACTOR = 8;
    public static final byte INFINITY = 127;
    public static final byte MAX_BYTE = 126;
    public static final double BUILDING_MULT = 0.6;
    public static final int QUICK_RESOLVE_DMG_DIV = 4;
    public static final int MIN_CITY_DIST = 25;
    public static final int MIN_NEST_DIST = 7;
    public static final int MIN_TOWN_DIST = 7;
    public final AirshipGame g;
    public int fleetIDCounter = 1;
    public Random r;
    public ArrayList<Empire> empires = new ArrayList();
    public int smartEmpireIndex = 0;
    public ArrayList<MonsterNest> nests = new ArrayList();
    public int smartNestIndex = 0;
    public boolean[][] water;
    public int[][] cityOwnership;
    public ArrayList<Road> roads = new ArrayList();
    public ArrayList<TerrainFeature> features = new ArrayList();
    public boolean villainDesignated;
    public int age;
    public int timeUntilMergePossible = 700000;
    public DifficultyLevel difficulty;
    public ArrayList<ShapeUtils.Area> landBoundaries;
    public ArrayList<ShapeUtils.Area> cityOwnershipAreas;
    public Locale lang;
    public final TechSpeedSetting techSpeed;
    public final MonsterSetting monsterity;
    public int timeSinceAIAttackVsHuman = 0;
    public boolean strategicRapidCommands;
    public transient SeaLevelSetting seaLevelSetting;
    public transient int startingTechTier;
    public transient int[] cityNestsCount;
    public transient double[][] height;
    public transient double[][] resistance;
    public transient byte[][][] approxCityDist;
    public transient ArrayList<NavNode> navNodes = new ArrayList();
    public transient ArrayList<MapLocation[]> locPairs;
    public transient List<StrategicSetupInfo> setupInfos;
    public transient ArrayList<String> setupCityNames;
    public transient MergerInfo merger;
    private transient MapSize size;
    private transient int stageIndex = 0;
    private transient int offset;
    public transient CampaignWorld campaignWorldDuringGen;
    private transient byte[][] connectedCache;
    private final SetupStage[] setupStages = new SetupStage[]{new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Generating_landscape", new Object[0]);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void run(int index, WorldMap wm) {
            int i;
            int y;
            int x;
            WorldMap.this.height = WorldMap.this.genGrid(WorldMap.this.r, WorldMap.this.size);
            Perlin perlin = new Perlin(WorldMap.this.r);
            WorldMap.this.resistance = new double[((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
            WorldMap.this.approxCityDist = new byte[((WorldMap)WorldMap.this).size.empires * (1 + ((WorldMap)WorldMap.this).size.townsPerEmpire)][((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
            for (int y2 = 0; y2 < ((WorldMap)WorldMap.this).size.gridSize; ++y2) {
                for (x = 0; x < ((WorldMap)WorldMap.this).size.gridSize; ++x) {
                    if (WorldMap.this.water[y2][x]) {
                        WorldMap.this.resistance[y2][x] = 10000.0;
                        continue;
                    }
                    WorldMap.this.resistance[y2][x] = perlin.pnoise((double)x * 0.03 * 8.0 + 988.0, (double)y2 * 0.023 * 8.0 - 2.0, -908.3) * 2.0 + perlin.pnoise((double)x * 0.09 * 8.0 + 2399.0, (double)y2 * 0.123 * 16.0 + 2.0, -33.3) + 3.0;
                    int waterCount = 0;
                    for (int dy = -WorldMap.scaled(7); dy < WorldMap.scaled(7) + 1; ++dy) {
                        for (int dx = -WorldMap.scaled(7); dx < WorldMap.scaled(7) + 1; ++dx) {
                            int yy = y2 + dy;
                            int xx = x + dx;
                            if (yy < 0 || yy >= WorldMap.this.water.length || xx < 0 || xx >= WorldMap.this.water[0].length || !WorldMap.this.water[yy][xx]) continue;
                            ++waterCount;
                        }
                    }
                    WorldMap.this.resistance[y2][x] = StrictMath.max(0.2, WorldMap.this.resistance[y2][x] - (double)waterCount * 0.04);
                    int borderDist = StrictMath.max(0, 10 - x) + StrictMath.max(0, x - ((WorldMap)WorldMap.this).size.gridSize + 10) + StrictMath.max(0, 10 - y2) + StrictMath.max(0, y2 - ((WorldMap)WorldMap.this).size.gridSize + 10);
                    double[] dArray = WorldMap.this.resistance[y2];
                    int n = x;
                    dArray[n] = dArray[n] + (double)borderDist * 0.3;
                }
            }
            for (int n = 0; n < ((WorldMap)WorldMap.this).size.gridSize * ((WorldMap)WorldMap.this).size.gridSize / 1500; ++n) {
                x = WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize);
                y = WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize);
                WorldMap.this.blitBlob(WorldMap.this.resistance, x, y, 1 + WorldMap.this.r.nextInt(WorldMap.scaled(30)), 5);
            }
            for (i = 0; i < ((WorldMap)WorldMap.this).size.gridSize * ((WorldMap)WorldMap.this).size.gridSize / 100; ++i) {
                x = WorldMap.scaled(20) + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - WorldMap.scaled(40));
                y = WorldMap.scaled(20) + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - WorldMap.scaled(40));
                if (!(WorldMap.this.height[y][x] > 1.25)) continue;
                WorldMap.this.features.add(new TerrainFeature(TerrainFeatureType.MOUNTAIN, x, y));
                WorldMap.this.blitBlob(WorldMap.this.resistance, x, y, WorldMap.scaled(40), 6);
            }
            for (i = 0; i < ((WorldMap)WorldMap.this).size.gridSize * ((WorldMap)WorldMap.this).size.gridSize / 10; ++i) {
                x = WorldMap.scaled(20) + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - WorldMap.scaled(40));
                y = WorldMap.scaled(20) + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - WorldMap.scaled(40));
                if (WorldMap.this.water[y][x] || !(perlin.pnoise((double)x * 0.01 * 8.0 - 88.0, (double)y * 0.01 * 8.0 + 9018.0, 555.0) > 0.25)) continue;
                WorldMap.this.features.add(new TerrainFeature(TerrainFeatureType.FOREST, x, y));
                WorldMap.this.blitBlob(WorldMap.this.resistance, x, y, WorldMap.scaled(30), 3);
            }
            for (i = 0; i < ((WorldMap)WorldMap.this).size.gridSize * ((WorldMap)WorldMap.this).size.gridSize / 10; ++i) {
                x = WorldMap.scaled(20) + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - WorldMap.scaled(40));
                y = WorldMap.scaled(20) + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - WorldMap.scaled(40));
                if (WorldMap.this.water[y][x] || WorldMap.this.water[y + 1][x + 1] || !(perlin.pnoise((double)y * 0.03 * 8.0 - 557.0, (double)x * 0.005 * 8.0 + 888.0, 222.0) > 0.3)) continue;
                WorldMap.this.features.add(new TerrainFeature(TerrainFeatureType.SWAMP, x, y));
                WorldMap.this.blitBlob(WorldMap.this.resistance, x, y, WorldMap.scaled(30), 3);
            }
            for (i = 0; i < ((WorldMap)WorldMap.this).size.gridSize * ((WorldMap)WorldMap.this).size.gridSize / 5000; ++i) {
                x = WorldMap.scaled(50) + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - WorldMap.scaled(100));
                y = WorldMap.scaled(50) + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - WorldMap.scaled(100));
                if (!WorldMap.this.water[y][x] || !WorldMap.this.water[y + WorldMap.scaled(16)][x + WorldMap.scaled(16)]) continue;
                WorldMap.this.features.add(new TerrainFeature(TerrainFeatureType.SEA_CREATURES, x, y));
            }
            WorldMap.this.offset = WorldMap.this.r.nextInt(Loadable.all(CityName.class).size());
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Placing_city_x_y", index + 1, ((WorldMap)WorldMap.this).size.empires);
        }

        @Override
        public int getSize() {
            return ((WorldMap)WorldMap.this).size.empires;
        }

        @Override
        public void run(int index, WorldMap wm) {
            Utils.Pair p = WorldMap.this.findMapLocationSpot(WorldMap.this.r, 25, null);
            if (WorldMap.this.setupCityNames == null) {
                WorldMap.this.setupCityNames = new ArrayList();
                for (CityName cn : Loadable.all(CityName.class)) {
                    WorldMap.this.setupCityNames.add(cn.name);
                }
                for (StrategicSetupInfo ssi : WorldMap.this.setupInfos) {
                    WorldMap.this.setupCityNames.remove(ssi.empireName);
                }
                Collections.shuffle(WorldMap.this.setupCityNames, WorldMap.this.r);
            }
            CoatOfArms arms = index < WorldMap.this.setupInfos.size() ? WorldMap.this.setupInfos.get(index).getArms() : CoatOfArms.getRandom(WorldMap.this.r, HeraldicStyle.ofName("city"));
            ArrayList<ConstructionStrategy> cs = ConstructionStrategy.forCharge(arms.getActiveCharge(), WorldMap.this.difficulty);
            Empire emp = new Empire(index + 1, index < WorldMap.this.setupInfos.size() ? WorldMap.this.setupInfos.get((int)index).empireName : WorldMap.this.setupCityNames.get((index + WorldMap.this.offset) % WorldMap.this.setupCityNames.size()), arms, index < WorldMap.this.setupInfos.size() ? WorldMap.this.setupInfos.get((int)index).playerName : null, arms.getBonus(), 400 + WorldMap.this.startingTechTier * 400, 0.4 + WorldMap.this.r.nextDouble() * 0.9, TakeoverMethod.values()[WorldMap.this.r.nextInt(TakeoverMethod.values().length)], cs.get(WorldMap.this.r.nextInt(cs.size())));
            emp.warConsiderDelay = WorldMap.this.difficulty.attackInterval / 2 + WorldMap.this.r.nextInt(WorldMap.this.difficulty.attackInterval / 2 + 1);
            if (index < WorldMap.this.setupInfos.size() && WorldMap.this.setupInfos.get((int)index).strategicPlayerInfo != null) {
                WorldMap.this.setupInfos.get((int)index).strategicPlayerInfo.empire = emp;
            }
            for (Tech t : Loadable.all(Tech.class)) {
                Tech.Choice c;
                if (t.tier > WorldMap.this.startingTechTier || !t.visible(emp) || emp.techs.contains(c = t.choices.get(0))) continue;
                emp.techs.add(c);
                emp.bonuses.addAll(c.bonuses);
            }
            if (arms.getTech() != null) {
                for (Tech.Choice c : arms.getTech().getAllPrerequisitesIncludingThis()) {
                    if (emp.techs.contains(c)) continue;
                    emp.techs.add(c);
                    emp.bonuses.addAll(c.bonuses);
                    break;
                }
            }
            boolean bl = emp.playerControlled = index < WorldMap.this.setupInfos.size();
            if (!emp.playerControlled) {
                for (int i = 0; i < WorldMap.this.difficulty.extraAIStartingTechs; ++i) {
                    Tech.Choice extra = StrategicAI.getScienceOption(emp, emp.constructionStrategy.techs);
                    if (extra == null) continue;
                    emp.techs.add(extra);
                    emp.bonuses.addAll(extra.bonuses);
                }
                ArrayList<ResearchSpeed> speeds = Loadable.all(ResearchSpeed.class);
                emp.researchSpeed = speeds.get(WorldMap.this.r.nextInt(speeds.size()));
            }
            City city = new City(WorldMap.this.empires.size(), (Integer)p.a, (Integer)p.b, emp.name, false, 1, 1, emp.arms, WorldMap.this.r.nextInt(10));
            city.originalEmpire = emp;
            city.income = WorldMap.this.income(emp.playerControlled, city, WorldMap.this.r);
            city.shipyardLevel = WorldMap.this.shipyardLevel(emp.playerControlled, city);
            city.generateLand(WorldMap.this.r, WorldMap.this.getBackground(city.x, city.y));
            emp.policeLevel = emp.playerControlled ? SecretPoliceLevel.LAX : SecretPoliceLevel.values()[WorldMap.this.r.nextInt(SecretPoliceLevel.values().length)];
            emp.money = WorldMap.this.money(emp.playerControlled, city, WorldMap.this.r) + WorldMap.this.startingTechTier * 500;
            emp.cities.add(city);
            WorldMap.this.empires.add(emp);
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Placing_town_x_y", index + 1, ((WorldMap)WorldMap.this).size.empires * ((WorldMap)WorldMap.this).size.townsPerEmpire);
        }

        @Override
        public int getSize() {
            return ((WorldMap)WorldMap.this).size.empires * ((WorldMap)WorldMap.this).size.townsPerEmpire;
        }

        @Override
        public void run(int index, WorldMap wm) {
            int empIndex = index % ((WorldMap)WorldMap.this).size.empires;
            Empire emp = WorldMap.this.empires.get(empIndex);
            Utils.Pair p = WorldMap.this.findMapLocationSpot(WorldMap.this.r, 7, emp);
            if (p == null) {
                return;
            }
            City town = new City(WorldMap.this.empires.size() + index, (Integer)p.a, (Integer)p.b, WorldMap.this.setupCityNames.get((index + WorldMap.this.offset + WorldMap.this.empires.size()) % WorldMap.this.setupCityNames.size()), true, 1, 1, CoatOfArms.getRandom(WorldMap.this.r, HeraldicStyle.ofName("city")), WorldMap.this.r.nextInt(6));
            town.originalEmpire = emp;
            town.income = WorldMap.this.townIncome(emp.playerControlled, town, WorldMap.this.r);
            town.shipyardLevel = 1;
            town.generateLand(WorldMap.this.r, WorldMap.this.getBackground(town.x, town.y));
            emp.cities.add(town);
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Claiming_land_x_y", index + 1, ((WorldMap)WorldMap.this).size.empires * (1 + ((WorldMap)WorldMap.this).size.townsPerEmpire));
        }

        @Override
        public int getSize() {
            return ((WorldMap)WorldMap.this).size.empires * (1 + ((WorldMap)WorldMap.this).size.townsPerEmpire);
        }

        @Override
        public void run(int index, WorldMap wm) {
            double[][] dists = WorldMap.this.calcLocationDistances(index, null);
            if (dists == null) {
                return;
            }
            for (int y = 0; y < ((WorldMap)WorldMap.this).size.gridSize; ++y) {
                for (int x = 0; x < ((WorldMap)WorldMap.this).size.gridSize; ++x) {
                    int value;
                    double d = dists[y][x];
                    WorldMap.this.approxCityDist[index][y][x] = value = (byte)(d == Double.MAX_VALUE ? 127 : (byte)StrictMath.min(126, (int)(d * 126.0 / 375.0)));
                }
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Drawing_borders", new Object[0]);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void run(int index, WorldMap wm) {
            for (Empire emp : WorldMap.this.empires) {
                if (emp.playerControlled) {
                    emp.money += WorldMap.this.difficulty.playerExtraMoney;
                    StrategicAI.setup(wm, emp, WorldMap.this.r, WorldMap.this.difficulty.startingShip);
                    emp.money = StrictMath.max(emp.money, 0) + WorldMap.this.difficulty.playerFinalCash;
                } else {
                    emp.money += WorldMap.this.difficulty.aiExtraMoney;
                    StrategicAI.setup(wm, emp, WorldMap.this.r, true);
                    emp.money = StrictMath.max(emp.money, 100);
                }
                if (emp.incomeBalance(wm) < 25) {
                    for (City c : emp.cities) {
                        c.income += 9;
                    }
                }
                for (City c : emp.cities) {
                    c.nestsInTerritory = null;
                }
            }
            WorldMap.this.cityOwnership = new int[((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
            for (int y = 0; y < ((WorldMap)WorldMap.this).size.gridSize; ++y) {
                for (int x = 0; x < ((WorldMap)WorldMap.this).size.gridSize; ++x) {
                    double maxInfluence = -1.0;
                    WorldMap.this.cityOwnership[y][x] = -1;
                    for (Empire e : WorldMap.this.empires) {
                        for (City c : e.cities) {
                            if (WorldMap.this.approxCityDist[c.id][y][x] >= 127) continue;
                            int n = c.income;
                            int n2 = c.isTown ? 3 : 1;
                            double influence = (double)StrictMath.min(40, n * n2) / (0.1 + (double)WorldMap.this.approxCityDist[c.id][y][x]);
                            if (!(influence > maxInfluence)) continue;
                            WorldMap.this.cityOwnership[y][x] = c.id;
                            maxInfluence = influence;
                        }
                    }
                }
            }
            LinkedList<int[]> q = new LinkedList<int[]>();
            for (Empire e : WorldMap.this.empires) {
                boolean[][] connectedCityOwnership = new boolean[((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
                for (City c : e.cities) {
                    int x;
                    connectedCityOwnership[c.y][c.x] = true;
                    WorldMap.this.cityOwnership[c.y][c.x] = c.id;
                    q.add(new int[]{c.x, c.y});
                    while (!q.isEmpty()) {
                        int[] xy = (int[])q.pollFirst();
                        x = xy[0];
                        int y = xy[1];
                        if (x - 1 > 0 && WorldMap.this.cityOwnership[y][x - 1] == c.id && !connectedCityOwnership[y][x - 1] && !WorldMap.this.water[y][x - 1]) {
                            connectedCityOwnership[y][x - 1] = true;
                            q.add(new int[]{x - 1, y});
                        }
                        if (x + 1 < WorldMap.this.cityOwnership[0].length && WorldMap.this.cityOwnership[y][x + 1] == c.id && !connectedCityOwnership[y][x + 1] && !WorldMap.this.water[y][x + 1]) {
                            connectedCityOwnership[y][x + 1] = true;
                            q.add(new int[]{x + 1, y});
                        }
                        if (y - 1 > 0 && WorldMap.this.cityOwnership[y - 1][x] == c.id && !connectedCityOwnership[y - 1][x] && !WorldMap.this.water[y - 1][x]) {
                            connectedCityOwnership[y - 1][x] = true;
                            q.add(new int[]{x, y - 1});
                        }
                        if (y + 1 >= WorldMap.this.cityOwnership.length || WorldMap.this.cityOwnership[y + 1][x] != c.id || connectedCityOwnership[y + 1][x] || WorldMap.this.water[y + 1][x]) continue;
                        connectedCityOwnership[y + 1][x] = true;
                        q.add(new int[]{x, y + 1});
                    }
                    for (int y = 0; y < WorldMap.this.cityOwnership.length; ++y) {
                        for (x = 0; x < WorldMap.this.cityOwnership[0].length; ++x) {
                            if (connectedCityOwnership[y][x] || WorldMap.this.cityOwnership[y][x] != c.id) continue;
                            WorldMap.this.cityOwnership[y][x] = -1;
                        }
                    }
                }
            }
            Utils.Pair<ArrayList<ShapeUtils.Area>, ArrayList<ShapeUtils.Area>> areas = ShapeUtils.allAreas(WorldMap.this.water, WorldMap.this.cityOwnership);
            WorldMap.this.landBoundaries = (ArrayList)areas.a;
            WorldMap.this.cityOwnershipAreas = (ArrayList)areas.b;
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Spawning_monsters_x_y", index + 1, this.getSize());
        }

        @Override
        public int getSize() {
            return ((WorldMap)WorldMap.this).size.nests;
        }

        @Override
        public void run(int index, WorldMap wm) {
            int owner;
            if (WorldMap.this.cityNestsCount == null) {
                WorldMap.this.cityNestsCount = new int[((WorldMap)WorldMap.this).size.empires * (1 + ((WorldMap)WorldMap.this).size.townsPerEmpire)];
            }
            Utils.Pair p = null;
            int attempt = 0;
            while ((p = WorldMap.this.findMapLocationSpot(WorldMap.this.r, 7, null)) != null && (owner = WorldMap.this.cityOwnership[(Integer)p.b][(Integer)p.a]) != -1) {
                if (WorldMap.this.cityNestsCount[owner] > ((WorldMap)WorldMap.this).size.nests / ((WorldMap)WorldMap.this).size.empires) {
                    if (++attempt <= 30) continue;
                    int i = 0;
                    while (i < ((WorldMap)WorldMap.this).size.empires) {
                        int n = i++;
                        WorldMap.this.cityNestsCount[n] = WorldMap.this.cityNestsCount[n] - 1;
                    }
                    attempt -= 30;
                    continue;
                }
                int n = owner;
                WorldMap.this.cityNestsCount[n] = WorldMap.this.cityNestsCount[n] + 1;
                break;
            }
            if (p != null) {
                MonsterNest nest = new MonsterNest(WorldMap.this.empires.size() * (((WorldMap)WorldMap.this).size.townsPerEmpire + 1) + WorldMap.this.nests.size(), (Integer)p.a, (Integer)p.b);
                nest.generateLand(WorldMap.this.r, WorldMap.this.getBackground(nest.x, nest.y));
                WorldMap.this.nests.add(nest);
            }
            if (index == ((WorldMap)WorldMap.this).size.nests - 1) {
                HashMap borderings = WorldMap.this.determineBorders();
                ArrayList borderingKeys = new ArrayList(borderings.keySet());
                Collections.sort(borderingKeys, new Comparator<City>(){

                    @Override
                    public int compare(City o1, City o2) {
                        return o1.id - o2.id;
                    }
                });
                block2: for (Empire e : WorldMap.this.empires) {
                    if (e.playerControlled) continue;
                    block3: for (int x = 0; x < 50; ++x) {
                        Color c = e.arms.getMixedColor();
                        for (Empire e2 : WorldMap.this.empires) {
                            Color c2 = e2.arms.getMixedColor();
                            if (c2.r != c.r || c2.g != c.g || c2.b != c.b) continue;
                            e.arms = CoatOfArms.getRandom(WorldMap.this.r, HeraldicStyle.ofName("city"));
                            continue block3;
                        }
                        continue block2;
                    }
                }
                WorldMap.this.locPairs = new ArrayList();
                for (City c1 : borderingKeys) {
                    for (City c2 : (ArrayList)borderings.get(c1)) {
                        if (c2.x <= c1.x && (c2.x != c1.x || c2.y <= c1.y)) continue;
                        WorldMap.this.locPairs.add(new MapLocation[]{c1, c2});
                    }
                }
                for (Empire e : WorldMap.this.empires) {
                    for (City c1 : e.cities) {
                        for (MonsterNest n : WorldMap.this.nests) {
                            if (WorldMap.this.cityOwnership[n.y][n.x] != c1.id) continue;
                            if (n.x > c1.x || n.x == c1.x && n.y > c1.y) {
                                WorldMap.this.locPairs.add(new MapLocation[]{c1, n});
                            } else {
                                WorldMap.this.locPairs.add(new MapLocation[]{n, c1});
                            }
                            if (!borderings.containsKey(c1)) continue;
                            for (City c2 : (ArrayList)borderings.get(c1)) {
                                if (n.x > c2.x || n.x == c2.x && n.y > c2.y) {
                                    WorldMap.this.locPairs.add(new MapLocation[]{c2, n});
                                    continue;
                                }
                                WorldMap.this.locPairs.add(new MapLocation[]{n, c2});
                            }
                        }
                    }
                }
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Building_road_x_y", index + 1, this.getSize());
        }

        @Override
        public int getSize() {
            return WorldMap.this.locPairs == null ? ((WorldMap)WorldMap.this).size.empires * (((WorldMap)WorldMap.this).size.townsPerEmpire + 1) * 3 + ((WorldMap)WorldMap.this).size.nests : WorldMap.this.locPairs.size();
        }

        @Override
        public void run(int index, WorldMap wm) {
            int bestDy;
            int bestDx;
            int roadY;
            WorldMap.this.approxCityDist = null;
            if (index == 0) {
                for (int y = 0; y < ((WorldMap)WorldMap.this).size.gridSize; ++y) {
                    for (int x = 0; x < ((WorldMap)WorldMap.this).size.gridSize; ++x) {
                        if (WorldMap.this.water[y][x]) continue;
                        int waterCount = 0;
                        for (int dy = -WorldMap.scaled(7); dy < WorldMap.scaled(7) + 1; ++dy) {
                            for (int dx = -WorldMap.scaled(7); dx < WorldMap.scaled(7) + 1; ++dx) {
                                int yy = y + dy;
                                int xx = x + dx;
                                if (yy < 0 || yy >= WorldMap.this.water.length || xx < 0 || xx >= WorldMap.this.water[0].length || !WorldMap.this.water[yy][xx]) continue;
                                ++waterCount;
                            }
                        }
                        double[] dArray = WorldMap.this.resistance[y];
                        int n = x;
                        dArray[n] = dArray[n] + (double)waterCount * 0.09;
                    }
                }
                Collections.sort(WorldMap.this.locPairs, new LocPairDistCmp());
            }
            MapLocation[] cs = WorldMap.this.locPairs.get(index);
            MapLocation c1 = cs[0];
            MapLocation c2 = cs[1];
            Road road = new Road(c1, c2);
            int roadX = c1.x;
            double[][] dist = WorldMap.this.calcLocationDistances(c2.id, new int[]{WorldMap.this.cityOwnership[c1.y][c1.x], WorldMap.this.cityOwnership[c2.y][c2.x]});
            if (dist[roadY][roadX] == Double.MAX_VALUE) {
                System.out.println("Cities too far apart.");
                return;
            }
            for (roadY = c1.y; roadX != c2.x || roadY != c2.y; roadX += bestDx, roadY += bestDy) {
                WorldMap.this.resistance[roadY][roadX] = 0.01;
                road.intPath.add(new int[]{roadX, roadY});
                road.path.add(new ShapeUtils.P(roadX, roadY));
                bestDy = 0;
                bestDx = 0;
                double lowestDist = dist[roadY][roadX];
                for (int dy = -1; dy < 2; ++dy) {
                    for (int dx = -1; dx < 2; ++dx) {
                        int xx = roadX + dx;
                        int yy = roadY + dy;
                        if (yy < 0 || yy >= dist.length || xx < 0 || xx >= dist[0].length || !(dist[yy][xx] < lowestDist)) continue;
                        bestDy = dy;
                        bestDx = dx;
                        lowestDist = dist[yy][xx];
                    }
                }
                if (bestDy != 0 || bestDx != 0) continue;
                throw new RuntimeException("Stuck in local minimum but not at destination.");
            }
            if (roadX == c2.x && roadY == c2.y) {
                road.intPath.add(new int[]{roadX, roadY});
                road.path.add(new ShapeUtils.P(roadX, roadY));
                WorldMap.this.roads.add(road);
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Spawning_monsters_x_y", index + 1, this.getSize());
        }

        @Override
        public int getSize() {
            return ((WorldMap)WorldMap.this).size.nests;
        }

        @Override
        public void run(int index, WorldMap wm) {
            if (index >= WorldMap.this.nests.size()) {
                return;
            }
            MonsterNest nest = WorldMap.this.nests.get(index);
            if (WorldMap.this.r.nextDouble() < WorldMap.this.difficulty.monsterNestDensity(WorldMap.this.monsterity) * 0.6) {
                Iterator<MonsterNestType> it;
                ArrayList<MonsterNestType> types = Loadable.all(MonsterNestType.class);
                if (!WorldMap.this.connectedToAnywhere(nest)) {
                    it = types.iterator();
                    while (it.hasNext()) {
                        if (!it.next().needsRoad) continue;
                        it.remove();
                    }
                }
                it = types.iterator();
                while (it.hasNext()) {
                    MonsterNestType mnt = it.next();
                    if (!mnt.oneOnly || !MonsterNest.hasType(wm, mnt)) continue;
                    it.remove();
                }
                if (!types.isEmpty()) {
                    int totalWeight = 0;
                    for (MonsterNestType mnt : types) {
                        totalWeight += mnt.spawnWeight;
                    }
                    int typeIndex = 0;
                    for (int roll = WorldMap.this.r.nextInt(totalWeight); roll >= types.get((int)typeIndex).spawnWeight; roll -= types.get((int)typeIndex++).spawnWeight) {
                    }
                    MonsterNestType type = types.get(typeIndex);
                    nest.occupy(type, wm);
                    nest.money = type.income * WorldMap.this.r.nextInt(12);
                }
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Mapping_oceans", new Object[0]);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void run(int index, WorldMap wm) {
            int xx;
            int yy;
            int dx;
            int dy;
            for (int y = 0; y < ((WorldMap)WorldMap.this).size.gridSize; ++y) {
                for (int x = 0; x < ((WorldMap)WorldMap.this).size.gridSize; ++x) {
                    if (WorldMap.this.water[y][x]) {
                        WorldMap.this.resistance[y][x] = 1.0;
                        int landCount = 0;
                        for (dy = -WorldMap.scaled(7); dy < WorldMap.scaled(7) + 1; ++dy) {
                            for (dx = -WorldMap.scaled(7); dx < WorldMap.scaled(7) + 1; ++dx) {
                                yy = y + dy;
                                xx = x + dx;
                                if (yy < 0 || yy >= WorldMap.this.water.length || xx < 0 || xx >= WorldMap.this.water[0].length || WorldMap.this.water[yy][xx]) continue;
                                ++landCount;
                            }
                        }
                        double[] dArray = WorldMap.this.resistance[y];
                        int n = x;
                        dArray[n] = dArray[n] + (double)landCount * 0.07;
                        continue;
                    }
                    WorldMap.this.resistance[y][x] = 10000.0;
                }
            }
            block4: for (Empire e : WorldMap.this.empires) {
                City c = e.cities.get(0);
                c.probablyCoastal = false;
                for (dy = -WorldMap.scaled(40); dy < WorldMap.scaled(40) + 1; ++dy) {
                    for (dx = -WorldMap.scaled(40); dx < WorldMap.scaled(40) + 1; ++dx) {
                        yy = c.y + dy;
                        xx = c.x + dx;
                        if (yy < 0 || yy >= WorldMap.this.water.length || xx < 0 || xx >= WorldMap.this.water[0].length || !WorldMap.this.water[yy][xx]) continue;
                        c.probablyCoastal = true;
                        WorldMap.this.suppressBlob(WorldMap.this.resistance, c.x, c.y, WorldMap.scaled(40), 1.0);
                        c.navNode = new NavNode(c.x, c.y);
                        WorldMap.this.navNodes.add(c.navNode);
                        double offset = WorldMap.this.r.nextDouble() * Math.PI;
                        for (int n = 0; n < 14; ++n) {
                            for (double angle = 0.0; angle < Math.PI * 2; angle += Math.PI / (5.0 + (double)n * 0.7)) {
                                double a = angle + offset;
                                double dist = WorldMap.scaled(20) + n * WorldMap.scaled(40);
                                int npX = c.x + (int)(StrictMath.cos(a) * dist);
                                int npY = c.y + (int)(StrictMath.sin(a) * dist);
                                if (npX < 0 || npX >= ((WorldMap)WorldMap.this).size.gridSize || npY < 0 || npY >= ((WorldMap)WorldMap.this).size.gridSize || (n == 0 ? !WorldMap.this.water[npY][npX] : WorldMap.this.resistance[npY][npX] > 3.0)) continue;
                                WorldMap.this.navNodes.add(new NavNode(npX, npY));
                            }
                        }
                        continue block4;
                    }
                }
            }
            for (NavNode nn1 : WorldMap.this.navNodes) {
                block10: for (NavNode nn2 : WorldMap.this.navNodes) {
                    double d;
                    if (nn1 == nn2 || (d = StrictMath.sqrt((nn1.x - nn2.x) * (nn1.x - nn2.x) + (nn1.y - nn2.y) * (nn1.y - nn2.y))) > (double)WorldMap.scaled(100)) continue;
                    int along = 0;
                    while ((double)along < d) {
                        int alY = (int)((double)nn1.y + (double)((nn2.y - nn1.y) * along) / d);
                        int alX = (int)((double)nn1.x + (double)((nn2.x - nn1.x) * along) / d);
                        if (WorldMap.this.resistance[alY][alX] > 3.0) continue block10;
                        ++along;
                    }
                    nn1.adjacent.add(nn2);
                }
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Charting_sea_routes", index + 1, this.getSize());
        }

        @Override
        public int getSize() {
            int ncc = this.numCoastalCities();
            return ncc * ncc;
        }

        private int numCoastalCities() {
            return this.coastalCities().size();
        }

        private ArrayList<City> coastalCities() {
            ArrayList<City> cs = new ArrayList<City>();
            for (Empire e : WorldMap.this.empires) {
                if (!e.cities.get((int)0).probablyCoastal) continue;
                cs.add(e.cities.get(0));
            }
            return cs;
        }

        @Override
        public void run(int index, WorldMap wm) {
            City c2;
            ArrayList<City> cities = this.coastalCities();
            if (cities.isEmpty()) {
                return;
            }
            City c1 = cities.get(index / cities.size());
            if (c1 == (c2 = cities.get(index % cities.size()))) {
                return;
            }
            if (WorldMap.this.connected(c1, c2)) {
                return;
            }
            Road road = new Road(c1, c2);
            road.seaRoute = true;
            for (NavNode nn : WorldMap.this.navNodes) {
                nn.dist = Double.MAX_VALUE;
            }
            c2.navNode.dist = 0.0;
            boolean progress = true;
            boolean found = false;
            while (progress) {
                progress = false;
                for (NavNode nn : WorldMap.this.navNodes) {
                    for (NavNode nn2 : nn.adjacent) {
                        double d = StrictMath.sqrt((nn.x - nn2.x) * (nn.x - nn2.x) + (nn.y - nn2.y) * (nn.y - nn2.y));
                        if (!(nn2.dist > nn.dist + (d /= (double)nn2.uses + 0.1))) continue;
                        nn2.dist = nn.dist + d;
                        progress = true;
                        if (nn2 != c1.navNode) continue;
                        found = true;
                    }
                }
            }
            if (found) {
                ArrayList<NavNode> nodePath = new ArrayList<NavNode>();
                NavNode current = c1.navNode;
                while (current != c2.navNode) {
                    if (current == null) {
                        return;
                    }
                    nodePath.add(current);
                    if (nodePath.size() > 50) {
                        return;
                    }
                    ++current.uses;
                    NavNode next = null;
                    double closest = 0.0;
                    for (NavNode adj : current.adjacent) {
                        if (next != null && !(closest > adj.dist)) continue;
                        next = adj;
                        closest = adj.dist;
                    }
                    current = next;
                }
                nodePath.add(c2.navNode);
                for (int i = 0; i < nodePath.size() - 1; ++i) {
                    NavNode nn1 = (NavNode)nodePath.get(i);
                    NavNode nn2 = (NavNode)nodePath.get(i + 1);
                    double d = StrictMath.sqrt((nn1.x - nn2.x) * (nn1.x - nn2.x) + (nn1.y - nn2.y) * (nn1.y - nn2.y));
                    if (nn2.x > nn1.x || nn2.x == nn1.x && nn2.y > nn1.y) {
                        int along = 0;
                        while ((double)along < d) {
                            int alX = (int)((double)nn1.x + (double)((nn2.x - nn1.x) * along) / d);
                            int alY = (int)((double)nn1.y + (double)((nn2.y - nn1.y) * along) / d);
                            road.intPath.add(new int[]{alX, alY});
                            road.path.add(new ShapeUtils.P(alX, alY));
                            ++along;
                        }
                        continue;
                    }
                    NavNode tmp = nn2;
                    nn2 = nn1;
                    nn1 = tmp;
                    int insertPt = road.path.size();
                    int along = 0;
                    while ((double)along < d) {
                        int alX = (int)((double)nn1.x + (double)((nn2.x - nn1.x) * along) / d);
                        int alY = (int)((double)nn1.y + (double)((nn2.y - nn1.y) * along) / d);
                        road.intPath.add(insertPt, new int[]{alX, alY});
                        road.path.add(insertPt, new ShapeUtils.P(alX, alY));
                        ++along;
                    }
                }
                WorldMap.this.roads.add(road);
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Roads_", new Object[0]);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void run(int index, WorldMap wm) {
            wm.findRoadOverlaps();
            ShapeUtils.smoothRoads(WorldMap.this.roads);
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return WorldMap.this.campaignWorldDuringGen.isMultiplayer() ? Lang._t("Waiting_for_other_players", new Object[0]) : Lang._t("Done", new Object[0]);
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public void run(int index, WorldMap wm) {
            if (WorldMap.this.campaignWorldDuringGen.isMultiplayer()) {
                AirshipGame g = WorldMap.this.campaignWorldDuringGen.g;
                if (index == 0) {
                    System.out.println("Sending worldgenComplete for " + g.playerID());
                    g.sendMessage(Client.msg("worldgenComplete").put("playerID", g.playerID()));
                } else {
                    boolean allReady = false;
                    while (!allReady) {
                        g.tickClients();
                        JSONObject frame = g.pollMessage();
                        if (frame == null || !frame.getString("type").equals("frame")) continue;
                        WorldMap.this.campaignWorldDuringGen.membershipUpdate(frame);
                        JSONArray messages = frame.getJSONArray("messages");
                        for (int i = 0; i < messages.length(); ++i) {
                            StrategicPlayerInfo pi;
                            JSONObject msg = messages.getJSONObject(i);
                            System.out.println(msg.getString("type"));
                            if (msg.getString("type").equals("chat")) {
                                CampaignWorld.EXECS.get("chat").run(msg, wm, WorldMap.this.campaignWorldDuringGen);
                                continue;
                            }
                            if (!msg.getString("type").equals("worldgenComplete") || (pi = WorldMap.this.campaignWorldDuringGen.channelPlayers.get(msg.getInt("playerID"))) == null) continue;
                            System.out.println("Received worldgenComplete for " + pi.name + " " + pi.id);
                            pi.worldgenComplete = true;
                            allReady = true;
                            for (StrategicPlayerInfo spi : WorldMap.this.campaignWorldDuringGen.channelPlayers.values()) {
                                allReady &= spi.worldgenComplete;
                            }
                            System.out.println("All ready? " + allReady);
                        }
                    }
                }
            }
        }
    }};

    public Empire victor() {
        Empire v = null;
        for (Empire e : this.empires) {
            for (City c : e.cities) {
                if (c.isTown) continue;
                if (v == null) {
                    v = e;
                    continue;
                }
                if (v == e) continue;
                return null;
            }
        }
        return v;
    }

    public void tick(int ms, boolean isMultiplayer) {
        if (ms > 0) {
            for (Empire e : this.empires) {
                e.tick(ms, this);
                this.cleanupMissingInterceptFleets("after " + e.name);
            }
            if (!this.nests.isEmpty()) {
                this.smartNestIndex = (this.smartNestIndex + 1) % this.nests.size();
                Iterator<FleetOwner> i$ = this.nests.iterator();
                while (i$.hasNext()) {
                    MonsterNest n;
                    n.tick(ms, this, this.nests.indexOf(n = (MonsterNest)i$.next()) == this.smartNestIndex, isMultiplayer);
                    this.cleanupMissingInterceptFleets("after " + n.getDisplayName());
                }
            }
            this.age += ms;
            this.timeSinceAIAttackVsHuman += ms;
            this.designateVillain();
            this.timeUntilMergePossible = StrictMath.max(0, this.timeUntilMergePossible - ms);
            if (this.timeUntilMergePossible == 0) {
                this.considerMerger();
                this.cleanupMissingInterceptFleets("after merger check");
            }
        }
    }

    public ArrayList<FleetOwner> fleetOwners() {
        ArrayList<FleetOwner> l = new ArrayList<FleetOwner>();
        l.addAll(this.empires);
        l.addAll(this.nests);
        return l;
    }

    public void resolveUncontestedSeaIntercepts(Empire e) {
        for (Fleet f : e.getFleets()) {
            if (f.interceptTarget == null || f.fleeDestinationNeeded || !(f.progress >= f.transitDistance()) || f.interceptTarget.usingRoad == null || !f.interceptTarget.usingRoad.seaRoute || !f.interceptTarget.groundOnly()) continue;
            this.owner(f.interceptTarget).getFleets().remove(f.interceptTarget);
            f.interceptTarget.broadcastDestroyed(this);
            f.stopAndAskForHelp(this);
            e.messages.add(new Empire.Message(Empire.MessageType.ENEMY_LANDSHIPS_CAUGHT, null, Lang._t("enemy_landships_caught", this.owner(f.interceptTarget))));
        }
    }

    public void cleanupMissingInterceptFleets(String status) {
        for (Empire e : this.empires) {
            for (Fleet f : e.getFleets()) {
                if (f.interceptTarget == null || this.owner(f.interceptTarget) != null) continue;
                this.g.reportError("Missing empire " + e.getName() + " intercept fleet: " + status, null, null, false, true);
                f.stopAndAskForHelp(this);
            }
        }
        for (MonsterNest mn : this.nests) {
            for (Fleet f : mn.getFleets()) {
                if (f.interceptTarget == null || this.owner(f.interceptTarget) != null) continue;
                this.g.reportError("Missing nest " + mn.getDisplayName() + " intercept fleet: " + status, null, null, false, true);
                f.stopAndAskForHelp(this);
            }
        }
    }

    public void quickResolveCombats(Random r) {
        Fleet fleet;
        int fi;
        int fsz;
        int ei;
        ArrayList<Empire> es = new ArrayList<Empire>(this.empires);
        ArrayList<Fleet> fs = new ArrayList<Fleet>();
        int esz = es.size();
        for (ei = 0; ei < esz; ++ei) {
            Empire attacker = es.get(ei);
            if (attacker.playerControlled) continue;
            fs.clear();
            fs.addAll(attacker.getFleets());
            fsz = fs.size();
            for (fi = 0; fi < fsz; ++fi) {
                FleetOwner defender;
                fleet = (Fleet)fs.get(fi);
                if (fleet.location == null || (defender = this.defender(fleet.location)) == attacker || defender instanceof Empire && ((Empire)defender).playerControlled) continue;
                this.quickResolveCombat(attacker, fleet, defender, fleet.location, r);
            }
        }
        es.clear();
        es.addAll(this.empires);
        esz = es.size();
        for (ei = 0; ei < esz; ++ei) {
            Empire e = es.get(ei);
            if (e.cities.isEmpty()) {
                this.removeEmpire(e);
                continue;
            }
            fsz = e.getFleets().size();
            for (fi = 0; fi < fsz; ++fi) {
                fleet = e.getFleets().get(fi);
                fleet.checkInterceptTargetValid(this);
            }
        }
        int nsz = this.nests.size();
        for (int ni = 0; ni < nsz; ++ni) {
            MonsterNest attacker = this.nests.get(ni);
            fs.clear();
            fs.addAll(attacker.getFleets());
            int fsz2 = fs.size();
            for (int fi2 = 0; fi2 < fsz2; ++fi2) {
                FleetOwner defender;
                Fleet fleet2 = (Fleet)fs.get(fi2);
                if (fleet2.location == null || !(fleet2.location instanceof City) || !((defender = this.defender(fleet2.location)) instanceof Empire) || defender == attacker || defender instanceof Empire && ((Empire)defender).playerControlled) continue;
                this.quickResolveRaid(attacker, fleet2, (Empire)defender, (City)fleet2.location, r);
            }
        }
    }

    static int cost(ArrayList<Airship> l) {
        int c = 0;
        for (Airship s : l) {
            if (!s.isArmedOrHasTroops()) continue;
            c += s.getCost();
        }
        return c;
    }

    static int cost(Fleet f) {
        return WorldMap.cost(f.actives) + WorldMap.cost(f.reserve);
    }

    public void quickResolveRaid(MonsterNest attacker, Fleet attackingFleet, Empire defender, City defendingLocation, Random r) {
        String bs;
        HashMap<Empire, String> altTexts;
        System.out.println(attacker.getName() + " raids " + defendingLocation.getDisplayName());
        Fleet defendingFleet = new Fleet(defendingLocation, this);
        for (Fleet fl : defender.getFleets()) {
            if (fl.location != defendingLocation) continue;
            defendingFleet = fl;
            break;
        }
        int maxLooting = StrictMath.min(3, 4 - defendingLocation.economicDamage);
        int attackerVictories = 0;
        int maxAttackerVictories = 0;
        int vic = 1;
        for (int i = 0; i < maxLooting; ++i) {
            maxAttackerVictories += vic;
            ++vic;
        }
        if (WorldMap.cost(attackingFleet) > (WorldMap.cost(defendingFleet) + WorldMap.cost(defendingLocation.getDefences())) * 2) {
            System.out.println("Instant surrender");
            attackerVictories = maxAttackerVictories;
        } else {
            while (attackerVictories < maxAttackerVictories && WorldMap.cost(attackingFleet) > (WorldMap.cost(defendingFleet) + WorldMap.cost(defendingLocation.getDefences())) / 4 && WorldMap.cost(defendingFleet) + WorldMap.cost(defendingLocation.getDefences()) > 0) {
                int remove;
                System.out.println("Combat round");
                int attackerCost = WorldMap.cost(attackingFleet);
                int defenderCost = WorldMap.cost(defendingFleet) + WorldMap.cost(defendingLocation.getDefences());
                double attackerValue = (double)attackerCost * (double)attackerCost;
                double defenderValue = (double)defenderCost * (double)defenderCost;
                System.out.println(attackerCost + " vs " + defenderCost);
                double drawValue = 250000.0;
                double roll = r.nextDouble() * (attackerValue + defenderValue + drawValue + 1.0);
                if (roll < attackerValue) {
                    System.out.println("Attacker wins");
                    remove = r.nextInt(defendingFleet.actives.size() + defendingFleet.reserve.size() + defendingLocation.getDefences().size());
                    if (remove < defendingFleet.actives.size()) {
                        defendingFleet.actives.remove(remove);
                    } else if (remove < defendingFleet.actives.size() + defendingFleet.reserve.size()) {
                        defendingFleet.reserve.remove(remove - defendingFleet.actives.size());
                    } else {
                        defendingLocation.removeDefence(defendingLocation.getDefences().get(remove - defendingFleet.actives.size() - defendingFleet.reserve.size()));
                    }
                    ++attackerVictories;
                    continue;
                }
                if (roll < attackerValue + defenderValue) {
                    System.out.println("Defender wins");
                    remove = r.nextInt(attackingFleet.actives.size() + attackingFleet.reserve.size());
                    if (remove < attackingFleet.actives.size()) {
                        attackingFleet.actives.remove(remove);
                        continue;
                    }
                    attackingFleet.reserve.remove(remove - attackingFleet.actives.size());
                    continue;
                }
                System.out.println("Raid continues");
                ++attackerVictories;
            }
            if (WorldMap.cost(defendingFleet) + WorldMap.cost(defendingLocation.getDefences()) == 0) {
                System.out.println("Total victory");
                attackerVictories = maxAttackerVictories;
                defender.getFleets().remove(defendingFleet);
                defendingFleet.broadcastDestroyed(this);
            }
        }
        if (attackerVictories > 0) {
            altTexts = new HashMap<Empire, String>();
            for (Empire e : this.empires) {
                bs = attacker.type.bonusSuffix(e);
                if (bs.isEmpty()) continue;
                altTexts.put(e, Lang._t("x_raided_by_y", defendingLocation.getDisplayName(), Lang._t(attacker.type.name + "_displayName" + bs, new Object[0])));
            }
            defendingLocation.addMessage(MapLocation.MessageType.COMBAT, Lang._t("x_raided_by_y", defendingLocation.getDisplayName(), attacker.getName()), altTexts);
        } else {
            altTexts = new HashMap();
            for (Empire e : this.empires) {
                bs = attacker.type.bonusSuffix(e);
                if (bs.isEmpty()) continue;
                altTexts.put(e, Lang._t("x_raided_by_y", defendingLocation.getDisplayName(), Lang._t(attacker.type.name + "_displayName" + bs, new Object[0])));
            }
            defendingLocation.addMessage(MapLocation.MessageType.COMBAT, Lang._t("x_repels_y", defendingLocation.getDisplayName(), attacker.getName()), altTexts);
        }
        if (WorldMap.cost(attackingFleet) == 0) {
            System.out.println("Total defeat");
            attackerVictories = 0;
            attacker.getFleets().remove(attackingFleet);
            attackingFleet.broadcastDestroyed(this);
        } else {
            System.out.println("Returning to base");
            attackingFleet.travelTo(attacker, this);
        }
        System.out.println("Victories " + attackerVictories);
        int lootAmount = 0;
        for (vic = 1; attackerVictories >= vic; ++vic) {
            ++lootAmount;
        }
        attacker.money += lootAmount * 650;
        if (!attacker.upgrading) {
            attacker.upgradeAccumulator += lootAmount * attacker.type.upgradeMsPerRaidSuccess;
        }
        System.out.println("Attacker gets $" + lootAmount * 650);
        defendingLocation.economicDamage += lootAmount;
    }

    public void quickResolveCombat(Empire attacker, Fleet attackingFleet, FleetOwner defender, MapLocation defendingLocation, Random r) {
        Fleet defendingFleet = new Fleet(defendingLocation, this);
        for (Fleet fl : defender.getFleets()) {
            if (fl.location != defendingLocation) continue;
            defendingFleet = fl;
            break;
        }
        int attackerAIValue = 100;
        for (Airship s : attackingFleet.getAllShips()) {
            attackerAIValue += s.getCost();
        }
        int defenderAIValue = 100;
        for (Airship s : defendingFleet.getAllShips()) {
            defenderAIValue += s.getCost();
        }
        for (Airship b : defendingLocation.getDefences()) {
            defenderAIValue = (int)((double)defenderAIValue + (double)b.getCost() * 0.6);
        }
        int attackerStrength = WorldMap.cost(attackingFleet);
        int defenderStrength = WorldMap.cost(defendingFleet) + WorldMap.cost(defendingLocation.getDefences());
        int damageToAttacker = 0;
        int damageToDefender = 0;
        while (attackerStrength > defenderStrength / 2 && defenderStrength > attackerStrength / 2) {
            int hitRoll;
            Airship hit;
            int cost;
            int roll = r.nextInt(attackerStrength + defenderStrength + 1);
            if (roll < attackerStrength) {
                damageToDefender += attackerStrength / 4;
                while (!(defendingFleet.actives.isEmpty() && defendingFleet.reserve.isEmpty() && defendingLocation.getDefences().isEmpty() || damageToDefender < (cost = (hit = (hitRoll = r.nextInt(defendingFleet.actives.size() + defendingFleet.reserve.size() + defendingLocation.getDefences().size())) < defendingFleet.actives.size() ? defendingFleet.actives.get(hitRoll) : ((hitRoll -= defendingFleet.actives.size()) < defendingFleet.reserve.size() ? defendingFleet.reserve.get(hitRoll) : defendingLocation.getDefences().get(hitRoll - defendingFleet.reserve.size()))).getCost()))) {
                    defendingFleet.actives.remove(hit);
                    defendingFleet.reserve.remove(hit);
                    defendingLocation.removeDefence(hit);
                    damageToDefender -= cost;
                    defenderStrength -= cost;
                }
                continue;
            }
            damageToAttacker += defenderStrength / 4;
            while (!(attackingFleet.actives.isEmpty() && attackingFleet.reserve.isEmpty() || damageToAttacker < (cost = (hit = (hitRoll = r.nextInt(attackingFleet.actives.size() + attackingFleet.reserve.size())) < attackingFleet.actives.size() ? attackingFleet.actives.get(hitRoll) : attackingFleet.reserve.get(hitRoll - attackingFleet.actives.size())).getCost()))) {
                attackingFleet.actives.remove(hit);
                attackingFleet.reserve.remove(hit);
                damageToAttacker -= cost;
                attackerStrength -= cost;
            }
        }
        if (defendingFleet.actives.isEmpty() && defendingFleet.reserve.isEmpty()) {
            defender.getFleets().remove(defendingFleet);
            defendingFleet.broadcastDestroyed(this);
        }
        if (attackerStrength < defenderStrength) {
            if (attackingFleet.actives.isEmpty() && attackingFleet.reserve.isEmpty()) {
                attacker.getFleets().remove(attackingFleet);
                attackingFleet.broadcastDestroyed(this);
            } else {
                attackingFleet.fleeDestinationNeeded = true;
            }
            StrategicAI.attackFailed(attacker, defendingLocation, attackerAIValue, defenderAIValue);
            defendingLocation.addMessage(MapLocation.MessageType.COMBAT, Lang._t("x_repels_y", defendingLocation.getDisplayName(), attacker.name));
        } else if (defendingLocation instanceof City) {
            Empire defendingEmpire = (Empire)defender;
            City defendingCity = (City)defendingLocation;
            defendingEmpire.cities.remove(defendingCity);
            defendingCity.takeoverNeeded = defendingCity.originalEmpire != attacker;
            defendingCity.takeoverMethod = null;
            defendingCity.takeoverAmount = 0;
            attacker.cities.add(defendingCity);
            defendingLocation.addMessage(MapLocation.MessageType.COMBAT, Lang._t("x_conquers_y", attacker.name, defendingCity.name));
        } else if (defendingLocation instanceof MonsterNest) {
            MonsterNest nest = (MonsterNest)defendingLocation;
            if (nest.type != null) {
                nest.type.giveRewardTo(attacker, this);
                HashMap<Empire, String> altTexts = new HashMap<Empire, String>();
                for (Empire e : this.empires) {
                    String bs = nest.type.bonusSuffix(e);
                    if (bs.isEmpty()) continue;
                    altTexts.put(e, Lang._t("x_defeats_" + nest.type.name + bs, attacker.name));
                }
                defendingLocation.addMessage(MapLocation.MessageType.COMBAT, Lang._t("x_defeats_" + nest.type.name, attacker.name), altTexts);
            }
            nest.clear(this);
        }
        defendingLocation.constructionTarget = null;
    }

    public CombatInfo getNextCombat(AirshipGame g, CampaignWorld cw) {
        int esz = this.empires.size();
        for (int ei = 0; ei < esz; ++ei) {
            CombatInfo ci;
            Empire e = this.empires.get(ei);
            if (!e.playerControlled || (ci = this.getCombatFor(e, g, cw)) == null) continue;
            return ci;
        }
        return null;
    }

    private CombatInfo getCombatFor(Empire e, AirshipGame g, CampaignWorld cw) {
        int fsz = e.getFleets().size();
        for (int fi = 0; fi < fsz; ++fi) {
            Fleet f = e.getFleets().get(fi);
            if (!(f.location == null || f.fleeDestinationNeeded || e.cities.contains(f.location) || f.location instanceof MonsterNest && ((MonsterNest)f.location).type == null)) {
                return this.makeCombat(cw, e, f, this.defender(f.location), f.location, false, g);
            }
            if (f.interceptTarget == null || f.fleeDestinationNeeded || !(f.progress >= f.transitDistance())) continue;
            return this.makeInterceptCombat(cw, e, f, this.owner(f.interceptTarget), f.interceptTarget, false, g);
        }
        int esz = this.empires.size();
        for (int ei = 0; ei < esz; ++ei) {
            Empire attacker = this.empires.get(ei);
            if (attacker == e) continue;
            fsz = attacker.getFleets().size();
            for (int fi = 0; fi < fsz; ++fi) {
                Fleet f = attacker.getFleets().get(fi);
                if (f.location == null || f.fleeDestinationNeeded || !e.cities.contains(f.location)) continue;
                return this.makeCombat(cw, attacker, f, e, f.location, true, g);
            }
        }
        int nsz = this.nests.size();
        for (int ni = 0; ni < nsz; ++ni) {
            MonsterNest attacker = this.nests.get(ni);
            fsz = attacker.getFleets().size();
            for (int fi = 0; fi < fsz; ++fi) {
                Fleet f = attacker.getFleets().get(fi);
                if (f.location == null || f.fleeDestinationNeeded || !e.cities.contains(f.location)) continue;
                return this.makeRaid(cw, attacker, f, e, (City)f.location, g);
            }
        }
        return null;
    }

    public ArrayList<City> cities() {
        ArrayList<City> cs = new ArrayList<City>();
        int esz = this.empires.size();
        for (int ei = 0; ei < esz; ++ei) {
            Empire e = this.empires.get(ei);
            cs.addAll(e.cities);
        }
        return cs;
    }

    public FleetOwner defender(MapLocation loc) {
        if (loc instanceof FleetOwner) {
            return (FleetOwner)((Object)loc);
        }
        if (loc instanceof City) {
            return this.owner((City)loc);
        }
        return null;
    }

    public Empire owner(City c) {
        int esz = this.empires.size();
        for (int ei = 0; ei < esz; ++ei) {
            Empire e = this.empires.get(ei);
            if (!e.cities.contains(c)) continue;
            return e;
        }
        return null;
    }

    public FleetOwner owner(Fleet f) {
        int esz = this.empires.size();
        for (int ei = 0; ei < esz; ++ei) {
            Empire e = this.empires.get(ei);
            if (!e.getFleets().contains(f)) continue;
            return e;
        }
        int nsz = this.nests.size();
        for (int ni = 0; ni < nsz; ++ni) {
            MonsterNest n = this.nests.get(ni);
            if (!n.getFleets().contains(f)) continue;
            return n;
        }
        return null;
    }

    public Empire owner(Spy spy) {
        int esz = this.empires.size();
        for (int ei = 0; ei < esz; ++ei) {
            Empire e = this.empires.get(ei);
            if (!e.spies.contains(spy)) continue;
            return e;
        }
        return null;
    }

    public Fleet travelTo(Fleet fleet, ArrayList<Airship> selection, MapLocation destination) {
        if (fleet == null || selection.isEmpty()) {
            return fleet;
        }
        FleetOwner owner = this.owner(fleet);
        boolean selectionCanFly = true;
        for (Airship ship : selection) {
            if (!ship.type.onGround) continue;
            selectionCanFly = false;
            break;
        }
        for (Fleet f : owner.getFleets()) {
            if (selectionCanFly != f.canFly() || f == fleet || f.destination != destination || f.realX() != fleet.realX() || f.realY() != fleet.realY()) continue;
            f.reserve.addAll(selection);
            fleet.actives.removeAll(selection);
            fleet.reserve.removeAll(selection);
            if (fleet.actives.isEmpty() && fleet.reserve.isEmpty()) {
                owner.getFleets().remove(fleet);
                fleet.broadcastDestroyed(this);
            }
            return f;
        }
        if (selection.containsAll(fleet.actives) && selection.containsAll(fleet.reserve) && fleet.canTravelTo(destination, this, owner)) {
            fleet.travelTo(destination, this);
            fleet.fleeDestinationNeeded = false;
        } else {
            Fleet f = new Fleet(fleet, this);
            f.actives.retainAll(selection);
            f.reserve.retainAll(selection);
            if (!f.canTravelTo(destination, this, owner)) {
                return null;
            }
            owner.getFleets().add(f);
            fleet.actives.removeAll(selection);
            fleet.reserve.removeAll(selection);
            if (fleet.actives.isEmpty() && fleet.reserve.isEmpty()) {
                owner.getFleets().remove(fleet);
                fleet.broadcastDestroyed(this);
            } else if (fleet.location != null && this.defender(fleet.location) == owner) {
                fleet.location.layoutGarrison(fleet);
            }
            fleet = f;
            f.travelTo(destination, this);
        }
        return fleet;
    }

    public void doCitySpyAction(Spy.CitySpyAction a, Empire e, City c) {
        SpyActionResult sar;
        boolean abjectFailure;
        int chance;
        Empire victim = this.owner(c);
        Spy spy = e.getSpyFor(c);
        if (spy == null) {
            return;
        }
        if (!a.available(spy, c, this)) {
            return;
        }
        e.money -= a.cost(spy, e, c, this);
        int roll = this.r.nextInt(100);
        boolean success = roll < (chance = a.successChance(spy, e, c, this));
        boolean bl = abjectFailure = roll < chance * 2;
        if (success) {
            Utils.Pair<String, String> myYourText = a.success(spy, c, this);
            c.alertAmount = this.owner(c) == e ? 0 : (c.alertAmount += 15000);
            sar = new SpyActionResult(a, true, c, e, victim, (String)myYourText.a, (String)myYourText.b);
        } else {
            Utils.Pair<String, String> myYourText = a.failure(spy, c, this);
            if (abjectFailure) {
                e.spies.remove(spy);
                sar = new SpyActionResult(a, false, c, e, victim, (String)myYourText.a + " " + Lang._t("Your_spy_has_been_captured", new Object[0]), (String)myYourText.b);
            } else {
                sar = new SpyActionResult(a, false, c, e, victim, (String)myYourText.a, (String)myYourText.b);
            }
        }
        e.spyActionResults.add(sar);
        victim.spyActionResults.add(sar);
    }

    public void doShipSpyAction(Spy.ShipSpyAction a, Empire e, City c, Airship ship) {
        SpyActionResult sar;
        boolean abjectFailure;
        int chance;
        Empire victim = this.owner(c);
        Spy spy = e.getSpyFor(c);
        if (spy == null) {
            return;
        }
        e.money -= a.cost(ship, spy, e, c, this);
        int roll = this.r.nextInt(100);
        boolean success = roll < (chance = a.successChance(ship, spy, e, c, this));
        boolean bl = abjectFailure = roll < chance * 2;
        if (success) {
            Utils.Pair<String, String> myYourText = a.success(ship, spy, c, this);
            c.alertAmount = this.owner(c) == e ? 0 : (c.alertAmount += 15000);
            sar = new SpyActionResult(a, true, c, e, victim, (String)myYourText.a, (String)myYourText.b);
        } else {
            Utils.Pair<String, String> myYourText = a.failure(ship, spy, c, this);
            if (abjectFailure) {
                e.spies.remove(spy);
                sar = new SpyActionResult(a, false, c, e, victim, (String)myYourText.a + " " + Lang._t("Your_spy_has_been_captured", new Object[0]), (String)myYourText.b);
            } else {
                sar = new SpyActionResult(a, false, c, e, victim, (String)myYourText.a, (String)myYourText.b);
            }
        }
        e.spyActionResults.add(sar);
        victim.spyActionResults.add(sar);
    }

    private CombatInfo makeRaid(CampaignWorld cw, MonsterNest attacker, Fleet attackingFleet, Empire defender, City defendingLoc, AirshipGame g) {
        Combat c = new Combat(g, TimeOfDay.getRandom(this.r, defendingLoc.ground.landscapeType), this.r, cw);
        c.recording.header.type = Recording.Header.Type.STRATEGIC;
        c.recording.header.placeName = defendingLoc.getDisplayName();
        c.backgroundFlavor = this.getBackground((int)attackingFleet.realX(), (int)attackingFleet.realY());
        c.sides.get((int)0).arms = attacker.getArms();
        c.sides.get(0).setName(attacker.getNameOrTranslationKey(), attacker.nameIsTranslationKey());
        c.sides.get((int)0).bonuses = attacker.bonuses();
        c.sides.get((int)0).ships.addAll(attackingFleet.actives);
        c.sides.get((int)0).reserve.addAll(attackingFleet.reserve);
        c.sides.get((int)1).arms = defender.getArms();
        c.sides.get(1).setName(defender.getNameOrTranslationKey(), defender.nameIsTranslationKey());
        c.sides.get((int)1).bonuses = defender.bonuses();
        c.sides.get((int)1).ships.addAll(defendingLoc.getDefences());
        Fleet defendingFleet = this.getGarrison(defendingLoc);
        if (defendingFleet != null) {
            c.sides.get((int)1).ships.addAll(defendingFleet.actives);
            c.sides.get((int)1).reserve.addAll(defendingFleet.reserve);
            ArrayList<Airship> l = new ArrayList<Airship>(defendingFleet.actives);
            l.retainAll(defendingFleet.reserve);
            if (!l.isEmpty()) {
                System.out.println("ACTIVE-RESERVE OVERLAP");
            }
        }
        for (Airship ship : c.sides.get((int)0).ships) {
            ship.currentBonuses = attacker.bonuses();
        }
        for (Airship ship : c.sides.get((int)1).ships) {
            ship.currentBonuses = defender.bonuses();
        }
        c.landFormations.add(defendingLoc.ground);
        for (LandFormation lf : defendingLoc.floaters) {
            c.landFormations.add(lf);
        }
        c.sides.get(0).layoutShips(c, false);
        c.sides.get(1).layoutShips(c, true);
        c.isRaid = true;
        c.maxLootAmount = StrictMath.min(3, 4 - defendingLoc.economicDamage);
        return new CombatInfo(c, attackingFleet, defendingFleet, defendingLoc, 1, false, attacker.getAIQuality(this));
    }

    private CombatInfo makeCombat(CampaignWorld cw, Empire attacker, Fleet attackingFleet, FleetOwner defender, MapLocation defendingLoc, boolean playerDefending, AirshipGame g) {
        int count;
        Combat c = new Combat(g, TimeOfDay.getRandom(this.r, defendingLoc.ground.landscapeType), this.r, cw);
        if (cw.channelPlayers != null) {
            HashMap<Integer, CombatSpeed> speedVoters = new HashMap<Integer, CombatSpeed>();
            for (StrategicPlayerInfo spi : cw.channelPlayers.values()) {
                if (spi.empire != attacker && spi.empire != defender) continue;
                speedVoters.put(spi.id, CombatSpeed.NORMAL);
            }
            if (speedVoters.size() > 1) {
                c.speedVoters = speedVoters;
            }
        }
        c.recording.header.type = Recording.Header.Type.STRATEGIC;
        c.recording.header.placeName = defendingLoc == null ? null : defendingLoc.getDisplayName();
        c.backgroundFlavor = this.getBackground((int)attackingFleet.realX(), (int)attackingFleet.realY());
        c.sides.get((int)0).arms = attacker.arms;
        c.sides.get(0).setName(attacker.getNameOrTranslationKey(), attacker.nameIsTranslationKey());
        c.sides.get((int)0).bonuses = attacker.bonuses();
        c.sides.get((int)0).ships.addAll(attackingFleet.actives);
        c.sides.get((int)0).reserve.addAll(attackingFleet.reserve);
        c.sides.get((int)1).arms = defender.getArms();
        c.sides.get(1).setName(defender.getNameOrTranslationKey(), defender.nameIsTranslationKey());
        c.sides.get((int)1).bonuses = defender.bonuses();
        c.sides.get((int)1).ships.addAll(defendingLoc.getDefences());
        Fleet defendingFleet = this.getGarrison(defendingLoc);
        if (defendingFleet != null) {
            c.sides.get((int)1).ships.addAll(defendingFleet.actives);
            c.sides.get((int)1).reserve.addAll(defendingFleet.reserve);
            ArrayList<Airship> l = new ArrayList<Airship>(defendingFleet.actives);
            l.retainAll(defendingFleet.reserve);
            if (!l.isEmpty()) {
                System.out.println("ACTIVE-RESERVE OVERLAP");
            }
        }
        Combat.Side side = c.sides.get(1);
        for (Airship ship : side.ships) {
            count = 0;
            for (Airship ship2 : side.ships) {
                if (ship != ship2) continue;
                ++count;
            }
            for (Airship ship2 : side.reserve) {
                if (ship != ship2) continue;
                ++count;
            }
            if (count == 1) continue;
            System.out.println("Miscount in combat setup: " + count);
        }
        for (Airship ship : side.reserve) {
            count = 0;
            for (Airship ship2 : side.ships) {
                if (ship != ship2) continue;
                ++count;
            }
            for (Airship ship2 : side.reserve) {
                if (ship != ship2) continue;
                ++count;
            }
            if (count == 1) continue;
            System.out.println("Miscount in combat setup: " + count);
        }
        for (Airship ship : c.sides.get((int)0).ships) {
            ship.currentBonuses = attacker.bonuses();
        }
        for (Airship ship : c.sides.get((int)1).ships) {
            ship.currentBonuses = defender.bonuses();
        }
        c.landFormations.add(defendingLoc.ground);
        for (LandFormation lf : defendingLoc.floaters) {
            c.landFormations.add(lf);
        }
        c.sides.get(0).layoutShips(c, false);
        c.sides.get(1).layoutShips(c, true);
        return new CombatInfo(c, attackingFleet, defendingFleet, defendingLoc, playerDefending ? 1 : 0, false, playerDefending ? attacker.getAIQuality(this) : defender.getAIQuality(this));
    }

    private CombatInfo makeInterceptCombat(CampaignWorld cw, Empire attacker, Fleet attackingFleet, FleetOwner defender, Fleet defendingFleet, boolean playerDefending, AirshipGame g) {
        CombatBackgroundFlavor cbf = this.getBackground((int)attackingFleet.realX(), (int)attackingFleet.realY());
        LandscapeType lt = cbf.getLandscapeType(this.r);
        Combat c = new Combat(g, TimeOfDay.getRandom(this.r, lt), this.r, cw);
        if (cw.channelPlayers != null) {
            HashMap<Integer, CombatSpeed> speedVoters = new HashMap<Integer, CombatSpeed>();
            for (StrategicPlayerInfo spi : cw.channelPlayers.values()) {
                if (spi.empire != attacker && spi.empire != defender) continue;
                speedVoters.put(spi.id, CombatSpeed.NORMAL);
            }
            if (speedVoters.size() > 1) {
                c.speedVoters = speedVoters;
            }
        }
        c.recording.header.type = Recording.Header.Type.STRATEGIC;
        c.recording.header.placeName = null;
        c.backgroundFlavor = cbf;
        c.sides.get((int)0).arms = attacker.arms;
        c.sides.get(0).setName(attacker.getNameOrTranslationKey(), attacker.nameIsTranslationKey());
        c.sides.get((int)0).bonuses = attacker.bonuses();
        c.sides.get((int)0).ships.addAll(attackingFleet.actives);
        c.sides.get((int)0).reserve.addAll(attackingFleet.reserve);
        c.sides.get((int)1).arms = defender.getArms();
        c.sides.get(1).setName(defender.getNameOrTranslationKey(), defender.nameIsTranslationKey());
        c.sides.get((int)1).bonuses = defender.bonuses();
        if (defendingFleet.usingRoad != null && defendingFleet.usingRoad.seaRoute) {
            for (Airship ship : defendingFleet.actives) {
                if (ship.type.onGround) continue;
                c.sides.get((int)1).ships.add(ship);
            }
            for (Airship ship : defendingFleet.reserve) {
                if (ship.type.onGround) continue;
                c.sides.get((int)1).reserve.add(ship);
            }
        } else {
            c.sides.get((int)1).ships.addAll(defendingFleet.actives);
            c.sides.get((int)1).reserve.addAll(defendingFleet.reserve);
        }
        for (Airship ship : c.sides.get((int)0).ships) {
            ship.currentBonuses = attacker.bonuses();
        }
        for (Airship ship : c.sides.get((int)1).ships) {
            ship.currentBonuses = defender.bonuses();
        }
        Utils.Pair<LandFormation, List<LandFormation>> p = LandFormation.generate(this.r, false, lt);
        c.landFormations.add((LandFormation)p.a);
        c.landFormations.addAll((Collection)p.b);
        c.sides.get(0).layoutShips(c, false);
        c.sides.get(1).layoutShips(c, true);
        return new CombatInfo(c, attackingFleet, defendingFleet, null, playerDefending ? 1 : 0, false, playerDefending ? attacker.getAIQuality(this) : defender.getAIQuality(this));
    }

    public CombatBackgroundFlavor getBackground(int x, int y) {
        CombatBackgroundFlavor cbf = CombatBackgroundFlavor.ofName("plains");
        int closest = 6400;
        for (TerrainFeature tf : this.features) {
            int distSq = (tf.x - x) * (tf.x - x) + (tf.y - y) * (tf.y - y);
            if (distSq >= 4900 || distSq >= closest) continue;
            closest = distSq;
            switch (tf.type) {
                case MOUNTAIN: {
                    cbf = CombatBackgroundFlavor.ofName("mountain");
                    break;
                }
                case FOREST: {
                    cbf = CombatBackgroundFlavor.ofName("forest");
                    break;
                }
                case SWAMP: {
                    cbf = CombatBackgroundFlavor.ofName("swamps");
                }
            }
        }
        if (cbf == CombatBackgroundFlavor.ofName("plains")) {
            block6: for (int dy = -20; dy < 20; ++dy) {
                for (int dx = -20; dx < 20; ++dx) {
                    int ny = y + dy;
                    int nx = x + dx;
                    if (ny < 0 || nx < 0 || ny >= this.water.length || nx >= this.water[0].length || !this.water[ny][nx]) continue;
                    cbf = CombatBackgroundFlavor.ofName("sea");
                    break block6;
                }
            }
        }
        return cbf;
    }

    public void removeEmpire(Empire loser) {
        this.empires.remove(loser);
        for (Empire e : this.empires) {
            for (City c : e.cities) {
                if (c.originalEmpire != loser) continue;
                c.originalEmpire = null;
            }
            for (Fleet f : e.getFleets()) {
                f.broadcastDestroyed(this);
            }
        }
    }

    public Fleet getGarrison(MapLocation loc) {
        block3: {
            block2: {
                if (!(loc instanceof City)) break block2;
                Empire o = this.owner((City)loc);
                for (Fleet f : o.getFleets()) {
                    if (f.location != loc) continue;
                    return f;
                }
                break block3;
            }
            if (!(loc instanceof MonsterNest)) break block3;
            for (Fleet f : ((MonsterNest)loc).getFleets()) {
                if (f.location != loc) continue;
                return f;
            }
        }
        return null;
    }

    public MapLocation getMapLocation(int id) {
        int esz = this.empires.size();
        for (int ei = 0; ei < esz; ++ei) {
            Empire e = this.empires.get(ei);
            int csz = e.cities.size();
            for (int ci = 0; ci < csz; ++ci) {
                City c = e.cities.get(ci);
                if (c.id != id) continue;
                return c;
            }
        }
        int nsz = this.nests.size();
        for (int ni = 0; ni < nsz; ++ni) {
            MonsterNest n = this.nests.get(ni);
            if (n.id != id) continue;
            return n;
        }
        return null;
    }

    public City getCity(int id) {
        int esz = this.empires.size();
        for (int ei = 0; ei < esz; ++ei) {
            Empire e = this.empires.get(ei);
            int csz = e.cities.size();
            for (int ci = 0; ci < csz; ++ci) {
                City c = e.cities.get(ci);
                if (c.id != id) continue;
                return c;
            }
        }
        return null;
    }

    public Empire getEmpire(int id) {
        for (Empire e : this.empires) {
            if (e.id != id) continue;
            return e;
        }
        return null;
    }

    public Airship getShipOfEmpire(Empire e, String networkID) {
        for (Fleet f : e.getFleets()) {
            for (Airship s : f.getAllShips()) {
                if (!s.networkID.equals(networkID)) continue;
                return s;
            }
        }
        for (City c : e.cities) {
            for (Airship s : c.getDefences()) {
                if (!s.networkID.equals(networkID)) continue;
                return s;
            }
        }
        return null;
    }

    public Airship getShip(String networkID) {
        for (Empire e : this.empires) {
            Airship s = this.getShipOfEmpire(e, networkID);
            if (s == null) continue;
            return s;
        }
        for (MonsterNest mn : this.nests) {
            for (Fleet f : mn.getFleets()) {
                for (Airship s : f.getAllShips()) {
                    if (!s.networkID.equals(networkID)) continue;
                    return s;
                }
            }
        }
        return null;
    }

    public Fleet getFleet(int fleetID) {
        for (Empire e : this.empires) {
            for (Fleet f : e.getFleets()) {
                if (f.id != fleetID) continue;
                return f;
            }
        }
        for (MonsterNest mn : this.nests) {
            for (Fleet f : mn.getFleets()) {
                if (f.id != fleetID) continue;
                return f;
            }
        }
        return null;
    }

    public int getFreeEmpireID() {
        int id = 1;
        for (Empire e : this.empires) {
            id = StrictMath.max(id, e.id + 1);
        }
        return id;
    }

    public String getSetupStageDesc() {
        int index = this.stageIndex;
        for (SetupStage ss : this.setupStages) {
            if (index < ss.getSize()) {
                return ss.getDesc(index);
            }
            index -= ss.getSize();
        }
        return "...";
    }

    public int getSetupProgress() {
        return this.stageIndex;
    }

    public int getSetupLength() {
        int n = 0;
        for (SetupStage stage : this.setupStages) {
            n += stage.getSize();
        }
        return n;
    }

    private void blitBlob(double[][] resistance, int x, int y, int r, int amt) {
        for (int dy = -r; dy <= r * 2; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= resistance.length) continue;
            for (int dx = -r; dx <= r * 2; ++dx) {
                double d;
                int xx = x + dx;
                if (xx < 0 || xx >= resistance[0].length || !((d = StrictMath.sqrt((x - xx) * (x - xx) + (y - yy) * (y - yy))) < (double)r)) continue;
                double a = (double)amt * ((double)r - d) / (double)r / 2.0 + (double)(amt / 2);
                double[] dArray = resistance[yy];
                int n = xx;
                dArray[n] = dArray[n] + a;
            }
        }
    }

    private void suppressBlob(double[][] resistance, int x, int y, int r, double max) {
        for (int dy = -r; dy <= r * 2; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= resistance.length) continue;
            for (int dx = -r; dx <= r * 2; ++dx) {
                double d;
                int xx = x + dx;
                if (xx < 0 || xx >= resistance[0].length || !((d = StrictMath.sqrt((x - xx) * (x - xx) + (y - yy) * (y - yy))) < (double)r)) continue;
                resistance[yy][xx] = StrictMath.min(resistance[yy][xx], max);
            }
        }
    }

    private int maxLocationID() {
        int id = 0;
        for (Empire e : this.empires) {
            for (City c : e.cities) {
                id = StrictMath.max(id, c.id);
            }
        }
        for (MonsterNest mn : this.nests) {
            id = StrictMath.max(id, mn.id);
        }
        return id;
    }

    private byte getConnectedStatus(MapLocation c1, MapLocation c2) {
        int result;
        if (this.connectedCache == null) {
            this.connectedCache = new byte[this.maxLocationID() + 1][this.maxLocationID() + 1];
        }
        if ((result = this.connectedCache[c1.id][c2.id]) == 0) {
            Road road = this.getConnection(c1, c2);
            result = road == null ? 1 : (road.seaRoute ? 2 : 3);
            this.connectedCache[c1.id][c2.id] = result;
        }
        return (byte)result;
    }

    public boolean connected(MapLocation c1, MapLocation c2) {
        return this.getConnectedStatus(c1, c2) >= 2;
    }

    public boolean connectedToAnywhere(MapLocation ml) {
        for (Road road : this.roads) {
            if (road.src != ml && road.dst != ml) continue;
            return true;
        }
        return false;
    }

    public boolean connectedByLand(MapLocation c1, MapLocation c2) {
        return this.getConnectedStatus(c1, c2) >= 3;
    }

    public Road getConnection(MapLocation c1, MapLocation c2) {
        int rsz = this.roads.size();
        for (int ri = 0; ri < rsz; ++ri) {
            Road road = this.roads.get(ri);
            if ((road.src != c1 || road.dst != c2) && (road.src != c2 || road.dst != c1)) continue;
            return road;
        }
        return null;
    }

    private double[][] calcLocationDistances(int locationIndex, int[] allowedTerritories) {
        MapLocation loc = null;
        if (locationIndex < this.empires.size() * (this.size.townsPerEmpire + 1)) {
            loc = this.getCity(locationIndex);
        } else {
            for (MonsterNest n : this.nests) {
                if (n.id != locationIndex) continue;
                loc = n;
            }
        }
        if (loc == null) {
            return null;
        }
        double[][] dist = new double[this.size.gridSize][this.size.gridSize];
        for (int y = 0; y < dist.length; ++y) {
            for (int x = 0; x < dist[y].length; ++x) {
                dist[y][x] = Double.MAX_VALUE;
            }
        }
        boolean[][] inQ = new boolean[this.size.gridSize][this.size.gridSize];
        LinkedList<int[]> q = new LinkedList<int[]>();
        dist[loc.y][loc.x] = 0.0;
        q.add(new int[]{loc.x, loc.y});
        inQ[loc.y][loc.x] = true;
        while (!q.isEmpty()) {
            int[] pt = (int[])q.pollFirst();
            int x = pt[0];
            int y = pt[1];
            inQ[y][x] = false;
            for (int dy = -1; dy < 2; ++dy) {
                for (int dx = -1; dx < 2; ++dx) {
                    double newDist;
                    int xx = x + dx;
                    int yy = y + dy;
                    if (yy < 0 || yy >= dist.length || xx < 0 || xx >= dist[0].length || this.resistance[yy][xx] >= 10000.0) continue;
                    if (allowedTerritories != null) {
                        boolean allowed = false;
                        for (int ti = 0; ti < allowedTerritories.length; ++ti) {
                            if (this.cityOwnership[yy][xx] != allowedTerritories[ti]) continue;
                            allowed = true;
                            break;
                        }
                        if (!allowed) continue;
                    }
                    if (!((newDist = (dx == 0 || dy == 0 ? 1.0 : 1.4) * this.resistance[yy][xx] + dist[y][x]) < dist[yy][xx])) continue;
                    int n = allowedTerritories == null ? 2000 : 3000;
                    if (!(newDist < (double)n)) continue;
                    dist[yy][xx] = newDist;
                    if (inQ[yy][xx]) continue;
                    inQ[yy][xx] = true;
                    q.add(new int[]{xx, yy});
                }
            }
        }
        return dist;
    }

    private void findRoadOverlaps() {
        for (Road road : this.roads) {
            road.overlaps.clear();
            for (int[] pt : road.intPath) {
                HashMap<Road, Integer> m = new HashMap<Road, Integer>();
                road.overlaps.add(m);
                block2: for (Road r2 : this.roads) {
                    for (int pi = 0; pi < r2.path.size(); ++pi) {
                        int[] pt2 = r2.intPath.get(pi);
                        if (pt[0] != pt2[0] || pt[1] != pt2[1]) continue;
                        m.put(r2, pi);
                        continue block2;
                    }
                }
            }
            if (road.overlaps.size() == road.path.size()) continue;
            System.out.println("len mismatch!");
        }
    }

    public boolean doSetup() {
        int index = this.stageIndex;
        for (SetupStage ss : this.setupStages) {
            if (index < ss.getSize()) {
                this.g.tickClients();
                ss.run(index, this);
                ++this.stageIndex;
                return false;
            }
            index -= ss.getSize();
        }
        return true;
    }

    private HashMap<City, ArrayList<City>> determineBorders() {
        HashMap<City, ArrayList<City>> borderings = new HashMap<City, ArrayList<City>>();
        for (int y = 0; y < this.cityOwnership.length; ++y) {
            for (int x = 0; x < this.cityOwnership[0].length; ++x) {
                int owner = this.cityOwnership[y][x];
                if (owner == -1) continue;
                for (int dy = -1; dy < 2; ++dy) {
                    for (int dx = -1; dx < 2; ++dx) {
                        int otherOwner;
                        int xx = x + dx;
                        int yy = y + dy;
                        if (yy < 0 || yy >= this.cityOwnership.length || xx < 0 || xx >= this.cityOwnership[0].length || (otherOwner = this.cityOwnership[yy][xx]) == -1 || otherOwner == owner) continue;
                        City e1 = this.getCity(owner);
                        City e2 = this.getCity(otherOwner);
                        if (!borderings.containsKey(e1)) {
                            borderings.put(e1, new ArrayList());
                        }
                        if (borderings.get(e1).contains(e2)) continue;
                        borderings.get(e1).add(e2);
                    }
                }
            }
        }
        return borderings;
    }

    static int scaled(int baseline) {
        return StrictMath.max(1, baseline / 8);
    }

    static int scaledSq(int baseline) {
        return StrictMath.max(1, baseline / 8 / 8);
    }

    public WorldMap(long seed, MapSize size, DifficultyLevel dl, AirshipGame g, List<StrategicSetupInfo> setupInfos, Locale lang, SeaLevelSetting seaLevelSetting, MonsterSetting monsterity, TechSpeedSetting techSpeed, int startingTechTier, boolean strategicRapidCommands) {
        this.g = g;
        this.r = new Random(seed);
        this.size = size;
        this.difficulty = dl;
        this.setupInfos = setupInfos;
        this.lang = lang;
        this.seaLevelSetting = seaLevelSetting;
        this.monsterity = monsterity;
        this.techSpeed = techSpeed;
        this.startingTechTier = startingTechTier;
        this.strategicRapidCommands = strategicRapidCommands;
    }

    private int money(boolean isPlayerControlled, City city, Random r) {
        return 2500 + r.nextInt(500);
    }

    private int townIncome(boolean isPlayerControlled, City city, Random r) {
        return 15 + r.nextInt(15);
    }

    private int income(boolean isPlayerControlled, City city, Random r) {
        if (isPlayerControlled) {
            return this.difficulty.playerIncome;
        }
        return 50 + r.nextInt(40);
    }

    private int shipyardLevel(boolean isPlayerControlled, City city) {
        if (isPlayerControlled) {
            return this.difficulty.playerShipyardLevel;
        }
        return 1 + this.r.nextInt(City.SHIPYARD_SIZES.length - 1);
    }

    private double[][] genGrid(Random r, MapSize size) {
        Perlin p = new Perlin(r);
        this.water = new boolean[size.gridSize][size.gridSize];
        double[][] height = new double[size.gridSize][size.gridSize];
        for (int y = 0; y < size.gridSize; ++y) {
            for (int x = 0; x < size.gridSize; ++x) {
                height[y][x] = 1.0 - (p.pnoise((double)x * 0.01 * 256.0 / (double)size.gridSize, (double)y * 0.01 * 256.0 / (double)size.gridSize, 0.0) + p.pnoise((double)(x - y) * 0.01 * 256.0 / (double)size.gridSize, (double)x * 0.02 * 256.0 / (double)size.gridSize, (double)y * 0.02 * 256.0 / (double)size.gridSize) + (double)(x + y) * this.seaLevelSetting.tilt * 256.0 / (double)size.gridSize + p.pnoise((double)x * 0.02 * 8.0 + 908.0, (double)y * 0.02 * 8.0 + 9018.0, 0.00176 * (double)y) * 0.2);
                this.water[y][x] = height[y][x] < this.seaLevelSetting.boundary;
            }
        }
        LinkedList<int[]> q = new LinkedList<int[]>();
        byte[][] visited = new byte[this.water.length][this.water[0].length];
        byte id = 0;
        for (int y = 0; y < this.water.length; ++y) {
            for (int x = 0; x < this.water[0].length; ++x) {
                if (!this.water[y][x] || visited[y][x] != 0) continue;
                boolean atEdge = false;
                visited[y][x] = id = (byte)((byte)(id + 1));
                q.add(new int[]{x, y});
                while (!q.isEmpty()) {
                    int[] xy = (int[])q.pop();
                    int qx = xy[0];
                    int qy = xy[1];
                    if (qx == 0 || qx == this.water[0].length - 1 || qy == 0 || qy == this.water.length - 1) {
                        atEdge = true;
                    }
                    for (int dy = -1; dy < 2; ++dy) {
                        if (qy + dy < 0 || qy + dy >= this.water.length) continue;
                        for (int dx = -1; dx < 2; ++dx) {
                            if (qx + dx < 0 || qx + dx >= this.water[0].length || !this.water[qy + dy][qx + dx] || visited[qy + dy][qx + dx] != 0) continue;
                            visited[qy + dy][qx + dx] = id;
                            q.add(new int[]{qx + dx, qy + dy});
                        }
                    }
                }
                if (atEdge) continue;
                for (int y2 = 0; y2 < this.water.length; ++y2) {
                    for (int x2 = 0; x2 < this.water[0].length; ++x2) {
                        if (visited[y2][x2] != id) continue;
                        this.water[y2][x2] = false;
                    }
                }
            }
        }
        return height;
    }

    private Utils.Pair<Integer, Integer> findMapLocationSpot(Random r, int minDist, Empire closestToCapital) {
        Utils.Pair p;
        int iters = 0;
        block0: while (true) {
            if (iters++ >= 12000) {
                return null;
            }
            if (iters % 1000 == 0) {
                minDist = StrictMath.max(2, minDist / 2);
            }
            p = new Utils.Pair((Object)(WorldMap.scaled(40) + r.nextInt(this.water[0].length - WorldMap.scaled(200))), (Object)(3 + r.nextInt(this.water.length - WorldMap.scaled(100))));
            if (this.water[(Integer)p.b][(Integer)p.a]) continue;
            block1: for (int dy = -WorldMap.scaled(40); dy < WorldMap.scaled(40) + 1; ++dy) {
                for (int dx = -WorldMap.scaled(40); dx < WorldMap.scaled(40) + 1; ++dx) {
                    int xx = (Integer)p.a + dx;
                    int yy = (Integer)p.b + dy;
                    if (xx < WorldMap.scaled(40) || xx >= this.size.gridSize - WorldMap.scaled(40) || yy < WorldMap.scaled(40) || yy >= this.size.gridSize - WorldMap.scaled(40) || this.water[yy][xx]) continue;
                    for (int dy2 = -1; dy2 < 2; ++dy2) {
                        for (int dx2 = -1; dx2 < 2; ++dx2) {
                            int xxx = xx + dx2;
                            int yyy = yy + dy2;
                            if (xxx < 0 || xxx >= this.size.gridSize || yyy < 0 || yyy >= this.size.gridSize || !this.water[yyy][xxx]) continue;
                            p = new Utils.Pair((Object)xx, (Object)yy);
                            break block1;
                        }
                    }
                }
            }
            if (this.water[(Integer)p.b][(Integer)p.a]) continue;
            City closestCity = null;
            double closestCityDSq = 0.0;
            for (Empire em : this.empires) {
                for (City c : em.cities) {
                    double dSq = (c.x - (Integer)p.a) * (c.x - (Integer)p.a) + (c.y - (Integer)p.b) * (c.y - (Integer)p.b);
                    if (closestCity == null || closestCityDSq > dSq) {
                        closestCity = c;
                        closestCityDSq = dSq;
                    }
                    if (!(dSq < (double)(minDist * minDist))) continue;
                    continue block0;
                }
            }
            if (closestToCapital != null) {
                City c = closestToCapital.cities.get(0);
                if (iters < 5000 && closestCity != null && closestCity != c) continue;
                double capitalDist = (c.x - (Integer)p.a) * (c.x - (Integer)p.a) + (c.y - (Integer)p.b) * (c.y - (Integer)p.b);
                if (iters < 8000 && closestCity != null && closestCityDSq * 4.0 < capitalDist) continue;
            }
            for (TerrainFeature f : this.features) {
                if ((f.x - (Integer)p.a) * (f.x - (Integer)p.a) + (f.y - (Integer)p.b) * (f.y - (Integer)p.b) >= WorldMap.scaledSq(400)) continue;
                continue block0;
            }
            for (MonsterNest n : this.nests) {
                if ((n.x - (Integer)p.a) * (n.x - (Integer)p.a) + (n.y - (Integer)p.b) * (n.y - (Integer)p.b) >= minDist * minDist) continue;
                continue block0;
            }
            break;
        }
        return p;
    }

    public WorldMap(JSONObject o, AirshipGame g) {
        int i;
        int i2;
        this.g = g;
        this.fleetIDCounter = o.optInt("fleetIDCounter", 1);
        this.difficulty = DifficultyLevel.ofName(o.optString("difficulty", "NORMAL"));
        this.r = new Random(o.optLong("currentSeed", 12345L));
        this.lang = Locale.forLanguageTag(o.getString("lang"));
        this.smartEmpireIndex = o.optInt("smartEmpireIndex", 0);
        this.smartNestIndex = o.optInt("smartNestIndex");
        this.monsterity = MonsterSetting.ofName(o.optString("monsterity", "DEFAULT"));
        this.techSpeed = TechSpeedSetting.ofName(o.optString("techSpeed", "NORMAL"));
        this.timeSinceAIAttackVsHuman = o.optInt("timeSinceAIAttackVsHuman", 0);
        this.strategicRapidCommands = o.optBoolean("strategicRapidCommands", false);
        HashMap[] mappingRef = new HashMap[]{LandBlockType.getMapping(o)};
        JSONArray a = o.getJSONArray("empires");
        for (i2 = 0; i2 < a.length(); ++i2) {
            this.empires.add(new Empire(a.getJSONObject(i2), this, mappingRef));
        }
        if (o.has("nests")) {
            JSONArray ns = o.getJSONArray("nests");
            for (i = 0; i < ns.length(); ++i) {
                this.nests.add(new MonsterNest(ns.getJSONObject(i), this, mappingRef));
            }
        }
        for (i2 = 0; i2 < a.length(); ++i2) {
            this.empires.get(i2).finish(a.getJSONObject(i2), this);
        }
        a = o.has("_terrainFeatures") ? new JSONArray(Compression.decompressFromString(o.getString("_terrainFeatures"))) : o.getJSONArray("terrainFeatures");
        for (i2 = 0; i2 < a.length(); ++i2) {
            JSONObject f = a.getJSONObject(i2);
            this.features.add(new TerrainFeature(TerrainFeatureType.valueOf(f.getString("type")), f.getInt("x"), f.getInt("y")));
        }
        JSONObject o2 = o.has("_water") ? new JSONObject(Compression.decompressFromString(o.getString("_water"))) : o.getJSONObject("water");
        this.water = this.fromBitString(o2);
        a = o.has("_roads") ? new JSONArray(Compression.decompressFromString(o.getString("_roads"))) : o.getJSONArray("roads");
        for (i = 0; i < a.length(); ++i) {
            this.roads.add(new Road(a.getJSONObject(i), this));
        }
        a = o.getJSONArray("empires");
        for (i = 0; i < a.length(); ++i) {
            this.empires.get(i).finishFleets(a.getJSONObject(i), this);
        }
        if (o.has("nests")) {
            a = o.getJSONArray("nests");
            for (i = 0; i < a.length(); ++i) {
                this.nests.get(i).finishFleets(a.getJSONObject(i), this);
            }
        }
        o2 = o.has("_cityOwnership") ? new JSONObject(Compression.decompressFromString(o.getString("_cityOwnership"))) : o.getJSONObject("cityOwnership");
        this.cityOwnership = this.fromIntString(o2);
        this.age = o.optInt("age", 0);
        this.villainDesignated = o.optBoolean("villainDesignated", false);
        this.timeUntilMergePossible = o.optInt("timeUntilMergePossible", 120000);
        this.height = new double[this.water.length][this.water[0].length];
        JSONArray heightValues = o.has("_height") ? new JSONArray(Compression.decompressFromString(o.getString("_height"))) : o.getJSONArray("height");
        for (int y = 0; y < this.height.length; ++y) {
            for (int x = 0; x < this.height.length; ++x) {
                this.height[y][x] = heightValues.getDouble(x + y * this.height[0].length);
            }
        }
        this.findRoadOverlaps();
        Utils.Pair<ArrayList<ShapeUtils.Area>, ArrayList<ShapeUtils.Area>> areas = ShapeUtils.allAreas(this.water, this.cityOwnership);
        this.landBoundaries = (ArrayList)areas.a;
        this.cityOwnershipAreas = (ArrayList)areas.b;
    }

    private boolean[][] fromBitString(JSONObject o) {
        int yl = o.getInt("yl");
        int xl = o.getInt("xl");
        String raw = o.getString("data");
        boolean[][] data = new boolean[yl][xl];
        for (int y = 0; y < data.length; ++y) {
            for (int x = 0; x < data[0].length; ++x) {
                data[y][x] = raw.charAt(y * xl + x) == '1';
            }
        }
        return data;
    }

    private JSONObject toBitString(boolean[][] data) {
        JSONObject o = new JSONObject();
        o.put("yl", data.length);
        o.put("xl", data[0].length);
        StringBuilder sb = new StringBuilder();
        for (int y = 0; y < data.length; ++y) {
            for (int x = 0; x < data[0].length; ++x) {
                sb.append(data[y][x] ? "1" : "0");
            }
        }
        o.put("data", sb.toString());
        return o;
    }

    private JSONObject toIntString(int[][] data) {
        JSONObject o = new JSONObject();
        o.put("yl", data.length);
        o.put("xl", data[0].length);
        StringBuilder sb = new StringBuilder();
        for (int y = 0; y < data.length; ++y) {
            for (int x = 0; x < data[0].length; ++x) {
                sb.append(data[y][x]).append(" ");
            }
        }
        o.put("data", sb.toString());
        return o;
    }

    private int[][] fromIntString(JSONObject o) {
        int h = o.getInt("yl");
        int w = o.getInt("xl");
        int[][] d = new int[h][w];
        String[] raw = o.getString("data").split(" ");
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                d[y][x] = Integer.parseInt(raw[y * w + x]);
            }
        }
        return d;
    }

    public void calcRoadDistancesToEnemy(Empire myEmpire) {
        LinkedList<MapLocation> q = new LinkedList<MapLocation>();
        int esz = this.empires.size();
        for (int ei = 0; ei < esz; ++ei) {
            Empire e = this.empires.get(ei);
            int csz = e.cities.size();
            for (int ci = 0; ci < csz; ++ci) {
                City c = e.cities.get(ci);
                if (e == myEmpire) {
                    c.roadDistanceToEnemy = 10000;
                    continue;
                }
                c.roadDistanceToEnemy = 0;
                q.add(c);
            }
        }
        int nsz = this.nests.size();
        for (int ni = 0; ni < nsz; ++ni) {
            MonsterNest n = this.nests.get(ni);
            if (n.type == null) {
                n.roadDistanceToEnemy = 10000;
                continue;
            }
            n.roadDistanceToEnemy = 0;
            q.add(n);
        }
        while (!q.isEmpty()) {
            MapLocation l = (MapLocation)q.pop();
            int rsz = this.roads.size();
            for (int ri = 0; ri < rsz; ++ri) {
                int newDist;
                Road r = this.roads.get(ri);
                if (r.seaRoute) continue;
                MapLocation connection = null;
                if (r.src == l) {
                    connection = r.dst;
                } else if (r.dst == l) {
                    connection = r.src;
                }
                if (connection == null || (newDist = l.roadDistanceToEnemy + 1) >= connection.roadDistanceToEnemy) continue;
                connection.roadDistanceToEnemy = newDist;
                if (q.contains(connection)) continue;
                q.add(connection);
            }
        }
    }

    public void designateVillain() {
        if (!this.villainDesignated && this.age > 90000) {
            for (Empire e : this.empires) {
                if (e.playerControlled || e.cities.size() <= 7) continue;
                return;
            }
            Empire villain = this.empires.get(this.empires.size() - 1);
            if (!villain.playerControlled) {
                villain.cities.get((int)0).income += 30;
                villain.money += 2000;
                villain.aggressiveness += 0.5;
            }
            this.villainDesignated = true;
            System.out.println("Designated villain: " + villain.name);
        }
    }

    public void considerMerger() {
        int strongest = 0;
        for (Empire e : this.empires) {
            int strength = e.getStrength(this);
            if (!e.playerControlled) {
                strength /= 2;
            }
            strongest = StrictMath.max(strongest, strength);
        }
        Empire e1 = null;
        Empire e2 = null;
        int sharedStrength = 0;
        for (Empire c1 : this.empires) {
            for (Empire c2 : this.empires) {
                if (c1 == c2 || c1.playerControlled || c2.playerControlled) continue;
                boolean isConnected = false;
                for (City city1 : c1.cities) {
                    for (City city2 : c2.cities) {
                        isConnected |= this.connected(city1, city2);
                    }
                }
                if (!isConnected) continue;
                int str1 = c1.getStrength(this);
                int str2 = c2.getStrength(this);
                if ((double)str1 > (double)strongest * this.difficulty.mergeUrgency || (double)str2 > (double)strongest * this.difficulty.mergeUrgency || e1 != null && str1 + str2 >= sharedStrength) continue;
                e1 = str1 > str2 ? c1 : c2;
                e2 = str1 > str2 ? c2 : c1;
                sharedStrength = str1 + str2;
            }
        }
        if (e1 != null) {
            CoatOfArms newCOA = e1.mergedArms(e2, this);
            this.merger = new MergerInfo(e1.name, e2.name, e1.name + "-" + e2.name, e1.arms, e2.arms, newCOA);
            e1.name = e1.mergedNames(e2, this);
            e1.arms = newCOA;
            e1.money += e2.money;
            e1.cities.addAll(e2.cities);
            e1.getFleets().addAll(e2.getFleets());
            e1.spies.addAll(e2.spies);
            e1.numAllianceMembers += e2.numAllianceMembers;
            for (Tech.Choice choice : e2.techs) {
                boolean hasItAlready = false;
                for (Tech.Choice anyC : choice.tech.choices) {
                    if (!e1.techs.contains(anyC)) continue;
                    hasItAlready = true;
                    break;
                }
                if (hasItAlready) continue;
                e1.techs.add(choice);
                e1.bonuses.addAll(choice.bonuses);
            }
            for (City city : e2.cities) {
                if (city.originalEmpire != e2) continue;
                city.originalEmpire = e1;
            }
            this.empires.remove(e2);
            this.timeUntilMergePossible = 300000;
        } else {
            this.timeUntilMergePossible = 30000;
        }
        System.out.println("---------------------------");
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put("currentSeed", AGame.getSeed(this.r));
        o.put("lang", this.lang.toLanguageTag());
        o.put("monsterity", this.monsterity.name);
        o.put("techSpeed", this.techSpeed.name);
        o.put("timeSinceAIAttackVsHuman", this.timeSinceAIAttackVsHuman);
        o.put("strategicRapidCommands", this.strategicRapidCommands);
        LandBlockType.writeMapping(o);
        JSONArray a = new JSONArray();
        o.put("empires", a);
        for (Empire e : this.empires) {
            a.put(e.toJSON(this));
        }
        o.put("smartEmpireIndex", this.smartEmpireIndex);
        a = new JSONArray();
        o.put("nests", a);
        for (MonsterNest n : this.nests) {
            a.put(n.toJSON(this));
        }
        o.put("smartNestIndex", this.smartNestIndex);
        a = new JSONArray();
        for (TerrainFeature tf : this.features) {
            a.put(new JSONObject().put("type", tf.type.name()).put("x", tf.x).put("y", tf.y));
        }
        o.put("_terrainFeatures", Compression.compressToString(a.toString()));
        o.put("_water", Compression.compressToString(this.toBitString(this.water).toString()));
        a = new JSONArray();
        for (int y = 0; y < this.height.length; ++y) {
            for (int x = 0; x < this.height[y].length; ++x) {
                a.put(this.height[y][x]);
            }
        }
        o.put("_height", Compression.compressToString(a.toString()));
        a = new JSONArray();
        for (Road road : this.roads) {
            a.put(road.toJSON(this));
        }
        o.put("_roads", Compression.compressToString(a.toString()));
        o.put("_cityOwnership", Compression.compressToString(this.toIntString(this.cityOwnership).toString()));
        o.put("age", this.age);
        o.put("villainDesignated", this.villainDesignated);
        o.put("timeUntilMergePossible", this.timeUntilMergePossible);
        return o;
    }

    private strictfp static class LocPairDistCmp
    implements Comparator<MapLocation[]> {
        private LocPairDistCmp() {
        }

        @Override
        public int compare(MapLocation[] o1, MapLocation[] o2) {
            int d1 = (o1[0].x - o1[1].x) * (o1[0].x - o1[1].x) + (o1[0].y - o1[1].y) * (o1[0].y - o1[1].y);
            int d2 = (o2[0].x - o2[1].x) * (o2[0].x - o2[1].x) + (o2[0].y - o2[1].y) * (o2[0].y - o2[1].y);
            return d1 - d2;
        }
    }

    public strictfp static final class NavNode {
        public int x;
        public int y;
        public final ArrayList<NavNode> adjacent = new ArrayList();
        public transient double dist;
        public int uses;

        public NavNode(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    private static interface SetupStage {
        public String getDesc(int var1);

        public int getSize();

        public void run(int var1, WorldMap var2);
    }

    public strictfp static class TerrainFeature {
        TerrainFeatureType type;
        public int x;
        public int y;

        public TerrainFeature(TerrainFeatureType type, int x, int y) {
            this.type = type;
            this.x = x;
            this.y = y;
        }
    }

    public strictfp static enum TerrainFeatureType {
        MOUNTAIN,
        FOREST,
        SWAMP,
        SEA_CREATURES;

    }

    public strictfp static final class MergerInfo {
        public final String nameA;
        public final String nameB;
        public final String nameM;
        public final CoatOfArms armsA;
        public final CoatOfArms armsB;
        public final CoatOfArms armsM;

        public MergerInfo(String nameA, String nameB, String nameM, CoatOfArms armsA, CoatOfArms armsB, CoatOfArms armsM) {
            this.nameA = nameA;
            this.nameB = nameB;
            this.nameM = nameM;
            this.armsA = armsA;
            this.armsB = armsB;
            this.armsM = armsM;
        }
    }
}

