/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.LoadingQuote;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public strictfp class WorldGenScreen
implements Screen {
    public CampaignWorld w;
    public AirshipGame g;
    public boolean drawn = false;
    public LoadingQuote.Quote quote;

    public WorldGenScreen(CampaignWorld w, AirshipGame g) {
        this.w = w;
        this.g = g;
        this.quote = LoadingQuote.getRandom();
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        try {
            this.w.map.campaignWorldDuringGen = this.w;
            if (this.drawn && this.w.map.doSetup()) {
                this.w.setupPlayer();
                this.w.map.campaignWorldDuringGen = null;
                this.g.s = new StrategicScreen(this.g, this.w);
            }
        }
        catch (OutOfMemoryError e) {
            this.w = null;
            Runtime.getRuntime().gc();
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.MAIN);
            this.g.showError(Lang._t("worldgen_out_of_memory", new Object[0]));
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(MyDraw.SCREEN_BG, sm);
        d.text(MyDraw.TITLE_C + this.w.map.getSetupStageDesc(), AGame.BIG_FOUNT, (int)((double)(sm.width / 2) - d.textSize((String)this.w.map.getSetupStageDesc(), (Fount)AGame.BIG_FOUNT).x / 2.0), sm.height / 3);
        d.progressBar(sm.width / 2 - 100, sm.height / 3 + AGame.BIG_FOUNT.height + MyDraw.UI_SPACING, 200, (double)this.w.map.getSetupProgress() * 1.0 / (double)this.w.map.getSetupLength());
        this.drawn = true;
        int scholarSize = 192;
        switch (this.g.currentGUIScale) {
            case MEDIUM: {
                scholarSize = 256;
                break;
            }
            case LARGE: {
                scholarSize = 512;
            }
        }
        int progressEndY = sm.height / 3 + AGame.BIG_FOUNT.height + MyDraw.UI_SPACING + MyDraw.PROGRESS_BAR_H;
        int y = progressEndY + MyDraw.UI_SPACING * 3;
        d.drawWindow(sm.width / 2 - scholarSize - MyDraw.UI_SPACING / 2 - MyDraw.WINDOW_INSET, y, scholarSize * 2 + MyDraw.UI_SPACING + MyDraw.WINDOW_INSET * 2, scholarSize + MyDraw.WINDOW_INSET * 2);
        d.blit(this.quote.img, sm.width / 2 - scholarSize - MyDraw.UI_SPACING / 2, y += MyDraw.WINDOW_INSET, scholarSize, scholarSize);
        d.drawPanelBorder(sm.width / 2 - scholarSize - MyDraw.UI_SPACING / 2, y, scholarSize, scholarSize);
        d.text(Lang._t(this.quote.text, new Object[0]), AGame.FOUNT, sm.width / 2 + MyDraw.UI_SPACING / 2, y, scholarSize);
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

