/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.ParticleType;
import org.json.JSONObject;

public strictfp class WeatherEffect
extends Loadable {
    public final double shootJitterMult;
    public final double shootToRightJitterMult;
    public final double shootToLeftJitterMult;
    public final double fireExtinguishChance;
    public final double wind;
    public final boolean lightning;
    public final boolean fog;
    public final ParticleType groundImpactParticle;
    public final int numGroundImpactParticles;
    public final Appearance icon;
    public final Appearance icon2;
    public final boolean rain;
    public final boolean snow;
    public final boolean fewStars;
    public final boolean manyStars;

    public WeatherEffect(JSONObject o) {
        super(o.getString("name"));
        this.shootJitterMult = o.optDouble("shootJitterMult", 1.0);
        this.shootToRightJitterMult = o.optDouble("shootToRightJitterMult", 1.0);
        this.shootToLeftJitterMult = o.optDouble("shootToLeftJitterMult", 1.0);
        this.fireExtinguishChance = o.optDouble("fireExtinguishChance", 0.0);
        this.wind = o.optDouble("wind", 0.0);
        this.lightning = o.optBoolean("lightning", false);
        this.rain = o.optBoolean("rain", false);
        this.snow = o.optBoolean("snow", false);
        this.fog = o.optBoolean("fog", false);
        this.fewStars = o.optBoolean("fewStars", false);
        this.manyStars = o.optBoolean("manyStars", false);
        this.groundImpactParticle = ParticleType.ofName(o.getString("groundImpactParticle"));
        this.numGroundImpactParticles = o.getInt("numGroundImpactParticles");
        this.icon = o.has("icon") ? new Appearance(o.getJSONObject("icon")) : null;
        this.icon2 = o.has("icon2") ? new Appearance(o.getJSONObject("icon2")) : null;
    }

    public String getEffectTooltip() {
        return Lang._t("weather_" + this.name + "_tooltip", new Object[0]);
    }

    public static WeatherEffect ofName(String name) {
        return Loadable.ofName(WeatherEffect.class, name);
    }
}

