/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.BonusableValue;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.SoundEffect;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class WeaponAppearance {
    public Appearance back;
    public Img[] shot;
    public int shotAnimationInterval = 150;
    public Img barrel;
    public Img externalBarrel;
    public Img flippedbarrel;
    public Img externalFlippedbarrel;
    public BarrelAnimation barrelAnimation;
    public BarrelAnimation externalBarrelAnimation;
    public BarrelAnimation flippedBarrelAnimation;
    public BarrelAnimation externalFlippedBarrelAnimation;
    public Pt barrelOffset;
    public Pt flippedBarrelOffset;
    public double recoil;
    public double hitExplosionSize;
    public double missExplosionSize;
    public Particle.Emitter shotEmitter;
    public ShotExhaustEmitter exhaust;
    public ParticleType impactParticle;
    public int numImpactParticles;
    public ArrayList<Shell> shells = new ArrayList();

    public WeaponAppearance(JSONObject o, int moduleW) {
        int i;
        ArrayList<Img> frames;
        JSONObject bao;
        int i2;
        JSONArray a;
        if (o.has("back")) {
            this.back = new Appearance(o.getJSONObject("back"));
        }
        if (o.has("shot")) {
            this.shot = new Img[]{ModuleType.img(o.getJSONObject("shot"))};
        }
        if (o.has("shotFrames")) {
            a = o.getJSONArray("shotFrames");
            this.shot = new Img[a.length()];
            for (i2 = 0; i2 < a.length(); ++i2) {
                this.shot[i2] = ModuleType.img(a.getJSONObject(i2));
            }
        }
        this.shotAnimationInterval = o.optInt("shotAnimationInterval", 150);
        this.hitExplosionSize = o.optDouble("hitExplosionSize", 0.0);
        this.missExplosionSize = o.optDouble("missExplosionSize", 0.0);
        if (o.has("barrel")) {
            this.barrel = ModuleType.img(o.getJSONObject("barrel"));
            this.flippedbarrel = this.barrel.flip();
        } else if (o.has("barrelAnimation")) {
            bao = o.getJSONObject("barrelAnimation");
            JSONArray framesA = bao.getJSONArray("frames");
            frames = new ArrayList<Img>();
            for (i = 0; i < framesA.length(); ++i) {
                frames.add(ModuleType.img(framesA.getJSONObject(i)));
            }
            this.barrelAnimation = new BarrelAnimation(bao.getInt("interval"), bao.optInt("msPerShot", -1), bao.optBoolean("loop", false), bao.optBoolean("loopConstantly", false), bao.optBoolean("finishLoopCycle", false), frames);
            this.flippedBarrelAnimation = this.barrelAnimation.flip();
        }
        if (o.has("externalBarrel")) {
            this.externalBarrel = ModuleType.img(o.getJSONObject("externalBarrel"));
            this.externalFlippedbarrel = this.externalBarrel.flip();
        } else if (o.has("externalBarrelAnimation")) {
            bao = o.getJSONObject("externalBarrelAnimation");
            JSONArray framesA = bao.getJSONArray("frames");
            frames = new ArrayList();
            for (i = 0; i < framesA.length(); ++i) {
                frames.add(ModuleType.img(framesA.getJSONObject(i)));
            }
            this.externalBarrelAnimation = new BarrelAnimation(bao.getInt("interval"), bao.optInt("msPerShot", -1), bao.optBoolean("loop", false), bao.optBoolean("loopConstantly", false), bao.optBoolean("finishLoopCycle", false), frames);
            this.externalFlippedBarrelAnimation = this.externalBarrelAnimation.flip();
        }
        if (o.has("barrelX")) {
            this.barrelOffset = new Pt(o.getDouble("barrelX"), o.getDouble("barrelY"));
            Img b = this.barrel != null ? this.barrel : this.barrelAnimation.frames.get(0);
            this.flippedBarrelOffset = new Pt((double)(moduleW * 16) - this.barrelOffset.x - (double)b.srcWidth, this.barrelOffset.y);
        }
        this.recoil = o.optDouble("recoil", 0.0);
        if (o.has("shotEmitter")) {
            JSONObject em = o.getJSONObject("shotEmitter");
            SoundEffect ef = null;
            if (em.has("sound")) {
                try {
                    String sound = em.getString("sound");
                    ef = new SoundEffect(sound, em.optDouble("volume"));
                }
                catch (Exception e) {
                    ef = new SoundEffect(em.getJSONObject("sound"));
                }
            }
            this.shotEmitter = new Particle.Emitter(ParticleType.ofName(em.getString("type")), em.getDouble("emitProbability"), em.optInt("numParticles", 1), ef);
        }
        if (o.has("exhaust")) {
            JSONObject e = o.getJSONObject("exhaust");
            this.exhaust = new ShotExhaustEmitter(ParticleType.ofName(e.getString("type")), e.getDouble("p"), e.getDouble("backOffset"), e.getDouble("angleRange"), e.getDouble("randomOffset"), e.getDouble("speedMin"), e.getDouble("speedMax"));
        }
        this.impactParticle = ParticleType.ofName(o.optString("impactParticle", "impact"));
        this.numImpactParticles = o.optInt("numImpactParticles", 0);
        if (o.has("shells")) {
            a = o.getJSONArray("shells");
            for (i2 = 0; i2 < a.length(); ++i2) {
                this.shells.add(new Shell(a.getJSONObject(i2)));
            }
        }
    }

    public WeaponAppearance exhaust(ShotExhaustEmitter exhaust) {
        this.exhaust = exhaust;
        return this;
    }

    public WeaponAppearance back(Appearance back) {
        this.back = back;
        return this;
    }

    public WeaponAppearance barrel(Img barrel, Pt barrelOffset, int w) {
        this.barrel = barrel;
        this.barrelOffset = barrelOffset;
        this.flippedbarrel = barrel.flip();
        this.flippedBarrelOffset = new Pt((double)(w * 16) - barrelOffset.x - (double)barrel.srcWidth, barrelOffset.y);
        return this;
    }

    public WeaponAppearance recoil(double recoil) {
        this.recoil = recoil;
        return this;
    }

    public WeaponAppearance shotEmitter(Particle.Emitter shotEmitter) {
        this.shotEmitter = shotEmitter;
        return this;
    }

    private WeaponAppearance() {
    }

    public WeaponAppearance flipped(int w) {
        WeaponAppearance wa2 = new WeaponAppearance();
        Appearance appearance = wa2.back = this.back == null ? null : this.back.flip();
        if (this.barrel != null) {
            wa2.barrel = this.flippedbarrel;
            wa2.flippedbarrel = this.barrel;
            wa2.barrelOffset = this.flippedBarrelOffset;
            wa2.flippedBarrelOffset = this.barrelOffset;
        }
        if (this.barrelAnimation != null) {
            wa2.barrelAnimation = this.flippedBarrelAnimation;
            wa2.flippedBarrelAnimation = this.barrelAnimation;
            wa2.barrelOffset = this.flippedBarrelOffset;
            wa2.flippedBarrelOffset = this.barrelOffset;
        }
        if (this.externalBarrel != null) {
            wa2.externalBarrel = this.externalFlippedbarrel;
            wa2.externalFlippedbarrel = this.externalBarrel;
            wa2.barrelOffset = this.flippedBarrelOffset;
            wa2.flippedBarrelOffset = this.barrelOffset;
        }
        if (this.externalBarrelAnimation != null) {
            wa2.externalBarrelAnimation = this.externalFlippedBarrelAnimation;
            wa2.externalFlippedBarrelAnimation = this.externalBarrelAnimation;
            wa2.barrelOffset = this.flippedBarrelOffset;
            wa2.flippedBarrelOffset = this.barrelOffset;
        }
        wa2.recoil = this.recoil;
        wa2.shot = this.shot;
        wa2.shotEmitter = this.shotEmitter;
        wa2.exhaust = this.exhaust;
        wa2.impactParticle = this.impactParticle;
        wa2.numImpactParticles = this.numImpactParticles;
        for (Shell s : this.shells) {
            wa2.shells.add(s.flipped(w));
        }
        return wa2;
    }

    public strictfp static class ShotExhaustEmitter {
        public final ParticleType type;
        public final double p;
        public final double backOffset;
        public final double angleRange;
        public final double randomOffset;
        public final double speedMin;
        public final double speedMax;

        public ShotExhaustEmitter(ParticleType type, double p, double backOffset, double angleRange, double randomOffset, double speedMin, double speedMax) {
            this.type = type;
            this.p = p;
            this.backOffset = backOffset;
            this.angleRange = angleRange;
            this.randomOffset = randomOffset;
            this.speedMin = speedMin;
            this.speedMax = speedMax;
        }

        public void emit(Shot shot, int ms, LinkedList<Particle> particles) {
            if (this.p < 1.0 && AGame.ANIM_R.nextDouble() > (double)ms * this.p) {
                return;
            }
            int nParticles = (int)StrictMath.ceil((double)ms * this.p);
            double shotAngle = StrictMath.atan2(shot.tY - shot.sY, shot.tX - shot.sX);
            double baseXOffset = StrictMath.cos(shotAngle) * -this.backOffset;
            double baseYOffset = StrictMath.sin(shotAngle) * -this.backOffset;
            for (int i = 0; i < nParticles; ++i) {
                int shotTime = shot.time - i * ms / nParticles;
                double shotX = shot.sX + (shot.tX - shot.sX) * (double)shotTime / (double)shot.travelTime;
                double shotY = shot.sY + (shot.tY - shot.sY) * (double)shotTime / (double)shot.travelTime;
                double xOffset = baseXOffset + (AGame.ANIM_R.nextDouble() - 0.5) * this.randomOffset;
                double yOffset = baseYOffset + (AGame.ANIM_R.nextDouble() - 0.5) * this.randomOffset;
                double angle = shotAngle + (AGame.ANIM_R.nextDouble() - 0.5) * this.angleRange;
                double speed = this.speedMin + AGame.ANIM_R.nextDouble() * (this.speedMax - this.speedMin);
                double dx = StrictMath.cos(angle) * -speed;
                double dy = StrictMath.sin(angle) * -speed;
                Particle particle = new Particle(this.type, shotX + xOffset, shotY + yOffset, dx, dy);
                particle.life -= i * ms / nParticles;
                particles.add(particle);
            }
        }
    }

    public strictfp static class FromJSON
    implements BonusableValue.FromJSON<WeaponAppearance> {
        private final int w;

        public FromJSON(int w) {
            this.w = w;
        }

        @Override
        public WeaponAppearance construct(JSONObject o, BonusSet b) {
            return new WeaponAppearance(o, this.w);
        }
    }

    public strictfp static class BarrelAnimation {
        public final int interval;
        public final int msPerShot;
        public final int totalLength;
        public final boolean loop;
        public final boolean loopConstantly;
        public final boolean finishLoopCycle;
        public final ArrayList<Img> frames;

        public BarrelAnimation(int interval, int msPerShot, boolean loop, boolean loopConstantly, boolean finishLoopCycle, ArrayList<Img> frames) {
            this.interval = interval;
            this.loop = loop;
            this.loopConstantly = loopConstantly;
            this.finishLoopCycle = finishLoopCycle;
            this.frames = frames;
            this.totalLength = interval * frames.size();
            this.msPerShot = msPerShot == -1 ? this.totalLength : msPerShot;
        }

        public BarrelAnimation flip() {
            ArrayList<Img> flippedFrames = new ArrayList<Img>();
            for (Img f : this.frames) {
                flippedFrames.add(f.flip());
            }
            return new BarrelAnimation(this.interval, this.msPerShot, this.loop, this.loopConstantly, this.finishLoopCycle, flippedFrames);
        }
    }

    public strictfp static class Shell {
        public Img img;
        public int x;
        public int y;
        public int pivotX;
        public int pivotY;
        public double openAngle;
        public double openShiftX;
        public double openShiftY;
        public int startOpenTimeBeforeFiring;
        public int endOpenTimeBeforeFiring;
        public int startCloseTimeAfterFiring;
        public int endCloseTimeAfterFiring;
        public int shellClosedPenAbsorb;
        public int shellClosedBlastAbsorb;
        public ArrayList<ShellEmitter> openEmitters = new ArrayList();
        public ArrayList<ShellEmitter> closeEmitters = new ArrayList();
        public SoundEffect openSound;
        public SoundEffect closeSound;

        private Shell(Img img, int x, int y, int pivotX, int pivotY, double openAngle, double openShiftX, double openShiftY, int startOpenTimeBeforeFiring, int endOpenTimeBeforeFiring, int startCloseTimeAfterFiring, int endCloseTimeAfterFiring, int shellClosedPenAbsorb, int shellClosedBlastAbsorb) {
            this.img = img;
            this.x = x;
            this.y = y;
            this.pivotX = pivotX;
            this.pivotY = pivotY;
            this.openAngle = openAngle;
            this.openShiftX = openShiftX;
            this.openShiftY = openShiftY;
            this.startOpenTimeBeforeFiring = startOpenTimeBeforeFiring;
            this.endOpenTimeBeforeFiring = endOpenTimeBeforeFiring;
            this.startCloseTimeAfterFiring = startCloseTimeAfterFiring;
            this.endCloseTimeAfterFiring = endCloseTimeAfterFiring;
            this.shellClosedPenAbsorb = shellClosedPenAbsorb;
            this.shellClosedBlastAbsorb = shellClosedBlastAbsorb;
        }

        public Shell(JSONObject o) {
            int i;
            JSONArray a;
            this.img = ModuleType.img(o.getJSONObject("img"));
            this.x = o.getInt("x");
            this.y = o.getInt("y");
            this.pivotX = o.optInt("pivotX", 0);
            this.pivotY = o.optInt("pivotY", 0);
            this.openShiftX = o.optDouble("openShiftX", 0.0);
            this.openShiftY = o.optDouble("openShiftY", 0.0);
            this.openAngle = o.optDouble("openAngle", 0.0);
            this.startOpenTimeBeforeFiring = o.getInt("startOpenTimeBeforeFiring");
            this.endOpenTimeBeforeFiring = o.getInt("endOpenTimeBeforeFiring");
            this.startCloseTimeAfterFiring = o.getInt("startCloseTimeAfterFiring");
            this.endCloseTimeAfterFiring = o.getInt("endCloseTimeAfterFiring");
            this.shellClosedPenAbsorb = o.optInt("shellClosedPenAbsorb", 0);
            this.shellClosedBlastAbsorb = o.optInt("shellClosedBlastAbsorb", 0);
            if (o.has("openEmitters")) {
                a = o.getJSONArray("openEmitters");
                for (i = 0; i < a.length(); ++i) {
                    this.openEmitters.add(new ShellEmitter(a.getJSONObject(i)));
                }
            }
            if (o.has("closeEmitters")) {
                a = o.getJSONArray("closeEmitters");
                for (i = 0; i < a.length(); ++i) {
                    this.closeEmitters.add(new ShellEmitter(a.getJSONObject(i)));
                }
            }
            if (o.has("openSound")) {
                this.openSound = new SoundEffect(o.getJSONObject("openSound"));
            }
            if (o.has("closeSound")) {
                this.closeSound = new SoundEffect(o.getJSONObject("closeSound"));
            }
        }

        public Shell flipped(int moduleW) {
            int i;
            Shell s2 = new Shell(this.img.flip(), moduleW * 16 - this.x - this.img.srcWidth, this.y, this.img.srcWidth - this.pivotX, this.pivotY, -this.openAngle, -this.openShiftX, this.openShiftY, this.startOpenTimeBeforeFiring, this.endOpenTimeBeforeFiring, this.startCloseTimeAfterFiring, this.endCloseTimeAfterFiring, this.shellClosedPenAbsorb, this.shellClosedBlastAbsorb);
            for (i = 0; i < this.openEmitters.size(); ++i) {
                s2.openEmitters.add(this.openEmitters.get(i).flipped(moduleW));
            }
            for (i = 0; i < this.closeEmitters.size(); ++i) {
                s2.closeEmitters.add(this.closeEmitters.get(i).flipped(moduleW));
            }
            s2.openSound = this.openSound;
            s2.closeSound = this.closeSound;
            return s2;
        }

        public double getOpenness(Module m) {
            double o = 0.0;
            if (m.msSinceFired < this.startCloseTimeAfterFiring) {
                o = 1.0;
            } else if (m.msSinceFired < this.endCloseTimeAfterFiring) {
                o = 1.0 - (double)(m.msSinceFired - this.startCloseTimeAfterFiring) * 1.0 / (double)(this.endCloseTimeAfterFiring - this.startCloseTimeAfterFiring);
            }
            int shootAccum = m.shootAccumulator;
            int reload = m.type.getReload(m.ship.currentBonuses);
            if (shootAccum > reload - this.endOpenTimeBeforeFiring) {
                o = 1.0;
            } else if (shootAccum > reload - this.startOpenTimeBeforeFiring) {
                o = (double)(shootAccum - (reload - this.startOpenTimeBeforeFiring)) * 1.0 / (double)(this.startOpenTimeBeforeFiring - this.endOpenTimeBeforeFiring);
            }
            return o;
        }
    }

    public strictfp static class ShellEmitter {
        public ParticleType type;
        public ArrayList<Pt> emitPoints = new ArrayList();

        public ShellEmitter flipped(int moduleW) {
            ShellEmitter e2 = new ShellEmitter();
            e2.type = this.type;
            for (int i = 0; i < this.emitPoints.size(); ++i) {
                e2.emitPoints.add(new Pt((double)(moduleW * 16) - this.emitPoints.get((int)i).x, this.emitPoints.get((int)i).y));
            }
            return e2;
        }

        private ShellEmitter() {
        }

        public ShellEmitter(JSONObject o) {
            this.type = ParticleType.ofName(o.getString("type"));
            JSONArray a = o.getJSONArray("emitPoints");
            for (int i = 0; i < a.length(); i += 2) {
                this.emitPoints.add(new Pt(a.getDouble(i), a.getDouble(i + 1)));
            }
        }

        public void emit(Combat c, Module m) {
            double mx = m.ship.getX() + (double)(m.ship.gridXToWorldX(m.x, m.type.getW()) * 16);
            double my = m.ship.getY() + (double)(m.y * 16);
            for (int i = 0; i < this.emitPoints.size(); ++i) {
                Pt p = this.emitPoints.get(i);
                double px = m.ship.flipped ? mx + (double)(m.type.getW() * 16) - p.x : mx + p.x;
                double py = my + p.y;
                c.particles.add(new Particle(this.type, px, py));
            }
        }
    }
}

