/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamPublishedFileUpdateHandle;
import com.codedisaster.steamworks.SteamRemoteStorage;
import com.codedisaster.steamworks.SteamRemoteStorageCallback;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUGCHandle;
import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.GenericProgress;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MissionSequence;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PublishedItemsManager;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.ZipUtils;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.util.Clr;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;

public strictfp class UploadMissionProcess
implements SteamRemoteStorageCallback {
    final MissionSequence seq;
    final PublishedItemsManager.Entry doUpdate;
    public MyDraw d;
    final String desc;
    final ArrayList<String> tags;
    String baseName;
    String previewName;
    boolean inited;
    boolean failed;
    byte[] seqData = null;
    byte[] previewImageData = null;
    boolean uploadedSeq;
    boolean uploadedPreview;
    boolean publishing;
    boolean published;
    boolean cleanedUp;
    String publishError = null;
    public boolean needsWLA = false;
    public long needsWLAId = -1L;

    public UploadMissionProcess(MissionSequence seq, PublishedItemsManager.Entry doUpdate) {
        this.seq = seq;
        this.desc = seq.getIdeallyEnglishDescriptionAndMods();
        this.tags = new ArrayList<String>(seq.tags);
        this.doUpdate = doUpdate;
    }

    public Progress tick() {
        if (this.failed) {
            return new Progress(true, true, 1, 1, Lang._t("Publishing_failed", new Object[0]) + (this.publishError != null ? "\n" + this.publishError : ""));
        }
        if (!this.inited) {
            this.inited = true;
            this.baseName = "MISSIONSEQ-" + System.currentTimeMillis() + "-" + this.seq.dir.getName();
            this.previewName = "preview-" + this.baseName;
            return new Progress(false, false, 0, 5, Lang._t("Preparing_data", new Object[0]));
        }
        if (this.seqData == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ZipUtils.enzip(this.seq.dir, baos);
                this.seqData = baos.toByteArray();
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_prepare_data", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 1, 5, Lang._t("Preparing_preview", new Object[0]));
        }
        if (this.d == null) {
            return new Progress(false, false, 1, 5, Lang._t("Preparing_preview", new Object[0]));
        }
        if (this.previewImageData == null) {
            try {
                this.seq.missions.get(0).loadMetadata();
                this.d.rect(new Clr(14, 14, 14), 0.0, 0.0, 512.0, 512.0);
                this.seq.missions.get((int)0).sideArms[0].draw(this.d, 64.0, 192.0, 128);
                this.seq.missions.get((int)0).sideArms[1].draw(this.d, 320.0, 192.0, 128);
                this.d.text("vs", AGame.HUGE_FOUNT, 256 - (int)this.d.textSize((String)"vs", (Fount)AGame.HUGE_FOUNT).x / 2, 320 - AGame.HUGE_FOUNT.height);
                if (this.d.textSize((String)this.seq.getIdeallyEnglishName(), (Fount)AGame.HUGE_FOUNT).x < 500.0) {
                    this.d.text(this.seq.getIdeallyEnglishName(), AGame.HUGE_FOUNT, 256.0 - this.d.textSize((String)this.seq.getIdeallyEnglishName(), (Fount)AGame.HUGE_FOUNT).x / 2.0, 20.0);
                } else {
                    this.d.text(this.seq.getIdeallyEnglishName(), AGame.BIGGER_FOUNT, 256.0 - this.d.textSize((String)this.seq.getIdeallyEnglishName(), (Fount)AGame.HUGE_FOUNT).x / 2.0, 20.0);
                }
                Image previewImg = new Image(512, 512);
                ((Graphics)this.d.frame().nativeRenderer()).copyArea(previewImg, 0, 0);
                byte[] rawImgData = previewImg.getTexture().getTextureData();
                ByteBuffer bb = ByteBuffer.allocate(rawImgData.length);
                bb.put(rawImgData);
                bb.rewind();
                IntBuffer ib = bb.asIntBuffer();
                previewImg.destroy();
                BufferedImage frame1 = new BufferedImage(512, 512, 1);
                for (int y = 0; y < 512; ++y) {
                    for (int x = 0; x < 512; ++x) {
                        int off = y * 512 + x;
                        int clr = ib.get(off) >> 8;
                        frame1.setRGB(x, 511 - y, clr);
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)frame1, "PNG", baos);
                this.previewImageData = baos.toByteArray();
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_prepare_preview", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 2, 5, Lang._t("Uploading_", new Object[0]));
        }
        if (!this.uploadedSeq) {
            try {
                SteamBackend.writeFile(this.baseName, this.seqData);
                this.uploadedSeq = true;
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_upload", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 3, 5, Lang._t("Uploading_preview_", new Object[0]));
        }
        if (!this.uploadedPreview) {
            try {
                SteamBackend.writeFile(this.previewName, this.previewImageData);
                this.uploadedPreview = true;
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_upload_preview", new Object[0]) + ":" + e.getMessage());
            }
            return new Progress(false, false, 4, 5, Lang._t("Publishing_", new Object[0]));
        }
        if (!this.publishing) {
            try {
                ArrayList<String> myTags = new ArrayList<String>();
                myTags.add("Missions");
                myTags.addAll(this.tags);
                if (this.doUpdate != null) {
                    SteamPublishedFileUpdateHandle spfuh = SteamBackend.storage.createPublishedFileUpdateRequest(this.doUpdate.fileID);
                    SteamBackend.storage.updatePublishedFileFile(spfuh, this.baseName);
                    SteamBackend.storage.updatePublishedFilePreviewFile(spfuh, this.previewName);
                    SteamBackend.storage.updatePublishedFileDescription(spfuh, this.desc);
                    SteamBackend.storage.updatePublishedFileTags(spfuh, AGame.normalizeTags(myTags.toArray(new String[myTags.size()])));
                    SteamBackend.storage.commitPublishedFileUpdate(spfuh);
                    SteamBackend.remoteStorageCallback = this;
                } else {
                    SteamBackend.remoteStorageCallback = this;
                    SteamBackend.storage.publishWorkshopFile(this.baseName, this.previewName, 342560L, this.seq.dir.getName(), this.desc, SteamRemoteStorage.PublishedFileVisibility.Public, AGame.normalizeTags(myTags.toArray(new String[myTags.size()])), SteamRemoteStorage.WorkshopFileType.Community);
                }
                this.publishing = true;
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                return new Progress(true, true, 1, 1, Lang._t("Unable_to_publish", new Object[0]) + ": " + e.getMessage());
            }
            return new Progress(false, false, 4, 5, Lang._t("Publishing_", new Object[0]));
        }
        if (!this.published) {
            return new Progress(false, false, 4, 5, Lang._t("Publishing_", new Object[0]));
        }
        if (this.doUpdate != null && !this.cleanedUp) {
            try {
                SteamBackend.storage.fileDelete(this.doUpdate.fileName);
                SteamBackend.storage.fileDelete("preview-" + this.doUpdate.fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cleanedUp = true;
        }
        return new Progress(true, false, 5, 5, Lang._t("Done", new Object[0]));
    }

    public void onFileShareResult(SteamUGCHandle fileHandle, String fileName, SteamResult sr) {
    }

    public void onDownloadUGCResult(SteamUGCHandle fileHandle, SteamResult sr) {
    }

    public void onPublishFileResult(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult sr) {
        if (sr == SteamResult.OK) {
            this.published = true;
            this.needsWLA = needsToAcceptWLA;
            this.needsWLAId = publishedFileID.getNativeHandle();
            PublishedItemsManager.put(PublishedItemsManager.Type.MISSIONSEQ, this.seq.dir.getName(), this.desc, this.tags, -1, publishedFileID, this.baseName);
        } else {
            this.failed = true;
            this.publishError = sr.name();
            this.needsWLA = false;
            this.needsWLAId = -1L;
        }
        SteamBackend.remoteStorageCallback = null;
    }

    public void onUpdatePublishedFileResult(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult sr) {
        if (sr == SteamResult.OK) {
            this.published = true;
            this.needsWLA = needsToAcceptWLA;
            PublishedItemsManager.put(PublishedItemsManager.Type.MISSIONSEQ, this.doUpdate.title, this.desc, this.tags, this.doUpdate.modified, this.doUpdate.fileID, this.baseName);
        } else {
            this.failed = true;
            this.publishError = sr.name();
            this.needsWLA = false;
        }
        SteamBackend.remoteStorageCallback = null;
    }

    public strictfp static class Progress
    extends GenericProgress {
        public final boolean failed;

        public Progress(boolean done, boolean failed, int progress, int total, String desc) {
            super(done, progress, total, desc);
            this.failed = failed;
        }
    }
}

