/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AIDebugLayer;
import com.zarkonnen.airships.AddConstructionButton;
import com.zarkonnen.airships.AddMonsterButton;
import com.zarkonnen.airships.AddMultiplayerConstructionButton;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.AreaLayer;
import com.zarkonnen.airships.BackdropVisualLayer;
import com.zarkonnen.airships.BeamLayer;
import com.zarkonnen.airships.BirdsVisualLayer;
import com.zarkonnen.airships.Blast;
import com.zarkonnen.airships.BoardingStatusChrome;
import com.zarkonnen.airships.BuildFromDesignButton;
import com.zarkonnen.airships.CameraControls;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.ChallengeInfoFloat;
import com.zarkonnen.airships.ChallengeInfoHighlighter;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CityNameOverlay;
import com.zarkonnen.airships.CitySpyButton;
import com.zarkonnen.airships.ClearDesignButton;
import com.zarkonnen.airships.ClickToSelectShipChrome;
import com.zarkonnen.airships.CloudsVisualLayer;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CombatReserveButton;
import com.zarkonnen.airships.CombatSetupHelpPanel;
import com.zarkonnen.airships.CombatSoundEffects;
import com.zarkonnen.airships.CombatSpeed;
import com.zarkonnen.airships.CombatSpeedButton;
import com.zarkonnen.airships.CommandButtonsPanel;
import com.zarkonnen.airships.ConfirmDialog;
import com.zarkonnen.airships.ConnectorsOverlay;
import com.zarkonnen.airships.CountdownFloat;
import com.zarkonnen.airships.DamageToolToggle;
import com.zarkonnen.airships.DefenceReserveButton;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.DisconnectionOverlay;
import com.zarkonnen.airships.DoBuildFromDefencesButton;
import com.zarkonnen.airships.DoBuildFromStrategicButton;
import com.zarkonnen.airships.DoRefitFromDefencesButton;
import com.zarkonnen.airships.DoRefitFromStrategicButton;
import com.zarkonnen.airships.EditErrorsPanel;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditMode;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.EditSelectionOverlay;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.EditorAttractBGLayer;
import com.zarkonnen.airships.EditorAttractIntent;
import com.zarkonnen.airships.EditorOverlay;
import com.zarkonnen.airships.EspionageIntent;
import com.zarkonnen.airships.FireArcs;
import com.zarkonnen.airships.FlashFloat;
import com.zarkonnen.airships.FleeButton;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.FleetCostPanel;
import com.zarkonnen.airships.FlipPlaceShipButton;
import com.zarkonnen.airships.FlipShipButton;
import com.zarkonnen.airships.FloaterTargetHeightVisualLayer;
import com.zarkonnen.airships.FloatieVisualLayer;
import com.zarkonnen.airships.FollowActionButton;
import com.zarkonnen.airships.FragmentVisualLayer;
import com.zarkonnen.airships.GenericProgress;
import com.zarkonnen.airships.HelpButton;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.LandFormationExternalVisualLayer;
import com.zarkonnen.airships.LandFormationVisualLayer;
import com.zarkonnen.airships.LandscapeEditorPanel;
import com.zarkonnen.airships.LandscapeEditorToggle;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.LeaveMPSetupButton;
import com.zarkonnen.airships.LeaveShipEditorButton;
import com.zarkonnen.airships.LeaveToMainMenuButton;
import com.zarkonnen.airships.LeaveToStrategicScreenButton;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.LightHaloLayer;
import com.zarkonnen.airships.LightMapLayer;
import com.zarkonnen.airships.LightsDebugLayer;
import com.zarkonnen.airships.LobbyChat;
import com.zarkonnen.airships.MPStatusFloat;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MessageDialog;
import com.zarkonnen.airships.MissionEditorPanel;
import com.zarkonnen.airships.MissionInfoPanels;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleProfilePanel;
import com.zarkonnen.airships.MoveFloatersButtons;
import com.zarkonnen.airships.MoveShipButton;
import com.zarkonnen.airships.MoveTargetVisualLayer;
import com.zarkonnen.airships.MultiplayerChat;
import com.zarkonnen.airships.MultiplayerCombatInfoPanel;
import com.zarkonnen.airships.MultiplayerSurrenderButton;
import com.zarkonnen.airships.MusicAffinity;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.OpenDesignButton;
import com.zarkonnen.airships.OverlayChooserPanel;
import com.zarkonnen.airships.OverlaysToggle;
import com.zarkonnen.airships.PaintArmourTool;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.ParticleVisualLayer;
import com.zarkonnen.airships.PingInfo;
import com.zarkonnen.airships.PlaceArmourTool;
import com.zarkonnen.airships.PlaceDecalTool;
import com.zarkonnen.airships.PlaceModuleTool;
import com.zarkonnen.airships.PlaceTool;
import com.zarkonnen.airships.PlaybackControlsPanel;
import com.zarkonnen.airships.PlaybackIntent;
import com.zarkonnen.airships.PortraitMessagePanel;
import com.zarkonnen.airships.PossiblePlacements;
import com.zarkonnen.airships.RaidPanel;
import com.zarkonnen.airships.ReadyButton;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RemoveShipButton;
import com.zarkonnen.airships.RenameShipChrome;
import com.zarkonnen.airships.RenameShipInDefencesButton;
import com.zarkonnen.airships.RenameShipPanel;
import com.zarkonnen.airships.RepairShipButton;
import com.zarkonnen.airships.ReservePanel;
import com.zarkonnen.airships.ReservePanelToggle;
import com.zarkonnen.airships.RotatingShader;
import com.zarkonnen.airships.SaveCombatButton;
import com.zarkonnen.airships.SaveDesignButton;
import com.zarkonnen.airships.SaveMissionButton;
import com.zarkonnen.airships.ScrapShipButton;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.SelectionGroupsFloat;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.SetupExplanationFloat;
import com.zarkonnen.airships.ShipLayers;
import com.zarkonnen.airships.ShipSpyButton;
import com.zarkonnen.airships.ShipTooltipChrome;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.ShipWarningsChrome;
import com.zarkonnen.airships.ShotVisualLayer;
import com.zarkonnen.airships.ShoutOverlay;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.SingleCombatSettingsChooser;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.SkyVisualLayer;
import com.zarkonnen.airships.SpectateInfoPanel;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.SpyActionResultDialog;
import com.zarkonnen.airships.StartCombatButton;
import com.zarkonnen.airships.StartDesignFromDefencesButton;
import com.zarkonnen.airships.StartRefitFromDefencesButton;
import com.zarkonnen.airships.StopPlacingShipsButton;
import com.zarkonnen.airships.TethersVisualLayer;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.ToggleAIControlButton;
import com.zarkonnen.airships.ToggleShowOutsideButton;
import com.zarkonnen.airships.TroopsVisualLayer;
import com.zarkonnen.airships.TryAgainChallengeButton;
import com.zarkonnen.airships.UnderConstructionChrome;
import com.zarkonnen.airships.UnderConstructionLayer;
import com.zarkonnen.airships.UndoRedoButton;
import com.zarkonnen.airships.UniscreenModLoadUI;
import com.zarkonnen.airships.UpperWeatherVisualLayer;
import com.zarkonnen.airships.VictoryOrDefeatOverlay;
import com.zarkonnen.airships.ViewCityIntent;
import com.zarkonnen.airships.WeatherEffect;
import com.zarkonnen.airships.WeatherStatusOverlay;
import com.zarkonnen.airships.WeatherVisualLayer;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public strictfp class UniScreen
implements Screen {
    public static final Img LEFT_ARROW = new Img("ui", 224, 512, 16, 16, false);
    public static final Img RIGHT_ARROW = new Img("ui", 112, 512, 16, 16, false);
    public static final Clr SELECT_RECT = new Clr(255, 255, 255, 90);
    public static final Tool NAVIGATE = new Tool(){

        @Override
        public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
            if (us.intent instanceof EditShipIntent) {
                ((EditShipIntent)us.intent).mode.draw(d, cursor, sm, us);
            }
        }

        @Override
        public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
            if (this.allowMultiselect(us) && click.y > (double)MyDraw.TOP_BAR_H && click.x > (double)us.panel(EditInfoPanel.class).myWidth) {
                ((EditShipIntent)us.intent).mode.click(us, in, new Pt(us.screenToWorldX(click.x), us.screenToWorldY(click.y)));
                return true;
            }
            return false;
        }

        @Override
        public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
            if (us.intent instanceof EditShipIntent) {
                EditShipIntent esi = (EditShipIntent)us.intent;
                EditMode em = esi.mode;
                PlaceTool newTool = null;
                switch (em) {
                    case ARMOUR: {
                        newTool = new PlaceArmourTool(us.panel(EditPalettePanel.class).lastArmourType);
                        break;
                    }
                    case DECALS: {
                        newTool = new PlaceDecalTool(null);
                        break;
                    }
                    case MODULES: {
                        newTool = new PlaceModuleTool(null, false);
                        ((PlaceModuleTool)newTool).ms = 10000;
                        ((PlaceModuleTool)newTool).ticksSinceRightClick = 10000;
                        break;
                    }
                    case PAINT: {
                        newTool = new PaintArmourTool(PaintType.values().get(0));
                    }
                }
                if (newTool != null && ((Tool)newTool).rightClick(in, click, sm, us)) {
                    us.tool = newTool;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void tick(Input in, int ms, UniScreen us) {
        }

        @Override
        public String getLabel() {
            return "";
        }

        @Override
        public boolean allowMultiselect(UniScreen us) {
            return us.intent instanceof EditShipIntent && ((EditShipIntent)us.intent).mode.allowSelect();
        }

        @Override
        public void dragOngoing(UniScreen us, Input in, double srX, double srY, double endX, double endY) {
            if (this.allowMultiselect(us)) {
                ((EditShipIntent)us.intent).mode.dragOngoing(us, in, srX, srY, endX, endY);
            }
        }

        @Override
        public void dragComplete(UniScreen us, Input in, double srX, double srY, double endX, double endY) {
            if (this.allowMultiselect(us)) {
                ((EditShipIntent)us.intent).mode.dragComplete(us, in, srX, srY, endX, endY);
            }
        }

        @Override
        public boolean showDragRect(UniScreen us, double startX, double startY, double endX, double endY) {
            return this.allowMultiselect(us) && ((EditShipIntent)us.intent).mode.showDragRect(us, startX, startY, endX, endY);
        }
    };
    public WorldMap wm;
    public City city;
    public Combat combat;
    public Combat.Side mySide;
    public CampaignWorld cw;
    public ArrayList<Airship> setupFleet;
    public LandFormation setupGround;
    public ArrayList<LandFormation> setupFloaters;
    public CombatBackgroundFlavor setupBG;
    public TimeOfDay setupTime;
    public Airship standaloneEditShip;
    public static Image[] lmCache;
    public Image[] lightingMap;
    public AirshipGame g;
    public boolean hideUI = false;
    public Airship followShip;
    public boolean attractMode;
    public boolean overrideCamera;
    public int attractTime;
    public int followIndex = 0;
    public int topBarScroll = 0;
    public int scrollRange = 0;
    public boolean mouseIsDown = false;
    public boolean selRectInited = false;
    public double selRectStartX;
    public double selRectStartY;
    public ArrayList<VisualLayer> lowerVisualLayers = new ArrayList();
    public ArrayList<VisualLayer> upperVisualLayers = new ArrayList();
    public ArrayList<Button> buttons = new ArrayList();
    public ArrayList<InfoPanel> infoPanels = new ArrayList();
    public ArrayList<InfoPanel> floats = new ArrayList();
    public Tool tool = NAVIGATE;
    public Intent intent;
    public ArrayList<ShipOverlay> shipOverlays = new ArrayList();
    public ArrayList<ShipButton> shipButtons = new ArrayList();
    public ArrayList<ShipChrome> shipChromes = new ArrayList();
    public ArrayList<InfoPanel> overlays = new ArrayList();
    public ConfirmDialog confirmDialog;
    public GenericProgress genericProgress;
    public int scrollX;
    public int scrollY;
    public int adjScrollX;
    public int adjScrollY;
    public int sscrollX;
    public int sscrollY;
    public double zoom = 1.0;
    public int time = 0;
    public double vibration = 0.0;
    public Airship selectedShip;
    public LandFormation selectedLF;
    public ArrayList<Airship> selectedShips = new ArrayList();
    public TimeOfDay bakedTOD;
    public boolean allOutside = false;
    public boolean hasScrolledWithArrows;
    public boolean hasScrolledWithDrag;
    private final HashSet<SpritesheetBundle> additionalSSBs = new HashSet();
    private final HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs = new HashSet();

    public TimeOfDay getTimeOfDay() {
        if (this.combat != null) {
            return this.combat.timeOfDay;
        }
        if (this.setupTime != null) {
            return this.setupTime;
        }
        return TimeOfDay.ofName("DAY");
    }

    public void setTimeOfDay(TimeOfDay tod) {
        if (this.combat != null) {
            this.combat.timeOfDay = tod;
            this.reloadComponents();
        }
    }

    public boolean isTimeMoving() {
        if (this.combat == null || !(this.intent instanceof CombatIntent)) {
            return true;
        }
        return !this.combat.combatFinished && this.combat.speed != CombatSpeed.STOP;
    }

    public boolean textInputOccurring() {
        if (this.g.mpChatOverlayActive) {
            return true;
        }
        int ipl = this.infoPanels.size();
        for (int ipi = 0; ipi < ipl; ++ipi) {
            if (!this.infoPanels.get(ipi).chatEnabled(this)) continue;
            return true;
        }
        int ol = this.overlays.size();
        for (int oi = 0; oi < ol; ++oi) {
            if (!this.overlays.get(oi).chatEnabled(this)) continue;
            return true;
        }
        int scl = this.shipChromes.size();
        for (int sci = 0; sci < scl; ++sci) {
            if (!this.shipChromes.get(sci).textInputOccurring(this)) continue;
            return true;
        }
        return false;
    }

    public UniScreen(AirshipGame g, Intent intent) {
        this.g = g;
        this.intent = intent;
        this.reloadComponents();
    }

    public final void clearComponents() {
        this.lowerVisualLayers.clear();
        this.upperVisualLayers.clear();
        this.shipOverlays.clear();
        this.shipChromes.clear();
        this.shipButtons.clear();
        this.buttons.clear();
        this.infoPanels.clear();
        this.overlays.clear();
        this.floats.clear();
    }

    public final void reloadComponents() {
        this.clearComponents();
        this.lowerVisualLayers.add(new LightMapLayer());
        this.lowerVisualLayers.add(new SkyVisualLayer());
        this.lowerVisualLayers.add(new CloudsVisualLayer());
        this.lowerVisualLayers.add(new SelectionVisualLayer());
        this.lowerVisualLayers.add(new BackdropVisualLayer());
        this.lowerVisualLayers.add(new FloatieVisualLayer());
        this.lowerVisualLayers.add(new BirdsVisualLayer());
        this.lowerVisualLayers.add(new AreaLayer());
        this.lowerVisualLayers.add(new WeatherVisualLayer());
        this.lowerVisualLayers.add(new FloaterTargetHeightVisualLayer());
        this.lowerVisualLayers.add(new LandFormationVisualLayer());
        this.lowerVisualLayers.add(new MoveTargetVisualLayer());
        this.lowerVisualLayers.add(new EditorAttractBGLayer());
        this.upperVisualLayers.add(new TethersVisualLayer());
        this.upperVisualLayers.add(new FragmentVisualLayer());
        this.upperVisualLayers.add(new LandFormationExternalVisualLayer());
        this.upperVisualLayers.add(new TroopsVisualLayer());
        this.upperVisualLayers.add(new UnderConstructionLayer());
        this.upperVisualLayers.add(new BeamLayer());
        this.upperVisualLayers.add(new ShotVisualLayer());
        this.upperVisualLayers.add(new ParticleVisualLayer());
        this.upperVisualLayers.add(new UpperWeatherVisualLayer());
        this.upperVisualLayers.add(new LightHaloLayer());
        this.upperVisualLayers.add(new AIDebugLayer());
        this.upperVisualLayers.add(new LightsDebugLayer());
        this.shipOverlays.add(new PossiblePlacements());
        this.shipOverlays.add(new DisconnectionOverlay());
        this.shipOverlays.add(new ConnectorsOverlay());
        this.shipOverlays.add(new EditorOverlay());
        this.shipOverlays.add(new EditSelectionOverlay());
        this.shipOverlays.add(new ChallengeInfoHighlighter());
        this.shipChromes.add(new FireArcs());
        this.shipChromes.add(new BoardingStatusChrome());
        this.shipChromes.add(new ClickToSelectShipChrome());
        this.shipChromes.add(new ShipWarningsChrome());
        this.shipChromes.add(new RenameShipChrome());
        this.shipChromes.add(new ShipTooltipChrome());
        this.shipButtons.add(new MoveShipButton());
        this.shipButtons.add(new RenameShipInDefencesButton());
        this.shipButtons.add(new RemoveShipButton());
        this.shipButtons.add(new ScrapShipButton());
        this.shipButtons.add(new RepairShipButton());
        this.shipButtons.add(new StartRefitFromDefencesButton());
        this.shipButtons.add(new DefenceReserveButton());
        this.shipButtons.add(new CombatReserveButton());
        for (Spy.ShipSpyAction shipSpyAction : Spy.ShipSpyAction.values()) {
            this.shipButtons.add(new ShipSpyButton(shipSpyAction));
        }
        this.buttons.add(new HelpButton());
        this.buttons.add(new ReadyButton());
        this.buttons.add(new StartCombatButton());
        this.buttons.add(new DoRefitFromStrategicButton());
        this.buttons.add(new DoBuildFromStrategicButton());
        this.buttons.add(new FleeButton());
        this.buttons.add(new LeaveToStrategicScreenButton());
        this.buttons.add(new DamageToolToggle());
        this.buttons.add(new StopPlacingShipsButton());
        for (Enum enum_ : ShipType.values()) {
            this.buttons.add(new BuildFromDesignButton((ShipType)enum_));
        }
        for (Enum enum_ : ShipType.values()) {
            this.buttons.add(new StartDesignFromDefencesButton((ShipType)enum_));
        }
        this.buttons.add(new LeaveMPSetupButton());
        this.buttons.add(new FlipPlaceShipButton());
        for (Enum enum_ : ShipType.values()) {
            this.buttons.add(new AddMultiplayerConstructionButton((ShipType)enum_));
        }
        this.buttons.add(new LeaveToMainMenuButton());
        this.buttons.add(new LeaveShipEditorButton());
        this.buttons.add(new TryAgainChallengeButton());
        this.buttons.add(new DoBuildFromDefencesButton());
        this.buttons.add(new DoRefitFromDefencesButton());
        this.buttons.add(new SaveCombatButton());
        this.buttons.add(new SaveMissionButton());
        for (Enum enum_ : ShipType.values()) {
            this.buttons.add(new AddConstructionButton((ShipType)enum_));
        }
        this.buttons.add(new AddMonsterButton());
        this.buttons.add(new SaveDesignButton());
        this.buttons.add(new OpenDesignButton());
        this.buttons.add(new ClearDesignButton());
        this.buttons.add(new UndoRedoButton(true));
        this.buttons.add(new UndoRedoButton(false));
        this.buttons.add(new FlipShipButton());
        this.buttons.add(new FollowActionButton());
        this.buttons.add(new ZoomToFitButton());
        this.buttons.add(new ToggleShowOutsideButton());
        this.buttons.add(new ToggleAIControlButton());
        this.buttons.add(new MultiplayerSurrenderButton());
        this.buttons.add(new ReservePanelToggle());
        this.buttons.add(new LandscapeEditorToggle());
        this.buttons.add(new OverlaysToggle());
        for (Enum enum_ : Spy.CitySpyAction.values()) {
            this.buttons.add(new CitySpyButton((Spy.CitySpyAction)enum_));
        }
        for (int i = CombatSpeed.values().length - 1; i >= 0; --i) {
            this.buttons.add(new CombatSpeedButton(CombatSpeed.values()[i]));
        }
        this.infoPanels.add(new PingInfo());
        this.infoPanels.add(new ShoutOverlay());
        this.infoPanels.add(new MoveFloatersButtons());
        this.infoPanels.add(new WeatherStatusOverlay());
        this.infoPanels.add(new UnderConstructionChrome());
        this.infoPanels.add(new LobbyChat());
        this.infoPanels.add(new EditErrorsPanel());
        this.infoPanels.add(new EditInfoPanel());
        this.infoPanels.add(new EditPalettePanel());
        this.infoPanels.add(new OverlayChooserPanel());
        this.infoPanels.add(new ReservePanel());
        this.infoPanels.add(new LandscapeEditorPanel());
        this.infoPanels.add(new RaidPanel());
        this.infoPanels.add(new ModuleProfilePanel());
        this.infoPanels.add(new CameraControls());
        this.infoPanels.add(new CommandButtonsPanel());
        this.infoPanels.add(new PlaybackControlsPanel());
        this.infoPanels.add(new SpectateInfoPanel());
        this.infoPanels.add(new MultiplayerChat());
        this.infoPanels.add(new SingleCombatSettingsChooser());
        this.infoPanels.add(new RenameShipPanel());
        this.infoPanels.add(new MissionEditorPanel());
        this.infoPanels.add(new MissionInfoPanels());
        this.infoPanels.add(new PortraitMessagePanel());
        this.infoPanels.add(new SpyActionResultDialog());
        this.overlays.add(new CityNameOverlay());
        this.overlays.add(new VictoryOrDefeatOverlay());
        this.overlays.add(new CombatSoundEffects());
        this.floats.add(new SetupExplanationFloat());
        this.floats.add(new CombatSetupHelpPanel());
        this.floats.add(new FleetCostPanel());
        this.floats.add(new MultiplayerCombatInfoPanel());
        this.floats.add(new FlashFloat());
        this.floats.add(new ChallengeInfoFloat());
        this.floats.add(new SelectionGroupsFloat());
        this.floats.add(new CountdownFloat());
        this.floats.add(new MPStatusFloat());
        this.floats.add(new UniscreenModLoadUI());
    }

    public <T extends InfoPanel> T panel(Class<T> c) {
        int ipl = this.infoPanels.size();
        for (int ipi = 0; ipi < ipl; ++ipi) {
            InfoPanel ip = this.infoPanels.get(ipi);
            if (!c.isInstance(ip)) continue;
            return (T)ip;
        }
        return null;
    }

    public <T extends InfoPanel> T overlay(Class<T> c) {
        int ovl = this.overlays.size();
        for (int ovi = 0; ovi < ovl; ++ovi) {
            InfoPanel ov = this.overlays.get(ovi);
            if (!c.isInstance(ov)) continue;
            return (T)ov;
        }
        return null;
    }

    public <T extends ShipOverlay> T shipOverlay(Class<T> c) {
        int ipl = this.shipOverlays.size();
        for (int ipi = 0; ipi < ipl; ++ipi) {
            ShipOverlay so = this.shipOverlays.get(ipi);
            if (!c.isInstance(so)) continue;
            return (T)so;
        }
        return null;
    }

    public <T extends InfoPanel> T findFloat(Class<T> c) {
        int ipl = this.floats.size();
        for (int ipi = 0; ipi < ipl; ++ipi) {
            InfoPanel so = this.floats.get(ipi);
            if (!c.isInstance(so)) continue;
            return (T)so;
        }
        return null;
    }

    public <T extends Button> T button(Class<T> c) {
        int bl = this.buttons.size();
        for (int bi = 0; bi < bl; ++bi) {
            Button b = this.buttons.get(bi);
            if (!c.isInstance(b)) continue;
            return (T)b;
        }
        return null;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        int vli;
        long start = System.currentTimeMillis();
        ScreenMode sm = in.mode();
        if (this.time == 0 && this.zoom == 1.0) {
            this.zoom = sm.width / 800;
        }
        Pt mouseDown = in.mouseDown();
        if (this.intent.allowMultiSelect() && this.mySide != null || this.tool.allowMultiselect(this)) {
            if (this.tool == NAVIGATE || this.tool.allowMultiselect(this)) {
                if (!this.selRectInited) {
                    if (!(in.mouseDownButton() != 1 || this.intent instanceof EditShipIntent && cursor.x < (double)this.panel(EditInfoPanel.class).myWidth || !(cursor.y > (double)MyDraw.TOP_BAR_H))) {
                        this.selRectStartX = this.screenToWorldX(cursor.x);
                        this.selRectStartY = this.screenToWorldY(cursor.y);
                        this.mouseIsDown = false;
                        this.selRectInited = true;
                    }
                } else if (in.mouseDownButton() > 1) {
                    this.selRectInited = false;
                    this.mouseIsDown = false;
                } else if (in.clicked() == null && mouseDown != null) {
                    if (!this.mouseIsDown && in.mouseDownButton() == 1) {
                        this.selRectStartX = this.screenToWorldX(mouseDown.x);
                        this.selRectStartY = this.screenToWorldY(mouseDown.y);
                    }
                    this.tool.dragOngoing(this, in, this.selRectStartX, this.selRectStartY, this.screenToWorldX(cursor.x), this.screenToWorldY(cursor.y));
                } else if (in.clicked() == null && mouseDown == null && this.mouseIsDown && (StrictMath.abs(cursor.x - this.worldToScreenX(this.selRectStartX)) > 3.0 || StrictMath.abs(cursor.y - this.worldToScreenY(this.selRectStartY)) > 3.0)) {
                    double srsX = StrictMath.min(this.screenToWorldX(cursor.x), this.selRectStartX);
                    double srsY = StrictMath.min(this.screenToWorldY(cursor.y), this.selRectStartY);
                    double sreX = StrictMath.max(this.screenToWorldX(cursor.x), this.selRectStartX);
                    double sreY = StrictMath.max(this.screenToWorldY(cursor.y), this.selRectStartY);
                    double srW = sreX - srsX;
                    double srH = sreY - srsY;
                    if (this.tool.allowMultiselect(this)) {
                        this.tool.dragComplete(this, in, this.selRectStartX, this.selRectStartY, this.screenToWorldX(cursor.x), this.screenToWorldY(cursor.y));
                    } else {
                        ArrayList<Airship> ships = new ArrayList<Airship>();
                        for (Airship s : this.mySide.ships) {
                            if (!Rect2D.intersects(s.getX(), s.getY(), s.getBBWidth(), s.getBBHeight(), srsX, srsY, srW, srH)) continue;
                            ships.add(s);
                        }
                        if (!ships.isEmpty()) {
                            if (ships.size() == 1) {
                                this.selectedShips.clear();
                                this.selectedShip = (Airship)ships.get(0);
                                this.selectedLF = null;
                            } else {
                                this.selectedShips.clear();
                                this.selectedShips.addAll(ships);
                                this.selectedShip = null;
                                this.selectedLF = null;
                            }
                        }
                    }
                    this.selRectInited = false;
                }
                this.mouseIsDown = mouseDown != null;
            } else {
                this.selRectStartX = this.screenToWorldX(cursor.x);
                this.selRectStartY = this.screenToWorldY(cursor.y);
                this.mouseIsDown = false;
                this.selRectInited = false;
            }
        } else {
            this.selectedShips.clear();
        }
        if (this.combat != null && SimplePref.SCREEN_SHAKE.get() && this.combat.speed != CombatSpeed.STOP && this.combat.isTimeMoving()) {
            this.vibration = 0.0;
            for (Blast b : this.combat.blasts) {
                this.vibration += b.getVibrateContribution(this, sm);
            }
        } else {
            this.vibration = 0.0;
        }
        this.genericProgress = null;
        this.time += ms;
        this.intent.tick(in, ms, this);
        if (this.attractMode && (this.combat.isFinished() || this.combat.isBoring() || this.combat.time > 120000 || this.g.mouseMoved)) {
            MainMenu mm = new MainMenu(this.g, MainMenu.Submenu.MAIN);
            mm.idleTime = this.g.mouseMoved ? 0 : 15000;
            this.g.s = mm;
        }
        if (this.intent instanceof EditorAttractIntent && this.g.mouseMoved) {
            MainMenu mm = new MainMenu(this.g, MainMenu.Submenu.MAIN);
            mm.idleTime = this.g.mouseMoved ? 0 : 15000;
            this.g.s = mm;
        }
        if (this.attractMode) {
            this.attractTime += ms;
            if (this.followShip != null && !this.combat.sides.get((int)0).ships.contains(this.followShip) && !this.combat.sides.get((int)1).ships.contains(this.followShip)) {
                this.attractTime = 10000;
            }
            if (this.attractTime >= 8000) {
                this.attractTime = 0;
                if (AGame.ANIM_R.nextBoolean()) {
                    this.button(FollowActionButton.class).follow = true;
                    this.followShip = null;
                } else {
                    Combat.Side s = this.combat.sides.get(0);
                    int fi = this.followIndex;
                    if (s.ships.size() <= fi) {
                        fi -= s.ships.size();
                        s = this.combat.sides.get(1);
                    }
                    if (s.ships.size() <= fi) {
                        s = this.combat.sides.get(0);
                        this.followIndex = 0;
                        fi = 0;
                    }
                    if (!s.ships.isEmpty()) {
                        this.button(FollowActionButton.class).follow = false;
                        this.followShip = s.ships.get(this.followIndex++ % s.ships.size());
                        this.zoom = AGame.ANIM_R.nextInt(2) + 2;
                    }
                }
            }
        }
        if (!this.overrideCamera) {
            Airship s;
            boolean arrowKeysInUse = false;
            for (InfoPanel ip : this.infoPanels) {
                arrowKeysInUse = arrowKeysInUse || ip.arrowKeysInUse(this);
            }
            for (InfoPanel ip : this.floats) {
                arrowKeysInUse = arrowKeysInUse || ip.arrowKeysInUse(this);
            }
            for (InfoPanel ip : this.overlays) {
                arrowKeysInUse = arrowKeysInUse || ip.arrowKeysInUse(this);
            }
            for (ShipChrome sc : this.shipChromes) {
                if (!(sc instanceof RenameShipChrome) || ((RenameShipChrome)sc).renaming == null) continue;
                arrowKeysInUse = true;
            }
            if (!arrowKeysInUse) {
                if (this.followShip != null) {
                    if (in.keyDown("UP")) {
                        this.sscrollY = (int)((double)this.sscrollY + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown("DOWN")) {
                        this.sscrollY = (int)((double)this.sscrollY - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown("LEFT")) {
                        this.sscrollX = (int)((double)this.sscrollX + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown("RIGHT")) {
                        this.sscrollX = (int)((double)this.sscrollX - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    this.scrollX = (int)(-(this.followShip.getX() + this.followShip.getBBWidth() / 2.0)) + this.sscrollX;
                    this.scrollY = (int)(-(this.followShip.getY() + this.followShip.getBBHeight() / 2.0)) + this.sscrollY;
                } else {
                    if (in.keyDown("UP")) {
                        this.scrollY = (int)((double)this.scrollY + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        this.hasScrolledWithArrows = true;
                    }
                    if (in.keyDown("DOWN")) {
                        this.scrollY = (int)((double)this.scrollY - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        this.hasScrolledWithArrows = true;
                    }
                    if (in.keyDown("LEFT")) {
                        this.scrollX = (int)((double)this.scrollX + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        this.hasScrolledWithArrows = true;
                    }
                    if (in.keyDown("RIGHT")) {
                        this.scrollX = (int)((double)this.scrollX - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        this.hasScrolledWithArrows = true;
                    }
                    if ((in.mouseDown() == null || in.mouseDownButton() < 2) && SimplePref.SIDE_BUMP_TO_SCROLL.get()) {
                        if (cursor.y < 2.0) {
                            this.scrollY = (int)((double)this.scrollY + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        }
                        if (cursor.y > (double)(in.mode().height - 2)) {
                            this.scrollY = (int)((double)this.scrollY - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        }
                        if (cursor.x < 2.0) {
                            this.scrollX = (int)((double)this.scrollX + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        }
                        if (cursor.x > (double)(in.mode().width - 2)) {
                            this.scrollX = (int)((double)this.scrollX - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        }
                    }
                }
            }
            if (!this.textInputOccurring()) {
                if (in.keyDown("ADD")) {
                    this.zoom *= 1.0 + (double)AirshipGame.zoomSpeed * 0.01;
                }
                if (in.keyDown("SUBTRACT")) {
                    this.zoom /= 1.0 + (double)AirshipGame.zoomSpeed * 0.01;
                }
                if (!this.overrideCamera) {
                    if (this.zoom > 16.1) {
                        this.zoom = 16.1;
                    }
                    if (this.zoom < 0.49 * (double)sm.width / 1536.0) {
                        this.zoom = 0.49 * (double)sm.width / 1536.0;
                    }
                }
                if (this.followShip != null) {
                    if (in.keyDown(Keys.get("up", "W"))) {
                        this.sscrollY = (int)((double)this.sscrollY + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown(Keys.get("down", "S"))) {
                        this.sscrollY = (int)((double)this.sscrollY - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown(Keys.get("left", "A"))) {
                        this.sscrollX = (int)((double)this.sscrollX + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown(Keys.get("right", "D"))) {
                        this.sscrollX = (int)((double)this.sscrollX - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    this.scrollX = (int)(-(this.followShip.getX() + this.followShip.getBBWidth() / 2.0)) + this.sscrollX;
                    this.scrollY = (int)(-(this.followShip.getY() + this.followShip.getBBHeight() / 2.0)) + this.sscrollY;
                } else {
                    if (in.keyDown(Keys.get("up", "W"))) {
                        this.scrollY = (int)((double)this.scrollY + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        this.hasScrolledWithArrows = true;
                    }
                    if (in.keyDown(Keys.get("down", "S"))) {
                        this.scrollY = (int)((double)this.scrollY - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        this.hasScrolledWithArrows = true;
                    }
                    if (in.keyDown(Keys.get("left", "A"))) {
                        this.scrollX = (int)((double)this.scrollX + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        this.hasScrolledWithArrows = true;
                    }
                    if (in.keyDown(Keys.get("right", "D"))) {
                        this.scrollX = (int)((double)this.scrollX - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                        this.hasScrolledWithArrows = true;
                    }
                }
            }
            if (this.intent instanceof SingleShipIntent && this.time > 500 && SimplePref.SIDE_BUMP_TO_SCROLL.get() && (s = ((SingleShipIntent)((Object)this.intent)).getShip(this)) != null) {
                if (this.worldToScreenX(s.getX()) > (double)(sm.width - 50)) {
                    this.scrollX = (int)((double)(sm.width / 2 - 50) / this.zoom - s.getX()) / 2 + this.scrollX / 2;
                }
                if (this.worldToScreenX(s.getX() + s.getBBWidth()) < 350.0) {
                    this.scrollX = (int)((double)(350 - sm.width / 2) / this.zoom - s.getX() - s.getBBWidth()) / 2 + this.scrollX / 2;
                }
                if (this.worldToScreenY(s.getY()) > (double)(sm.height - 50)) {
                    this.scrollY = (int)((double)(sm.height / 2 - 50) / this.zoom - s.getY()) / 2 + this.scrollY / 2;
                }
                if (this.worldToScreenY(s.getY() + s.getBBHeight()) < (double)(MyDraw.TOP_BAR_H + 50)) {
                    this.scrollY = (int)((double)(MyDraw.TOP_BAR_H + 50 - sm.height / 2) / this.zoom - s.getY() - s.getBBHeight()) / 2 + this.scrollY / 2;
                }
            }
        }
        if (this.confirmDialog != null) {
            if (in.keyPressed("ESCAPE")) {
                this.confirmDialog.cancel(this);
            } else if (in.keyPressed("ENTER")) {
                this.confirmDialog.ok(this);
            }
            return;
        }
        if (this.genericProgress != null) {
            return;
        }
        int vll = this.lowerVisualLayers.size();
        for (vli = 0; vli < vll; ++vli) {
            this.lowerVisualLayers.get(vli).tick(in, ms, this);
        }
        vll = this.upperVisualLayers.size();
        for (vli = 0; vli < vll; ++vli) {
            this.upperVisualLayers.get(vli).tick(in, ms, this);
        }
        int ipl = this.infoPanels.size();
        for (int ipi = 0; ipi < ipl; ++ipi) {
            this.infoPanels.get(ipi).tick(in, ms, this);
        }
        if (in.scrollAmount() != 0 && cursor == null || cursor.y > (double)MyDraw.TOP_BAR_H) {
            boolean captured = false;
            for (int ipi = 0; ipi < ipl; ++ipi) {
                if (!this.infoPanels.get(ipi).doScroll(this, in.scrollAmount(), cursor, sm)) continue;
                captured = true;
                break;
            }
            if (!captured && !this.overrideCamera && in.scrollAmount() != 0) {
                if (cursor != null) {
                    double targetX = this.screenToWorldX(cursor.x);
                    double targetY = this.screenToWorldY(cursor.y);
                    this.zoom *= StrictMath.pow(1.0 + (double)AirshipGame.mouseWheelZoomSpeed * 1.0E-4, in.scrollAmount());
                    if (!this.overrideCamera) {
                        if (this.zoom > 16.1) {
                            this.zoom = 16.1;
                        }
                        if (this.zoom < 0.49 * (double)sm.width / 1536.0) {
                            this.zoom = 0.49 * (double)sm.width / 1536.0;
                        }
                    }
                    this.scrollX = (int)(-targetX + (cursor.x - (double)(sm.width / 2)) / this.zoom);
                    this.scrollY = (int)(-targetY + (cursor.y - (double)(sm.height / 2)) / this.zoom);
                } else {
                    this.zoom *= StrictMath.pow(1.0 + (double)AirshipGame.mouseWheelZoomSpeed * 1.0E-4, in.scrollAmount());
                    if (!this.overrideCamera) {
                        if (this.zoom > 16.1) {
                            this.zoom = 16.1;
                        }
                        if (this.zoom < 0.49 * (double)sm.width / 1536.0) {
                            this.zoom = 0.49 * (double)sm.width / 1536.0;
                        }
                    }
                }
            }
        }
        if (in.scrollAmount() != 0 && cursor.y <= (double)MyDraw.TOP_BAR_H) {
            this.topBarScroll += in.scrollAmount() / 2;
            this.topBarScroll = StrictMath.min(this.scrollRange, StrictMath.max(0, this.topBarScroll));
        }
        this.adjScrollX = this.scrollX + (int)((double)(sm.width / 2) / this.zoom) + (int)(this.vibration * (AGame.ANIM_R.nextDouble() - 0.5));
        this.adjScrollY = this.scrollY + (int)((double)(sm.height / 2) / this.zoom) + (int)(this.vibration * (AGame.ANIM_R.nextDouble() - 0.5));
        if (!this.overrideCamera && !(this.intent instanceof SingleShipIntent)) {
            while (this.screenToWorldX(0.0) <= -3200.0) {
                --this.scrollX;
                this.adjScrollX = this.scrollX + (int)((double)(sm.width / 2) / this.zoom);
            }
            while (this.screenToWorldX(sm.width) >= 3200.0) {
                ++this.scrollX;
                this.adjScrollX = this.scrollX + (int)((double)(sm.width / 2) / this.zoom);
            }
            while (this.screenToWorldY(0.0) <= -1988.0) {
                --this.scrollY;
                this.adjScrollY = this.scrollY + (int)((double)(sm.height / 2) / this.zoom);
            }
            while (this.screenToWorldY(sm.height) >= 1012.0) {
                ++this.scrollY;
                this.adjScrollY = this.scrollY + (int)((double)(sm.height / 2) / this.zoom);
            }
        }
        this.tool.tick(in, ms, this);
        this.tool.tick2(in, ms, this);
        if (mouseDown != null && mouseDown.y > (double)MyDraw.TOP_BAR_H) {
            this.tool.mouseDown(in, mouseDown, sm, this);
        }
        if (click != null && click.y > (double)MyDraw.TOP_BAR_H && drawState.canClick()) {
            if (in.clickButton() == 2) {
                if (this.tool.rightClick(in, click, sm, this)) {
                    drawState.hasClicked();
                }
            } else if (this.tool.click(in, click, sm, this)) {
                drawState.hasClicked();
            }
        }
        int sbl = this.shipButtons.size();
        for (int sbi = 0; sbi < sbl; ++sbi) {
            this.shipButtons.get(sbi).tick(in, ms, this);
        }
        int scl = this.shipChromes.size();
        for (int sci = 0; sci < scl; ++sci) {
            this.shipChromes.get(sci).tick(in, ms, this);
        }
        int bl = this.buttons.size();
        for (int bi = 0; bi < bl; ++bi) {
            Button b = this.buttons.get(bi);
            if (!b.visible(this)) continue;
            b.tick(in, this);
        }
        int oll = this.overlays.size();
        for (int oli = 0; oli < oll; ++oli) {
            this.overlays.get(oli).tick(in, ms, this);
        }
        int fll = this.floats.size();
        for (int fli = 0; fli < fll; ++fli) {
            this.floats.get(fli).tick(in, ms, this);
        }
        if (!this.textInputOccurring()) {
            for (int bi = 0; bi < bl; ++bi) {
                Button b = this.buttons.get(bi);
                if (!b.visible(this) || b.hotkey(this) == null || !b.enabled(this) || !in.keyPressed(b.translatedHotkey(this))) continue;
                b.click(in, this);
                break;
            }
        }
        if (this.intent instanceof CombatIntent && ((CombatIntent)this.intent).perfRep != null) {
            ((CombatIntent)this.intent).perfRep.countTickTime((int)(System.currentTimeMillis() - start));
        }
    }

    public double screenToWorldX(double x) {
        return x / this.zoom - (double)this.adjScrollX;
    }

    public double screenToWorldY(double y) {
        return y / this.zoom - (double)this.adjScrollY;
    }

    public double worldToScreenX(double x) {
        return (x + (double)this.adjScrollX) * this.zoom;
    }

    public double worldToScreenY(double y) {
        return (y + (double)this.adjScrollY) * this.zoom;
    }

    private void drawShipChrome(MyDraw d, Airship ship, Combat.Side side, ShipChrome sc, Pt cursor, ScreenMode sm) {
        int x = (int)((double)(ship.getIntX() + this.adjScrollX) * this.zoom);
        int y = (int)((double)(ship.getIntY() + this.adjScrollY) * this.zoom);
        int w = (int)(ship.getBBWidth() * this.zoom);
        int h = (int)(ship.getBBHeight() * this.zoom);
        sc.draw(d, cursor, ship, side, x, y, w, h, sm, this);
    }

    private void drawShipButton(MyDraw d, final Airship ship, final ShipButton sb, final Combat.Side side, int[] offsets) {
        if (this.hideUI) {
            return;
        }
        if (!sb.acceptsTool(this.tool)) {
            return;
        }
        if (!sb.visible(ship, side, this)) {
            return;
        }
        int x = (int)((double)(ship.getIntX() + this.adjScrollX) * this.zoom);
        int y = (int)((double)(ship.getIntY() + this.adjScrollY) * this.zoom);
        int w = (int)(ship.getBBWidth() * this.zoom);
        String text = sb.text(ship, side, this);
        int bw = d.bw(text);
        if (offsets[0] > 0 && offsets[0] + bw > w) {
            offsets[0] = 0;
            offsets[1] = offsets[1] - (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING);
        }
        final UniScreen us = this;
        d.button(x + offsets[0], y - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING + offsets[1], bw, sb.text(ship, side, this), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                sb.click(in, ship, side, us);
            }
        }, sb.enabled(ship, side, us));
        offsets[0] = offsets[0] + (bw + MyDraw.BUTTON_SPACING);
    }

    public static boolean isShipInCropRect(Airship ship, double cropX, double cropY, double cropW, double cropH) {
        double sx = ship.getX();
        double sy = ship.getY();
        double sRight = ship.getX() + ship.getBBWidth();
        double sBottom = ship.getY() + ship.getBBHeight();
        int msz = ship.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = ship.modules.get(mi);
            double mx = ship.getX() + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16);
            double my = ship.getY() + (double)(m.y * 16) + (double)(m.type.getH() * 16);
            int ll = m.legs.size();
            for (int li = 0; li < ll; ++li) {
                Leg l = m.legs.get(li);
                if (l.spec.upperLeg == null) continue;
                double legW = l.spec.upperLeg.srcHeight;
                double hipX = ship.flipped ? mx + ((double)m.type.getW() - l.spec.xOffset) * 16.0 : mx + l.spec.xOffset * 16.0;
                double hipY = my + l.spec.yOffset * 16.0;
                double kneeX = hipX + StrictMath.cos(l.upperRotation) * l.spec.upperLimbLength;
                double kneeY = hipY + StrictMath.sin(l.upperRotation) * l.spec.upperLimbLength;
                sx = StrictMath.min(kneeX - legW / 2.0, sx);
                sRight = StrictMath.max(kneeX + legW / 2.0, sRight);
                sy = StrictMath.min(kneeY - legW / 2.0, sy);
                sBottom = StrictMath.max(kneeY + legW / 2.0, sBottom);
                double footX = kneeX + StrictMath.cos(l.lowerRotation) * l.spec.lowerLimbLength;
                double footY = kneeY + StrictMath.sin(l.lowerRotation) * l.spec.lowerLimbLength;
                sx = StrictMath.min(footX - legW / 2.0, sx);
                sRight = StrictMath.max(footX + legW / 2.0, sRight);
                sy = StrictMath.min(footY - legW / 2.0, sy);
                sBottom = StrictMath.max(footY + l.spec.footHeight + legW / 2.0, sBottom);
            }
        }
        return Rect2D.intersects(cropX, cropY, cropW, cropH, sx, sy, sRight - sx, sBottom - sy);
    }

    public CoatOfArms getBestOverallCOA() {
        if (this.combat != null) {
            return this.mySide.arms;
        }
        if (this.city != null) {
            return this.wm.owner((City)this.city).arms;
        }
        if (this.setupFleet != null) {
            return this.g.getBestCOA();
        }
        if (this.standaloneEditShip != null) {
            if (this.intent instanceof EditShipIntent) {
                return ((EditShipIntent)this.intent).getArms(this);
            }
            if (this.intent instanceof EditorAttractIntent) {
                return ((EditorAttractIntent)this.intent).coa;
            }
        }
        return this.g.getBestCOA();
    }

    private void updateFlagImages(MyDraw d) {
        CoatOfArms coa0 = null;
        CoatOfArms coa1 = null;
        if (this.combat != null) {
            coa0 = this.combat.sides.get((int)0).arms;
            coa1 = this.combat.sides.get((int)1).arms;
        } else if (this.city != null) {
            coa1 = coa0 = this.wm.owner((City)this.city).arms;
        } else if (this.setupFleet != null) {
            coa0 = this.g.getBestCOA();
        } else if (this.standaloneEditShip != null) {
            coa0 = this.intent instanceof EditShipIntent ? ((EditShipIntent)this.intent).getArms(this) : (this.intent instanceof EditorAttractIntent ? ((EditorAttractIntent)this.intent).coa : this.g.getBestCOA());
            coa1 = coa0;
        }
        ShipLayers.Flags.updateFlags(d, coa0, coa1);
    }

    private void renderLayer(ShipLayer shipLayer, SpritesheetBundle ssb, MyDraw d, TimeOfDay tod, double cropX, double cropY, double cropW, double cropH, HashSet<SpritesheetBundle> additionalSSBs, SpritesheetBundle ssb2, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> additionalSSBPairs) {
        if (!shipLayer.doDraw(this.zoom)) {
            return;
        }
        boolean showHpBarsAndDoors = this.zoom >= 1.25 && !this.hideUI;
        shipLayer.lockShader(ssb, ssb2, d, this.zoom, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
        if (this.combat != null) {
            int sl = this.combat.sides.size();
            for (int si = 0; si < sl; ++si) {
                Combat.Side side = this.combat.sides.get(si);
                Combat.Side otherSide = this.combat.otherSide(side);
                int al = side.ships.size();
                for (int ai = 0; ai < al; ++ai) {
                    boolean inside;
                    Airship ship = side.ships.get(ai);
                    if (!shipLayer.drawEvenIfShipOutsideCropRect() && !UniScreen.isShipInCropRect(ship, cropX, cropY, cropW, cropH)) continue;
                    boolean bl = side == this.mySide ? ship.commandPointsGenerated() > 0 : (inside = !ship.boarders.isEmpty());
                    if (this.intent instanceof PlaybackIntent) {
                        inside = true;
                    }
                    if (this.allOutside) {
                        inside = false;
                    }
                    shipLayer.draw(ship, tod.effect, si, d, !inside, this.zoom, ship.getIntX(), ship.getIntY(), this.time, true, this.intent.showDecals(), side.arms, otherSide.arms, showHpBarsAndDoors, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint, ssb, additionalSSBs, ssb2, additionalSSBPairs);
                }
            }
        } else if (this.city != null) {
            CoatOfArms ownerCOA = this.wm.owner((City)this.city).arms;
            Fleet garrison = this.wm.getGarrison(this.city);
            for (Airship ship : this.city.getDefences()) {
                if (!UniScreen.isShipInCropRect(ship, cropX, cropY, cropW, cropH)) continue;
                shipLayer.draw(ship, tod.effect, 1, d, this.intent.showOutside(), this.zoom, ship.getIntX(), ship.getIntY(), this.time, true, this.intent.showDecals(), ownerCOA, ownerCOA, showHpBarsAndDoors, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint, ssb, additionalSSBs, ssb2, additionalSSBPairs);
            }
            if (garrison != null) {
                int al = garrison.actives.size();
                for (int ai = 0; ai < al; ++ai) {
                    Airship ship = garrison.actives.get(ai);
                    if (!UniScreen.isShipInCropRect(ship, cropX, cropY, cropW, cropH)) continue;
                    shipLayer.draw(ship, tod.effect, 1, d, this.intent.showOutside(), this.zoom, ship.getIntX(), ship.getIntY(), this.time, true, this.intent.showDecals(), ownerCOA, ownerCOA, showHpBarsAndDoors, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint, ssb, additionalSSBs, ssb2, additionalSSBPairs);
                }
            }
        } else if (this.setupFleet != null) {
            CoatOfArms coa = this.g.getBestCOA();
            int al = this.setupFleet.size();
            for (int ai = 0; ai < al; ++ai) {
                Airship ship = this.setupFleet.get(ai);
                if (!UniScreen.isShipInCropRect(ship, cropX, cropY, cropW, cropH)) continue;
                shipLayer.draw(ship, tod.effect, 0, d, this.intent.showOutside(), this.zoom, ship.getIntX(), ship.getIntY(), this.time, true, this.intent.showDecals(), coa, coa, showHpBarsAndDoors, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint, ssb, additionalSSBs, ssb2, additionalSSBPairs);
            }
        } else if (this.standaloneEditShip != null) {
            CoatOfArms coa = this.intent instanceof EditShipIntent ? ((EditShipIntent)this.intent).getArms(this) : (this.intent instanceof EditorAttractIntent ? ((EditorAttractIntent)this.intent).coa : this.g.getBestCOA());
            shipLayer.draw(this.standaloneEditShip, tod.effect, 0, d, this.intent.showOutside(), this.zoom, this.standaloneEditShip.getIntX(), this.standaloneEditShip.getIntY(), this.time, true, this.intent.showDecals(), coa, coa, showHpBarsAndDoors, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation, tod.ambientTint, ssb, additionalSSBs, ssb2, additionalSSBPairs);
        }
        shipLayer.unlockShader(this.lightingMap, this.zoom);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        void var20_57;
        long start = System.currentTimeMillis();
        this.updateFlagImages(d);
        if (this.lightingMap != null && Appearance.useLighting && !Appearance.useSimpleGraphics && (this.lightingMap[0].getWidth() != sm.width / 4 || this.lightingMap[0].getHeight() != sm.height / 4)) {
            for (Image lm : this.lightingMap) {
                try {
                    lm.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.lightingMap = null;
            lmCache = null;
        }
        if (this.lightingMap == null && Appearance.useLighting && !Appearance.useSimpleGraphics) {
            try {
                if (lmCache == null) {
                    lmCache = new Image[4];
                    for (int i = 0; i < 4; ++i) {
                        UniScreen.lmCache[i] = new Image(sm.width / 4, sm.height / 4);
                    }
                }
                this.lightingMap = lmCache;
            }
            catch (SlickException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.lightingMap != null && (!Appearance.useLighting || Appearance.useSimpleGraphics)) {
            this.lightingMap = null;
        }
        if (this.hideUI) {
            d.state.setCursor(null, null);
        } else {
            d.state.resetCursor();
        }
        d.rect(this.getTimeOfDay().skyColors[4], 0.0, 0.0, sm.width, sm.height);
        d.scale(this.zoom, this.zoom);
        d.shift(this.adjScrollX, this.adjScrollY);
        double cropX = this.screenToWorldX(0.0);
        double cropY = this.screenToWorldY(0.0);
        double cropW = this.screenToWorldX(sm.width) - cropX;
        double cropH = this.screenToWorldY(sm.height) - cropY;
        int vll = this.lowerVisualLayers.size();
        for (int vli = 0; vli < vll; ++vli) {
            this.lowerVisualLayers.get(vli).draw(d, this, cropX, cropY, cropW, cropH);
        }
        TimeOfDay tod = this.getTimeOfDay();
        for (ShipLayer shipLayer : ShipLayers.ALL) {
            this.additionalSSBs.clear();
            this.additionalSSBPairs.clear();
            if (shipLayer.getBaseSSB2() == null) {
                this.renderLayer(shipLayer, shipLayer.getBaseSSB(), d, tod, cropX, cropY, cropW, cropH, this.additionalSSBs, null, null);
                for (SpritesheetBundle spritesheetBundle : this.additionalSSBs) {
                    this.renderLayer(shipLayer, spritesheetBundle, d, tod, cropX, cropY, cropW, cropH, null, null, null);
                }
            } else {
                this.renderLayer(shipLayer, shipLayer.getBaseSSB(), d, tod, cropX, cropY, cropW, cropH, null, shipLayer.getBaseSSB2(), this.additionalSSBPairs);
                for (Utils.Pair pair : this.additionalSSBPairs) {
                    this.renderLayer(shipLayer, (SpritesheetBundle)pair.a, d, tod, cropX, cropY, cropW, cropH, null, (SpritesheetBundle)pair.b, null);
                }
            }
            if (!RotatingShader.shaderLocked) continue;
            this.g.reportError("Rotating shader still locked after " + shipLayer.getClass().getSimpleName(), null, null, false, true);
            RotatingShader.unlockShader();
        }
        for (ShipOverlay so : this.shipOverlays) {
            if (this.combat != null) {
                void var20_40;
                int sl = this.combat.sides.size();
                boolean bl = false;
                while (var20_40 < sl) {
                    Combat.Side side = this.combat.sides.get((int)var20_40);
                    int al = side.ships.size();
                    for (int ai = 0; ai < al; ++ai) {
                        Airship ship = side.ships.get(ai);
                        if (!so.drawIfOffScreen() && !Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) continue;
                        so.draw(d, ship, this);
                    }
                    ++var20_40;
                }
                continue;
            }
            if (this.city != null) {
                Fleet garrison = this.wm.getGarrison(this.city);
                for (Airship ship : this.city.getDefences()) {
                    if (!so.drawIfOffScreen() && !Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) continue;
                    so.draw(d, ship, this);
                }
                if (garrison == null) continue;
                int n = garrison.actives.size();
                for (int ai = 0; ai < n; ++ai) {
                    Airship ship = garrison.actives.get(ai);
                    if (!so.drawIfOffScreen() && !Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) continue;
                    so.draw(d, ship, this);
                }
                continue;
            }
            if (this.setupFleet != null) {
                void var20_44;
                int al = this.setupFleet.size();
                boolean bl = false;
                while (var20_44 < al) {
                    Airship ship = this.setupFleet.get((int)var20_44);
                    if (so.drawIfOffScreen() || Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) {
                        so.draw(d, ship, this);
                    }
                    ++var20_44;
                }
                continue;
            }
            if (this.standaloneEditShip == null) continue;
            so.draw(d, this.standaloneEditShip, this);
        }
        vll = this.upperVisualLayers.size();
        for (int vli = 0; vli < vll; ++vli) {
            this.upperVisualLayers.get(vli).draw(d, this, cropX, cropY, cropW, cropH);
            if (!RotatingShader.shaderLocked) continue;
            this.g.reportError("Rotating shader still locked after " + this.upperVisualLayers.get(vli).getClass().getSimpleName(), null, null, false, true);
            RotatingShader.unlockShader();
        }
        d.resetTransforms();
        int scl = this.shipChromes.size();
        for (int sci = 0; sci < scl; ++sci) {
            ShipChrome sc = this.shipChromes.get(sci);
            if (this.combat != null) {
                int n = this.combat.sides.size();
                for (int si = 0; si < n; ++si) {
                    Combat.Side side = this.combat.sides.get(si);
                    int al = side.ships.size();
                    for (int ai = 0; ai < al; ++ai) {
                        Airship ship = side.ships.get(ai);
                        if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) continue;
                        this.drawShipChrome(d, ship, side, sc, cursor, sm);
                    }
                }
                continue;
            }
            if (this.city != null) {
                Fleet fleet = this.wm.getGarrison(this.city);
                for (Airship ship : this.city.getDefences()) {
                    if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) continue;
                    this.drawShipChrome(d, ship, null, sc, cursor, sm);
                }
                if (fleet == null) continue;
                int al = fleet.actives.size();
                for (int ai = 0; ai < al; ++ai) {
                    Airship ship = fleet.actives.get(ai);
                    if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) continue;
                    this.drawShipChrome(d, ship, null, sc, cursor, sm);
                }
                continue;
            }
            if (this.setupFleet != null) {
                int n = this.setupFleet.size();
                for (int ai = 0; ai < n; ++ai) {
                    Airship ship = this.setupFleet.get(ai);
                    if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) continue;
                    this.drawShipChrome(d, ship, null, sc, cursor, sm);
                }
                continue;
            }
            if (this.standaloneEditShip == null) continue;
            this.drawShipChrome(d, this.standaloneEditShip, null, sc, cursor, sm);
        }
        int[] offsets = new int[]{0, 0};
        if (this.combat != null) {
            void var20_49;
            int sl = this.combat.sides.size();
            boolean bl = false;
            while (var20_49 < sl) {
                Combat.Side side = this.combat.sides.get((int)var20_49);
                int al = side.ships.size();
                for (int ai = 0; ai < al; ++ai) {
                    Airship ship = side.ships.get(ai);
                    if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) continue;
                    offsets[0] = 0;
                    offsets[1] = 0;
                    int sbl = this.shipButtons.size();
                    for (int sbi = 0; sbi < sbl; ++sbi) {
                        this.drawShipButton(d, ship, this.shipButtons.get(sbi), side, offsets);
                    }
                }
                ++var20_49;
            }
        } else if (this.city != null) {
            Fleet garrison = this.wm.getGarrison(this.city);
            for (Airship ship : this.city.getDefences()) {
                if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) continue;
                offsets[0] = 0;
                offsets[1] = 0;
                int sbl = this.shipButtons.size();
                for (int sbi = 0; sbi < sbl; ++sbi) {
                    this.drawShipButton(d, ship, this.shipButtons.get(sbi), null, offsets);
                }
            }
            if (garrison != null) {
                int n = garrison.actives.size();
                for (int ai = 0; ai < n; ++ai) {
                    Airship ship = garrison.actives.get(ai);
                    if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) continue;
                    offsets[0] = 0;
                    offsets[1] = 0;
                    int sbl = this.shipButtons.size();
                    for (int sbi = 0; sbi < sbl; ++sbi) {
                        this.drawShipButton(d, ship, this.shipButtons.get(sbi), null, offsets);
                    }
                }
            }
        } else if (this.setupFleet != null) {
            void var20_53;
            int al = this.setupFleet.size();
            boolean bl = false;
            while (var20_53 < al) {
                Airship ship = this.setupFleet.get((int)var20_53);
                if (Rect2D.intersects(cropX, cropY, cropW, cropH, ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight())) {
                    offsets[0] = 0;
                    offsets[1] = 0;
                    int sbl = this.shipButtons.size();
                    for (int sbi = 0; sbi < sbl; ++sbi) {
                        this.drawShipButton(d, ship, this.shipButtons.get(sbi), null, offsets);
                    }
                }
                ++var20_53;
            }
        } else if (this.standaloneEditShip != null) {
            void var20_55;
            offsets[0] = 0;
            offsets[1] = 0;
            int sbl = this.shipButtons.size();
            boolean bl = false;
            while (var20_55 < sbl) {
                this.drawShipButton(d, this.standaloneEditShip, this.shipButtons.get((int)var20_55), null, offsets);
                ++var20_55;
            }
        }
        this.tool.draw(d, cursor, sm, this);
        int ipl = this.infoPanels.size();
        boolean bl = false;
        while (var20_57 < ipl) {
            this.infoPanels.get((int)var20_57).draw(d, cursor, sm, hs, this);
            ++var20_57;
        }
        if (this.mouseIsDown && (this.intent.allowMultiSelect() || this.tool.showDragRect(this, this.selRectStartX, this.selRectStartY, this.screenToWorldX(cursor.x), this.screenToWorldY(cursor.y))) && this.selRectInited && (StrictMath.abs(cursor.x - this.selRectStartX) > 3.0 || StrictMath.abs(cursor.y - this.selRectStartY) > 3.0)) {
            d.state.setCursor("SELECT", null);
            d.rect(SELECT_RECT, this.worldToScreenX(this.selRectStartX), this.worldToScreenY(this.selRectStartY), cursor.x - this.worldToScreenX(this.selRectStartX), cursor.y - this.worldToScreenY(this.selRectStartY));
        }
        final UniScreen uniScreen = this;
        if (!this.hideUI) {
            d.drawTopBar(sm);
            boolean chat = this.textInputOccurring();
            int bsz = this.buttons.size();
            int totalButtonWidth = 0;
            for (int bi = 0; bi < bsz; ++bi) {
                Button b = this.buttons.get(bi);
                if (!b.visible(this)) continue;
                Img icon = b.icon(this);
                totalButtonWidth = icon != null ? (totalButtonWidth += MyDraw.BUTTON_H) : (totalButtonWidth += (int)d.textSize((String)b.text((UniScreen)this), (Fount)AGame.BIG_FOUNT).x + (b.isToggle() ? MyDraw.TOGGLE_EXTRA_W : MyDraw.BUTTON_EXTRA_W));
                totalButtonWidth += MyDraw.BUTTON_SPACING;
            }
            int x = (totalButtonWidth -= MyDraw.BUTTON_SPACING) > sm.width - MyDraw.BUTTON_SPACING * 2 - MyDraw.BUTTON_H * 2 ? sm.width - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_SPACING - MyDraw.BUTTON_H + this.topBarScroll : sm.width - MyDraw.SIDE_CLEARANCE + this.topBarScroll;
            for (int bi = 0; bi < bsz; ++bi) {
                final Button b = this.buttons.get(bi);
                if (!b.visible(this)) continue;
                Img icon = b.icon(this);
                if (icon != null) {
                    x -= MyDraw.BUTTON_H;
                    if (b.isToggle()) {
                        d.iconToggle(x, MyDraw.TOP_BAR_INSET, icon, new InputRunnable(){

                            @Override
                            public void run(Input in) {
                                b.click(in, uniScreen);
                            }
                        }, b.selected(this), b.enabled(this));
                    } else {
                        d.iconButton(x, MyDraw.TOP_BAR_INSET, icon, new InputRunnable(){

                            @Override
                            public void run(Input in) {
                                b.click(in, uniScreen);
                            }
                        }, b.enabled(this));
                    }
                    b.renderExtra(uniScreen, d, x, MyDraw.TOP_BAR_INSET, MyDraw.BUTTON_H, MyDraw.BUTTON_H);
                    x -= MyDraw.BUTTON_SPACING;
                    continue;
                }
                String text = b.text(this);
                int bw = (int)d.textSize((String)text, (Fount)AGame.BIG_FOUNT).x + (b.isToggle() ? MyDraw.TOGGLE_EXTRA_W : MyDraw.BUTTON_EXTRA_W);
                x -= bw;
                if (b.isToggle()) {
                    d.toggle(x, MyDraw.TOP_BAR_INSET, bw, text, chat ? null : b.translatedHotkey(this), new InputRunnable(){

                        @Override
                        public void run(Input in) {
                            b.click(in, uniScreen);
                        }
                    }, b.selected(this), b.enabled(this));
                } else if (b.gold(uniScreen)) {
                    d.goldbutton(x, MyDraw.TOP_BAR_INSET, bw, text, chat ? null : b.translatedHotkey(this), new InputRunnable(){

                        @Override
                        public void run(Input in) {
                            b.click(in, uniScreen);
                        }
                    }, b.enabled(this));
                } else {
                    d.button(x, MyDraw.TOP_BAR_INSET, bw, text, chat ? null : b.translatedHotkey(this), new InputRunnable(){

                        @Override
                        public void run(Input in) {
                            b.click(in, uniScreen);
                        }
                    }, b.enabled(this));
                }
                b.renderExtra(uniScreen, d, x, MyDraw.TOP_BAR_INSET, bw, MyDraw.BUTTON_H);
                x -= MyDraw.BUTTON_SPACING;
            }
            if (totalButtonWidth > sm.width - MyDraw.SIDE_CLEARANCE * 2) {
                d.hook(sm.width - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING, MyDraw.SIDE_CLEARANCE, MyDraw.SIDE_CLEARANCE + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, MyDraw.BUTTON_H + 2, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN, Hook.Type.HOVER}){

                    public void run(Input in, Pt p, Hook.Type type) {
                    }
                });
                d.state.removeIntersectingGlowRects(sm.width - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, MyDraw.SIDE_CLEARANCE + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, MyDraw.BUTTON_H);
                d.drawWoodGrain(sm.width - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET - (MyDraw.BUTTON_START.srcHeight - MyDraw.BUTTON_H) / 2 - 1, MyDraw.SIDE_CLEARANCE + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, MyDraw.BUTTON_START.srcHeight + 2);
                d.repeatingIconButton(sm.width - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H, MyDraw.TOP_BAR_INSET, RIGHT_ARROW, new Runnable(){

                    @Override
                    public void run() {
                        UniScreen.this.topBarScroll -= 5;
                    }
                }, this.topBarScroll > 0);
                d.hook(0.0, MyDraw.SIDE_CLEARANCE, MyDraw.SIDE_CLEARANCE + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, MyDraw.BUTTON_H + 2, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN, Hook.Type.HOVER}){

                    public void run(Input in, Pt p, Hook.Type type) {
                    }
                });
                d.drawWoodGrain(0, MyDraw.TOP_BAR_INSET - (MyDraw.BUTTON_START.srcHeight - MyDraw.BUTTON_H) / 2 - 1, MyDraw.SIDE_CLEARANCE + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, MyDraw.BUTTON_START.srcHeight + 2);
                d.repeatingIconButton(MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_INSET, LEFT_ARROW, new Runnable(){

                    @Override
                    public void run() {
                        UniScreen.this.topBarScroll += 5;
                    }
                }, x < MyDraw.SIDE_CLEARANCE + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING);
                this.scrollRange = StrictMath.max(0, this.topBarScroll - x + MyDraw.SIDE_CLEARANCE + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING);
                if (x > this.scrollRange) {
                    this.topBarScroll = this.scrollRange;
                }
            }
        }
        int os = this.overlays.size();
        for (int oi = 0; oi < os; ++oi) {
            this.overlays.get(oi).draw(d, cursor, sm, hs, this);
        }
        int fll = this.floats.size();
        for (int fli = 0; fli < fll; ++fli) {
            this.floats.get(fli).draw(d, cursor, sm, hs, this);
        }
        if (this.attractMode || this.intent instanceof EditorAttractIntent) {
            hs.list.clear();
            d.getHooks().list.clear();
            d.hook(0.0, 0.0, sm.width, sm.height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    UniScreen.this.g.s = new MainMenu(UniScreen.this.g, MainMenu.Submenu.MAIN);
                }
            });
        }
        if (this.genericProgress != null) {
            hs.list.clear();
            int w = 300 + MyDraw.WINDOW_INSET * 2;
            int h = AGame.FOUNT.height + MyDraw.UI_SPACING + MyDraw.PROGRESS_BAR_H + MyDraw.WINDOW_INSET * 2;
            int x = sm.width / 2 - w / 2;
            int y = sm.height / 2 - h / 2;
            d.drawShadowedPanel(x, y, w, h);
            d.text(this.genericProgress.desc, AGame.FOUNT, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET);
            d.progressBar(x, y += AGame.FOUNT.height + MyDraw.UI_SPACING, 300, 1.0 * (double)this.genericProgress.progress / (double)StrictMath.max(1, this.genericProgress.total));
        }
        if (this.confirmDialog != null) {
            hs.list.clear();
            d.getHooks().list.clear();
            d.rect(AirshipGame.ERR_BG_TINT, 0.0, 0.0, sm.width, sm.height);
            int dialogW = StrictMath.max(400, sm.width / 2);
            if (this.confirmDialog instanceof MessageDialog) {
                try {
                    d.messageDialog(sm.width / 2 - dialogW / 2, sm.height / 2 - 150, dialogW, this.confirmDialog.text(), new Runnable(){

                        @Override
                        public void run() {
                            UniScreen.this.confirmDialog.ok(uniScreen);
                        }
                    });
                }
                catch (Exception e) {
                    this.g.reportError("{0} problem with " + this.confirmDialog.text(), e, null, false, true);
                }
            } else {
                d.confirmDialog(sm.width / 2 - dialogW / 2, sm.height / 2 - 150, dialogW, this.confirmDialog.text(), this.confirmDialog.okText(), this.confirmDialog.cancelText(), new Runnable(){

                    @Override
                    public void run() {
                        UniScreen.this.confirmDialog.ok(uniScreen);
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        UniScreen.this.confirmDialog.cancel(uniScreen);
                    }
                });
            }
        }
        if (this.intent instanceof CombatIntent && ((CombatIntent)this.intent).perfRep != null) {
            ((CombatIntent)this.intent).perfRep.countRenderTime((int)(System.currentTimeMillis() - start));
        }
        if (this.hideUI) {
            d.state.cursorAppearance = null;
        }
    }

    public LandscapeType landscapeType() {
        if (this.combat != null) {
            return this.combat.landFormations.get((int)0).landscapeType;
        }
        if (this.city != null) {
            return this.city.ground.landscapeType;
        }
        if (this.setupGround != null) {
            return this.setupGround.landscapeType;
        }
        return LandscapeType.ofName("GRASSLAND");
    }

    @Override
    public ArrayList<String> music() {
        if (this.intent instanceof EditShipIntent) {
            return AGame.EDITOR_MUSIC;
        }
        if (this.intent instanceof DefencesIntent || this.intent instanceof EspionageIntent || this.intent instanceof ViewCityIntent) {
            return AGame.CITY_MUSIC;
        }
        if (this.combat != null && this.combat.time > 0) {
            return MusicAffinity.pickMusic(this.combat);
        }
        return AGame.STRATEGIC_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return this.getTimeOfDay().appearancePostfix;
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    public static interface ShipLayer {
        public SpritesheetBundle getBaseSSB();

        public SpritesheetBundle getBaseSSB2();

        public boolean doDraw(double var1);

        public void lockShader(SpritesheetBundle var1, SpritesheetBundle var2, MyDraw var3, double var4, Image[] var6, float var7, Color var8, float var9);

        public void draw(Airship var1, WeatherEffect var2, int var3, MyDraw var4, boolean var5, double var6, double var8, double var10, int var12, boolean var13, boolean var14, CoatOfArms var15, CoatOfArms var16, boolean var17, Image[] var18, float var19, Color var20, float var21, Clr var22, SpritesheetBundle var23, HashSet<SpritesheetBundle> var24, SpritesheetBundle var25, HashSet<Utils.Pair<SpritesheetBundle, SpritesheetBundle>> var26);

        public void unlockShader(Image[] var1, double var2);

        public boolean drawEvenIfShipOutsideCropRect();
    }

    public static interface Intent {
        public void tick(Input var1, int var2, UniScreen var3);

        public boolean showOutside();

        public boolean showDecals();

        public boolean drawAsBlueprint();

        public boolean allowMultiSelect();
    }

    public static interface ShipChrome {
        public void draw(MyDraw var1, Pt var2, Airship var3, Combat.Side var4, int var5, int var6, int var7, int var8, ScreenMode var9, UniScreen var10);

        public void tick(Input var1, int var2, UniScreen var3);

        public boolean textInputOccurring(UniScreen var1);
    }

    public static interface ShipOverlay {
        public boolean drawIfOffScreen();

        public void draw(MyDraw var1, Airship var2, UniScreen var3);
    }

    public strictfp static abstract class Tool {
        Pt prevDragPt = null;
        int pdtN = 5;

        public abstract void draw(MyDraw var1, Pt var2, ScreenMode var3, UniScreen var4);

        public abstract boolean click(Input var1, Pt var2, ScreenMode var3, UniScreen var4);

        public abstract boolean rightClick(Input var1, Pt var2, ScreenMode var3, UniScreen var4);

        public abstract void tick(Input var1, int var2, UniScreen var3);

        public abstract String getLabel();

        public boolean allowMultiselect(UniScreen us) {
            return false;
        }

        public void dragOngoing(UniScreen us, Input in, double srX, double srY, double endX, double endY) {
        }

        public void dragComplete(UniScreen us, Input in, double srX, double srY, double endX, double endY) {
        }

        public boolean showDragRect(UniScreen us, double startX, double startY, double endX, double endY) {
            return false;
        }

        public void tick2(Input in, int ms, UniScreen us) {
            if (this.pdtN++ > 2) {
                this.prevDragPt = null;
            }
        }

        public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
            if (in.mouseDownButton() != 1) {
                this.pdtN = 0;
                if (this.prevDragPt != null) {
                    us.scrollX = (int)((double)us.scrollX + (click.x - this.prevDragPt.x) / us.zoom);
                    us.scrollY = (int)((double)us.scrollY + (click.y - this.prevDragPt.y) / us.zoom);
                }
                this.prevDragPt = click;
                us.hasScrolledWithDrag = true;
            }
            return false;
        }
    }

    public static interface InfoPanel {
        public void draw(MyDraw var1, Pt var2, ScreenMode var3, Hooks var4, UniScreen var5);

        public void tick(Input var1, int var2, UniScreen var3);

        public boolean chatEnabled(UniScreen var1);

        public boolean doScroll(UniScreen var1, int var2, Pt var3, ScreenMode var4);

        public boolean arrowKeysInUse(UniScreen var1);
    }

    public strictfp static abstract class ShipButton {
        public abstract boolean visible(Airship var1, Combat.Side var2, UniScreen var3);

        public boolean enabled(Airship ship, Combat.Side side, UniScreen us) {
            return true;
        }

        public boolean acceptsTool(Tool t) {
            return t == NAVIGATE;
        }

        public abstract String text(Airship var1, Combat.Side var2, UniScreen var3);

        public abstract void click(Input var1, Airship var2, Combat.Side var3, UniScreen var4);

        public void tick(Input in, int ms, UniScreen us) {
        }
    }

    public strictfp static abstract class Button {
        public abstract boolean visible(UniScreen var1);

        public boolean enabled(UniScreen us) {
            return true;
        }

        public boolean isToggle() {
            return false;
        }

        public boolean selected(UniScreen us) {
            return false;
        }

        public abstract String text(UniScreen var1);

        public Img icon(UniScreen us) {
            return null;
        }

        public abstract void click(Input var1, UniScreen var2);

        public void tick(Input in, UniScreen us) {
        }

        public String hotkey(UniScreen us) {
            return null;
        }

        public boolean gold(UniScreen us) {
            return false;
        }

        public void renderExtra(UniScreen us, MyDraw d, int x, int y, int w, int h) {
        }

        public String translatedHotkey(UniScreen us) {
            if (this.hotkey(us) == null) {
                return null;
            }
            return Keys.get(this.getClass().getSimpleName() + "_" + this.hotkey(us), this.hotkey(us));
        }
    }

    public static interface VisualLayer {
        public void tick(Input var1, int var2, UniScreen var3);

        public void draw(MyDraw var1, UniScreen var2, double var3, double var5, double var7, double var9);
    }
}

