/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.ConfirmDialog;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public strictfp class UnderConstructionChrome
implements UniScreen.InfoPanel {
    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, final UniScreen us) {
        if (us.hideUI) {
            return;
        }
        if (us.city == null) {
            return;
        }
        if (!(us.intent instanceof DefencesIntent)) {
            return;
        }
        for (final MapLocation.ConstructionEntry ce : us.city.constructing) {
            final Airship ship = ce.ship;
            if (us.tool instanceof PlaceShipTool && ((PlaceShipTool)us.tool).shipToPlace == ship) {
                return;
            }
            int x = (int)((double)(ship.getIntX() + us.adjScrollX) * us.zoom);
            int y = (int)((double)(ship.getIntY() + us.adjScrollY) * us.zoom);
            int w = (int)(ship.getBBWidth() * us.zoom) + 2;
            int h = (int)(ship.getBBHeight() * us.zoom);
            if (ce == us.city.constructing.get(0)) {
                int completionPercent = 100 * us.city.constructionProgress / us.city.constructionTimeCost();
                d.progressBar(x, y + h + MyDraw.BUTTON_SPACING, w, (double)completionPercent * 0.01);
                d.text(completionPercent + "%", AGame.FOUNT, x, y + h + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING * 2);
            }
            int bw = d.bw(Lang._t("Move", new Object[0]));
            d.button(x, y - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING, bw, Lang._t("Move", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    us.tool = new PlaceShipTool(ship, true, null, 1, true);
                }
            });
            x += MyDraw.BUTTON_SPACING + bw;
            bw = d.bw(Lang._t("Cancel", new Object[0]));
            d.button(x, y - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING, bw, Lang._t("Cancel", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    us.confirmDialog = new ConfirmCancelConstructionDialog(us.city, ce);
                }
            });
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }

    public strictfp static class ConfirmCancelConstructionDialog
    implements ConfirmDialog {
        public City c;
        public MapLocation.ConstructionEntry ce;

        public ConfirmCancelConstructionDialog(City c, MapLocation.ConstructionEntry ce) {
            this.c = c;
            this.ce = ce;
        }

        @Override
        public String text() {
            return Lang._t("Cancel_" + this.ce.type.name().toLowerCase() + "_of_x_for_y_gold", this.ce.ship.getName(), this.c.refund(this.ce));
        }

        @Override
        public String okText() {
            return Lang._t("OK", new Object[0]);
        }

        @Override
        public String cancelText() {
            return Lang._t("Cancel", new Object[0]);
        }

        @Override
        public void ok(UniScreen us) {
            us.cw.giveCommand(Client.msg("cancelShipConstruction").put("city", this.c.id).put("id", this.ce.id));
            us.confirmDialog = null;
        }

        @Override
        public void cancel(UniScreen us) {
            us.confirmDialog = null;
        }
    }
}

