/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.Challenge;
import com.zarkonnen.airships.ChallengeCombatIntent;
import com.zarkonnen.airships.ChallengeEditShipIntent;
import com.zarkonnen.airships.ConfirmDialog;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public strictfp class TryAgainChallengeButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        if (us.intent instanceof ChallengeCombatIntent) {
            return !us.combat.sides.get(0).lost();
        }
        return false;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Restart_Tutorial", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        if (us.intent instanceof ChallengeCombatIntent) {
            final ChallengeCombatIntent cci = (ChallengeCombatIntent)us.intent;
            final Challenge challenge = cci.challenge;
            us.confirmDialog = new ConfirmDialog(){

                @Override
                public String text() {
                    return Lang._t("restart_tutorial_confirm", new Object[0]);
                }

                @Override
                public String okText() {
                    return Lang._t("OK", new Object[0]);
                }

                @Override
                public String cancelText() {
                    return Lang._t("Cancel", new Object[0]);
                }

                @Override
                public void ok(UniScreen us) {
                    challenge.reset(true);
                    Analytics.tutorialRestart(challenge.ordinal(), us.combat.time);
                    UniScreen us2 = new UniScreen(us.g, new ChallengeEditShipIntent(challenge, true));
                    us2.standaloneEditShip = cci.playerDesign.clone();
                    us.g.s = us2;
                }

                @Override
                public void cancel(UniScreen us) {
                    us.confirmDialog = null;
                }
            };
        }
    }
}

