/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;

public class TranslationTSVEmitter {
    static StringBuilder out = new StringBuilder();

    private static void p(String ... vs) {
        for (String v : vs) {
            out.append("\"");
            out.append(v.replace("\"", "\\\""));
            out.append("\"\t");
        }
    }

    private static void l() {
        out.append("\n");
    }

    public static void main(String[] args) throws IOException {
        String[] kv;
        String[] languages = new String[]{"en", "fr", "ru", "jpn", "chi", "kor"};
        String[] languageNames = new String[]{"English", "French", "Russian", "Japanese", "Chinese", "Korean"};
        String[] fileNames = new String[]{"_store_short.txt", "_store_long.txt", "_ai_airship_names.txt", "_airship_names.txt", "_building_names.txt", "_combat_help.txt", "_editor_help.txt", "_strategic_help.txt", "_intro.txt"};
        ArrayList<String> ignoredPrefixes = new ArrayList<String>();
        ignoredPrefixes.add("tincture");
        ignoredPrefixes.add("RAM");
        ignoredPrefixes.add("TOWER");
        ignoredPrefixes.add("WHEEL");
        ignoredPrefixes.add("SCALES");
        ignoredPrefixes.add("EAGLE");
        ignoredPrefixes.add("TREE");
        ignoredPrefixes.add("RAT");
        ignoredPrefixes.add("LION");
        ignoredPrefixes.add("CROWN");
        ignoredPrefixes.add("ANVIL");
        ignoredPrefixes.add("DRAGON");
        ignoredPrefixes.add("MOUNTAIN");
        ignoredPrefixes.add("WAVES");
        ignoredPrefixes.add("EYE");
        ignoredPrefixes.add("WRENCH");
        ignoredPrefixes.add("GUILLOTINE");
        ignoredPrefixes.add("SPIDER");
        ignoredPrefixes.add("WOLF");
        ignoredPrefixes.add("BOAR");
        ignoredPrefixes.add("ROUNDEL");
        ignoredPrefixes.add("ANNULET");
        ignoredPrefixes.add("CRESCENT");
        ignoredPrefixes.add("GOUTTE");
        ignoredPrefixes.add("SUN");
        ignoredPrefixes.add("MULLET");
        ignoredPrefixes.add("ESTOILE");
        ignoredPrefixes.add("GEAR");
        ignoredPrefixes.add("FLOWER");
        ignoredPrefixes.add("VOL");
        ignoredPrefixes.add("KEY");
        ignoredPrefixes.add("ANCHOR");
        ignoredPrefixes.add("LOZENGE");
        ignoredPrefixes.add("HARPOON");
        ignoredPrefixes.add("SPEARHEAD");
        ignoredPrefixes.add("BEE");
        ignoredPrefixes.add("fess");
        ignoredPrefixes.add("pale");
        ignoredPrefixes.add("bordure");
        ignoredPrefixes.add("scarpe");
        ignoredPrefixes.add("on_bend");
        ignoredPrefixes.add("on_cross");
        ignoredPrefixes.add("layout");
        HashMap knownItems = new HashMap();
        HashMap<String, String> notes = new HashMap<String, String>();
        HashMap<String, String> oldVersion = new HashMap<String, String>();
        ArrayList<String> enKeyList = new ArrayList<String>();
        for (int li = 0; li < languages.length; ++li) {
            String lang = languages[li];
            HashMap<String, String> items = new HashMap<String, String>();
            knownItems.put(lang, items);
            for (String fn : fileNames) {
                File f = new File("data/lang/" + lang + fn);
                if (f.exists()) {
                    items.put(fn, FileUtils.readFileToString((File)f, (String)"UTF-8"));
                }
                if (!lang.equals("en")) continue;
                enKeyList.add(fn);
            }
            File f = new File("data/lang/" + lang + ".properties");
            if (!f.exists()) continue;
            for (String l : FileUtils.readLines((File)f, (String)"UTF-8")) {
                String[] kv2 = l.split("=");
                if (kv2.length < 2 || ignoredPrefixes.contains(kv2[0].split("_")[0]) || kv2[0].split("_").length > 2 && ignoredPrefixes.contains(kv2[0].split("_")[0] + "_" + kv2[0].split("_")[1])) continue;
                items.put(kv2[0], kv2[1].replace("QUOTE", "'"));
                if (!lang.equals("en")) continue;
                enKeyList.add(kv2[0]);
            }
        }
        for (String l : FileUtils.readLines((File)new File("data/lang/notes.txt"), (String)"UTF-8")) {
            kv = l.split("=");
            if (kv.length < 2) continue;
            notes.put(kv[0], kv[1].replace("QUOTE", "'"));
        }
        for (String l : FileUtils.readLines((File)new File("prev_lang/en.properties"), (String)"UTF-8")) {
            kv = l.split("=");
            if (kv.length < 2) continue;
            oldVersion.put(kv[0], kv[1].replace("QUOTE", "'"));
        }
        for (String fn : fileNames) {
            File f = new File("prev_lang/en" + fn);
            if (!f.exists()) continue;
            oldVersion.put(fn, FileUtils.readFileToString((File)f, (String)"UTF-8"));
        }
        for (int i = 1; i < languages.length; ++i) {
            String lang = languages[i];
            int missingItems = 0;
            int skipped = 0;
            TranslationTSVEmitter.p("ID");
            TranslationTSVEmitter.p("English");
            TranslationTSVEmitter.p(languageNames[i]);
            TranslationTSVEmitter.p("Notes");
            TranslationTSVEmitter.l();
            for (String k : enKeyList) {
                if (oldVersion.containsKey(k) && ((String)oldVersion.get(k)).equals(((HashMap)knownItems.get("en")).get(k)) && ((HashMap)knownItems.get(lang)).containsKey(k)) {
                    ++skipped;
                    continue;
                }
                TranslationTSVEmitter.p(k);
                TranslationTSVEmitter.p((String)((HashMap)knownItems.get("en")).get(k));
                if (((HashMap)knownItems.get(lang)).containsKey(k)) {
                    TranslationTSVEmitter.p((String)((HashMap)knownItems.get(lang)).get(k));
                } else {
                    ++missingItems;
                    TranslationTSVEmitter.p("");
                }
                if (notes.containsKey(k)) {
                    TranslationTSVEmitter.p((String)notes.get(k));
                } else {
                    TranslationTSVEmitter.p("");
                }
                TranslationTSVEmitter.l();
            }
            FileUtils.write((File)new File("airships_" + lang + "_translations.tsv"), (CharSequence)out.toString(), (String)"UTF-8");
            out = new StringBuilder();
            System.out.println(languageNames[i] + " missing items: " + missingItems + ", skipped: " + skipped);
        }
    }
}

