/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;

public class TranslationPreprocessor {
    public static void main(String[] args) throws IOException {
        String srcLang = "en";
        String[] targetLangs = new String[]{"chi", "jpn", "ru", "fr"};
        File base = new File("/home/zar/Desktop/Projects/Airships/data/lang");
        File outDir = new File("/home/zar/Desktop/airshipLangs2");
        String[] src = FileUtils.readFileToString((File)new File(base, srcLang + ".properties"), (String)"UTF-8").split("\n");
        ArrayList<String> keys = new ArrayList<String>();
        StringBuilder srcOut = new StringBuilder();
        for (String l : src) {
            String key = l.split("=")[0];
            if (key.isEmpty()) continue;
            keys.add(key);
            srcOut.append(key);
            srcOut.append("\t");
            srcOut.append(l.split("=").length < 2 ? "" : l.split("=")[1].replace("QUOTE", "'"));
            srcOut.append("\n");
        }
        FileUtils.writeStringToFile((File)new File(outDir, srcLang + ".csv"), (String)srcOut.toString(), (String)"UTF-8");
        for (String lang : targetLangs) {
            String[] lsrc = FileUtils.readFileToString((File)new File(base, lang + ".properties"), (String)"UTF-8").split("\n");
            HashMap<String, String> mapping = new HashMap<String, String>();
            for (String l : lsrc) {
                String[] kv = l.split("=");
                if (kv.length != 2 || kv[0].isEmpty()) continue;
                mapping.put(kv[0], kv[1].replace("QUOTE", "'"));
            }
            StringBuilder out = new StringBuilder();
            for (String k : keys) {
                out.append(k);
                out.append("\t");
                out.append(mapping.containsKey(k) ? (String)mapping.get(k) : "");
                out.append("\n");
            }
            FileUtils.writeStringToFile((File)new File(outDir, lang + ".csv"), (String)out.toString(), (String)"UTF-8");
        }
    }
}

