/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import org.json.JSONObject;
import org.newdawn.slick.Color;

public class Tincture
extends Loadable {
    public final Clr tint;
    public final Color mapColor;
    public final Clr paintTint;
    public final Clr nicePaintTint;
    public final Color tintColor;
    public final boolean metal;
    public final float[] replacementValue;
    public PaintType paintType;

    public Tincture(JSONObject o) {
        super(o.getString("name"), o.optInt("sort", 0));
        this.tint = new Clr(o.getJSONObject("pureColour").getInt("r"), o.getJSONObject("pureColour").getInt("g"), o.getJSONObject("pureColour").getInt("b"));
        this.metal = o.optBoolean("metal", false);
        this.paintTint = new Clr(this.tint.r, this.tint.g, this.tint.b, 100);
        this.nicePaintTint = new Clr(this.tint.r, this.tint.g, this.tint.b, 200).mix(0.2, Clr.DARK_GREY);
        this.replacementValue = new float[]{(float)o.getJSONObject("moduleColour").getInt("r") / 255.0f, (float)o.getJSONObject("moduleColour").getInt("g") / 255.0f, (float)o.getJSONObject("moduleColour").getInt("b") / 255.0f};
        this.mapColor = new Color(this.tint.r, this.tint.g, this.tint.b, 64);
        this.tintColor = new Color(this.tint.r, this.tint.g, this.tint.b);
    }

    public String getName() {
        return Lang._t("tincture_" + this.name, new Object[0]);
    }

    public static Tincture valueOf(String name) {
        return Loadable.ofName(Tincture.class, name);
    }

    public static ArrayList<Tincture> values() {
        return Loadable.all(Tincture.class);
    }

    public int ordinal() {
        return Tincture.values().indexOf(this);
    }

    public String name() {
        return this.name;
    }
}

