/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CloudType;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.WeatherEffect;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;
import org.newdawn.slick.Color;

public strictfp class TimeOfDay
extends Loadable {
    public final Color[] light;
    public final float lightStrength;
    public final double haloStrength;
    public final Clr[] skyColors;
    public final int skyColorBandHeight;
    public final WeatherEffect effect;
    public final Color ambient;
    public final float ambientAmt;
    public final float ambientSaturation;
    public final Color backdropAmbient;
    public final float backdropAmbientSaturation;
    public final Clr ambientTint;
    public final Clr deepSoilTint;
    public final CloudType clouds;
    public final boolean cloudBottomsAligned;
    public final String appearancePostfix;
    public final boolean appearancePostfixIsBad;
    public static final ArrayList<String> ORIGINAL_APPEARANCE_POSTFIXES = new ArrayList();
    public static TimeOfDay[] TOURNAMENT;

    public String getName() {
        return Lang._t("timeOfDay_" + this.name, new Object[0]);
    }

    private static Color getColor(JSONObject o) {
        return new Color(o.getInt("r"), o.getInt("g"), o.getInt("b"));
    }

    private static Clr getClr(JSONObject o) {
        return new Clr(o.getInt("r"), o.getInt("g"), o.getInt("b"));
    }

    public TimeOfDay(JSONObject o) {
        super(o.getString("name"));
        this.light = new Color[]{TimeOfDay.getColor(o.getJSONObject("topLight")), TimeOfDay.getColor(o.getJSONObject("leftLight")), TimeOfDay.getColor(o.getJSONObject("rightLight")), TimeOfDay.getColor(o.getJSONObject("bottomLight"))};
        this.ambientSaturation = (float)o.optDouble("ambientSaturation", 1.0);
        if (o.optJSONObject("ambient") != null) {
            this.ambient = TimeOfDay.getColor(o.getJSONObject("ambient"));
            this.ambientTint = TimeOfDay.getClr(o.getJSONObject("ambient"));
            this.ambientAmt = (float)((double)(this.ambient.r + this.ambient.g + this.ambient.b) * 1.0 / 765.0);
            this.deepSoilTint = new Clr((int)(87.3 * (double)this.ambientTint.r / 255.0), (int)(56.7 * (double)this.ambientTint.g / 255.0), (int)(40.5 * (double)this.ambientTint.b / 255.0));
        } else {
            this.ambientAmt = (float)o.getDouble("ambient");
            this.ambient = new Color(this.ambientAmt, this.ambientAmt, this.ambientAmt);
            this.ambientTint = new Clr((int)(255.0f * this.ambientAmt), (int)(255.0f * this.ambientAmt), (int)(255.0f * this.ambientAmt));
            float a2 = 0.1f + this.ambientAmt;
            this.deepSoilTint = new Clr((int)(87.3 * (double)a2), (int)(56.7 * (double)a2), (int)(40.5 * (double)a2));
        }
        this.backdropAmbient = o.optJSONObject("backdropAmbient") != null ? TimeOfDay.getColor(o.getJSONObject("backdropAmbient")) : this.ambient;
        this.backdropAmbientSaturation = (float)o.optDouble("backdropAmbientSaturation", (double)this.ambientSaturation * 0.5);
        this.lightStrength = (float)o.getDouble("lightStrength");
        this.haloStrength = o.getDouble("haloSize");
        JSONArray sc = o.getJSONArray("skyColors");
        this.skyColors = new Clr[sc.length()];
        for (int i = 0; i < this.skyColors.length; ++i) {
            this.skyColors[i] = TimeOfDay.getClr(sc.getJSONObject(i));
        }
        this.skyColorBandHeight = o.getInt("skyColorBandHeight");
        this.effect = WeatherEffect.ofName(o.getString("weatherEffect"));
        this.clouds = CloudType.ofName(o.getString("clouds"));
        this.cloudBottomsAligned = o.getBoolean("cloudBottomsAligned");
        String apf = o.optString("appearancePostfix", this.name);
        if (!ORIGINAL_APPEARANCE_POSTFIXES.contains(apf)) {
            this.appearancePostfixIsBad = true;
            this.appearancePostfix = "DAY";
        } else {
            this.appearancePostfixIsBad = false;
            this.appearancePostfix = apf;
        }
    }

    public static TimeOfDay ofName(String name) {
        return Loadable.ofName(TimeOfDay.class, name);
    }

    public static void postLoad() {
        TOURNAMENT = new TimeOfDay[]{TimeOfDay.ofName("DAY"), TimeOfDay.ofName("DAY"), TimeOfDay.ofName("DAY"), TimeOfDay.ofName("NIGHT"), TimeOfDay.ofName("RAIN"), TimeOfDay.ofName("FOG"), TimeOfDay.ofName("STORM"), TimeOfDay.ofName("SNOW"), TimeOfDay.ofName("SNOW")};
    }

    public static ArrayList<TimeOfDay> getOriginals() {
        ArrayList<TimeOfDay> l = new ArrayList<TimeOfDay>();
        for (String s : ORIGINAL_APPEARANCE_POSTFIXES) {
            l.add(TimeOfDay.ofName(s));
        }
        return l;
    }

    public static TimeOfDay getRandom(Random r, LandscapeType lst) {
        int total = 0;
        for (Utils.Pair<Integer, TimeOfDay> p : lst.timesOfDay) {
            total += ((Integer)p.a).intValue();
        }
        int roll = r.nextInt(total);
        for (Utils.Pair<Integer, TimeOfDay> p : lst.timesOfDay) {
            if ((roll -= ((Integer)p.a).intValue()) > 0) continue;
            return (TimeOfDay)p.b;
        }
        return (TimeOfDay)lst.timesOfDay.get((int)0).b;
    }

    public static TimeOfDay getRandomForTournament(Random r) {
        return TOURNAMENT[r.nextInt(TOURNAMENT.length)];
    }

    static {
        ORIGINAL_APPEARANCE_POSTFIXES.add("DAY");
        ORIGINAL_APPEARANCE_POSTFIXES.add("NIGHT");
        ORIGINAL_APPEARANCE_POSTFIXES.add("DAWN");
        ORIGINAL_APPEARANCE_POSTFIXES.add("DUSK");
        ORIGINAL_APPEARANCE_POSTFIXES.add("SNOW");
        ORIGINAL_APPEARANCE_POSTFIXES.add("RAIN");
        ORIGINAL_APPEARANCE_POSTFIXES.add("FOG");
        ORIGINAL_APPEARANCE_POSTFIXES.add("STORM");
        TOURNAMENT = null;
    }
}

