/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ArmourPlate;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.ExceptionalCombatEvent;
import com.zarkonnen.airships.Fragment;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.GridLocation;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.TileMask;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import org.json.JSONObject;

public strictfp class Tile
implements JSONAble,
GridLocation {
    public static final double MIN_CREW_HARM_P = 1.5;
    public static final double PEN_TO_HARM = 0.1;
    public static final double BLAST_TO_HARM = 0.2;
    public static final double DIRECT_TO_HARM = 0.1;
    public transient int pathCostTmp;
    public int x;
    public int y;
    public ArmourPlate armour;
    public Module module;
    public final boolean[][] hadAdjacentOccupableTile = new boolean[3][3];
    public transient boolean canOccupy;
    public transient boolean[][] adjacent = new boolean[3][3];
    public transient Airship ship;
    public transient ArrayList<GridLocation> reachable = new ArrayList();
    public transient Img[] splinters;

    public int cheapHash() {
        int h = 7;
        h = h * 31 + this.x;
        h = h * 31 + this.y;
        h = h * 31 + this.armour.hp;
        return h;
    }

    @Override
    public ArrayList<GridLocation> reachable() {
        return this.reachable;
    }

    @Override
    public boolean enterable() {
        return this.canOccupy && (this.armour.hp <= 0 || this.armour.type == ArmourType.ofName("NONE") || this.module.type.isHatch(this.ship.currentBonuses) || !this.adjacent[0][1] && this.hadAdjacentOccupableTile[0][1] || !this.adjacent[2][1] && this.hadAdjacentOccupableTile[2][1] || !this.adjacent[1][0] && this.hadAdjacentOccupableTile[1][0] || !this.adjacent[1][2] && this.hadAdjacentOccupableTile[1][2]);
    }

    public void setShip(Airship ship) {
        this.ship = ship;
        this.armour.ship = ship;
    }

    public final boolean isMaskedEmpty() {
        return this.module.type.getTileMasks(this.ship.currentBonuses)[this.y - this.module.y][this.x - this.module.x] == TileMask.EMPTY;
    }

    public Tile(Airship ship, Module module, int x, int y) {
        this.ship = ship;
        this.module = module;
        this.x = x;
        this.y = y;
        boolean hasWin = false;
        for (Utils.Pair<Integer, Integer> win : module.type.getWindows()) {
            if ((Integer)win.a != x - module.x || (Integer)win.b != y - module.y) continue;
            hasWin = true;
            break;
        }
        for (Utils.Pair<Integer, Integer> occ : module.type.getCanOccupy()) {
            if ((Integer)occ.a != x - module.x || (Integer)occ.b != y - module.y) continue;
            this.canOccupy = true;
            break;
        }
        this.armour = new ArmourPlate(hasWin, ship);
    }

    private Decal checkDecalDestruction() {
        for (Decal d : this.ship.decals) {
            if (!d.enabled || d.x > this.x || d.y > this.y || d.x + d.type.w <= this.x || d.y + d.type.h <= this.y) continue;
            d.enabled = false;
            return d;
        }
        return null;
    }

    public void splashHit(Combat c, boolean onViewingSide, int blast, Shot optionalSourceShot, boolean inside) {
        Crewman op;
        Decal dest;
        int absorb;
        int prevArmourHP = this.armour.hp;
        double myX = this.ship.getIntX() + this.ship.gridXToWorldX(this.x, 1) * 16 + 8;
        double myY = this.ship.getIntY() + this.y * 16 + 8;
        if (this.armour.hp > 0) {
            if (!inside) {
                absorb = this.armour.type.getBlastDmgAbsorb(this.ship.constructionBonuses);
                if (this.module.hp > 0) {
                    absorb += this.module.getShellBlastAbsorb();
                }
                blast = blast <= absorb ? (c.r.nextInt(2 + absorb - blast) == 1 ? 1 : 0) : (blast -= absorb);
            }
            if (this.armour.hp > blast) {
                this.armour.hp -= blast;
                if (!inside) {
                    blast = 0;
                }
            } else {
                if (!inside) {
                    blast -= this.armour.hp;
                }
                this.armour.hp = 0;
            }
            this.armour.hp = StrictMath.max(0, this.armour.hp);
            if (this.armour.hp == 0) {
                c.play(this.armour.type.brokenSound.get(this.ship.currentBonuses), myX, myY, 0.0, 0.0, !onViewingSide);
            } else if (blast > this.armour.getMaxHP() / 2) {
                c.play(this.armour.type.largeHitSound.get(this.ship.currentBonuses), myX, myY, 0.0, 0.0, !onViewingSide);
            }
        } else if (this.module.hp > 0 && !inside) {
            absorb = this.module.getShellBlastAbsorb();
            blast = blast <= absorb ? (c.r.nextInt(2 + absorb - blast) == 1 ? 1 : 0) : (blast -= absorb);
        }
        if ((double)this.armour.hp < (double)this.armour.getMaxHP() * 0.4 && (dest = this.checkDecalDestruction()) != null) {
            for (int dx = dest.x; dx < dest.x + dest.type.w; ++dx) {
                for (int dy = dest.y; dy < dest.y + dest.type.h; ++dy) {
                    for (int i = 0; i < 2; ++i) {
                        c.particles.add(new Particle(ParticleType.ofName("fragment"), this.ship.getIntX() + this.ship.gridXToWorldX(dx, 1) * 16 + 8, this.ship.getIntY() + dy * 16 + 8));
                    }
                }
            }
        }
        for (ModuleType.FragmentImg fragI : this.armour.getFragments(prevArmourHP, this.armour.hp)) {
            double speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * 0.3;
            double angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
            double dx = speed * StrictMath.cos(angle);
            double dy = speed * StrictMath.sin(angle) - 0.3 * speed;
            c.fragments.add(new Fragment(fragI.ssb, fragI.img, (double)(this.ship.getIntX() + this.ship.gridXToWorldX(this.x, 1) * 16 + fragI.dx), (double)(this.ship.getIntY() + this.y * 16 + fragI.dy), dx, dy, 0.0, AGame.ANIM_R.nextDouble() * 0.02 - 0.01, 300 + AGame.ANIM_R.nextInt(400), 4));
        }
        ParticleType hitParticle = this.module.type.hitParticle(this.ship.currentBonuses);
        if (hitParticle != null) {
            int nParticles = StrictMath.min(10, blast / 10) + 1;
            for (int i = 0; i < nParticles; ++i) {
                c.particles.add(new Particle(hitParticle, (double)(this.ship.getIntX() + this.ship.gridXToWorldX(this.x, 1) * 16) + AGame.ANIM_R.nextDouble() * 16.0, (double)(this.ship.getIntY() + this.y * 16) + AGame.ANIM_R.nextDouble() * 16.0));
            }
        }
        if (blast == 0) {
            return;
        }
        int prevModuleHP = this.module.hp;
        this.module.hp -= blast;
        boolean cheer = this.module.hp <= 0 && prevModuleHP > 0;
        int adjFireHP = this.module.type.getFireHP(this.ship.currentBonuses) * this.module.maxHP / this.module.type.getHp(this.ship.currentBonuses);
        if (this.module.hp > 0 && this.module.hp < adjFireHP) {
            double fireRollVs = (double)blast * 1.5 * (double)adjFireHP / (double)this.module.maxHP / (double)this.module.maxHP;
            if (c.r.nextDouble() <= fireRollVs) {
                this.module.fire = StrictMath.max(this.module.fire, 6);
                cheer = true;
            }
        }
        if (cheer && optionalSourceShot != null && optionalSourceShot.weapon != null && (op = optionalSourceShot.weapon.findOperator()) != null) {
            op.shout("directHit");
        }
        double harmPotential = 1.5 + (double)blast * 0.2;
        for (int boarders = 0; boarders < 2; ++boarders) {
            int csz = (boarders == 1 ? this.ship.boarders : this.ship.crew).size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = (boarders == 1 ? this.ship.boarders : this.ship.crew).get(ci);
                if (cm.currentTile != this) continue;
                int harm = (int)StrictMath.floor((inside ? 1.0 : c.r.nextDouble()) * harmPotential);
                if (this.module.hp <= 0) {
                    harm = cm.type.maxHP * 2;
                }
                cm.hurt(optionalSourceShot, harm, c, onViewingSide);
            }
        }
    }

    public void hit(Shot shot, Combat c, boolean onViewingSide) {
        int pen = shot.getPenDmg();
        int blast = shot.getBlastSplashRadius() == 0 ? shot.getBlastDmg() : 0;
        int direct = shot.getDirectDmg();
        int total = pen + blast + direct;
        int prevArmourHP = this.armour.hp;
        double myX = this.ship.getIntX() + this.ship.gridXToWorldX(this.x, 1) * 16 + 8;
        double myY = this.ship.getIntY() + this.y * 16 + 8;
        if (!shot.internal) {
            Crewman op;
            Decal dest;
            int blastAbsorb;
            int penAbsorb;
            boolean plinked;
            if (this.armour.hp > 0) {
                plinked = direct == 0;
                penAbsorb = this.armour.type.getPenDmgAbsorb(this.ship.constructionBonuses);
                if (this.module.hp > 0) {
                    penAbsorb += this.module.getShellPenAbsorb();
                }
                if (pen <= penAbsorb) {
                    pen = c.r.nextInt(2 + penAbsorb - pen) == 1 ? 1 : 0;
                } else {
                    plinked = false;
                    pen -= penAbsorb;
                }
                if (this.armour.hp > pen) {
                    this.armour.hp -= pen;
                    pen = 0;
                } else {
                    pen -= this.armour.hp;
                    this.armour.hp = 0;
                }
                blastAbsorb = this.armour.type.getBlastDmgAbsorb(this.ship.constructionBonuses);
                if (this.module.hp > 0) {
                    blastAbsorb += this.module.getShellBlastAbsorb();
                }
                if (blast <= blastAbsorb) {
                    blast = c.r.nextInt(2 + blastAbsorb - blast) == 1 ? 1 : 0;
                } else {
                    plinked = false;
                    blast -= blastAbsorb;
                }
                if (plinked && shot.weaponType != null && !c.plinkedArmoursAndModules.contains(this.armour.type)) {
                    c.plinkedArmoursAndModules.add(this.armour.type);
                    c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("plinked " + this.armour.type.name + " " + shot.weaponType.name, c.otherSide(c.sideOf(this.ship)), shot.getX(), shot.getY(), null, null, shot.weaponType));
                }
                if (this.armour.hp > blast) {
                    this.armour.hp -= blast;
                    blast = 0;
                } else {
                    blast -= this.armour.hp;
                    this.armour.hp = 0;
                }
                if (this.armour.hp > direct) {
                    this.armour.hp -= direct;
                    direct = 0;
                } else {
                    direct -= this.armour.hp;
                    this.armour.hp = 0;
                }
                this.armour.hp = StrictMath.max(0, this.armour.hp);
                if (this.armour.hp == 0) {
                    c.play(this.armour.type.brokenSound.get(this.ship.currentBonuses), myX, myY, 0.0, 0.0, !onViewingSide);
                } else if (total > this.armour.getMaxHP() / 2) {
                    c.play(this.armour.type.largeHitSound.get(this.ship.currentBonuses), myX, myY, 0.0, 0.0, !onViewingSide);
                } else {
                    c.play(this.armour.type.smallHitSound.get(this.ship.currentBonuses), myX, myY, 0.0, 0.0, !onViewingSide);
                }
            } else {
                if (this.module.hp > 0) {
                    plinked = direct == 0;
                    penAbsorb = this.module.getShellPenAbsorb();
                    if (pen <= penAbsorb) {
                        pen = c.r.nextInt(2 + penAbsorb - pen) == 1 ? 1 : 0;
                    } else {
                        pen -= penAbsorb;
                        plinked = false;
                    }
                    blastAbsorb = this.module.getShellBlastAbsorb();
                    if (blast <= blastAbsorb) {
                        blast = c.r.nextInt(2 + blastAbsorb - blast) == 1 ? 1 : 0;
                    } else {
                        blast -= blastAbsorb;
                        plinked = false;
                    }
                    if (plinked && shot.weaponType != null && !c.plinkedArmoursAndModules.contains(this.module.type)) {
                        c.plinkedArmoursAndModules.add(this.module.type);
                        c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("plinked " + this.module.type.name + " " + shot.weaponType.name, c.otherSide(c.sideOf(this.ship)), shot.getX(), shot.getY(), null, null, shot.weaponType));
                    }
                }
                if ((total = pen + blast + direct) < 15) {
                    c.play(MiscCombatSound.SMALL_HIT, myX, myY, 0.0, 0.0, !onViewingSide);
                } else if (total < 40) {
                    c.play(MiscCombatSound.MEDIUM_HIT, myX, myY, 0.0, 0.0, !onViewingSide);
                } else {
                    c.play(MiscCombatSound.LARGE_HIT, myX, myY, 0.0, 0.0, !onViewingSide);
                }
            }
            if ((double)this.armour.hp < (double)this.armour.getMaxHP() * 0.4 && (dest = this.checkDecalDestruction()) != null) {
                for (int dx = dest.x; dx < dest.x + dest.type.w; ++dx) {
                    for (int dy = dest.y; dy < dest.y + dest.type.h; ++dy) {
                        for (int i = 0; i < 2; ++i) {
                            c.particles.add(new Particle(ParticleType.ofName("fragment"), this.ship.getIntX() + this.ship.gridXToWorldX(dx, 1) * 16 + 8, this.ship.getIntY() + dy * 16 + 8));
                        }
                    }
                }
            }
            for (ModuleType.FragmentImg fragI : this.armour.getFragments(prevArmourHP, this.armour.hp)) {
                double speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * 0.3;
                double angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                double dx = speed * StrictMath.cos(angle);
                double dy = speed * StrictMath.sin(angle) - 0.3 * speed;
                c.fragments.add(new Fragment(fragI.ssb, fragI.img, (double)(this.ship.getIntX() + this.ship.gridXToWorldX(this.x, 1) * 16 + fragI.dx), (double)(this.ship.getIntY() + this.y * 16 + fragI.dy), dx, dy, 0.0, AGame.ANIM_R.nextDouble() * 0.02 - 0.01, 300 + AGame.ANIM_R.nextInt(400), 4));
            }
            ParticleType hitParticle = this.module.type.hitParticle(this.ship.currentBonuses);
            if (hitParticle != null) {
                int nParticles = StrictMath.min(10, (pen + blast) / 10) + 1;
                for (int i = 0; i < nParticles; ++i) {
                    c.particles.add(new Particle(hitParticle, shot.tX, shot.tY));
                }
            }
            if (pen + blast + direct == 0) {
                return;
            }
            int prevModuleHP = this.module.hp;
            this.module.hp -= pen + blast + direct;
            boolean cheer = this.module.hp <= 0 && prevModuleHP > 0;
            int adjFireHP = this.module.type.getFireHP(this.ship.currentBonuses) * this.module.maxHP / this.module.type.getHp(this.ship.currentBonuses);
            if (this.module.hp > 0 && this.module.hp < adjFireHP) {
                double fireRollVs = (double)(pen + blast + direct) * 1.5 * (double)adjFireHP / (double)this.module.maxHP / (double)this.module.maxHP;
                if (c.r.nextDouble() <= fireRollVs) {
                    this.module.fire = StrictMath.max(this.module.fire, 6);
                    cheer = true;
                }
            }
            if (cheer && shot.weapon != null && (op = shot.weapon.findOperator()) != null) {
                op.shout("directHit");
            }
            if (this.module.hp <= -this.module.type.getHp(this.ship.currentBonuses) / 2) {
                this.module.hp = this.module.type.getHp(this.ship.currentBonuses) * -16 - 1;
            }
        }
        double harmPotential = 1.5 + (double)pen * 0.1 + (double)blast * 0.2 + (double)direct * 0.1;
        for (int boarders = 0; boarders < 2; ++boarders) {
            if (boarders == 0 && !shot.harmsCrew() || boarders == 1 && !shot.harmsBoarders()) continue;
            int csz = (boarders == 1 ? this.ship.boarders : this.ship.crew).size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = (boarders == 1 ? this.ship.boarders : this.ship.crew).get(ci);
                if (cm.currentTile != this || !cm.alive()) continue;
                int harm = (int)StrictMath.floor(c.r.nextDouble() * harmPotential);
                cm.hurt(shot, harm, c, onViewingSide);
                if (harm <= 0 || !shot.internal) continue;
                return;
            }
        }
    }

    public int getMoveDelay() {
        return this.module.type.getMoveDelay(this.ship.currentBonuses);
    }

    public void tick(Combat c, int ms, Airship ship) {
        if (this.module.fire > 0) {
            int i;
            double fireParticlesSpawn = (double)(this.module.fire * ms) * AGame.ANIM_R.nextDouble() * 0.003;
            double smokeParticlesSpawn = (double)(this.module.fire * ms) * AGame.ANIM_R.nextDouble() * 1.0E-4;
            int fireParticlesSpawned = StrictMath.min(1, (int)StrictMath.floor(fireParticlesSpawn) + (AGame.ANIM_R.nextDouble() < fireParticlesSpawn % 1.0 ? 1 : 0));
            int smokeParticlesSpawned = StrictMath.min(1, (int)StrictMath.floor(smokeParticlesSpawn) + (AGame.ANIM_R.nextDouble() < smokeParticlesSpawn % 1.0 ? 1 : 0));
            for (i = 0; i < fireParticlesSpawned; ++i) {
                c.particles.add(new Particle(ParticleType.ofName("fire"), ship.getIntX() + ship.gridXToWorldX(this.x, 1) * 16 + 8, ship.getIntY() + this.y * 16 + 8));
            }
            for (i = 0; i < smokeParticlesSpawned; ++i) {
                c.particles.add(new Particle(ParticleType.ofName("fire_smoke"), ship.getIntX() + ship.gridXToWorldX(this.x, 1) * 16 + 8, ship.getIntY() + this.y * 16 + 8));
            }
        }
    }

    public Tile(JSONObject o, Airship ship) {
        this.x = o.getInt("x");
        this.y = o.getInt("y");
        this.armour = new ArmourPlate(o.getJSONObject("armour"), ship);
        this.module = ship.modules.get(o.getInt("module"));
        for (Utils.Pair<Integer, Integer> occ : this.module.type.getCanOccupy()) {
            if ((Integer)occ.a != this.x - this.module.x || (Integer)occ.b != this.y - this.module.y) continue;
            this.canOccupy = true;
            break;
        }
        this.ship = ship;
        String adjString = o.optString("hAdj", "000000000");
        for (int i = 0; i < 9; ++i) {
            this.hadAdjacentOccupableTile[i / 3][i % 3] = adjString.charAt(i) != '0';
        }
        if (this.isMaskedEmpty()) {
            this.armour.setType(ArmourType.ofName("NONE"));
        }
        if (this.module.type.getArmourType() != null && this.armour.type != this.module.type.getArmourType()) {
            this.armour.setType(this.module.type.getArmourType());
        }
    }

    @Override
    public JSONObject toJSON() {
        StringBuilder hAdjString = new StringBuilder();
        for (int hay = 0; hay < 3; ++hay) {
            for (int hax = 0; hax < 3; ++hax) {
                hAdjString.append(this.hadAdjacentOccupableTile[hay][hax] ? "1" : "0");
            }
        }
        return new JSONObject().put("x", this.x).put("y", this.y).put("armour", this.armour.toJSON()).put("module", this.module.ship.modules.indexOf(this.module)).put("hAdj", hAdjString.toString());
    }

    @Override
    public GridBody body() {
        return this.ship;
    }

    @Override
    public int worldGridX() {
        return this.ship.gridXToWorldX(this.x, 1);
    }

    @Override
    public int worldGridY() {
        return this.y;
    }

    @Override
    public boolean solid() {
        return this.ship.tileAt(this.x, this.y) != null;
    }

    public boolean full() {
        return this.module.type.getTileMasks(this.ship.currentBonuses)[this.y - this.module.y][this.x - this.module.x] == TileMask.FULL;
    }

    @Override
    public double worldX() {
        return this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, 1) * 16);
    }

    @Override
    public double worldY() {
        return this.ship.getY() + (double)(this.y * 16);
    }

    public String toString() {
        return this.x + " " + this.y + " @ " + this.ship.getName();
    }
}

