/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.SoundEffect;
import com.zarkonnen.catengine.Img;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class TentacleSpec {
    public final int numSegments;
    public final double baseXOffset;
    public final double baseYOffset;
    public final double baseAngle;
    public final double baseStiffness;
    public final double tipStiffness;
    public final double baseLength;
    public final double tipLength;
    public final double baseWidth;
    public final double tipWidth;
    public final double speed;
    public final boolean snatchesCrew;
    public final SoundEffect snatchSound;
    public final double mouthXOffset;
    public final double mouthYOffset;
    public final boolean attacksHull;
    public final int attackBlastDmg;
    public final int attackPenDmg;
    public final int attackDirectDmg;
    public final SoundEffect attackSound;
    public final ParticleType attackSprayParticle;
    public final double attackSprayP;
    public final ParticleType attackImpactParticle;
    public final int numAttackImpactParticles;
    public final boolean wavesAround;
    public final boolean suckerDirection;
    public final int minNextTargetPause;
    public final int maxNextTargetPause;
    public final Img segmentImg;
    public final Img segmentImgVerticallyFlipped;
    public final Img[] segmentImgOverride;
    public final Img[] segmentImgOverrideVerticallyFlipped;
    public final double imgLength;
    public final Particle.Emitter tipEmitter;

    public int getDPSEquivalent() {
        return 10;
    }

    public TentacleSpec(TentacleSpec flipFrom, int moduleW) {
        this.numSegments = flipFrom.numSegments;
        this.baseAngle = Direction.flipHorizontal(flipFrom.baseAngle);
        this.baseXOffset = (double)moduleW - flipFrom.baseXOffset;
        this.baseYOffset = flipFrom.baseYOffset;
        this.baseStiffness = flipFrom.baseStiffness;
        this.tipStiffness = flipFrom.tipStiffness;
        this.baseLength = flipFrom.baseLength;
        this.tipLength = flipFrom.tipLength;
        this.baseWidth = flipFrom.baseWidth;
        this.tipWidth = flipFrom.tipWidth;
        this.speed = flipFrom.speed;
        this.snatchesCrew = flipFrom.snatchesCrew;
        this.mouthXOffset = (double)moduleW - flipFrom.mouthXOffset;
        this.mouthYOffset = flipFrom.mouthYOffset;
        this.snatchSound = flipFrom.snatchSound;
        this.attacksHull = flipFrom.attacksHull;
        this.attackPenDmg = flipFrom.attackPenDmg;
        this.attackBlastDmg = flipFrom.attackBlastDmg;
        this.attackDirectDmg = flipFrom.attackDirectDmg;
        this.attackSprayParticle = flipFrom.attackSprayParticle;
        this.attackSprayP = flipFrom.attackSprayP;
        this.attackImpactParticle = flipFrom.attackImpactParticle;
        this.numAttackImpactParticles = flipFrom.numAttackImpactParticles;
        this.attackSound = flipFrom.attackSound;
        this.minNextTargetPause = flipFrom.minNextTargetPause;
        this.maxNextTargetPause = flipFrom.maxNextTargetPause;
        this.wavesAround = flipFrom.wavesAround;
        this.suckerDirection = !flipFrom.suckerDirection;
        this.segmentImg = flipFrom.segmentImgVerticallyFlipped;
        this.segmentImgVerticallyFlipped = flipFrom.segmentImg;
        this.segmentImgOverride = flipFrom.segmentImgOverrideVerticallyFlipped;
        this.segmentImgOverrideVerticallyFlipped = flipFrom.segmentImgOverride;
        this.imgLength = flipFrom.imgLength;
        this.tipEmitter = flipFrom.tipEmitter;
    }

    public TentacleSpec(JSONObject o) {
        this.numSegments = o.getInt("numSegments");
        this.baseAngle = o.getDouble("baseAngle");
        this.baseXOffset = o.getDouble("baseXOffset");
        this.baseYOffset = o.getDouble("baseYOffset");
        this.baseStiffness = o.getDouble("baseStiffness");
        this.tipStiffness = o.getDouble("tipStiffness");
        this.baseLength = o.getDouble("baseLength");
        this.tipLength = o.getDouble("tipLength");
        this.baseWidth = o.getDouble("baseWidth");
        this.tipWidth = o.getDouble("tipWidth");
        this.speed = o.getDouble("speed");
        this.snatchesCrew = o.getBoolean("snatchesCrew");
        if (this.snatchesCrew) {
            this.mouthXOffset = o.getDouble("mouthXOffset");
            this.mouthYOffset = o.getDouble("mouthYOffset");
        } else {
            this.mouthXOffset = 0.0;
            this.mouthYOffset = 0.0;
        }
        SoundEffect ss = null;
        if (o.has("snatchSound")) {
            try {
                ss = new SoundEffect(o.getString("snatchSound"), o.optInt("numSnatchSounds", 1));
            }
            catch (Exception e) {
                ss = new SoundEffect(o.getJSONObject("snatchSound"));
            }
        }
        this.snatchSound = ss;
        this.attacksHull = o.getBoolean("attacksHull");
        if (this.attacksHull) {
            this.attackPenDmg = o.getInt("attackPenDmg");
            this.attackBlastDmg = o.getInt("attackBlastDmg");
            this.attackDirectDmg = o.optInt("attackDirectDmg");
            this.attackSprayParticle = o.has("attackSprayParticle") ? ParticleType.ofName(o.getString("attackSprayParticle")) : null;
            this.attackSprayP = o.optDouble("attackSprayP", 1.0);
            this.attackImpactParticle = o.has("attackImpactParticle") ? ParticleType.ofName(o.getString("attackImpactParticle")) : null;
            this.numAttackImpactParticles = o.optInt("numAttackImpactParticles", 1);
        } else {
            this.attackPenDmg = 0;
            this.attackBlastDmg = 0;
            this.attackDirectDmg = 0;
            this.attackSprayParticle = null;
            this.attackSprayP = 0.0;
            this.attackImpactParticle = null;
            this.numAttackImpactParticles = 0;
        }
        SoundEffect as = null;
        if (o.has("attackSound")) {
            try {
                as = new SoundEffect(o.getString("attackSound"), o.optInt("numAttackSounds", 1));
            }
            catch (Exception e) {
                as = new SoundEffect(o.getJSONObject("attackSound"));
            }
        }
        this.attackSound = as;
        this.minNextTargetPause = o.optInt("minNextTargetPause", 500);
        this.maxNextTargetPause = StrictMath.max(this.minNextTargetPause + 1, o.optInt("maxNextTargetPause", 1000));
        this.wavesAround = o.getBoolean("wavesAround");
        this.suckerDirection = o.getBoolean("suckerDirection");
        this.segmentImg = new Img(o.getJSONObject("segmentImg").getString("src"), o.getJSONObject("segmentImg").getInt("x"), o.getJSONObject("segmentImg").getInt("y"), o.getJSONObject("segmentImg").getInt("w"), o.getJSONObject("segmentImg").getInt("h"), o.getJSONObject("segmentImg").optBoolean("flipped", false));
        this.segmentImgVerticallyFlipped = new Img(o.getJSONObject("segmentImgVerticallyFlipped").getString("src"), o.getJSONObject("segmentImgVerticallyFlipped").getInt("x"), o.getJSONObject("segmentImgVerticallyFlipped").getInt("y"), o.getJSONObject("segmentImgVerticallyFlipped").getInt("w"), o.getJSONObject("segmentImgVerticallyFlipped").getInt("h"), o.getJSONObject("segmentImgVerticallyFlipped").optBoolean("flipped", false));
        this.segmentImgOverride = new Img[this.numSegments];
        this.segmentImgOverrideVerticallyFlipped = new Img[this.numSegments];
        if (o.has("segmentImgOverrides")) {
            JSONArray a = o.getJSONArray("segmentImgOverrides");
            for (int i = 0; i < a.length(); ++i) {
                JSONObject ov = a.getJSONObject(i);
                int index = ov.getInt("index");
                JSONObject img = ov.getJSONObject("img");
                this.segmentImgOverride[index] = new Img(img.getString("src"), img.getInt("x"), img.getInt("y"), img.getInt("w"), img.getInt("h"), img.optBoolean("flipped", false));
                img = ov.getJSONObject("imgVerticallyFlipped");
                this.segmentImgOverrideVerticallyFlipped[index] = new Img(img.getString("src"), img.getInt("x"), img.getInt("y"), img.getInt("w"), img.getInt("h"), img.optBoolean("flipped", false));
            }
        }
        this.imgLength = o.getDouble("imgLength");
        if (o.has("tipEmitter")) {
            JSONObject pe = o.getJSONObject("tipEmitter");
            SoundEffect ef = null;
            if (pe.has("sound")) {
                try {
                    String sound = pe.getString("sound");
                    ef = new SoundEffect(sound, pe.optDouble("volume"));
                }
                catch (Exception e) {
                    ef = new SoundEffect(pe.getJSONObject("sound"));
                }
            }
            this.tipEmitter = new Particle.Emitter(ParticleType.ofName(pe.getString("type")), pe.getDouble("emitProbability"), pe.optInt("numParticles", 1), ef);
        } else {
            this.tipEmitter = null;
        }
    }
}

