/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Arc;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.ExceptionalCombatEvent;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.TentacleSpec;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public strictfp class Tentacle {
    public ArrayList<Segment> segments = new ArrayList();
    public double goalX;
    public double goalY;
    public double closestDistToTarget = 1.0E8;
    public int msNotImproved = 0;
    public int backOffMs = 0;
    public int backOffMsAmt = 320;
    public int retractMs = 0;
    public boolean allowAnySegmentToBeAtTarget = false;
    public boolean atTarget = false;
    public boolean flipped = false;
    public final TentacleSpec spec;
    public boolean needMsUntilNextTarget = true;
    public int msUntilNextTarget = -1;
    public boolean needsInitialTarget = true;
    public Crewman targetCrew;
    public Airship targetCrewShip;
    public boolean targetCrewGrabbed;
    public Tile smackTile;
    public int smackPhase = 0;

    public Tentacle(TentacleSpec spec) {
        this.spec = spec;
        double suckerDirection = spec.suckerDirection ? 1.0 : -1.0;
        for (int i = 0; i < spec.numSegments; ++i) {
            double width = spec.baseWidth + (spec.tipWidth - spec.baseWidth) * (double)i / (double)spec.numSegments;
            double length = spec.baseLength + (spec.tipLength - spec.baseLength) * (double)i / (double)spec.numSegments;
            double localRequiredAngleVsTarget = suckerDirection * StrictMath.max(0.0, StrictMath.min(0.3141592653589793, StrictMath.sin((double)i * 4.0 / (double)spec.numSegments - 0.5) * 0.4));
            double stiffness = spec.baseStiffness + (spec.tipStiffness - spec.baseStiffness) * (double)i / (double)spec.numSegments;
            this.segments.add(new Segment(width, new Muscle(length * stiffness, length), new Muscle(length * stiffness, length), 0.0, 0.0, i == 0 ? spec.baseAngle : 0.0, localRequiredAngleVsTarget));
        }
    }

    public boolean canTentacle(Airship ship, Module myModule, Airship target, double myX, double myY, double targetX, double targetY, boolean myFlipped, int inset, double rangeMult) {
        double baseX = myX + (double)(ship.gridXToWorldX(myModule.x, myModule.type.getW(), myFlipped) * 16);
        if (myFlipped) {
            baseX += (double)(myModule.type.getW() * 16);
        }
        baseX += this.spec.baseXOffset * 16.0 * (double)(myFlipped ? -1 : 1);
        double baseY = myY + (double)(myModule.y * 16) + this.spec.baseYOffset;
        double maxRange = (this.spec.baseLength * 0.5 + this.spec.tipLength * 0.5) * (double)this.spec.numSegments * rangeMult;
        Arc fireArc = Arc.centeredRadians(myFlipped ? Direction.flipHorizontal(this.spec.baseAngle) : this.spec.baseAngle, 4.71238898038469);
        double targetLeft = targetX + (double)inset;
        double targetRight = targetX + target.getBBWidth() - (double)inset;
        double targetTop = targetY + (double)inset;
        double targetBottom = targetY + target.getBBHeight() - (double)inset;
        double dSq = (baseX - targetLeft) * (baseX - targetLeft) + (baseY - targetTop) * (baseY - targetTop);
        if (dSq <= maxRange * maxRange && fireArc.contains(Direction.radiansFromTo(baseX, baseY, targetLeft, targetTop))) {
            return true;
        }
        dSq = (baseX - targetRight) * (baseX - targetRight) + (baseY - targetBottom) * (baseY - targetBottom);
        if (dSq <= maxRange * maxRange && fireArc.contains(Direction.radiansFromTo(baseX, baseY, targetRight, targetBottom))) {
            return true;
        }
        dSq = (baseX - targetRight) * (baseX - targetRight) + (baseY - targetTop) * (baseY - targetTop);
        if (dSq <= maxRange * maxRange && fireArc.contains(Direction.radiansFromTo(baseX, baseY, targetRight, targetTop))) {
            return true;
        }
        dSq = (baseX - targetLeft) * (baseX - targetLeft) + (baseY - targetBottom) * (baseY - targetBottom);
        return dSq <= maxRange * maxRange && fireArc.contains(Direction.radiansFromTo(baseX, baseY, targetLeft, targetBottom));
    }

    public void updateTarget(double goalX, double goalY) {
        this.goalX = goalX;
        this.goalY = goalY;
    }

    public void setTarget(double goalX, double goalY, double speed) {
        this.goalX = goalX;
        this.goalY = goalY;
        this.backOffMs = 0;
        this.backOffMsAmt = (int)(320.0 / this.spec.speed);
        this.msNotImproved = 0;
        this.closestDistToTarget = 1.0E8;
        this.atTarget = false;
        Segment tip = this.segments.get(this.segments.size() - 1);
        Segment base = this.segments.get(0);
        Direction baseToTip = Direction.fromTo(base.centerX, base.centerY, tip.centerX, tip.centerY);
        Direction baseToGoal = Direction.fromTo(base.centerX, base.centerY, goalX, goalY);
        double diff = baseToGoal.minus((Direction)baseToTip).radians;
        if (diff > 1.8849555921538759 && diff < Math.PI) {
            this.retractMs = (int)(320.0 / speed);
        }
    }

    public void setFlipped(double parentX, double parentY, boolean flipped) {
        if (this.flipped != flipped) {
            this.segments.get((int)0).centerX = parentX + this.spec.baseXOffset * 16.0 * (double)(flipped ? -1 : 1);
            this.segments.get((int)0).centerY = parentY + this.spec.baseYOffset * 16.0;
            this.segments.get((int)0).angle = flipped ? Direction.flipHorizontal(this.spec.baseAngle) : this.spec.baseAngle;
            for (int i = 1; i < this.segments.size(); ++i) {
                Segment s = this.segments.get(i);
                double l = s.leftM.length;
                s.leftM.length = s.rightM.length;
                s.rightM.length = l;
                s.updatePosition(this.segments.get(i - 1));
            }
        }
        this.flipped = flipped;
    }

    public final void reset(double parentX, double parentY, boolean flipped) {
        this.flipped = flipped;
        this.segments.get((int)0).centerX = parentX + this.spec.baseXOffset * 16.0 * (double)(flipped ? -1 : 1);
        this.segments.get((int)0).centerY = parentY + this.spec.baseYOffset * 16.0;
        this.segments.get((int)0).angle = flipped ? Direction.flipHorizontal(this.spec.baseAngle) : this.spec.baseAngle;
        for (int i = 1; i < this.segments.size(); ++i) {
            Segment s = this.segments.get(i);
            double curlAmt = 0.95 - (double)i * 0.4 / (double)this.segments.size();
            s.leftM.length = s.leftM.maxLength * (this.spec.suckerDirection ^ flipped ? 1.0 : curlAmt);
            s.rightM.length = s.rightM.maxLength * (!(this.spec.suckerDirection ^ flipped) ? 1.0 : curlAmt);
            s.updatePosition(this.segments.get(i - 1));
        }
        this.needMsUntilNextTarget = true;
        this.needsInitialTarget = true;
    }

    public double crewX(Crewman cm, Airship ship) {
        if (ship != null) {
            return ship.getX() + (double)(ship.gridXToWorldX(cm.currentTile.x, 1) * 16) + 8.0;
        }
        return cm.getX() + cm.getBBWidth() / 2.0;
    }

    public double crewY(Crewman cm, Airship ship) {
        if (ship != null) {
            return ship.getY() + (double)(cm.currentTile.y * 16) + 8.0;
        }
        return cm.getY() + cm.getBBHeight() / 2.0;
    }

    public void smackBehaviour(Combat c, Airship myShip, Combat.Side mySide, double parentX, double parentY, boolean onViewingSide) {
        double sty;
        double stx;
        double d2;
        if (this.targetCrew != null) {
            return;
        }
        Combat.Side enemySide = c.otherSide(mySide);
        double baseX = this.segments.get((int)0).centerX;
        double baseY = this.segments.get((int)0).centerY;
        Arc fireArc = Arc.centeredRadians(this.segments.get((int)0).angle, 4.71238898038469);
        double maxRange = (this.spec.baseLength * 0.5 + this.spec.tipLength * 0.5) * (double)this.spec.numSegments * 0.8;
        if (this.smackTile != null && !enemySide.ships.contains(this.smackTile.ship)) {
            this.smackTile = null;
            this.allowAnySegmentToBeAtTarget = false;
        }
        if (this.smackTile != null && ((d2 = (baseX - (stx = this.smackTile.ship.getX() + (double)(this.smackTile.ship.gridXToWorldX(this.smackTile.x, 1) * 16) + 8.0)) * (baseX - stx) + (baseY - (sty = this.smackTile.ship.getY() + (double)(this.smackTile.y * 16) + 8.0)) * (baseY - sty)) > maxRange * maxRange || !fireArc.contains(Direction.radiansFromTo(baseX, baseY, stx, sty)))) {
            this.smackTile = null;
            this.allowAnySegmentToBeAtTarget = false;
        }
        if (this.smackTile == null && this.msUntilNextTarget <= 0) {
            ArrayList<Tile> candidates = new ArrayList<Tile>();
            for (Airship s : enemySide.ships) {
                for (Tile t : s.tiles) {
                    double sty2;
                    double stx2 = t.ship.getX() + (double)(t.ship.gridXToWorldX(t.x, 1) * 16) + 8.0;
                    double d22 = (baseX - stx2) * (baseX - stx2) + (baseY - (sty2 = t.ship.getY() + (double)(t.y * 16) + 8.0)) * (baseY - sty2);
                    if (!(d22 <= maxRange * maxRange) || !fireArc.contains(Direction.radiansFromTo(baseX, baseY, stx2, sty2)) || t.isMaskedEmpty()) continue;
                    candidates.add(t);
                }
            }
            Collections.shuffle(candidates, c.r);
            if (!candidates.isEmpty()) {
                this.smackTile = (Tile)candidates.get(0);
                this.smackPhase = 0;
                double tx = baseX + StrictMath.cos(this.segments.get((int)0).angle) * maxRange / 6.0;
                double ty = baseY - maxRange / 6.0;
                this.setTarget(tx, ty, this.spec.speed * 10.0);
            }
            this.needMsUntilNextTarget = true;
        }
        if (this.smackTile != null) {
            double ty;
            double tx;
            if (this.smackPhase == 0) {
                if (this.atTarget || this.msNotImproved > 1000) {
                    this.smackPhase = 1;
                    stx = this.smackTile.ship.getX() + (double)(this.smackTile.ship.gridXToWorldX(this.smackTile.x, 1) * 16) + 8.0;
                    sty = this.smackTile.ship.getY() + (double)(this.smackTile.y * 16) + 8.0;
                    this.setTarget(stx, sty, this.spec.speed * 10.0);
                    this.allowAnySegmentToBeAtTarget = true;
                    if (this.spec.attackSound != null) {
                        c.play(this.spec.attackSound, stx, sty, 0.0, 0.0, onViewingSide);
                    }
                    if (this.spec.attackSprayParticle != null) {
                        for (Segment seg : this.segments) {
                            if (AGame.ANIM_R.nextDouble() > this.spec.attackSprayP) continue;
                            double sx = seg.centerX + seg.xOffset + (AGame.ANIM_R.nextDouble() - 0.5) * StrictMath.min(seg.getLength(), seg.getWidth());
                            double sy = seg.centerY + seg.yOffset + (AGame.ANIM_R.nextDouble() - 0.5) * StrictMath.min(seg.getLength(), seg.getWidth());
                            c.particles.add(new Particle(this.spec.attackSprayParticle, sx, sy));
                        }
                    }
                } else {
                    tx = baseX + StrictMath.cos(this.segments.get((int)0).angle) * maxRange / 6.0;
                    ty = baseY - maxRange / 6.0;
                    this.updateTarget(tx, ty);
                }
            }
            if (this.smackPhase == 1) {
                if (this.atTarget) {
                    stx = this.smackTile.ship.getX() + (double)(this.smackTile.ship.gridXToWorldX(this.smackTile.x, 1) * 16) + 8.0;
                    sty = this.smackTile.ship.getY() + (double)(this.smackTile.y * 16) + 8.0;
                    this.smackTile.hit(new Shot(this.smackTile.ship, stx, sty, myShip, this), c, !onViewingSide);
                    int dmg = this.spec.attackBlastDmg + this.spec.attackPenDmg;
                    if (dmg < 15) {
                        c.play(MiscCombatSound.SMALL_HIT, stx, sty, 0.0, 0.0, !onViewingSide);
                    } else if (dmg < 40) {
                        c.play(MiscCombatSound.MEDIUM_HIT, stx, sty, 0.0, 0.0, !onViewingSide);
                    } else {
                        c.play(MiscCombatSound.LARGE_HIT, stx, sty, 0.0, 0.0, !onViewingSide);
                    }
                    c.boringTicks = 0;
                    if (this.spec.attackImpactParticle != null) {
                        for (int i = 0; i < this.spec.numAttackImpactParticles; ++i) {
                            c.particles.add(new Particle(this.spec.attackImpactParticle, stx, sty));
                        }
                    }
                    double tx2 = baseX + StrictMath.cos(this.segments.get((int)0).angle) * maxRange / 6.0;
                    double ty2 = baseY - maxRange / 6.0;
                    this.setTarget(tx2, ty2, this.spec.speed * 10.0);
                    this.smackTile = null;
                    this.allowAnySegmentToBeAtTarget = false;
                } else if (this.msNotImproved > 1500) {
                    tx = baseX + StrictMath.cos(this.segments.get((int)0).angle) * maxRange / 6.0;
                    ty = baseY - maxRange / 6.0;
                    this.setTarget(tx, ty, this.spec.speed * 10.0);
                    this.smackTile = null;
                    this.allowAnySegmentToBeAtTarget = false;
                } else {
                    stx = this.smackTile.ship.getX() + (double)(this.smackTile.ship.gridXToWorldX(this.smackTile.x, 1) * 16) + 8.0;
                    sty = this.smackTile.ship.getY() + (double)(this.smackTile.y * 16) + 8.0;
                    this.updateTarget(stx, sty);
                }
            }
        }
    }

    public void crewGrabBehaviour(Combat c, Airship myShip, Combat.Side mySide, Module myModule, double parentX, double parentY, boolean onViewingSide) {
        Combat.Side enemySide = c.otherSide(mySide);
        double baseX = this.segments.get((int)0).centerX;
        double baseY = this.segments.get((int)0).centerY;
        Segment tip = this.segments.get(this.segments.size() - 1);
        if (this.targetCrew != null && this.targetCrewGrabbed) {
            this.targetCrew.setX(tip.centerX + tip.xOffset - this.targetCrew.getBBWidth() / 2.0);
            this.targetCrew.setY(tip.centerY + tip.yOffset - this.targetCrew.getBBHeight() / 2.0);
            if (this.atTarget) {
                boolean alive = this.targetCrew.alive();
                this.targetCrew.hp = 0;
                double cx = this.targetCrew.getX() + this.targetCrew.getBBWidth() / 2.0;
                double cy = this.targetCrew.getY() + this.targetCrew.getBBHeight() / 2.0;
                if (alive && !this.targetCrew.alive() && this.targetCrew.type.deathSnd != null) {
                    c.play(this.targetCrew.type.deathSnd, cx, cy, 0.0, 0.0, onViewingSide);
                }
                if (alive && !this.targetCrew.alive()) {
                    c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("eatenBy " + myModule.type.name, c.otherSide(mySide), cx, cy, this.targetCrew.type, null));
                }
                if (this.targetCrew.type.bloodParticleExternal != null) {
                    for (int i = 0; i < 20; ++i) {
                        Particle p = new Particle(this.targetCrew.type.bloodParticleExternal, cx, cy);
                        c.particles.add(p);
                    }
                }
                this.targetCrew = null;
                this.targetCrewShip = null;
                this.atTarget = false;
                this.targetCrewGrabbed = false;
                this.needsInitialTarget = true;
            } else {
                this.updateTarget(parentX + this.spec.mouthXOffset * 16.0 * (double)(this.flipped ? -1 : 1), parentY + this.spec.mouthYOffset * 16.0);
                return;
            }
        }
        if (this.targetCrew != null && this.targetCrew.grabbed) {
            this.targetCrew = null;
            this.targetCrewShip = null;
        }
        if (this.targetCrewShip != null && !mySide.ships.contains(this.targetCrewShip) && !enemySide.ships.contains(this.targetCrewShip)) {
            this.targetCrewShip = null;
        }
        if (this.targetCrew != null) {
            if (this.targetCrewShip != null && !this.targetCrewShip.crew.contains(this.targetCrew) && !this.targetCrewShip.boarders.contains(this.targetCrew)) {
                this.targetCrewShip = null;
            }
            if (this.targetCrewShip == null && !enemySide.troops.contains(this.targetCrew)) {
                this.targetCrew = null;
            }
        }
        Arc fireArc = Arc.centeredRadians(this.segments.get((int)0).angle, 4.71238898038469);
        double maxRange = (this.spec.baseLength * 0.5 + this.spec.tipLength * 0.5) * (double)this.spec.numSegments * 0.8;
        if (this.targetCrew != null) {
            double targetY;
            double targetX = this.crewX(this.targetCrew, this.targetCrewShip);
            double dSq = (baseX - targetX) * (baseX - targetX) + (baseY - (targetY = this.crewY(this.targetCrew, this.targetCrewShip))) * (baseY - targetY);
            if (dSq > maxRange * maxRange) {
                this.targetCrew = null;
                this.targetCrewShip = null;
            } else if (!fireArc.contains(Direction.radiansFromTo(baseX, baseY, targetX, targetY))) {
                this.targetCrew = null;
                this.targetCrewShip = null;
            }
        }
        if (this.targetCrew == null && this.msUntilNextTarget <= 0) {
            ArrayList<Utils.Pair> candidates = new ArrayList<Utils.Pair>();
            for (Crewman cm : enemySide.troops) {
                double targetY;
                double targetX;
                double dSq;
                if (!cm.alive() || !((dSq = (baseX - (targetX = this.crewX(cm, null))) * (baseX - targetX) + (baseY - (targetY = this.crewY(cm, null))) * (baseY - targetY)) <= maxRange * maxRange) || !fireArc.contains(Direction.radiansFromTo(baseX, baseY, targetX, targetY))) continue;
                candidates.add(new Utils.Pair((Object)cm, null));
            }
            for (Airship s : enemySide.ships) {
                for (Crewman cm : s.crew) {
                    double targetY;
                    double targetX;
                    double dSq;
                    if (!cm.alive() || !cm.currentTile.enterable() && !cm.currentTile.armour.window || !((dSq = (baseX - (targetX = this.crewX(cm, s))) * (baseX - targetX) + (baseY - (targetY = this.crewY(cm, s))) * (baseY - targetY)) <= maxRange * maxRange) || !fireArc.contains(Direction.radiansFromTo(baseX, baseY, targetX, targetY))) continue;
                    candidates.add(new Utils.Pair((Object)cm, (Object)s));
                }
            }
            Collections.shuffle(candidates, c.r);
            if (!candidates.isEmpty()) {
                this.targetCrew = (Crewman)((Utils.Pair)candidates.get((int)0)).a;
                this.targetCrewShip = (Airship)((Utils.Pair)candidates.get((int)0)).b;
                double targetX = this.crewX(this.targetCrew, this.targetCrewShip);
                double targetY = this.crewY(this.targetCrew, this.targetCrewShip);
                this.setTarget(targetX, targetY, this.spec.speed);
            }
            this.needMsUntilNextTarget = true;
        }
        if (this.targetCrew != null) {
            double targetX = this.crewX(this.targetCrew, this.targetCrewShip);
            double targetY = this.crewY(this.targetCrew, this.targetCrewShip);
            if (this.atTarget) {
                this.targetCrewGrabbed = true;
                if (this.targetCrewShip != null) {
                    this.targetCrew.popOut(enemySide, c);
                    this.targetCrewShip = null;
                }
                if (this.spec.attackSound != null) {
                    c.play(this.spec.snatchSound, targetX, targetY, 0.0, 0.0, onViewingSide);
                }
                c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("grabbedBy " + myModule.type.name, c.otherSide(mySide), targetX, targetY, this.targetCrew.type, this.targetCrewShip));
                this.targetCrew.grabbed = true;
                this.setTarget(parentX + this.spec.mouthXOffset * 16.0 * (double)(this.flipped ? -1 : 1), parentY + this.spec.mouthYOffset * 16.0, this.spec.speed);
            } else {
                this.updateTarget(targetX, targetY);
            }
        }
    }

    public void deathSpasm(Combat c, Airship myShip, int ms, double parentX, double parentY) {
        this.segments.get((int)0).centerX = parentX + this.spec.baseXOffset * 16.0 * (double)(this.flipped ? -1 : 1);
        this.segments.get((int)0).centerY = parentY + this.spec.baseYOffset * 16.0;
        for (int i = 1; i < this.segments.size(); ++i) {
            int j;
            double amt;
            if (AGame.ANIM_R.nextDouble() < 3.0E-4 * (double)ms) {
                amt = 100.0 * AGame.ANIM_R.nextDouble();
                for (j = StrictMath.max(1, i - 5); j < StrictMath.min(this.segments.size(), i + 5); ++j) {
                    this.segments.get((int)j).leftM.spasmAmount += amt / (double)((i - j) * (i - j) + 2);
                }
            }
            this.segments.get((int)i).leftM.spasmMove((double)ms * this.spec.speed * 2.0);
            if (AGame.ANIM_R.nextDouble() < 3.0E-4 * (double)ms) {
                amt = 100.0 * AGame.ANIM_R.nextDouble();
                for (j = StrictMath.max(1, i - 5); j < StrictMath.min(this.segments.size(), i + 5); ++j) {
                    this.segments.get((int)j).rightM.spasmAmount += amt / (double)((i - j) * (i - j) + 2);
                }
            }
            this.segments.get((int)i).rightM.spasmMove((double)ms * this.spec.speed * 2.0);
            this.segments.get(i).updatePosition(this.segments.get(i - 1));
        }
    }

    public void tick(Combat c, Airship myShip, Combat.Side mySide, Module myModule, int ms, double parentX, double parentY, boolean onViewingSide) {
        double localYOffset;
        double localXOffset;
        Segment prev;
        Segment seg;
        int i;
        double randomDist;
        double maxRange;
        double randomDir;
        double baseX = parentX + this.spec.baseXOffset * 16.0 * (double)(this.flipped ? -1 : 1);
        double baseY = parentY + this.spec.baseYOffset * 16.0;
        this.segments.get((int)0).centerX = baseX;
        this.segments.get((int)0).centerY = baseY;
        if (this.needMsUntilNextTarget) {
            this.msUntilNextTarget = this.spec.minNextTargetPause + c.r.nextInt(this.spec.maxNextTargetPause - this.spec.minNextTargetPause);
            this.needMsUntilNextTarget = false;
        }
        this.msUntilNextTarget -= ms;
        if (this.needsInitialTarget) {
            if (this.spec.wavesAround) {
                randomDir = this.segments.get((int)0).angle - 1.0 + c.r.nextDouble() * 2.0;
                maxRange = (this.spec.baseLength * 0.5 + this.spec.tipLength * 0.5) * (double)this.spec.numSegments * 0.8;
                randomDist = maxRange * 0.3 + 0.7 * c.r.nextDouble() * maxRange;
                this.setTarget(baseX + StrictMath.cos(randomDir) * randomDist, baseY + StrictMath.sin(randomDir) * randomDist, this.spec.speed);
            } else {
                this.setTarget(this.segments.get((int)(this.segments.size() - 1)).centerX, this.segments.get((int)(this.segments.size() - 1)).centerY, this.spec.speed);
            }
            this.needsInitialTarget = false;
        }
        if (this.spec.snatchesCrew) {
            this.crewGrabBehaviour(c, myShip, mySide, myModule, parentX, parentY, onViewingSide);
        }
        if (this.spec.attacksHull) {
            this.smackBehaviour(c, myShip, mySide, parentX, parentY, onViewingSide);
        }
        if (this.spec.wavesAround && this.targetCrew == null && this.smackTile == null && this.msUntilNextTarget <= 0) {
            randomDir = this.segments.get((int)0).angle - 1.0 + c.r.nextDouble() * 2.0;
            maxRange = (this.spec.baseLength * 0.5 + this.spec.tipLength * 0.5) * (double)this.spec.numSegments * 0.8;
            randomDist = maxRange * 0.3 + 0.7 * c.r.nextDouble() * maxRange;
            this.setTarget(baseX + StrictMath.cos(randomDir) * randomDist, baseY + StrictMath.sin(randomDir) * randomDist, this.spec.speed);
            this.needMsUntilNextTarget = true;
        }
        for (int i2 = 1; i2 < this.segments.size(); ++i2) {
            this.segments.get(i2).updatePosition(this.segments.get(i2 - 1));
        }
        double speed = this.spec.speed;
        if (this.smackTile != null && this.smackPhase == 1) {
            speed *= 10.0;
        }
        for (Segment s : this.segments) {
            s.leftM.returnToBalance((double)ms * speed);
            s.rightM.returnToBalance((double)ms * speed);
        }
        for (int i3 = 1; i3 < this.segments.size(); ++i3) {
            if (this.retractMs > 0) {
                this.segments.get((int)i3).leftM.contract((double)(ms * 2) * speed);
                this.segments.get((int)i3).rightM.contract((double)(ms * 2) * speed);
            } else if (this.retractMs <= 0 || i3 > this.segments.size() / 2 && (this.backOffMsAmt <= 1200 || this.backOffMs <= 0)) {
                this.segments.get(i3).moveMusclesForTarget((double)ms * speed, this.goalX, this.goalY);
            }
            this.segments.get(i3).updatePosition(this.segments.get(i3 - 1));
        }
        Segment tip = this.segments.get(this.segments.size() - 1);
        double d2 = (tip.centerX - this.goalX) * (tip.centerX - this.goalX) + (tip.centerY - this.goalY) * (tip.centerY - this.goalY);
        this.retractMs -= ms;
        int maxShiftDistSq = (this.segments.size() - 2) * (this.segments.size() - 2) * 3;
        double shiftAmt = (double)ms * speed * 0.3;
        if (d2 < (double)maxShiftDistSq) {
            for (i = 1; i < this.segments.size(); ++i) {
                seg = this.segments.get(i);
                prev = this.segments.get(i - 1);
                localXOffset = seg.xOffset - prev.xOffset;
                localYOffset = seg.yOffset - prev.yOffset;
                double targetXOffset = (this.goalX - tip.centerX) / (double)(this.segments.size() - 1);
                double targetYOffset = (this.goalY - tip.centerY) / (double)(this.segments.size() - 1);
                double totalOffsetDifference = StrictMath.abs(localXOffset - targetXOffset) + StrictMath.abs(localYOffset - targetYOffset);
                if (totalOffsetDifference <= shiftAmt) {
                    localXOffset = targetXOffset;
                    localYOffset = targetYOffset;
                } else {
                    localXOffset += shiftAmt * (targetXOffset - localXOffset) / totalOffsetDifference;
                    localYOffset += shiftAmt * (targetYOffset - localYOffset) / totalOffsetDifference;
                }
                seg.xOffset = prev.xOffset + localXOffset;
                seg.yOffset = prev.yOffset + localYOffset;
            }
        } else {
            for (i = 1; i < this.segments.size(); ++i) {
                seg = this.segments.get(i);
                prev = this.segments.get(i - 1);
                localXOffset = seg.xOffset - prev.xOffset;
                localYOffset = seg.yOffset - prev.yOffset;
                double totalOffset = StrictMath.abs(localXOffset) + StrictMath.abs(localYOffset);
                if (totalOffset <= shiftAmt) {
                    localXOffset = 0.0;
                    localYOffset = 0.0;
                } else {
                    localXOffset -= shiftAmt * localXOffset / totalOffset;
                    localYOffset -= shiftAmt * localYOffset / totalOffset;
                }
                seg.xOffset = prev.xOffset + localXOffset;
                seg.yOffset = prev.yOffset + localYOffset;
            }
        }
        if ((d2 = (tip.centerX + tip.xOffset - this.goalX) * (tip.centerX + tip.xOffset - this.goalX) + (tip.centerY + tip.yOffset - this.goalY) * (tip.centerY + tip.yOffset - this.goalY)) < 100.0) {
            this.atTarget = true;
        } else {
            if (this.allowAnySegmentToBeAtTarget) {
                Iterator<Segment> i$ = this.segments.iterator();
                while (i$.hasNext()) {
                    double sd2 = (seg.centerX + seg.xOffset - this.goalX) * (seg.centerX + seg.xOffset - this.goalX) + (seg.centerY + seg.yOffset - this.goalY) * (seg.centerY + seg.yOffset - this.goalY);
                    seg = i$.next();
                    if (!(sd2 < seg.getWidth() * seg.getLength())) continue;
                    this.atTarget = true;
                    break;
                }
            }
            if (!this.atTarget) {
                if (d2 < this.closestDistToTarget - 5000.0) {
                    this.closestDistToTarget = d2;
                    this.msNotImproved = 0;
                } else {
                    if (this.backOffMs <= 0) {
                        this.msNotImproved += ms;
                    }
                    if ((double)this.msNotImproved > 3500.0 / this.spec.speed) {
                        this.backOffMs = this.backOffMsAmt;
                        this.backOffMsAmt *= 2;
                        this.msNotImproved = 0;
                        this.closestDistToTarget = 1.0E8;
                    }
                }
            }
        }
        if (this.spec.tipEmitter != null) {
            Particle.Emitter em = this.spec.tipEmitter;
            if (AGame.ANIM_R.nextDouble() < em.emitProbability * (double)ms) {
                for (int i4 = 0; i4 < em.numParticles; ++i4) {
                    c.particles.add(new Particle(em.t, tip.centerX, tip.centerY));
                }
                if (em.soundEffect != null) {
                    c.play(em.soundEffect, tip.centerX, tip.centerY, 0.0, 0.0, onViewingSide);
                }
            }
        }
    }

    public strictfp static class Segment {
        public final double baseWidth;
        public final Muscle leftM;
        public final Muscle rightM;
        public double centerX;
        public double centerY;
        public double angle;
        public final double desiredAngleVsTarget;
        public double xOffset;
        public double yOffset;

        public Segment(double width, Muscle leftM, Muscle rightM, double x, double y, double angle, double desiredAngleVsTarget) {
            this.baseWidth = width;
            this.leftM = leftM;
            this.rightM = rightM;
            this.centerX = x;
            this.centerY = y;
            this.angle = angle;
            this.desiredAngleVsTarget = desiredAngleVsTarget;
        }

        public double getWidth() {
            return this.baseWidth;
        }

        public double getLength() {
            return this.leftM.length / 2.0 + this.rightM.length / 2.0;
        }

        public void updatePosition(Segment prev) {
            double startX = prev.centerX + StrictMath.cos(prev.angle) * prev.getLength() / 2.0;
            double startY = prev.centerY + StrictMath.sin(prev.angle) * prev.getLength() / 2.0;
            double angleChange = StrictMath.atan2(this.leftM.length - this.rightM.length, this.baseWidth);
            this.angle = prev.angle + angleChange;
            this.centerX = startX + StrictMath.cos(this.angle) * this.getLength() / 2.0;
            this.centerY = startY + StrictMath.sin(this.angle) * this.getLength() / 2.0;
        }

        public void moveMusclesForTarget(double msXSpeed, double tx, double ty) {
            double globalAngleVsTarget = StrictMath.atan2(ty - this.centerY, tx - this.centerX);
            double localAngleVsTarget = globalAngleVsTarget - this.angle;
            Direction reqA = Direction.ofRadians(this.desiredAngleVsTarget);
            Direction targA = Direction.ofRadians(localAngleVsTarget);
            double angleDiff = targA.minus((Direction)reqA).radians;
            if (angleDiff < Math.PI) {
                double amt = StrictMath.min(0.15, angleDiff / Math.PI / 2.0) * msXSpeed / 16.0;
                this.rightM.length = this.rightM.length * (1.0 - amt) + this.rightM.minLength * amt;
            } else {
                double amt = StrictMath.min(0.15, (2.0 - angleDiff / Math.PI) / 2.0) * msXSpeed / 16.0;
                this.leftM.length = this.leftM.length * (1.0 - amt) + this.leftM.minLength * amt;
            }
        }
    }

    public strictfp static class Muscle {
        public final double minLength;
        public final double maxLength;
        public double length;
        public double spasmAmount;

        public Muscle(double minLength, double maxLength) {
            this.minLength = minLength;
            this.maxLength = maxLength;
            this.length = maxLength;
        }

        private void spasmMove(double msXSpeed) {
            this.spasmAmount *= StrictMath.pow(0.99, msXSpeed);
            this.contract(msXSpeed * this.spasmAmount);
            this.returnToBalance(msXSpeed);
        }

        private void returnToBalance(double msXSpeed) {
            this.length = this.length * (1.0 - 0.00125 * msXSpeed) + this.maxLength * 0.00125 * msXSpeed;
        }

        private void contract(double msXSpeed) {
            this.length = this.length * (1.0 - 0.003125 * msXSpeed) + this.minLength * 0.003125 * msXSpeed;
        }
    }
}

