/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.ResearchSpeed;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public strictfp class TechScreen
implements Screen {
    public static int TECH_ICON_SIZE = 64;
    public static int TECH_TIER_GAP_ZOOMED_OUT = 64;
    public static int SMALL_TECH_TIER_GAP_ZOOMED_OUT = 64;
    public static int MEDIUM_TECH_TIER_GAP_ZOOMED_OUT = 64;
    public static int LARGE_TECH_TIER_GAP_ZOOMED_OUT = 64;
    public static int TECH_TIER_GAP = 128;
    public static int SMALL_TECH_TIER_GAP = 128;
    public static int MEDIUM_TECH_TIER_GAP = 128;
    public static int LARGE_TECH_TIER_GAP = 128;
    public static int TECH_ROW_GAP = 32;
    public static int SMALL_TECH_ROW_GAP = 32;
    public static int MEDIUM_TECH_ROW_GAP = 32;
    public static int LARGE_TECH_ROW_GAP = 32;
    public static int TECH_LANE_DIST = 12;
    public static int SMALL_TECH_LANE_DIST = 12;
    public static int MEDIUM_TECH_LANE_DIST = 12;
    public static int LARGE_TECH_LANE_DIST = 12;
    public static Img TECH_ICON = new Img("ui", 480, 480, 32, 32, false);
    public static Img TECH_ICON_ACTIVE = new Img("ui", 512, 480, 32, 32, false);
    public static Clr SELECTED_TECH = Clr.fromHex((String)"f5edb5");
    public static String SELECTED_TECH_C = "[f5edb5]";
    public static Clr AVAILABLE_TECH = Clr.fromHex((String)"f5e474");
    public static Clr UNAVAILABLE_TECH = Clr.fromHex((String)"c8b84f");
    public static String UNAVAILABLE_TECH_C = "[c8b84f]";
    public static Img ZOOM_IN = new Img("ui", 384, 512, 16, 16, false);
    public static Img ZOOM_OUT = new Img("ui", 400, 512, 16, 16, false);
    private boolean dragging = false;
    private int dragStartX;
    private int dragStartY;
    private int dragStartScrollX;
    private int dragStartScrollY;
    private final int[] tierWidths = new int[Tech.layout.length];
    private final int[] rowHeights = new int[Tech.layout[0].length];
    private int totalWidth;
    private int totalHeight;
    private int smWidth;
    private int smHeight;
    private int sidePanelW = 0;
    public boolean zoomedOut;
    private Tech hoverTech;
    private Tech focusOn;
    private final StrategicScreen ss;
    private static ShaderProgram reToneShader;

    private int techTierGap() {
        return this.zoomedOut ? TECH_TIER_GAP_ZOOMED_OUT : TECH_TIER_GAP;
    }

    public TechScreen(StrategicScreen ss) {
        this.ss = ss;
    }

    private void focusOnCenter() {
        Empire e = this.ss.w.player;
        ArrayList<Tech> techs = Loadable.all(Tech.class);
        this.focusOn = null;
        int bestDSq = 0;
        for (Tech t : techs) {
            if (!t.visible(e)) continue;
            int tx = t.x + t.w / 2 + this.ss.techScreenScrollX;
            int ty = t.y + t.h / 2 + this.ss.techScreenScrollY;
            int centerX = (this.smWidth - this.sidePanelW) / 2;
            int centerY = this.smHeight / 2;
            int dSq = (tx - centerX) * (tx - centerX) + (ty - centerY) * (ty - centerY);
            if (this.focusOn != null && dSq >= bestDSq) continue;
            this.focusOn = t;
            bestDSq = dSq;
        }
    }

    private void zoomOut() {
        if (!this.zoomedOut) {
            this.zoomedOut = true;
            this.focusOnCenter();
            this.totalWidth = 0;
        }
    }

    private void zoomIn() {
        if (this.zoomedOut) {
            this.zoomedOut = false;
            this.focusOnCenter();
            this.totalWidth = 0;
        }
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        Pt mouseDown = in.mouseDown();
        if (mouseDown != null && in.mouseDownButton() > 1) {
            if (this.dragging) {
                this.ss.techScreenScrollX = (int)((double)this.dragStartScrollX + (mouseDown.x - (double)this.dragStartX));
                this.ss.techScreenScrollY = (int)((double)this.dragStartScrollY + (mouseDown.y - (double)this.dragStartY));
            } else {
                this.dragStartX = (int)mouseDown.x;
                this.dragStartY = (int)mouseDown.y;
                this.dragStartScrollX = this.ss.techScreenScrollX;
                this.dragStartScrollY = this.ss.techScreenScrollY;
                this.dragging = true;
            }
        } else {
            this.dragging = false;
        }
        if (SimplePref.SIDE_BUMP_TO_SCROLL.get()) {
            if (in.keyDown("UP") || in.keyDown(Keys.get("up", "W")) || cursor.y < 2.0) {
                this.ss.techScreenScrollY += AirshipGame.scrollSpeed;
            }
            if (in.keyDown("DOWN") || in.keyDown(Keys.get("down", "S")) || cursor.y > (double)(in.mode().height - 2)) {
                this.ss.techScreenScrollY -= AirshipGame.scrollSpeed;
            }
            if (in.keyDown("LEFT") || in.keyDown(Keys.get("left", "A")) || cursor.x < 2.0) {
                this.ss.techScreenScrollX += AirshipGame.scrollSpeed;
            }
            if (in.keyDown("RIGHT") || in.keyDown(Keys.get("right", "D")) || cursor.x > (double)(in.mode().width - 2)) {
                this.ss.techScreenScrollX -= AirshipGame.scrollSpeed;
            }
        } else {
            if (in.keyDown("UP") || in.keyDown(Keys.get("up", "W"))) {
                this.ss.techScreenScrollY += AirshipGame.scrollSpeed;
            }
            if (in.keyDown("DOWN") || in.keyDown(Keys.get("down", "S"))) {
                this.ss.techScreenScrollY -= AirshipGame.scrollSpeed;
            }
            if (in.keyDown("LEFT") || in.keyDown(Keys.get("left", "A"))) {
                this.ss.techScreenScrollX += AirshipGame.scrollSpeed;
            }
            if (in.keyDown("RIGHT") || in.keyDown(Keys.get("right", "D"))) {
                this.ss.techScreenScrollX -= AirshipGame.scrollSpeed;
            }
        }
        if (in.keyPressed("SUBTRACT") || in.scrollAmount() < 0) {
            this.zoomOut();
        }
        if (in.keyPressed("ADD") || in.scrollAmount() > 0) {
            this.zoomIn();
        }
        int minScrollX = StrictMath.min(MyDraw.SIDE_CLEARANCE, -this.totalWidth - MyDraw.SIDE_CLEARANCE + this.smWidth - this.sidePanelW - MyDraw.SIDE_CLEARANCE - MyDraw.WINDOW_INSET);
        this.ss.techScreenScrollX = StrictMath.max(minScrollX, StrictMath.min(MyDraw.SIDE_CLEARANCE, this.ss.techScreenScrollX));
        int minScrollY = StrictMath.min(MyDraw.SIDE_CLEARANCE, -this.totalHeight - MyDraw.SIDE_CLEARANCE + this.smHeight);
        this.ss.techScreenScrollY = StrictMath.max(minScrollY, StrictMath.min(MyDraw.UI_SPACING + MyDraw.TOP_BAR_H, this.ss.techScreenScrollY));
        if (in.keyPressed("ESCAPE") || in.keyPressed(Keys.get("leave", "L"))) {
            this.ss.g.s = this.ss;
        }
        this.ss.backgroundTick(ms);
    }

    private void reToneBlit(MyDraw d, int x, int y, Img img, Clr dark, Clr light) {
        if (img.machineImgCache == null) {
            d.blit(img, x, y);
            return;
        }
        reToneShader.bind();
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)((Image)img.machineImgCache).getTexture().getTextureID());
        reToneShader.setUniform1i("tex", 0);
        reToneShader.setUniform3f("darkest", 0.078431375f, 0.078431375f, 0.078431375f);
        reToneShader.setUniform3f("dark", (float)dark.r / 255.0f, (float)dark.g / 255.0f, (float)dark.b / 255.0f);
        reToneShader.setUniform3f("light", (float)light.r / 255.0f, (float)light.g / 255.0f, (float)light.b / 255.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
        GL11.glVertex2d((double)x, (double)(y + img.srcHeight));
        GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
        GL11.glVertex2d((double)(x + img.srcWidth), (double)(y + img.srcHeight));
        GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
        GL11.glVertex2d((double)(x + img.srcWidth), (double)y);
        GL11.glEnd();
        reToneShader.unbind();
        TextureImpl.bindNone();
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        if (reToneShader == null && !Appearance.shaderLoadFailed && !Appearance.useSimpleGraphics) {
            try {
                reToneShader = ShaderProgram.loadProgram((String)AGame.getStaticGameDirectoryPath("data/passthrough.vert"), (String)AGame.getStaticGameDirectoryPath("data/retone.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Appearance.shaderLoadFailed = true;
            }
        }
        Empire e = this.ss.w.player;
        d.drawBG(MyDraw.SCREEN_BG, sm);
        ArrayList<Tech> techs = Loadable.all(Tech.class);
        this.smWidth = sm.width;
        this.smHeight = sm.height;
        int altSeparation = AGame.FOUNT.lineHeight + MyDraw.PANEL_INSET;
        if (this.totalWidth == 0) {
            int i;
            this.totalHeight = 0;
            for (i = 0; i < this.tierWidths.length; ++i) {
                this.tierWidths[i] = 0;
            }
            for (i = 0; i < this.rowHeights.length; ++i) {
                this.rowHeights[i] = 0;
            }
            for (Tech t : techs) {
                if (!t.visible(e)) continue;
                int tw = 0;
                if (this.zoomedOut) {
                    tw = TECH_ICON_SIZE + MyDraw.PANEL_INSET * 2;
                } else {
                    for (Tech.Choice c : t.choices) {
                        tw = StrictMath.max(tw, (int)d.textSize((String)Lang._t((String)new StringBuilder().append((String)"tech_").append((String)c.name).toString(), (Object[])new Object[0]), (Fount)AGame.FOUNT).x);
                        for (Bonus b : c.bonuses.list()) {
                            tw = StrictMath.max(tw, (int)d.textSize((String)b.getDesc(), (Fount)AGame.FOUNT).x);
                        }
                    }
                    tw += TECH_ICON_SIZE + MyDraw.PANEL_INSET * 2 + MyDraw.PANEL_INSET * 2;
                }
                this.tierWidths[t.tier - Tech.getMinTier()] = StrictMath.max(this.tierWidths[t.tier - Tech.getMinTier()], tw);
                int rh = 0;
                for (Tech.Choice c : t.choices) {
                    if (this.zoomedOut) {
                        rh += TECH_ICON_SIZE + MyDraw.PANEL_INSET * 2;
                        continue;
                    }
                    rh += StrictMath.max(TECH_ICON_SIZE, AGame.BIG_FOUNT.lineHeight + c.bonuses.list().size() * AGame.FOUNT.lineHeight) + MyDraw.PANEL_INSET * 2;
                }
                this.rowHeights[t.row] = StrictMath.max(this.rowHeights[t.row], rh += altSeparation * (t.choices.size() - 1));
            }
            for (int w : this.tierWidths) {
                this.totalWidth += w;
            }
            this.totalWidth += this.techTierGap() * (Tech.layout.length - 1);
            for (int h : this.rowHeights) {
                this.totalHeight += h;
            }
            this.totalHeight += TECH_ROW_GAP * (Tech.layout[0].length - 1);
            int x = 0;
            for (int column = 0; column < Tech.layout.length; ++column) {
                int y = 0;
                for (int row = 0; row < Tech.layout[0].length; ++row) {
                    Tech t = Tech.layout[column][row];
                    if (t != null && t.visible(e)) {
                        t.x = x;
                        t.y = y;
                        t.w = this.tierWidths[column];
                        t.h = 0;
                        for (Tech.Choice c : t.choices) {
                            if (this.zoomedOut) {
                                t.h += TECH_ICON_SIZE + MyDraw.PANEL_INSET * 2;
                                continue;
                            }
                            t.h += StrictMath.max(TECH_ICON_SIZE, AGame.BIG_FOUNT.lineHeight + c.bonuses.list().size() * AGame.FOUNT.lineHeight) + MyDraw.PANEL_INSET * 2;
                        }
                        t.h += altSeparation * (t.choices.size() - 1);
                    }
                    y += this.rowHeights[row] + TECH_ROW_GAP;
                }
                x += this.tierWidths[column] + this.techTierGap();
            }
        }
        if (this.focusOn != null) {
            this.ss.techScreenScrollX = -(this.focusOn.x + this.focusOn.w / 2) + sm.width * 7 / 8 / 2;
            this.ss.techScreenScrollY = -(this.focusOn.y + this.focusOn.h / 2) + sm.height / 2;
            this.focusOn = null;
        }
        int orW = (int)d.textSize((String)Lang._t((String)"tech_OR", (Object[])new Object[0]), (Fount)AGame.FOUNT).x + MyDraw.PANEL_INSET * 2;
        int tsz = techs.size();
        for (int hoverLp = 0; hoverLp < 2; ++hoverLp) {
            for (int lp = hoverLp; lp < 2; ++lp) {
                int[][] lanes = new int[Tech.layout.length][Tech.layout[0].length];
                int[][] hLanes = new int[Tech.layout.length][Tech.layout[0].length];
                for (int ti = 0; ti < tsz; ++ti) {
                    Tech t = techs.get(ti);
                    if (!t.visible(e)) continue;
                    int dsz = t.dependencies.size();
                    for (int di = 0; di < dsz; ++di) {
                        int shift;
                        int i;
                        int col = t.tier - Tech.getMinTier();
                        Tech dep = t.dependencies.get(di);
                        int lane = 0;
                        int laneStart = StrictMath.min(t.row, dep.row);
                        int laneEnd = StrictMath.max(t.row, dep.row);
                        for (i = laneStart; i <= laneEnd; ++i) {
                            lane = StrictMath.max(lanes[col][i], lane);
                        }
                        ++lane;
                        for (i = laneStart; i <= laneEnd; ++i) {
                            lanes[col][i] = lane;
                        }
                        lane = -lane;
                        boolean doDraw = hoverLp != 1 || t == this.hoverTech || dep == this.hoverTech;
                        Clr c = MyDraw.SELECTED;
                        boolean hasResearchedDep = false;
                        for (int i2 = 0; i2 < dep.choices.size(); ++i2) {
                            if (!e.techs.contains(dep.choices.get(i2))) continue;
                            hasResearchedDep = true;
                        }
                        if (!hasResearchedDep) {
                            c = MyDraw.DARK_BG;
                            if (t == this.hoverTech || dep == this.hoverTech) {
                                c = AVAILABLE_TECH.mix(0.5, MyDraw.DARK_BG);
                            }
                        } else if (t == this.hoverTech || dep == this.hoverTech) {
                            c = Clr.WHITE;
                        }
                        if (lp == 0) {
                            c = Clr.BLACK;
                        }
                        int w = lp == 0 ? 6 : 2;
                        int n = shift = lp == 0 ? -2 : 0;
                        if (Rect2D.intersects(dep.x + this.ss.techScreenScrollX + shift, StrictMath.min(dep.y + dep.h / 2 + this.ss.techScreenScrollY + shift, t.y + t.h / 2 + hLanes[col][t.row] * TECH_LANE_DIST + this.ss.techScreenScrollY + shift), t.x - this.techTierGap() / 4 + lane * TECH_LANE_DIST + this.techTierGap() / 4 + t.w / 2 - lane * TECH_LANE_DIST - dep.x, StrictMath.abs(dep.y + dep.h / 2 + this.ss.techScreenScrollY + shift - (t.y + t.h / 2 + hLanes[col][t.row] * TECH_LANE_DIST + this.ss.techScreenScrollY + shift)), 0.0, 0.0, sm.width, sm.height)) {
                            if (doDraw) {
                                d.rect(c, dep.x + this.ss.techScreenScrollX + shift + this.tierWidths[dep.tier] / 2, dep.y + dep.h / 2 + this.ss.techScreenScrollY + shift, t.x - dep.x - this.techTierGap() / 4 + w + lane * TECH_LANE_DIST - this.tierWidths[dep.tier] / 2, w);
                            }
                            if (dep.y + dep.h / 2 < t.y + t.h / 2 + hLanes[col][t.row] * TECH_LANE_DIST - (t.dependencies.size() - 1) * TECH_LANE_DIST / 2) {
                                if (doDraw) {
                                    d.rect(c, t.x + this.ss.techScreenScrollX - this.techTierGap() / 4 + lane * TECH_LANE_DIST + shift, dep.y + dep.h / 2 + this.ss.techScreenScrollY + shift, w, t.y + t.h / 2 + hLanes[col][t.row] * TECH_LANE_DIST - (t.dependencies.size() - 1) * TECH_LANE_DIST / 2 - dep.y - dep.h / 2);
                                }
                            } else if (dep.y + dep.h / 2 > t.y + t.h / 2 + hLanes[col][t.row] * TECH_LANE_DIST - (t.dependencies.size() - 1) * TECH_LANE_DIST / 2) {
                                int nextTechIndex;
                                for (nextTechIndex = techs.indexOf(dep) + 1; nextTechIndex < techs.size() && techs.get((int)nextTechIndex).tier != dep.tier; ++nextTechIndex) {
                                }
                                if (nextTechIndex < techs.size()) {
                                    Tech nextTech = techs.get(nextTechIndex);
                                    if (nextTech.tier == dep.tier) {
                                        for (int ti2 = 0; ti2 < tsz; ++ti2) {
                                            Tech conflicter = techs.get(ti2);
                                            if (conflicter == t || !conflicter.dependencies.contains(nextTech)) continue;
                                            int[] nArray = hLanes[col];
                                            int n2 = Math.min(hLanes[col].length - 1, t.row + 1);
                                            nArray[n2] = nArray[n2] + 1;
                                            break;
                                        }
                                    }
                                }
                                if (doDraw) {
                                    d.rect(c, t.x + this.ss.techScreenScrollX - this.techTierGap() / 4 + lane * TECH_LANE_DIST + shift, t.y + t.h / 2 + hLanes[col][t.row] * TECH_LANE_DIST - (t.dependencies.size() - 1) * TECH_LANE_DIST / 2 + this.ss.techScreenScrollY + shift, w, dep.y + dep.h / 2 - t.y - t.h / 2 - hLanes[col][t.row] * TECH_LANE_DIST + (t.dependencies.size() - 1) * TECH_LANE_DIST / 2);
                                }
                            }
                            if (doDraw) {
                                d.rect(c, t.x + this.ss.techScreenScrollX - this.techTierGap() / 4 + lane * TECH_LANE_DIST + shift, t.y + t.h / 2 + hLanes[col][t.row] * TECH_LANE_DIST - (t.dependencies.size() - 1) * TECH_LANE_DIST / 2 + this.ss.techScreenScrollY + shift, this.techTierGap() / 4 + t.w / 2 - lane * TECH_LANE_DIST, w);
                            }
                        }
                        int[] nArray = hLanes[col];
                        int n3 = t.row;
                        nArray[n3] = nArray[n3] + 1;
                    }
                }
            }
        }
        this.hoverTech = null;
        for (int ti = 0; ti < tsz; ++ti) {
            Tech.Choice c;
            int ci;
            Tech t = techs.get(ti);
            if (!t.visible(e)) continue;
            int csz = t.choices.size();
            int y = t.y + this.ss.techScreenScrollY;
            int x = t.x + this.ss.techScreenScrollX;
            for (ci = 0; ci < csz; ++ci) {
                c = t.choices.get(ci);
                int ch = StrictMath.max(TECH_ICON_SIZE, AGame.BIG_FOUNT.lineHeight + c.bonuses.list().size() * AGame.FOUNT.lineHeight) + MyDraw.PANEL_INSET * 2;
                if (Rect2D.intersects(x, y, t.w, ch, 0.0, 0.0, sm.width, sm.height)) {
                    if (!this.zoomedOut) {
                        d.drawPanel(x + TECH_ICON_SIZE / 2, y, t.w - TECH_ICON_SIZE / 2, ch);
                    }
                    d.drawPanel(x, y, TECH_ICON_SIZE + MyDraw.PANEL_INSET * 2, TECH_ICON_SIZE + MyDraw.PANEL_INSET * 2);
                    String tint = "";
                    if (e.techs.contains(c)) {
                        d.blit(c.img, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET);
                    } else if (e.research == c) {
                        if (reToneShader == null) {
                            d.blit(TECH_ICON_ACTIVE, SELECTED_TECH, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET);
                        } else {
                            this.reToneBlit(d, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET, c.img, AVAILABLE_TECH, SELECTED_TECH);
                        }
                        tint = SELECTED_TECH_C;
                    } else if (c.tech.available(e)) {
                        boolean hilit = Rect2D.contains(x, y, t.w, ch, d.cursor().x, d.cursor().y);
                        if (reToneShader == null) {
                            d.blit(TECH_ICON, hilit ? SELECTED_TECH : AVAILABLE_TECH, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET);
                        } else {
                            this.reToneBlit(d, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET, c.img, hilit ? AVAILABLE_TECH : UNAVAILABLE_TECH, hilit ? SELECTED_TECH : AVAILABLE_TECH);
                        }
                        d.hook(x, y, t.w, ch, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                            public void run(Input in, Pt p, Hook.Type type) {
                                ((TechScreen)TechScreen.this).ss.w.giveCommand(Client.msg("setResearch").put("empire", ((TechScreen)TechScreen.this).ss.w.player.id).put("tech", c.tech.name).put("choice", c.name));
                            }
                        });
                        d.tooltip((double)x, (double)y, (double)t.w, (double)ch, Lang._t("click_to_research", new Object[0]));
                    } else {
                        tint = UNAVAILABLE_TECH_C;
                        if (reToneShader == null) {
                            d.blit(TECH_ICON, UNAVAILABLE_TECH, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET);
                        } else {
                            this.reToneBlit(d, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET, c.img, MyDraw.DARK_BG, MyDraw.DARK_BG);
                        }
                        d.tooltip((double)x, (double)y, (double)t.w, (double)ch, Lang._t("prerequisites_not_met", new Object[0]));
                    }
                    if (Rect2D.contains(x, y, t.w, ch, d.cursor().x, d.cursor().y)) {
                        this.hoverTech = c.tech;
                    }
                    if (!this.zoomedOut) {
                        int x2 = x + TECH_ICON_SIZE + MyDraw.PANEL_INSET * 3;
                        int y2 = y;
                        d.text(tint + Lang._t("tech_" + c.name, new Object[0]), AGame.BIG_FOUNT, x2, y2 += MyDraw.PANEL_INSET);
                        y2 += AGame.BIG_FOUNT.lineHeight;
                        int bsz = c.bonusList.size();
                        for (int bi = 0; bi < bsz; ++bi) {
                            d.text(tint + c.bonusList.get(bi).getDesc(), AGame.FOUNT, x2, y2);
                            y2 += AGame.FOUNT.lineHeight;
                        }
                    } else {
                        StringBuilder info = new StringBuilder();
                        info.append(Lang._t("tech_" + c.name, new Object[0]));
                        int bsz = c.bonusList.size();
                        for (int bi = 0; bi < bsz; ++bi) {
                            info.append("\n").append(c.bonusList.get(bi).getDesc());
                        }
                        if (!e.techs.contains(c) && e.research != c) {
                            if (c.tech.available(e)) {
                                info.append("\n").append(Lang._t("click_to_research", new Object[0]));
                            } else {
                                info.append("\n").append(Lang._t("prerequisites_not_met", new Object[0]));
                            }
                        }
                        d.tooltip((double)x, (double)y, (double)t.w, (double)ch, info.toString());
                        if (this.hoverTech == c.tech) {
                            d.iconButton(x + TECH_ICON_SIZE + MyDraw.PANEL_INSET - MyDraw.ICON_BUTTON_SZ, y + TECH_ICON_SIZE + MyDraw.PANEL_INSET - MyDraw.ICON_BUTTON_SZ, ZOOM_IN, new Runnable(){

                                @Override
                                public void run() {
                                    TechScreen.this.zoomIn();
                                    TechScreen.this.focusOn = c.tech;
                                }
                            }, true);
                        }
                        d.tooltip((double)(x + TECH_ICON_SIZE + MyDraw.PANEL_INSET - MyDraw.ICON_BUTTON_SZ), (double)(y + TECH_ICON_SIZE + MyDraw.PANEL_INSET - MyDraw.ICON_BUTTON_SZ), (double)MyDraw.ICON_BUTTON_SZ, (double)MyDraw.ICON_BUTTON_SZ, Lang._t("Zoom_in", new Object[0]));
                    }
                }
                y += ch + altSeparation;
            }
            y = t.y + this.ss.techScreenScrollY;
            for (ci = 0; ci < csz; ++ci) {
                c = t.choices.get(ci);
                String tint = c.tech.available(e) ? "" : UNAVAILABLE_TECH_C;
                int ch = StrictMath.max(TECH_ICON_SIZE, AGame.BIG_FOUNT.lineHeight + c.bonuses.list().size() * AGame.FOUNT.lineHeight) + MyDraw.PANEL_INSET * 2;
                if (ci >= csz - 1 || !Rect2D.intersects(x + t.w / 2 - orW / 2, (y += ch + altSeparation) - altSeparation / 2 - AGame.FOUNT.lineHeight / 2 - MyDraw.PANEL_INSET, orW, MyDraw.PANEL_INSET * 2 + AGame.FOUNT.lineHeight, 0.0, 0.0, sm.width, sm.height)) continue;
                d.drawPanel(x + t.w / 2 - orW / 2, y - altSeparation / 2 - AGame.FOUNT.lineHeight / 2 - MyDraw.PANEL_INSET, orW, MyDraw.PANEL_INSET * 2 + AGame.FOUNT.lineHeight);
                d.text(tint + Lang._t("tech_OR", new Object[0]), AGame.FOUNT, x + t.w / 2 - orW / 2 + MyDraw.PANEL_INSET, y - altSeparation / 2 - AGame.FOUNT.lineHeight / 2);
            }
        }
        d.drawTopBar(sm);
        int bw = d.bw(Lang._t("Leave", new Object[0]));
        int x2 = sm.width - bw - MyDraw.SIDE_CLEARANCE;
        d.button(x2, MyDraw.TOP_BAR_INSET, bw, Lang._t("Leave", new Object[0]), "L", new InputRunnable(){

            @Override
            public void run(Input in) {
                ((TechScreen)TechScreen.this).ss.g.s = TechScreen.this.ss;
            }
        });
        d.text(Lang._t("Research", new Object[0]), AGame.BIG_FOUNT, MyDraw.SIDE_CLEARANCE, MyDraw.SIDE_CLEARANCE + 2);
        d.iconToggle(MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING, ZOOM_OUT, new Runnable(){

            @Override
            public void run() {
                if (TechScreen.this.zoomedOut) {
                    TechScreen.this.zoomIn();
                } else {
                    TechScreen.this.zoomOut();
                }
            }
        }, this.zoomedOut, true);
        d.tooltip((double)MyDraw.SIDE_CLEARANCE, (double)(MyDraw.TOP_BAR_H + MyDraw.UI_SPACING), (double)MyDraw.ICON_BUTTON_SZ, (double)MyDraw.ICON_BUTTON_SZ, Lang._t("Zoom", new Object[0]));
        this.sidePanelW = sm.width / 8;
        this.sidePanelW = StrictMath.max(this.sidePanelW, TECH_ICON_SIZE + MyDraw.UI_SPACING + (int)d.textSize((String)Lang._t((String)"Select_Research", (Object[])new Object[0]), (Fount)AGame.BIG_FOUNT).x);
        for (ResearchSpeed rs : Loadable.all(ResearchSpeed.class)) {
            this.sidePanelW = StrictMath.max(this.sidePanelW, d.tw(Lang._t("research_speed_" + rs.name, new Object[0]) + " ($" + e.researchCost(rs, this.ss.w.map) + ")"));
        }
        int x = sm.width - (this.sidePanelW + MyDraw.WINDOW_INSET + MyDraw.SIDE_CLEARANCE);
        int y = MyDraw.TOP_BAR_H;
        d.drawRightSideWindow(sm, x, y);
        d.hook(x, y, this.sidePanelW + MyDraw.WINDOW_INSET + MyDraw.SIDE_CLEARANCE, sm.height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

            public void run(Input in, Pt p, Hook.Type type) {
            }
        });
        int y2 = y += MyDraw.WINDOW_INSET;
        int col2W = this.sidePanelW - TECH_ICON_SIZE - MyDraw.UI_SPACING * 2;
        int col2X = (x += MyDraw.WINDOW_INSET) + TECH_ICON_SIZE + MyDraw.UI_SPACING;
        if (e.research == null) {
            d.blit(TECH_ICON, MyDraw.SELECTED, x, y);
            d.text(Lang._t("Select_Research", new Object[0]), AGame.BIG_FOUNT, col2X, y2, col2W);
            y = (int)((double)y + (StrictMath.max((double)TECH_ICON_SIZE, d.textSize((String)Lang._t((String)"Select_Research", (Object[])new Object[0]), (Fount)AGame.BIG_FOUNT, (double)0.0, (double)0.0, (int)col2W).height) + (double)MyDraw.UI_SPACING));
            d.progressBar(x, y, this.sidePanelW, 0.0);
        } else {
            d.text(Lang._t("Researching_x", Lang._t("tech_" + e.research.name, new Object[0])), AGame.BIG_FOUNT, x, y, this.sidePanelW);
            y2 = y = (int)((double)y + (d.textSize((String)Lang._t((String)"Researching_x", (Object[])new Object[]{Lang._t((String)new StringBuilder().append((String)"tech_").append((String)e.research.name).toString(), (Object[])new Object[0])}), (Fount)AGame.BIG_FOUNT, (double)0.0, (double)0.0, (int)this.sidePanelW).height + (double)MyDraw.UI_SPACING));
            d.blit(e.research.img, x, y);
            int bsz = e.research.bonusList.size();
            for (int bi = 0; bi < bsz; ++bi) {
                d.text(e.research.bonusList.get(bi).getDesc(), AGame.FOUNT, col2X, y2, col2W);
                y2 = (int)((double)y2 + d.textSize((String)e.research.bonusList.get((int)bi).getDesc(), (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)col2W).height);
            }
            y = StrictMath.max(y2, y + TECH_ICON_SIZE) + MyDraw.UI_SPACING;
            d.progressBar(x, y, this.sidePanelW, (double)e.researchPoints * 1.0 / (double)e.research.tech.cost(e.bonuses()));
        }
        d.text(Lang._t("Research_Budget", new Object[0]), AGame.BIG_FOUNT, x, y += MyDraw.PROGRESS_BAR_H + MyDraw.UI_SPACING);
        y += AGame.BIG_FOUNT.lineHeight + MyDraw.BUTTON_SPACING;
        for (final ResearchSpeed rs : Loadable.all(ResearchSpeed.class)) {
            d.toggle(x, y, this.sidePanelW, Lang._t("research_speed_" + rs.name, new Object[0]) + " ($" + e.researchCost(rs, this.ss.w.map) + ")", null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    ((TechScreen)TechScreen.this).ss.w.giveCommand(Client.msg("setResearchSpeed").put("empire", ((TechScreen)TechScreen.this).ss.w.player.id).put("speed", rs.name));
                }
            }, rs == e.researchSpeed, true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
    }

    @Override
    public ArrayList<String> music() {
        return null;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

