/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.EmpireStat;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.catengine.Img;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Tech
extends Loadable {
    public static final int ALL_TIERS = 100000;
    public final int tier;
    public final ArrayList<String> dependencyNames = new ArrayList();
    public final ArrayList<Tech> dependencies = new ArrayList();
    public final ArrayList<Choice> choices = new ArrayList();
    public final Bonus requiresBonus;
    public int row;
    public static Tech[][] layout;
    private static boolean[][] depMatrix;
    private int depMatrixID;
    private static int maxTier;
    private static int minTier;
    public transient int x;
    public transient int y;
    public transient int w;
    public transient int h;

    public Tech(JSONObject o) {
        super(o.getString("name"), o.optInt("sort", 0));
        int i;
        JSONArray a;
        this.tier = o.getInt("tier");
        if (o.has("choices")) {
            a = o.getJSONArray("choices");
            for (i = 0; i < a.length(); ++i) {
                this.choices.add(new Choice(a.getJSONObject(i), this));
            }
        } else {
            this.choices.add(new Choice(o, this));
        }
        if (o.has("dependencies")) {
            a = o.getJSONArray("dependencies");
            for (i = 0; i < a.length(); ++i) {
                this.dependencyNames.add(a.getString(i));
            }
        }
        this.requiresBonus = o.has("requiresBonus") ? Bonus.ofName(o.getString("requiresBonus")) : null;
    }

    public boolean visible(Empire e) {
        return this.requiresBonus == null || e.bonuses().contains[this.requiresBonus.ordinal()];
    }

    public boolean available(Empire e) {
        int depSz = this.dependencies.size();
        for (int depI = 0; depI < depSz; ++depI) {
            boolean hasDep = false;
            Tech dep = this.dependencies.get(depI);
            int techsSz = e.techs.size();
            for (int techsI = 0; techsI < techsSz; ++techsI) {
                if (dep != e.techs.get((int)techsI).tech) continue;
                hasDep = true;
            }
            if (hasDep) continue;
            return false;
        }
        return this.visible(e);
    }

    public Choice getChoice(String name) {
        for (Choice c : this.choices) {
            if (!c.name.equals(name)) continue;
            return c;
        }
        return this.choices.get(0);
    }

    public static Tech ofName(String name) {
        return Loadable.ofName(Tech.class, name);
    }

    public static Choice choiceOfName(String name) {
        for (Tech t : Loadable.all(Tech.class)) {
            for (Choice c : t.choices) {
                if (!c.name.equals(name)) continue;
                return c;
            }
        }
        return null;
    }

    public static Choice findProvider(Bonus required) {
        ArrayList<Tech> ts = Loadable.all(Tech.class);
        int tsz = ts.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tech t = ts.get(ti);
            int csz = t.choices.size();
            for (int ci = 0; ci < csz; ++ci) {
                Choice c = t.choices.get(ci);
                if (!c.bonuses.contains[required.ordinal()]) continue;
                return c;
            }
        }
        return null;
    }

    public boolean dependsOn(Tech t2) {
        return t2 != null && depMatrix[this.depMatrixID][t2.depMatrixID];
    }

    public int cost(BonusSet bonuses) {
        return (int)((double)EmpireStat.BASE_RESEARCH_COST.get(bonuses).intValue() * StrictMath.pow(EmpireStat.RESEARCH_COST_EXPONENT.get(bonuses), this.tier));
    }

    public static int getMinTier() {
        return minTier;
    }

    public static int getMaxTier() {
        return maxTier;
    }

    public static BonusSet getStandardBonuses() {
        BonusSet bs = Tech.getBonusesForTier(maxTier);
        bs.addAll(Bonus.standardSet);
        return bs;
    }

    public static BonusSet getBonusesForTier(int tier) {
        BonusSet bonuses = new BonusSet();
        for (Tech t : Loadable.all(Tech.class)) {
            if (t.tier > tier || t.choices.size() > 1) continue;
            for (Choice c : t.choices) {
                bonuses.addAll(c.bonuses);
            }
        }
        return bonuses;
    }

    public static boolean postLoad() {
        int tier;
        int idCounter = 0;
        ArrayList<Tech> techs = Loadable.all(Tech.class);
        for (Tech t : techs) {
            t.depMatrixID = idCounter++;
            for (String dep : t.dependencyNames) {
                if (!Loadable.hasOfName(Tech.class, dep)) {
                    if (t.sourceMod == null) continue;
                    t.sourceMod.loadLog = t.sourceMod.loadLog + "\nUnknown dependency: " + dep;
                    t.sourceMod.loadFailed = true;
                    return false;
                }
                t.dependencies.add(Tech.ofName(dep));
            }
        }
        depMatrix = new boolean[idCounter][idCounter];
        for (Tech a : techs) {
            for (Tech b : techs) {
                if (!a.dependencies.contains(b)) continue;
                Tech.depMatrix[a.depMatrixID][b.depMatrixID] = true;
            }
        }
        minTier = 0;
        maxTier = 0;
        for (Tech t : techs) {
            maxTier = StrictMath.max(maxTier, t.tier);
            minTier = StrictMath.min(minTier, t.tier);
        }
        int maxTierSize = 0;
        for (tier = minTier; tier <= maxTier; ++tier) {
            int size = 0;
            for (Tech t : Loadable.all(Tech.class)) {
                if (t.tier != tier) continue;
                ++size;
            }
            maxTierSize = StrictMath.max(maxTierSize, size);
        }
        layout = new Tech[maxTier + 1 - minTier][maxTierSize];
        for (tier = minTier; tier <= maxTier; ++tier) {
            int size = 0;
            for (Tech t : techs) {
                if (t.tier != tier) continue;
                Tech.layout[tier - Tech.minTier][size] = t;
                ++size;
            }
        }
        boolean progress = true;
        int distBaseline = Tech.distances();
        while (progress) {
            progress = false;
            for (int column = 0; column < layout.length; ++column) {
                for (int rowLength = layout.length - column; rowLength >= 1; --rowLength) {
                    for (int row = 0; row < layout[0].length - 1; ++row) {
                        for (int rowHeight = layout[0].length - row - 1; rowHeight >= 1; --rowHeight) {
                            int i;
                            int i2;
                            Tech[] bubbleUp = new Tech[rowLength];
                            for (i2 = 0; i2 < rowLength; ++i2) {
                                bubbleUp[i2] = layout[column + i2][row + rowHeight];
                            }
                            for (i2 = 0; i2 < rowLength; ++i2) {
                                for (int j = rowHeight; j > 0; --j) {
                                    Tech.layout[column + i2][row + j] = layout[column + i2][row + j - 1];
                                }
                            }
                            for (i2 = 0; i2 < rowLength; ++i2) {
                                Tech.layout[column + i2][row] = bubbleUp[i2];
                            }
                            int dist = Tech.distances();
                            if (dist < distBaseline) {
                                distBaseline = dist;
                                progress = true;
                                continue;
                            }
                            for (i = 0; i < rowLength; ++i) {
                                for (int j = 0; j < rowHeight; ++j) {
                                    Tech.layout[column + i][row + j] = layout[column + i][row + j + 1];
                                }
                            }
                            for (i = 0; i < rowLength; ++i) {
                                Tech.layout[column + i][row + rowHeight] = bubbleUp[i];
                            }
                        }
                    }
                }
            }
        }
        for (int column = 0; column < layout.length; ++column) {
            for (int row = 0; row < layout[0].length; ++row) {
                if (layout[column][row] == null) continue;
                Tech.layout[column][row].row = row;
            }
        }
        for (Tech t : techs) {
            Collections.sort(t.dependencies, new Comparator<Tech>(){

                @Override
                public int compare(Tech o1, Tech o2) {
                    return o1.row - o2.row;
                }
            });
        }
        return true;
    }

    public static int distances() {
        int row;
        int column;
        int dist = 0;
        for (column = 1; column < layout.length; ++column) {
            for (row = 0; row < layout[0].length; ++row) {
                for (int depCol = 0; depCol < column; ++depCol) {
                    for (int depRow = 0; depRow < layout[0].length; ++depRow) {
                        if (layout[column][row] == null || !layout[column][row].dependsOn(layout[depCol][depRow])) continue;
                        dist += (row - depRow) * (row - depRow);
                    }
                }
            }
        }
        dist *= 10;
        for (column = 0; column < layout.length - 1; ++column) {
            for (row = 0; row < layout[0].length - 1; ++row) {
                if (layout[column][row] == null || layout[column + 1][row] == null) continue;
                for (int srcRow = 0; srcRow < row; ++srcRow) {
                    if (layout[column][srcRow] == null || !layout[column + 1][row].dependsOn(layout[column][srcRow])) continue;
                    for (int dstRow = row + 1; dstRow < layout[0].length; ++dstRow) {
                        if (layout[column + 1][dstRow] == null || !layout[column + 1][dstRow].dependsOn(layout[column][row])) continue;
                        ++dist;
                    }
                }
            }
        }
        return dist;
    }

    public strictfp static class Choice
    implements Comparable<Choice> {
        public final String name;
        public final BonusSet bonuses;
        public final ArrayList<Bonus> bonusList;
        public final Img img;
        public final Tech tech;

        public Choice(JSONObject o, Tech tech) {
            this.tech = tech;
            this.name = o.getString("name");
            this.bonuses = new BonusSet();
            JSONArray a = o.getJSONArray("bonuses");
            for (int i = 0; i < a.length(); ++i) {
                this.bonuses.add(Bonus.ofNameOrNone(a.getString(i)));
            }
            this.bonusList = this.bonuses.list();
            JSONObject imgO = o.getJSONObject("img");
            this.img = new Img(imgO.getString("src"), imgO.getInt("x"), imgO.getInt("y"), imgO.getInt("w"), imgO.getInt("h"), imgO.optBoolean("flipped", false));
        }

        public ArrayList<Choice> getAllPrerequisitesIncludingThis() {
            ArrayList<Tech> ts = Loadable.all(Tech.class);
            ArrayList<Choice> prereqs = new ArrayList<Choice>();
            prereqs.add(this);
            block0: while (true) {
                block1: for (Tech candidate : ts) {
                    for (Choice c : candidate.choices) {
                        if (!prereqs.contains(c)) continue;
                        continue block1;
                    }
                    for (Choice prereq : prereqs) {
                        if (!prereq.tech.dependsOn(candidate)) continue;
                        prereqs.add(candidate.choices.get(0));
                        continue block0;
                        continue block1;
                    }
                }
                break;
            }
            Collections.sort(prereqs);
            return prereqs;
        }

        @Override
        public int compareTo(Choice o) {
            if (this.tech == o.tech) {
                return this.tech.choices.indexOf(this) - this.tech.choices.indexOf(o);
            }
            if (this.tech.tier == o.tech.tier) {
                return this.tech.sort - o.tech.sort;
            }
            return this.tech.tier - o.tech.tier;
        }
    }
}

