/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.FireMode;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Tentacle;
import com.zarkonnen.airships.WeatherEffect;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;
import java.util.Iterator;

public strictfp class TacticalAI {
    public static final int X_GRID_STEP = 20;
    public static final int Y_GRID_STEP = 30;
    public static final int INSET = 8;
    public static final int MAX_GRID_V_SIZE = 76;
    public static final int GRID_X_ANCHOR = -3200;
    public static final double NO = -1000000.0;
    public final int gridVSize;
    public final int gridYAnchor;
    public final double[][][] grid;
    public final boolean[][] ramZones;
    public final int gridHSize;
    public final Airship ship;
    public final Combat c;
    public final Combat.Side mySide;
    public final Combat.Side enemySide;
    int yIndex = 0;
    int ticksUntilCommand = 0;
    int phaseTick = 0;
    int movePhaseTick = 0;
    int sideTickCounter = 0;
    int ticksUntilNextFireModeCheck = 0;
    int ticksRammersOnly = 0;
    Airship lastBoardTarget = null;
    boolean tunfmcSet = false;
    public boolean doesSurrender = true;
    public int baseSurrenderFactor = 8;
    public boolean inited = false;
    public AIQuality quality = AIQuality.SMART;
    public static boolean fixed = false;
    public static boolean lfs = true;
    public static final int BOARD_X_DIST_MAX = 40;
    public static final int BOARD_X_DIST_MAX_CMD = 50;
    public static final int TOO_HIGH = 30;
    public static final int TOO_HIGH_CMD = 50;
    public static final int TOO_LOW = -40;
    public static final int TOO_LOW_CMD = -50;

    public TacticalAI(Airship ship, Combat c, Combat.Side mySide, Combat.Side enemySide) {
        this.gridVSize = !ship.type.mobile ? 0 : (ship.type.onGround ? 1 : StrictMath.min(76, StrictMath.max(0, ship.serviceCeiling()) / 30 + 2));
        this.gridYAnchor = 512 - this.gridVSize * 30;
        this.gridHSize = (6400 - (int)ship.getBBWidth() - 3) / 20;
        this.grid = new double[this.gridVSize][this.gridHSize][2];
        this.ramZones = new boolean[this.gridVSize][this.gridHSize];
        this.ship = ship;
        this.c = c;
        this.mySide = mySide;
        this.enemySide = enemySide;
    }

    public void sideTick() {
        if (this.sideTickCounter-- > 0) {
            return;
        }
        Iterator<Airship> it = this.mySide.reserve.iterator();
        block0: while (it.hasNext()) {
            double proposedY;
            int proposedX;
            Airship res = it.next();
            int n = proposedX = this.c.sides.indexOf(this.mySide) == 0 ? -3199 : 3200 - res.getWidth() * 16 - 1;
            if (res.type.onGround) {
                proposedY = this.c.landFormations.get(0).getVerticalPosition(res, proposedX, res.flipped, false);
                if (!PlaceShipTool.canPlace(res, proposedX, proposedY, res.flipped, this.c, true, null, -1)) continue;
                res.setX(proposedX);
                res.setY(proposedY);
                res.ai = new TacticalAI(res, this.c, this.mySide, this.enemySide);
                this.mySide.ships.add(res);
                it.remove();
                continue;
            }
            for (proposedY = (double)(512 - res.serviceCeiling()); proposedY < 512.0; proposedY += 16.0) {
                if (!PlaceShipTool.canPlace(res, proposedX, proposedY, res.flipped, this.c, false, null, -1)) continue;
                res.setX(proposedX);
                res.setY(proposedY);
                res.ai = new TacticalAI(res, this.c, this.mySide, this.enemySide);
                this.mySide.ships.add(res);
                it.remove();
                continue block0;
            }
        }
        this.sideTickCounter = 20;
        this.checkSurrender();
    }

    public void init() {
        this.calculate();
        this.ticksUntilCommand = this.mySide.ships.indexOf(this.ship) * 3 + 1;
        this.inited = true;
    }

    public void tick() {
        int ptMult;
        if (!this.inited) {
            System.out.println("I didn't get inited!");
            this.init();
        }
        ++this.movePhaseTick;
        if (this.ship == this.mySide.ships.get(0)) {
            this.sideTick();
        }
        if (!this.tunfmcSet) {
            this.ticksUntilNextFireModeCheck = this.mySide.ships.indexOf(this.ship) * 3 + 2;
            this.tunfmcSet = true;
        }
        if (!this.ship.type.mobile) {
            this.buildingMove();
            return;
        }
        int n = ptMult = this.grid.length == 1 ? 4 : 1;
        if (this.phaseTick++ % (this.mySide.ships.size() * ptMult) == this.mySide.ships.indexOf(this.ship)) {
            int aiMaxY = this.aiMaxY();
            boolean wantsToBoard = this.wantsToBoard();
            boolean isShortRange = this.hasShortRangeWeapons();
            this.calculateRow(this.yIndex, this.wantsToRam(), wantsToBoard, wantsToBoard || this.hasShortRangeWeapons(), isShortRange, aiMaxY);
            this.yIndex = (this.yIndex + 1) % this.grid.length;
        }
        if (this.ticksUntilCommand <= 0 && this.movePhaseTick % this.mySide.ships.size() == this.mySide.ships.indexOf(this.ship)) {
            this.move();
        } else {
            --this.ticksUntilCommand;
        }
    }

    private void checkSurrender() {
        if (!this.doesSurrender) {
            return;
        }
        if (this.c.isRaid && this.c.lootAmount == this.c.maxLootAmount) {
            this.doSurrender(this.c);
            return;
        }
        double surrenderFactor = this.baseSurrenderFactor;
        if (this.c.isRaid && this.c.lootAmount == 1) {
            surrenderFactor = 2.5;
        }
        if (this.c.isRaid && this.c.lootAmount == 2) {
            surrenderFactor = 1.0;
        }
        if (this.c.isRaid && this.c.lootAmount == 3) {
            surrenderFactor = 0.5;
        }
        int ourStrength = 0;
        int ssz = this.mySide.ships.size();
        for (int si = 0; si < ssz; ++si) {
            Airship s = this.mySide.ships.get(si);
            if (s.inCombat(this.c)) {
                ourStrength += s.getCost();
            }
            if (!s.preventsSurrender()) continue;
            return;
        }
        int enemyStrength = 0;
        ssz = this.enemySide.ships.size();
        for (int si = 0; si < ssz; ++si) {
            Airship s = this.enemySide.ships.get(si);
            if (!s.inCombat(this.c)) continue;
            enemyStrength += s.getCost();
        }
        if ((double)enemyStrength > (double)ourStrength * (surrenderFactor /= StrictMath.min(32.0, StrictMath.max(1.0, (double)(this.c.time - 90000) / 150000.0)))) {
            this.doSurrender(this.c);
            return;
        }
        boolean doSurrender = !this.c.isRaid;
        boolean rammersOnly = !this.c.isRaid;
        for (Airship s : this.mySide.ships) {
            if (!s.hasActiveCrew()) continue;
            if (s.canShoot() && this.c.msSinceShotFired < 30000 || s.hasActiveFlyers(this.c)) {
                doSurrender = false;
                rammersOnly = false;
                break;
            }
            if (!s.hasRam() || !s.canMove()) continue;
            doSurrender = false;
        }
        if (doSurrender) {
            this.doSurrender(this.c);
        } else if (rammersOnly && this.ticksRammersOnly++ > 40) {
            this.doSurrender(this.c);
        }
    }

    private void doSurrender(Combat c) {
        c.execCommand(Client.msg("surrender").put("side", c.sides.indexOf(this.mySide)));
    }

    private void buildingMove() {
        if (!this.ship.readyForCommand()) {
            return;
        }
        FireMode bfm = this.getBestFireMode();
        if (this.ship.fireMode != bfm) {
            this.c.execCommand(Client.msg("fireMode").put("id", this.c.getShipID(this.ship)).put("value", bfm.name()));
        }
    }

    private void move() {
        if (!this.ship.readyForCommand()) {
            return;
        }
        Airship boardable = this.getBoardable();
        FireMode bfm = this.getBestFireMode();
        Pt vrp = this.checkForVerticalRamPossibility();
        if (vrp != null) {
            this.c.execCommand(Client.msg("ram").put("id", this.c.getShipID(this.ship)).put("x", vrp.x).put("y", vrp.y).put("flipTo", this.ship.flipped));
        } else if (this.ship.fireMode != bfm) {
            this.c.execCommand(Client.msg("fireMode").put("id", this.c.getShipID(this.ship)).put("value", bfm.name()));
        } else if (this.currentlyHookingHasBoarders()) {
            this.c.execCommand(Client.msg("cutOwnTethers").put("id", this.c.getShipID(this.ship)));
        } else if (boardable != null && this.ship.board == null && this.lastBoardTarget != boardable) {
            this.c.execCommand(Client.msg("board").put("id", this.c.getShipID(this.ship)).put("target", this.c.getShipID(boardable)));
            this.lastBoardTarget = boardable;
        } else if (this.hasHook() && boardable != null && !this.currentlyHooking(boardable)) {
            this.c.execCommand(Client.msg("tetherAt").put("id", this.c.getShipID(this.ship)).put("target", this.c.getShipID(boardable)));
        } else if (this.hasHook() && !this.currentlyHookingValidTarget() && this.nearestMovableTarget() != null && (!this.ship.hasCrewQuartersAny(CrewType.boarders) || this.nearestMovableTarget().boarders.isEmpty())) {
            this.c.execCommand(Client.msg("tetherAt").put("id", this.c.getShipID(this.ship)).put("target", this.c.getShipID(this.nearestMovableTarget())));
        } else if (this.wantsToRam() && this.canRam()) {
            this.c.execCommand(Client.msg("ram").put("id", this.c.getShipID(this.ship)).put("x", StrictMath.min(3200.0 - this.ship.getBBWidth(), StrictMath.max(-3200.0, this.ship.getX() + (double)(this.ship.flipped ? -1500 : 1500)))).put("y", this.ship.getY()).put("flipTo", this.ship.flipped));
            this.ticksUntilCommand = 400;
        } else {
            MoveTo mt = this.choose();
            if (mt != null) {
                if (StrictMath.abs(this.ship.moveTo.x - mt.getMoveToPt().x) > 16.0 || StrictMath.abs(this.ship.moveTo.y - mt.getMoveToPt().y) > 16.0 || mt.flipped != this.ship.flipped) {
                    this.c.execCommand(Client.msg("moveTo").put("id", this.c.getShipID(this.ship)).put("x", mt.getMoveToPt().x).put("y", mt.getMoveToPt().y).put("flipTo", mt.flipped));
                    this.ticksUntilCommand = this.gridVSize * 3 + 1;
                } else {
                    this.ticksUntilCommand = 12;
                }
            }
        }
        this.ticksUntilCommand = 7 + this.ship.tiles.size() / 80;
    }

    public boolean hasHook() {
        int msz = this.ship.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.ship.modules.get(mi);
            if (m.type.getTetherSpec(this.ship.currentBonuses) == null) continue;
            return true;
        }
        return false;
    }

    public boolean currentlyHookingValidTarget() {
        return this.ship.tetherAt != null && this.ship.tetherAt.inCombat(this.c);
    }

    public boolean currentlyHooking(Airship target) {
        return this.ship.tetherAt == target;
    }

    public boolean currentlyHookingHasBoarders() {
        return this.ship.tetherAt != null && !this.ship.tetherAt.boarders.isEmpty();
    }

    public Airship nearestMovableTarget() {
        double bestD2 = 0.0;
        Airship best = null;
        for (Airship as : this.enemySide.ships) {
            if (!as.type.mobile || !as.inCombat(this.c)) continue;
            double d2 = (this.ship.getX() + this.ship.getBBWidth() / 2.0 - as.getX() - as.getBBWidth() / 2.0) * (this.ship.getX() + this.ship.getBBWidth() / 2.0 - as.getX() - as.getBBWidth() / 2.0) + (this.ship.getY() + this.ship.getBBHeight() / 2.0 - as.getY() - as.getBBHeight() / 2.0) * (this.ship.getY() + this.ship.getBBHeight() / 2.0 - as.getY() - as.getBBHeight() / 2.0);
            if (best != null && !(d2 < bestD2)) continue;
            best = as;
            bestD2 = d2;
        }
        return best;
    }

    private Pt checkForVerticalRamPossibility() {
        if (this.quality != AIQuality.SMART) {
            return null;
        }
        int ssz = this.mySide.ships.size();
        for (int si = 0; si < ssz; ++si) {
            Airship s = this.mySide.ships.get(si);
            if (s == this.ship || !(s.getY() > this.ship.getY()) || !(s.getX() < this.ship.getX() + this.ship.getBBWidth()) || !(s.getX() + s.getBBWidth() > this.ship.getX())) continue;
            return null;
        }
        boolean hasSmashZone = false;
        int smashZoneStart = 0;
        int smashZoneWidth = 0;
        boolean hasSoftZone = false;
        int softZoneStart = 0;
        int softZoneWidth = 0;
        int msz = this.ship.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.ship.modules.get(mi);
            if (m.y + m.type.getH() != this.ship.getHeight()) continue;
            if (ModuleType.keelsAndRams.contains(m.type)) {
                hasSmashZone = true;
                smashZoneStart = m.x;
                smashZoneWidth = m.type.getW();
                continue;
            }
            if (!hasSoftZone) {
                hasSoftZone = true;
                softZoneStart = m.x;
                softZoneWidth = m.type.getW();
                continue;
            }
            int softZoneEnd = softZoneStart + softZoneWidth;
            softZoneStart = StrictMath.min(m.x, softZoneStart);
            softZoneEnd = StrictMath.max(softZoneEnd, m.x + m.type.getW());
            softZoneWidth = softZoneEnd - softZoneStart;
        }
        if (!this.ship.canShoot()) {
            hasSoftZone = false;
        }
        double softStart = this.ship.getX() + (double)((this.ship.flipped ? this.ship.getWidth() - softZoneStart - softZoneWidth : softZoneStart) * 16);
        double softEnd = this.ship.getX() + (double)((this.ship.flipped ? this.ship.getWidth() - softZoneStart : softZoneStart + softZoneWidth) * 16);
        double smashStart = this.ship.getX() + (double)((this.ship.flipped ? this.ship.getWidth() - smashZoneStart - smashZoneWidth : smashZoneStart) * 16) + 5.0;
        double smashEnd = this.ship.getX() + (double)((this.ship.flipped ? this.ship.getWidth() - smashZoneStart : smashZoneStart + smashZoneWidth) * 16) - 5.0;
        int tsz = this.enemySide.ships.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Airship target = this.enemySide.ships.get(ti);
            if (target.getY() < this.ship.getY() + this.ship.getBBHeight() + 50.0 || hasSoftZone && target.getX() < softEnd && target.getX() + target.getBBWidth() > softStart || !hasSmashZone || !(target.getX() < smashEnd) || !(target.getX() + target.getBBWidth() > smashStart)) continue;
            return new Pt(this.ship.getX(), 512.0 - this.ship.getBBHeight() - 10.0);
        }
        return null;
    }

    private FireMode getBestFireMode() {
        if (this.quality != AIQuality.SMART) {
            return this.ship.fireMode;
        }
        if (this.ticksUntilNextFireModeCheck-- > 0) {
            return this.ship.fireMode;
        }
        this.ticksUntilNextFireModeCheck = 120;
        WeatherEffect we = this.c.timeOfDay.effect;
        double shootToLeftJitterMult = we.shootJitterMult * we.shootToLeftJitterMult;
        double shootToRightJitterMult = we.shootJitterMult * we.shootToRightJitterMult;
        int rapidVotes = 0;
        int normalVotes = 0;
        int aimedVotes = 0;
        int msz = this.ship.modules.size();
        int esz = this.enemySide.ships.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = this.ship.modules.get(mi);
            if (!m.type.isWeapon() || !m.canRun()) continue;
            double shortestDist = -100.0;
            for (int ei = 0; ei < esz; ++ei) {
                boolean ltr;
                Airship e = this.enemySide.ships.get(ei);
                if (!m.canHit(e, this.ship.getX(), this.ship.getY(), e.getX(), e.getY(), this.ship.flipped, 8)) continue;
                double manhattanDist = StrictMath.min(StrictMath.abs(this.ship.getX() - e.getX() - e.getBBWidth()), StrictMath.abs(e.getX() - this.ship.getX() - this.ship.getBBWidth())) + StrictMath.min(StrictMath.abs(this.ship.getY() - e.getY() - e.getBBHeight()), StrictMath.abs(e.getY() - this.ship.getY() - this.ship.getBBHeight()));
                boolean bl = ltr = e.getX() - this.ship.getX() > 0.0;
                manhattanDist = ltr ? (manhattanDist *= shootToRightJitterMult) : (manhattanDist *= shootToLeftJitterMult);
                if (!(shortestDist < -1.0) && !(manhattanDist < shortestDist)) continue;
                shortestDist = manhattanDist;
            }
            if (shortestDist < -1.0) continue;
            int optDist = m.type.getOptimumRange(this.ship.currentBonuses);
            if (shortestDist >= (double)(optDist * 2)) {
                ++aimedVotes;
                continue;
            }
            if (shortestDist <= (double)(optDist / 3)) {
                ++rapidVotes;
                continue;
            }
            ++normalVotes;
        }
        switch (this.ship.fireMode) {
            case AIMED: {
                aimedVotes *= 2;
                break;
            }
            case NORMAL: {
                normalVotes *= 2;
                break;
            }
            case RAPID: {
                rapidVotes *= 2;
            }
        }
        if (aimedVotes > normalVotes && aimedVotes > rapidVotes) {
            return FireMode.AIMED;
        }
        if (rapidVotes > normalVotes && rapidVotes > aimedVotes) {
            return FireMode.RAPID;
        }
        return FireMode.NORMAL;
    }

    public double distanceToGround(Airship s) {
        return s.getY() - (double)this.c.landFormations.get(0).getVerticalPosition(s, (int)s.getX(), s.flipped, false);
    }

    public Airship getBoardable() {
        ArrayList<CrewType> cts = this.ship.getBoarderTypes();
        int tsz = this.mySide.troops.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Crewman cm = this.mySide.troops.get(ti);
            if (cm.attachedTo != this.ship || !cm.alive() || cts.contains(cm.type)) continue;
            cts.add(cm.type);
        }
        if (cts.isEmpty()) {
            return null;
        }
        int ssz = this.enemySide.ships.size();
        int ctss = cts.size();
        for (int ctsi = 0; ctsi < ctss; ++ctsi) {
            Airship s;
            int si;
            CrewType ct = cts.get(ctsi);
            if (ct.hasHook) {
                block2: for (si = 0; si < ssz; ++si) {
                    double dy;
                    s = this.enemySide.ships.get(si);
                    if (!s.inCombat(this.c) || !s.canBeBoarded()) continue;
                    int bsz = s.boarders.size();
                    for (int bi = 0; bi < bsz; ++bi) {
                        if (s.boarders.get(bi).alive()) continue block2;
                    }
                    double dx = StrictMath.max(0.0, StrictMath.min(StrictMath.abs(this.ship.getX() - s.getX() - s.getBBWidth()), StrictMath.abs(s.getX() - this.ship.getX() - this.ship.getBBWidth())));
                    if (dx + (dy = StrictMath.max(0.0, StrictMath.min(StrictMath.abs(this.ship.getY() - s.getY() - s.getBBHeight()), StrictMath.abs(s.getY() - this.ship.getY() - this.ship.getBBHeight())))) < (double)ct.hookRopeLength) {
                        return s;
                    }
                    if (!(this.distanceToGround(this.ship) < 120.0) || !(this.distanceToGround(s) < (double)ct.hookRopeLength * 0.7)) continue;
                    return s;
                }
                continue;
            }
            for (si = 0; si < ssz; ++si) {
                boolean yep;
                s = this.enemySide.ships.get(si);
                if (!s.inCombat(this.c) || !s.canBeBoarded()) continue;
                boolean bl = yep = s.getX() - (this.ship.getX() + this.ship.getBBWidth()) <= (double)ct.assumedJumpDist && this.ship.getX() - (s.getX() + s.getBBWidth()) <= (double)ct.assumedJumpDist && s.getY() - (this.ship.getY() + this.ship.getBBHeight()) <= 50.0 && this.ship.getY() - (s.getY() + s.getBBHeight()) <= -50.0;
                if (yep) {
                    return s;
                }
                if (!(this.distanceToGround(this.ship) < 120.0) || !(this.distanceToGround(s) < 3.0)) continue;
                return s;
            }
        }
        return null;
    }

    public double getWorldYFromGridY(int gridX, int gridY, boolean flipped) {
        if (this.ship.type.onGround) {
            return (double)this.c.landFormations.get(0).getVerticalPosition(this.ship, -3200 + gridX * 20, flipped, true) - this.ship.getCachedGroundOffset();
        }
        return this.gridYAnchor + gridY * 30;
    }

    public void calculate() {
        boolean wantsToRam = this.wantsToRam();
        boolean wantsToBoard = this.wantsToBoard();
        boolean isShortRange = this.hasShortRangeWeapons();
        int aiMaxY = this.aiMaxY();
        for (int gridY = 0; gridY < this.grid.length; ++gridY) {
            this.calculateRow(gridY, wantsToRam, wantsToBoard, wantsToBoard || isShortRange, isShortRange, aiMaxY);
        }
    }

    private boolean isNearEnemy(int x, int y) {
        int ssz = this.enemySide.ships.size();
        int delta = 300;
        for (int si = 0; si < ssz; ++si) {
            Airship en = this.enemySide.ships.get(si);
            if (!Rect2D.intersects(en.getX() - (double)delta, en.getY() - (double)delta, en.getBBWidth() + (double)(delta * 2), en.getBBHeight() + (double)(delta * 2), x, y, this.ship.getBBWidth(), this.ship.getBBHeight())) continue;
            return true;
        }
        return false;
    }

    private void calculateRow(int gridY, boolean wantsToRam, boolean wantsToBoard, boolean doShortRangeGrid, boolean isShortRange, int aiMaxY) {
        int asc = this.ship.availableServiceCeiling();
        for (int gridX = 0; gridX < this.grid[0].length; ++gridX) {
            boolean shortRangeNearEnemy;
            int x = -3200 + gridX * 20;
            int y = (int)this.getWorldYFromGridY(gridX, gridY, false);
            boolean bl = gridX % 5 == 0 && gridY % 4 == 0 ? true : (shortRangeNearEnemy = doShortRangeGrid && this.isNearEnemy(x, y));
            if ((gridX % 5 == 0 || shortRangeNearEnemy) && (gridY % 4 == 0 || wantsToRam || shortRangeNearEnemy)) {
                double result;
                this.grid[gridY][gridX][0] = result = this.calculate(x, y, false, asc, wantsToRam, wantsToBoard, isShortRange, aiMaxY);
                y = (int)this.getWorldYFromGridY(gridX, gridY, true);
                this.grid[gridY][gridX][1] = result = this.calculate(x, y, true, asc, wantsToRam, wantsToBoard, isShortRange, aiMaxY);
                continue;
            }
            this.grid[gridY][gridX][0] = -1000000.0;
            this.grid[gridY][gridX][1] = -1000000.0;
        }
    }

    private void updateRamZones() {
        for (int gridY = 0; gridY < this.ramZones.length; ++gridY) {
            for (int gridX = 0; gridX < this.ramZones[0].length; ++gridX) {
                this.ramZones[gridY][gridX] = false;
            }
        }
        int esz = this.enemySide.ships.size();
        for (int ei = 0; ei < esz; ++ei) {
            Airship enemy = this.enemySide.ships.get(ei);
            int msz = enemy.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                int gx;
                int gy;
                Module m = enemy.modules.get(mi);
                if (!m.type.isRam()) continue;
                double startY = enemy.getY() + (double)(m.y * 16);
                double endY = enemy.getY() + (double)(m.y * 16) + (double)(m.type.getH() * 16);
                double startX = enemy.getX() + enemy.getBBWidth() / 2.0;
                int startGridY = (int)StrictMath.max(0.0, StrictMath.floor((startY - (double)this.gridYAnchor) / 30.0));
                int endGridY = (int)StrictMath.min((double)(this.grid.length - 1), StrictMath.ceil((endY - (double)this.gridYAnchor) / 30.0));
                int startGridX = (int)StrictMath.max(0.0, StrictMath.min((double)(this.grid[0].length - 1), (startX - -3200.0) / 20.0));
                if (enemy.flipped) {
                    for (gy = startGridY; gy <= endGridY; ++gy) {
                        for (gx = startGridX; gx >= 0; --gx) {
                            this.ramZones[gy][gx] = true;
                        }
                    }
                    continue;
                }
                for (gy = startGridY; gy <= endGridY; ++gy) {
                    for (gx = startGridX; gx < this.grid[0].length; ++gx) {
                        this.ramZones[gy][gx] = true;
                    }
                }
            }
        }
    }

    private boolean inRamZone(int gx, int gy) {
        int myGW = (int)StrictMath.ceil(this.ship.getBBWidth() / 20.0);
        int myGH = (int)StrictMath.ceil(this.ship.getBBHeight() / 30.0);
        for (int yy = gy; yy < gy + myGH; ++yy) {
            for (int xx = gx; xx < gx + myGW; ++xx) {
                if (yy < 0 || yy >= this.ramZones.length || xx < 0 || xx >= this.ramZones[0].length || !this.ramZones[yy][xx]) continue;
                return true;
            }
        }
        return false;
    }

    public MoveTo choose() {
        boolean careAboutRamZones;
        boolean bl = careAboutRamZones = this.quality == AIQuality.SMART && !this.ship.hasRam();
        if (careAboutRamZones) {
            this.updateRamZones();
        }
        int myGY = (int)StrictMath.max(0.0, StrictMath.floor((this.ship.getY() - (double)this.gridYAnchor) / 30.0));
        int myGX = (int)StrictMath.max(0.0, StrictMath.min((double)(this.grid[0].length - 1), (this.ship.getX() - -3200.0) / 20.0));
        boolean currentlyInRamZone = false;
        if (careAboutRamZones && this.inRamZone(myGX, myGY)) {
            currentlyInRamZone = true;
        }
        double best = -1000000.0;
        int bestY = 0;
        int bestX = 0;
        boolean bestFlipped = false;
        for (int gridY = 0; gridY < this.grid.length; ++gridY) {
            for (int gridX = 0; gridX < this.grid[0].length; ++gridX) {
                double q = this.grid[gridY][gridX][0];
                if (q != -1000000.0) {
                    q += !this.ship.flipped ? 0.001 : 0.0;
                    if (currentlyInRamZone && StrictMath.abs(gridX - myGX) > 3) {
                        q *= 0.3;
                    }
                    if (careAboutRamZones && this.inRamZone(gridX, gridY)) {
                        q -= 1000.0;
                    }
                    if (q > best) {
                        bestX = gridX;
                        bestY = gridY;
                        bestFlipped = false;
                        best = q;
                    }
                }
                if ((q = this.grid[gridY][gridX][1]) == -1000000.0) continue;
                q += this.ship.flipped ? 0.001 : 0.0;
                if (currentlyInRamZone && StrictMath.abs(gridX - myGX) > 3) {
                    q *= 0.3;
                }
                if (careAboutRamZones && this.inRamZone(gridX, gridY)) {
                    q -= 1000.0;
                }
                if (!(q > best)) continue;
                bestX = gridX;
                bestY = gridY;
                bestFlipped = true;
                best = q;
            }
        }
        double currentValue = this.calculate(this.ship.getX(), this.ship.getY(), this.ship.flipped, this.ship.availableServiceCeiling(), this.wantsToRam(), this.wantsToBoard(), this.hasShortRangeWeapons(), this.aiMaxY()) + 0.1;
        if (currentlyInRamZone) {
            currentValue -= 1000.0;
        }
        if (best > -1000000.0 && best > currentValue) {
            return new MoveTo(bestX, bestY, bestFlipped);
        }
        return null;
    }

    private double awayFromCurrentPosition(double x, boolean pointingLeft, double optimalDistance, double value) {
        double distance = this.ship.flipped ? x - this.ship.getX() : this.ship.getX() - x;
        double distanceFromOptimalDistance = StrictMath.abs(distance - optimalDistance);
        return value + 10.0 * optimalDistance - 10.0 * distanceFromOptimalDistance + (double)(pointingLeft == this.ship.flipped ? 10 : 0);
    }

    private double calculate(double x, double y, boolean pointingLeft, int asc, boolean wantsToRam, boolean wantsToBoard, boolean isShortRange, int aiMaxY) {
        if (this.ship.type.onGround && this.ship.moveTo != null && StrictMath.abs(this.ship.moveTo.x - this.ship.getX()) > 50.0 && this.ship.msSinceLastXMove > 500) {
            return this.awayFromCurrentPosition(x, pointingLeft, 100.0, this.calculateNormally(x, y, pointingLeft, asc, wantsToBoard, isShortRange, aiMaxY));
        }
        return wantsToRam ? this.calculateRamSpot(x, y, pointingLeft, asc, wantsToBoard, isShortRange, aiMaxY) : this.calculateNormally(x, y, pointingLeft, asc, wantsToBoard, isShortRange, aiMaxY);
    }

    private boolean wantsToRam() {
        return !this.ship.isArmedOrHasTroops() && this.quality != AIQuality.STUPID || this.ship.hasRam();
    }

    private boolean wantsToBoard() {
        if (this.ship.hasCrewTypeAny(CrewType.boarders)) {
            return true;
        }
        int tsz = this.mySide.troops.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Crewman cm = this.mySide.troops.get(ti);
            if (cm.attachedTo != this.ship || !cm.type.canBoard || !cm.alive()) continue;
            return true;
        }
        return false;
    }

    private int aiMaxY() {
        int aiMaxY = 10000;
        int msz = this.ship.modules.size();
        for (int i = 0; i < msz; ++i) {
            aiMaxY = StrictMath.min(this.ship.modules.get((int)i).type.aiMaxY(), aiMaxY);
        }
        return aiMaxY;
    }

    private boolean hasShortRangeWeapons() {
        int msz = this.ship.modules.size();
        for (int i = 0; i < msz; ++i) {
            int mxr = this.ship.modules.get((int)i).type.getMaxXRange(this.ship.currentBonuses);
            int mr = this.ship.modules.get((int)i).type.getMaxRange(this.ship.currentBonuses);
            if ((mxr <= 0 || mxr >= 500) && (mr <= 0 || mr >= 500)) continue;
            return true;
        }
        return false;
    }

    private boolean canRam() {
        FindClosestResult fcr = new FindClosestResult();
        this.findClosestRock(fcr, this.ship.getX(), this.ship.getY(), this.ship.flipped);
        if (fcr.invalidMove) {
            return false;
        }
        this.findRammableShip(fcr, this.ship.getX(), this.ship.getY(), this.ship.flipped);
        if (fcr.invalidMove) {
            return false;
        }
        return fcr.dist > 100.0 && fcr.dist < 1000.0 && this.enemySide.ships.contains(fcr.xClosest);
    }

    private void findClosestRock(FindClosestResult fcr, double x, double y, boolean pointingLeft) {
        int start;
        double shipW = this.ship.getBBWidth();
        double shipH = this.ship.getBBHeight();
        double lowX = StrictMath.min(this.ship.getX(), x) - 1.0;
        double highX = StrictMath.max(this.ship.getX() + shipW, x + shipW) + 1.0;
        double mvW = highX - lowX;
        double lowY = StrictMath.min(this.ship.getY(), y) - 1.0;
        double highY = StrictMath.max(this.ship.getY() + shipH, y + shipH) + 1.0;
        double mvH = highY - lowY;
        int lfsz = this.c.landFormations.size();
        for (int lfi = start = this.ship.type.onGround ? 1 : 0; lfi < lfsz; ++lfi) {
            int widen;
            LandFormation lf = this.c.landFormations.get(lfi);
            if (y + shipH > lf.getY() && y < lf.getY() + lf.getBBHeight()) {
                if (pointingLeft) {
                    if (lf.getX() < x) {
                        double d = x - lf.getX() - lf.getBBWidth();
                        if (fcr.xClosest == null || d < fcr.dist) {
                            fcr.xClosest = lf;
                            fcr.dist = d;
                        }
                    }
                } else if (lf.getX() > x) {
                    double d = lf.getX() - x - this.ship.getBBWidth();
                    if (fcr.xClosest == null || d < fcr.dist) {
                        fcr.xClosest = lf;
                        fcr.dist = d;
                    }
                }
            }
            if (Rect2D.intersects(this.ship.getX() - 2.0, this.ship.getY() - 2.0, shipW + 4.0, shipH + 4.0, lf.getX(), lf.getY(), lf.getBBWidth(), lf.getBBHeight())) continue;
            int n = widen = Rect2D.intersects(this.ship.getX() - 20.0, this.ship.getY() - 20.0, shipW + 40.0, shipH + 40.0, lf.getX(), lf.getY(), lf.getBBWidth(), lf.getBBHeight()) ? 0 : 5;
            if (!Rect2D.intersects(lowX - (double)widen, lowY - (double)widen, mvW + (double)(widen * 2), mvH + (double)(widen * 2), lf.getX(), lf.getY(), lf.getBBWidth(), lf.getBBHeight())) continue;
            fcr.invalidMove = true;
            return;
        }
    }

    private void findClosestShip(FindClosestResult fcr, double x, double y, boolean pointingLeft, double areaY, double areaH) {
        double shipW = this.ship.getBBWidth();
        double shipH = this.ship.getBBHeight();
        double lowX = StrictMath.min(this.ship.getX(), x) - 1.0;
        double highX = StrictMath.max(this.ship.getX() + shipW, x + shipW) + 1.0;
        double mvW = highX - lowX;
        double lowY = this.ship.type.onGround ? y - 1.0 : StrictMath.min(this.ship.getY(), y) - 1.0;
        double highY = this.ship.type.onGround ? y + shipH + 1.0 : StrictMath.max(this.ship.getY() + shipH, y + shipH) + 1.0;
        double mvH = highY - lowY;
        int ssz = this.c.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side s = this.c.sides.get(si);
            int osz = s.ships.size();
            for (int oi = 0; oi < osz; ++oi) {
                int widen;
                Airship other = s.ships.get(oi);
                if (other == this.ship) continue;
                if (areaY > other.getY() && areaY + areaH < other.getY() + other.getBBHeight()) {
                    if (pointingLeft) {
                        if (other.getX() < x) {
                            double d = x - other.getX() - other.getBBWidth();
                            if (fcr.xClosest == null || d < fcr.dist) {
                                fcr.xClosest = other;
                                fcr.dist = d;
                            }
                        }
                    } else if (other.getX() > x) {
                        double d = other.getX() - x - this.ship.getBBWidth();
                        if (fcr.xClosest == null || d < fcr.dist) {
                            fcr.xClosest = other;
                            fcr.dist = d;
                        }
                    }
                }
                if (Rect2D.intersects(this.ship.getX() - 2.0, this.ship.getY() - 2.0, shipW + 4.0, shipH + 4.0, other.getX(), other.getY(), other.getBBWidth(), other.getBBHeight())) continue;
                int n = widen = Rect2D.intersects(this.ship.getX() - 20.0, this.ship.getY() - 20.0, shipW + 40.0, shipH + 40.0, other.getX(), other.getY(), other.getBBWidth(), other.getBBHeight()) ? 0 : 5;
                if (!Rect2D.intersects(lowX - (double)widen, lowY - (double)widen, mvW + (double)(widen * 2), mvH + (double)(widen * 2), other.getX(), other.getY(), other.getBBWidth(), other.getBBHeight())) continue;
                fcr.invalidMove = true;
                return;
            }
        }
    }

    private void findRammableShip(FindClosestResult fcr, double x, double y, boolean pointingLeft) {
        if (!this.ship.type.onGround && this.ship.hasRam()) {
            int msz = this.ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = this.ship.modules.get(mi);
                if (!m.type.isRam()) continue;
                double my = y + (double)(m.y * 16) + (double)(m.type.getH() * 16);
                double mh = y + (double)(m.y * 16);
                this.findClosestShip(fcr, x, y, pointingLeft, my, mh);
                if (!fcr.invalidMove) continue;
                return;
            }
        } else {
            this.findClosestShip(fcr, x, y, pointingLeft, y, this.ship.getBBHeight());
        }
    }

    private double calculateRamSpot(double x, double y, boolean pointingLeft, int asc, boolean wantsToBoard, boolean isShortRange, int aiMaxY) {
        if (y < (double)(512 - asc) && !this.ship.type.onGround) {
            return -1000000.0;
        }
        FindClosestResult fcr = new FindClosestResult();
        this.findClosestRock(fcr, x, y, pointingLeft);
        if (fcr.invalidMove) {
            return -1000000.0;
        }
        this.findRammableShip(fcr, x, y, pointingLeft);
        if (fcr.invalidMove) {
            return -1000000.0;
        }
        if (this.enemySide.ships.contains(fcr.xClosest)) {
            int ramDist = this.ship.type.onGround ? 200 : 800;
            return (double)ramDist - StrictMath.abs(fcr.dist - (double)ramDist);
        }
        return this.calculateNormally(x, y, pointingLeft, asc, wantsToBoard, isShortRange, aiMaxY);
    }

    private double calculateNormally(double x, double y, boolean flipped, int asc, boolean wantsToBoard, boolean isShortRange, int aiMaxY) {
        if (y > (double)aiMaxY) {
            return -1000000.0;
        }
        if (!this.ship.type.onGround && y < (double)(512 - asc)) {
            return -1000000.0;
        }
        double shipW = this.ship.getBBWidth();
        double shipH = this.ship.getBBHeight();
        double boardMult = 1.0;
        double belowMult = 1.0;
        double freeXMult = 1.0;
        double freeYMult = 1.0;
        double freeXBonus = 0.2;
        double freeYBonus = 0.2;
        double rockInWayMult = 1.0;
        double lowX = StrictMath.min(this.ship.getX(), x) - 1.0;
        double highX = StrictMath.max(this.ship.getX() + shipW, x + shipW) + 1.0;
        double mvW = highX - lowX;
        double lowY = StrictMath.min(this.ship.getY(), y) - 1.0;
        double highY = StrictMath.max(this.ship.getY() + shipH, y + shipH) + 1.0;
        double mvH = highY - lowY;
        if (lfs) {
            int start;
            int lfsz = this.c.landFormations.size();
            for (int lfi = start = this.ship.type.onGround ? 1 : 0; lfi < lfsz; ++lfi) {
                int widen;
                LandFormation lf = this.c.landFormations.get(lfi);
                if (lf.immobile) {
                    if (isShortRange) {
                        for (double probeX = x; probeX < x + shipW; probeX += 16.0) {
                            if (!(lf.yBoundaryAt(probeX) < y + shipH)) continue;
                            return -1000000.0;
                        }
                        continue;
                    }
                    for (double probeX = lowX; probeX < highX + 16.0; probeX += 16.0) {
                        if (!(lf.yBoundaryAt(probeX) < highY)) continue;
                        return -1000000.0;
                    }
                    continue;
                }
                if (Rect2D.intersects(this.ship.getX() - 2.0, this.ship.getY() - 2.0, shipW + 4.0, shipH + 4.0, lf.getX(), lf.getY(), lf.getBBWidth(), lf.getBBHeight())) continue;
                int n = widen = Rect2D.intersects(this.ship.getX() - 20.0, this.ship.getY() - 20.0, shipW + 40.0, shipH + 40.0, lf.getX(), lf.getY(), lf.getBBWidth(), lf.getBBHeight()) ? 0 : 5;
                if (Rect2D.intersects(lowX - (double)widen, lowY - (double)widen, mvW + (double)(widen * 2), mvH + (double)(widen * 2), lf.getX(), lf.getY(), lf.getBBWidth(), lf.getBBHeight())) {
                    if (wantsToBoard) {
                        rockInWayMult = 0.1;
                    } else {
                        return -1000000.0;
                    }
                }
                if (y < lf.getY() + lf.getBBHeight() + 12.0 && lf.getY() < y + shipH + 12.0) {
                    double dist = x < lf.getX() ? StrictMath.max(100.0, x + shipW - lf.getX()) : StrictMath.max(100.0, lf.getX() + lf.getBBWidth() - x);
                    freeXMult = 1.0 - 20.0 / dist;
                    freeXBonus = StrictMath.min(0.2, dist / 4000.0);
                }
                if (!(x < lf.getX() + lf.getBBWidth() + 3.0) || !(lf.getX() < x + shipW + 3.0)) continue;
                freeYMult = 0.8;
                freeYBonus = 0.0;
            }
        }
        highY += this.ship.getCachedGroundOffset();
        double shipHForPreIntersect = shipH + this.ship.getCachedGroundOffset();
        int ssz = this.c.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side s = this.c.sides.get(si);
            int osz = s.ships.size();
            for (int oi = 0; oi < osz; ++oi) {
                Airship other = s.ships.get(oi);
                if (other == this.ship) continue;
                boolean wouldBeMovingAwayFromOther = StrictMath.signum(x - other.getX()) == StrictMath.signum(this.ship.getX() - other.getX());
                double otherW = other.getBBWidth();
                double otherH = other.getBBHeight();
                boolean considerMove = s == this.mySide && other.aiTmpCanMove && other.aiTmpAvailableLift > 0;
                double otherLowX = considerMove ? StrictMath.min(other.getX(), other.moveTo.x) : other.getX();
                double otherLowY = considerMove ? StrictMath.min(other.getY(), other.moveTo.y) : other.getY();
                double otherHighX = considerMove ? StrictMath.max(other.getX() + otherW, other.moveTo.x + otherW) : other.getX() + otherW;
                double otherHighY = considerMove ? StrictMath.max(other.getY() + otherH, other.moveTo.y + otherH) : other.getY() + otherH;
                otherW = otherHighX - otherLowX;
                otherH = (otherHighY += other.getCachedGroundOffset()) - otherLowY;
                double otherBBHeightForPreIntersect = other.getBBHeight() + other.getCachedGroundOffset();
                if (!wouldBeMovingAwayFromOther || !Rect2D.intersects(this.ship.getX() - 2.0, this.ship.getY() - 2.0, shipW + 4.0, shipHForPreIntersect + 4.0, other.getX(), other.getY(), other.getBBWidth(), otherBBHeightForPreIntersect)) {
                    int widen;
                    int n = widen = Rect2D.intersects(this.ship.getX() - 20.0, this.ship.getY() - 20.0, shipW + 40.0, shipH + 40.0, other.getX(), other.getY(), other.getBBWidth(), other.getBBHeight()) ? 0 : 5;
                    if (Rect2D.intersects(lowX - (double)widen, lowY - (double)widen, mvW + (double)(widen * 2), mvH + (double)(widen * 2), otherLowX, otherLowY, otherW, otherH)) {
                        return -1000000.0;
                    }
                }
                if (Rect2D.intersects(x, y, shipW, shipH, otherLowX, otherLowY, otherW, 10000.0)) {
                    belowMult = 0.9;
                }
                if (y < otherHighY + 5.0 && otherLowY < y + shipH + 5.0) {
                    double dist = x < other.getX() ? StrictMath.max(100.0, x + shipW - other.getX()) : StrictMath.max(100.0, other.getX() + otherW - x);
                    freeXMult = 1.0 - 20.0 / dist;
                    freeXBonus = StrictMath.min(0.2, dist / 4000.0);
                }
                if (x < otherHighX && otherLowX < x + shipW) {
                    freeYMult = 0.8;
                    freeYBonus = 0.0;
                }
                if (!wantsToBoard || !(other.getX() - (x + shipW) <= 40.0) || !(x - (other.getX() + otherW) <= 40.0) || !(other.getY() - (y + shipH) <= 30.0) || !(y - (other.getY() + otherH) <= -40.0)) continue;
                boardMult = 10.0;
            }
        }
        int esz = this.enemySide.ships.size();
        double optimumRangeMult = 1.0;
        if (this.ship.type == ShipType.LANDSHIP) {
            double div = 1.0;
            ssz = this.mySide.ships.size();
            for (int si = 0; si < ssz; ++si) {
                if (this.mySide.ships.get((int)si).type != ShipType.LANDSHIP) continue;
                div += 1.0;
            }
            optimumRangeMult = 2.0 / div;
        }
        WeatherEffect we = this.c.timeOfDay.effect;
        double shootToLeftJitterMult = this.quality == AIQuality.SMART ? we.shootJitterMult * we.shootToLeftJitterMult : 1.0;
        double shootToRightJitterMult = this.quality == AIQuality.SMART ? we.shootJitterMult * we.shootToRightJitterMult : 1.0;
        double shootQuality = 0.1;
        int msz = this.ship.modules.size();
        boolean hasWeapons = false;
        block6: for (int mi = 0; mi < msz; ++mi) {
            Module m = this.ship.modules.get(mi);
            if (!m.type.isWeapon() && m.tentacles.isEmpty() || !m.canRun()) continue;
            hasWeapons = true;
            for (int ei = 0; ei < esz; ++ei) {
                boolean ltr;
                int tsi;
                Module em;
                int emi;
                int emsz;
                double q;
                Airship e = this.enemySide.ships.get(ei);
                int tsz = m.tentacles.size();
                for (int ti = 0; ti < tsz; ++ti) {
                    Tentacle t = m.tentacles.get(ti);
                    if (!t.canTentacle(this.ship, m, e, x, y, e.getX(), e.getY(), flipped, 8, 0.8)) continue;
                    q = t.canTentacle(this.ship, m, e, x, y, e.getX(), e.getY(), flipped, 18, 0.5) ? 1.0 : 0.5;
                    emsz = e.modules.size();
                    for (emi = 0; emi < emsz; ++emi) {
                        CrewType qt;
                        em = e.modules.get(emi);
                        if (em.type.isWeapon() && em.hp > 0) {
                            q += em.type.DPS(e.currentBonuses);
                        }
                        if (!em.type.getTentacleSpecs().isEmpty() && em.hp > 0) {
                            int tss = em.type.getTentacleSpecs().size();
                            for (tsi = 0; tsi < tss; ++tsi) {
                                q += (double)em.type.getTentacleSpecs().get(tsi).getDPSEquivalent();
                            }
                        }
                        if ((qt = em.type.getQuartersType(e.currentBonuses)) == null || !qt.canBoard && !qt.canFly) continue;
                        q += (double)(em.type.getCost(e.currentBonuses) / 20 + 1);
                    }
                    shootQuality += q;
                }
                if (!m.type.isWeapon() || !(isShortRange ? m.canHitCloseUp(e, x, y, e.getX(), e.getY(), flipped, 8) : m.canHit(e, x, y, e.getX(), e.getY(), flipped, 8))) continue;
                double qMult = isShortRange || m.canHit(e, x, y, e.getX(), e.getY(), flipped, 28) ? 1.0 : 0.5;
                q = 0.0;
                emsz = e.modules.size();
                for (emi = 0; emi < emsz; ++emi) {
                    CrewType qt;
                    em = e.modules.get(emi);
                    if (em.type.isWeapon() && em.hp > 0) {
                        q += em.type.DPS(e.currentBonuses);
                    }
                    if (!em.type.getTentacleSpecs().isEmpty() && em.hp > 0) {
                        int tss = em.type.getTentacleSpecs().size();
                        for (tsi = 0; tsi < tss; ++tsi) {
                            q += (double)em.type.getTentacleSpecs().get(tsi).getDPSEquivalent();
                        }
                    }
                    if ((qt = em.type.getQuartersType(e.currentBonuses)) == null || !qt.canBoard && !qt.canFly) continue;
                    q += (double)(em.type.getCost(e.currentBonuses) / 20 + 1);
                }
                if (y + this.ship.getBBHeight() < e.getY()) {
                    q *= 1.5;
                } else if (y < e.getY()) {
                    q *= 1.2;
                }
                double manhattanDist = StrictMath.min(StrictMath.abs(x - e.getX() - e.getBBWidth()), StrictMath.abs(e.getX() - x - shipW)) + StrictMath.min(StrictMath.abs(y - e.getY() - e.getBBHeight()), StrictMath.abs(e.getY() - y - shipH));
                boolean bl = ltr = e.getX() - x > 0.0;
                manhattanDist = ltr ? (manhattanDist *= shootToRightJitterMult) : (manhattanDist *= shootToLeftJitterMult);
                q *= qMult;
                shootQuality += (q *= StrictMath.max(0.01, StrictMath.min(1.0, (double)m.type.getOptimumRange(this.ship.currentBonuses) * optimumRangeMult / manhattanDist)));
                continue block6;
            }
        }
        double damageQuality = 5.0;
        double closestEnemyDist = 100000.0;
        double closestEnemyXDist = 100000.0;
        if (this.quality != AIQuality.STUPID) {
            for (int ei = 0; ei < esz; ++ei) {
                boolean ltr;
                Airship e = this.enemySide.ships.get(ei);
                int emsz = e.modules.size();
                double manhattanDist = StrictMath.min(StrictMath.abs(x - e.getX() - e.getBBWidth()), StrictMath.abs(e.getX() - x - shipW)) + StrictMath.min(StrictMath.abs(y - e.getY() - e.getBBHeight()), StrictMath.abs(e.getY() - y - shipH));
                closestEnemyDist = StrictMath.min(manhattanDist, closestEnemyDist);
                closestEnemyXDist = StrictMath.min(StrictMath.min(StrictMath.abs(x - e.getX() - e.getBBWidth()), StrictMath.abs(e.getX() - x - shipW)), closestEnemyXDist);
                boolean bl = ltr = x - e.getX() > 0.0;
                manhattanDist = ltr ? (manhattanDist *= shootToRightJitterMult) : (manhattanDist *= shootToLeftJitterMult);
                for (int emi = 0; emi < emsz; ++emi) {
                    Module em = e.modules.get(emi);
                    if (em.type.isWeapon() && em.hp > 0 && em.canHit(this.ship, e.getX(), e.getY(), x, y, e.flipped, -8)) {
                        damageQuality += StrictMath.min(1.0, (double)em.type.getOptimumRange(e.currentBonuses) / manhattanDist) * em.type.DPS(e.currentBonuses);
                    }
                    int tsz = em.tentacles.size();
                    for (int ti = 0; ti < tsz; ++ti) {
                        Tentacle t = em.tentacles.get(ti);
                        if (em.hp <= 0 || !t.canTentacle(e, em, this.ship, e.getX(), e.getY(), x, y, e.flipped, -8, 1.05)) continue;
                        damageQuality += (double)t.spec.getDPSEquivalent();
                    }
                }
            }
        }
        double closerBonus = hasWeapons || wantsToBoard ? 1000.0 / (closestEnemyDist + 1000.0) : closestEnemyXDist / 10.0 - y / 4.0;
        return shootQuality / damageQuality * rockInWayMult * belowMult * freeXMult * freeYMult * boardMult + freeXBonus * 3.0 + freeYBonus * 3.0 + closerBonus * 3.0;
    }

    strictfp static class FindClosestResult {
        boolean invalidMove = false;
        Body xClosest;
        double dist = 0.0;

        FindClosestResult() {
        }
    }

    public strictfp final class MoveTo {
        public final int gridX;
        public final int gridY;
        public final boolean flipped;

        public MoveTo(int gridX, int gridY, boolean flipped) {
            this.gridX = gridX;
            this.gridY = gridY;
            this.flipped = flipped;
        }

        public Pt getMoveToPt() {
            return new Pt((double)(-3200 + this.gridX * 20), TacticalAI.this.getWorldYFromGridY(this.gridX, this.gridY, this.flipped));
        }
    }
}

