/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MonsterNest;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.StrategicScreen;
import java.util.EnumSet;

public strictfp class StrategicHelp {
    private City defendWarned = null;
    public EnumSet<Type> cleared = EnumSet.noneOf(Type.class);

    public HelpMsg getMessage(StrategicScreen ss) {
        Empire p = ss.w.player;
        if (p.cities.isEmpty()) {
            return null;
        }
        if (!this.cleared.contains((Object)Type.HOME)) {
            return new HelpMsg(Type.HOME, Lang._t("sh_HOME", p.cities.get((int)0).name), null, p.cities.get(0), false);
        }
        if (!this.cleared.contains((Object)Type.FLEET) && !p.getFleets().isEmpty()) {
            return new HelpMsg(Type.FLEET, Lang._t("sh_FLEET", new Object[0]), p.getFleets().get(0), null, false);
        }
        if (!this.cleared.contains((Object)Type.CONSTRUCT)) {
            return new HelpMsg(Type.CONSTRUCT, Lang._t("sh_CONSTRUCT", new Object[0]), null, p.cities.get(0), false);
        }
        if (!this.cleared.contains((Object)Type.SPEED)) {
            return new HelpMsg(Type.SPEED, Lang._t("sh_SPEED", new Object[0]), null, null, true);
        }
        City targetCity = null;
        City closest = null;
        int bestDsq = 0;
        City home = p.cities.get(0);
        block0: for (Empire e : ss.w.map.empires) {
            if (e == ss.w.player) continue;
            for (City c : e.cities) {
                if (ss.w.map.getConnection(home, c) != null) {
                    targetCity = c;
                    continue block0;
                }
                int dsq = (c.x - home.x) * (c.x - home.x) + (c.y - home.y) * (c.y - home.y);
                if (closest != null && dsq >= bestDsq) continue;
                closest = c;
                bestDsq = dsq;
            }
        }
        boolean canWalk = targetCity != null;
        boolean allAir = true;
        if (!p.getFleets().isEmpty()) {
            for (Airship s : p.getFleets().get((int)0).actives) {
                if (!s.type.onGround) continue;
                allAir = false;
            }
            for (Airship s : p.getFleets().get((int)0).reserve) {
                if (!s.type.onGround) continue;
                allAir = false;
            }
        }
        canWalk = canWalk || allAir;
        targetCity = targetCity == null ? closest : targetCity;
        boolean spyReady = false;
        Spy readySpy = null;
        for (Spy s : p.spies) {
            if (s.location != targetCity) continue;
            spyReady = s.infiltrationTimeout <= 0;
            readySpy = spyReady ? s : null;
            this.clear(Type.SPY);
        }
        for (Fleet f : p.getFleets()) {
            if (f.destination != targetCity) continue;
            this.clear(Type.INVADE);
        }
        if (targetCity != null && !this.cleared.contains((Object)Type.SPY)) {
            return new HelpMsg(Type.SPY, Lang._t("sh_SPY", new Object[0]), null, targetCity, false);
        }
        if (targetCity != null && spyReady && !this.cleared.contains((Object)Type.SPY_DONE)) {
            return new HelpMsg(Type.SPY_DONE, Lang._t("sh_SPY_DONE", targetCity.name, "?"), null, targetCity, false);
        }
        if (targetCity != null && !p.getFleets().isEmpty() && !this.cleared.contains((Object)Type.INVADE) && this.cleared.contains((Object)Type.SPY_DONE)) {
            return new HelpMsg(Type.INVADE, canWalk ? Lang._t("sh_INVADE", new Object[0]) : Lang._t("sh_INVADE_air", new Object[0]), null, targetCity, false);
        }
        City unprotected = null;
        for (City c : p.cities) {
            if (this.cleared.contains((Object)Type.DEFEND) && c == this.defendWarned || !c.getDefences().isEmpty() || c.takeoverMethod != null || c.takeoverNeeded) continue;
            unprotected = c;
            break;
        }
        if (unprotected != null && !this.cleared.contains((Object)Type.DEFEND)) {
            this.defendWarned = unprotected;
            return new HelpMsg(Type.DEFEND, Lang._t("sh_DEFEND", new Object[0]), null, unprotected, false);
        }
        if (unprotected != null && !this.cleared.contains((Object)Type.DEFEND2)) {
            return new HelpMsg(Type.DEFEND2, Lang._t("sh_DEFEND", new Object[0]), null, unprotected, false);
        }
        Fleet invaders = null;
        for (Empire e : ss.w.map.empires) {
            if (e == p) continue;
            for (Fleet f : e.getFleets()) {
                if (!p.cities.contains(f.destination)) continue;
                invaders = f;
            }
        }
        if (invaders != null && !this.cleared.contains((Object)Type.INVADERS)) {
            return new HelpMsg(Type.INVADERS, Lang._t("sh_INVADERS", new Object[0]), invaders, null, false);
        }
        Fleet raiders = null;
        for (MonsterNest e : ss.w.map.nests) {
            for (Fleet f : e.getFleets()) {
                if (!p.cities.contains(f.destination)) continue;
                raiders = f;
            }
        }
        if (raiders != null && !this.cleared.contains((Object)Type.RAIDERS)) {
            return new HelpMsg(Type.RAIDERS, Lang._t("sh_RAIDERS", new Object[0]), raiders, null, false);
        }
        int consCities = 0;
        for (City c : p.cities) {
            if (c.getDefences().isEmpty()) continue;
            ++consCities;
        }
        if (consCities >= 5 && !this.cleared.contains((Object)Type.CONTINUE)) {
            return new HelpMsg(Type.CONTINUE, Lang._t("sh_CONTINUE", new Object[0]), null, null, false);
        }
        return null;
    }

    public void clear(Type t) {
        this.cleared.add(t);
    }

    public strictfp static class HelpMsg {
        public final Type type;
        public final String text;
        public final Fleet fleet;
        public final City city;
        public final boolean speedControls;

        public HelpMsg(Type type, String text, Fleet fleet, City city, boolean speedControls) {
            this.type = type;
            this.text = text;
            this.fleet = fleet;
            this.city = city;
            this.speedControls = speedControls;
        }
    }

    public strictfp static enum Type {
        HOME,
        FLEET,
        CONSTRUCT,
        SPEED,
        SPY,
        SPY_DONE,
        INVADE,
        DEFEND,
        DEFEND2,
        INVADERS,
        RAIDERS,
        CONTINUE;

    }
}

